/*
 * Decompiled with CFR 0.152.
 */
package tripphippy;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import tripphippy.BotData;
import tripphippy.StatusMessage;
import wiki.HelperMethods;

public class BotCache {
    public HashMap<String, BotData> bots;
    public static TeamRobot r;
    public int radarDir;

    public BotCache(TeamRobot in_r) {
        r = in_r;
        this.bots = new HashMap();
        this.radarDir = 1;
    }

    public void Update(ScannedRobotEvent e) {
        BotData b = this.bots.get(e.getName());
        if (b == null) {
            b = new BotData(r);
            b.Update(e);
            this.bots.put(e.getName(), b);
        } else {
            b.Update(e);
        }
    }

    public void Update(RobotDeathEvent e) {
        BotData b = this.bots.get(e.getName());
        if (b == null) {
            b = new BotData(r);
            b.Update(e);
            this.bots.put(e.getName(), b);
        } else {
            b.Update(e);
        }
    }

    public void Update(BulletHitEvent e) {
        BotData b = this.bots.get(e.getName());
        if (b == null) {
            b = new BotData(r);
            b.Update(e);
            this.bots.put(e.getName(), b);
        } else {
            b.Update(e);
        }
    }

    public void Update(HitRobotEvent e) {
        BotData b = this.bots.get(e.getName());
        if (b == null) {
            b = new BotData(r);
            b.Update(e);
            this.bots.put(e.getName(), b);
        } else {
            b.Update(e);
        }
    }

    public void Update(HitByBulletEvent e) {
        BotData b = this.bots.get(e.getName());
        if (b == null) {
            b = new BotData(r);
            b.Update(e);
            this.bots.put(e.getName(), b);
        } else {
            b.Update(e);
        }
    }

    public void Update(DeathEvent e) {
        for (BotData tmp : this.bots.values()) {
            if (tmp == null) continue;
            tmp.Update(e);
        }
    }

    public void Update(StatusMessage m) {
        BotData b = this.bots.get(m.name);
        if (b == null) {
            b = new BotData(r);
            b.Update(m);
            this.bots.put(m.name, b);
        } else {
            b.Update(m);
        }
    }

    public void Run() {
        for (BotData tmp : this.bots.values()) {
            if (tmp == null) continue;
            tmp.Run();
        }
    }

    public void ResetRound() {
        for (BotData tmp : this.bots.values()) {
            if (tmp == null) continue;
            tmp.Reset();
        }
    }

    public BotData getLeader() {
        for (BotData tmp : this.bots.values()) {
            if (tmp == null || !tmp.friend || !tmp.leader) continue;
            return tmp;
        }
        return null;
    }

    public BotData getClosestUpdated(double x, double y) {
        if (this.bots.isEmpty()) {
            return null;
        }
        Iterator<BotData> iterator = this.bots.values().iterator();
        double closestDist = Double.POSITIVE_INFINITY;
        double dist = 0.0;
        BotData returner = null;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || !tmp.isUpdated() || !((dist = HelperMethods.getDistance(x, y, tmp.x, tmp.y)) < closestDist)) continue;
            closestDist = dist;
            returner = tmp;
        }
        return returner;
    }

    public BotData getClosestUpdatedEnemy(double x, double y) {
        if (this.bots.isEmpty()) {
            return null;
        }
        Iterator<BotData> iterator = this.bots.values().iterator();
        double closestDist = Double.POSITIVE_INFINITY;
        double dist = 0.0;
        BotData returner = null;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || !tmp.isUpdated() || tmp.friend || !((dist = HelperMethods.getDistance(x, y, tmp.x, tmp.y)) < closestDist)) continue;
            closestDist = dist;
            returner = tmp;
        }
        return returner;
    }

    public BotData getClosestUpdatedEnemyAvoidFriendlyFire(double x, double y) {
        if (this.bots.isEmpty()) {
            return null;
        }
        Iterator<BotData> iterator = this.bots.values().iterator();
        double closestDist = Double.POSITIVE_INFINITY;
        double dist = 0.0;
        BotData returner = null;
        Color c = Color.green;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || !tmp.isUpdated() || tmp.friend) continue;
            dist = HelperMethods.getDistance(x, y, tmp.x, tmp.y);
            Line2D.Double line = new Line2D.Double(x, y, tmp.x, tmp.y);
            boolean safe = true;
            c = Color.green;
            for (BotData other : this.bots.values()) {
                if (!other.friend || other.dead) continue;
                Line2D.Double path = new Line2D.Double(other.x, other.y, other.x + HelperMethods.getXcomponent(other.direction, other.velocity * (dist / 11.0)), other.y + HelperMethods.getYcomponent(other.direction, other.velocity * (dist / 11.0)));
                Rectangle2D.Double box = new Rectangle2D.Double(other.x - 18.0, other.y - 18.0, 36.0, 36.0);
                r.getGraphics().setColor(Color.blue);
                r.getGraphics().draw(path);
                r.getGraphics().draw(box);
                if (!line.intersectsLine(path) && !line.intersects(box)) continue;
                safe = false;
                c = Color.red;
            }
            r.getGraphics().setColor(c);
            r.getGraphics().drawLine((int)x, (int)y, (int)tmp.x, (int)tmp.y);
            if (!(dist < closestDist) || !safe) continue;
            closestDist = dist;
            returner = tmp;
        }
        return returner;
    }

    public BotData getClosestEnemyAvoidFriendlyFire(double x, double y) {
        if (this.bots.isEmpty()) {
            return null;
        }
        Iterator<BotData> iterator = this.bots.values().iterator();
        double closestDist = Double.POSITIVE_INFINITY;
        double dist = 0.0;
        BotData returner = null;
        Color c = Color.green;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || tmp.friend) continue;
            dist = HelperMethods.getDistance(x, y, tmp.x, tmp.y);
            Line2D.Double line = new Line2D.Double(x, y, tmp.x, tmp.y);
            boolean safe = true;
            c = Color.green;
            for (BotData other : this.bots.values()) {
                if (!other.friend || other.dead) continue;
                Line2D.Double path = new Line2D.Double(other.x, other.y, other.x + HelperMethods.getXcomponent(other.direction, other.velocity * (dist / 11.0)), other.y + HelperMethods.getYcomponent(other.direction, other.velocity * (dist / 11.0)));
                Rectangle2D.Double box = new Rectangle2D.Double(other.x - 18.0, other.y - 18.0, 36.0, 36.0);
                r.getGraphics().setColor(Color.blue);
                r.getGraphics().draw(path);
                r.getGraphics().draw(box);
                if (!line.intersectsLine(path) && !line.intersects(box)) continue;
                safe = false;
                c = Color.red;
            }
            r.getGraphics().setColor(c);
            r.getGraphics().drawLine((int)x, (int)y, (int)tmp.x, (int)tmp.y);
            if (!(dist < closestDist) || !safe) continue;
            closestDist = dist;
            returner = tmp;
        }
        return returner;
    }

    public BotData getClosest(double x, double y) {
        if (this.bots.isEmpty()) {
            return null;
        }
        Iterator<BotData> iterator = this.bots.values().iterator();
        double closestDist = Double.POSITIVE_INFINITY;
        double dist = 0.0;
        BotData returner = null;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || !((dist = HelperMethods.getDistance(x, y, tmp.x, tmp.y)) < closestDist)) continue;
            closestDist = dist;
            returner = tmp;
        }
        return returner;
    }

    public long lastUpdate() {
        Iterator<BotData> iterator = this.bots.values().iterator();
        long lu = 0L;
        while (iterator.hasNext()) {
            BotData tmp = iterator.next();
            if (tmp == null || tmp.dead || tmp.friend || lu >= tmp.lastUpdate) continue;
            lu = tmp.lastUpdate;
        }
        return lu;
    }

    public double getOptimumRadar() {
        if (r.getTime() < 9L) {
            return (double)this.radarDir * Math.PI / 2.0;
        }
        if (r.getTime() - this.lastUpdate() > 8L) {
            return (double)this.radarDir * Math.PI / 2.0;
        }
        Vector<Double> a = new Vector<Double>();
        for (BotData b : this.bots.values()) {
            if (b.friend || b.dead) continue;
            a.add(HelperMethods.getAngle(r.getX(), r.getY(), b.x, b.y));
        }
        if (a.isEmpty()) {
            return (double)this.radarDir * Math.PI / 4.0;
        }
        Collections.sort(a);
        a.add((Double)a.elementAt(0) + Math.PI * 2);
        double lowSweep = 0.0;
        double hiSweep = 0.0;
        double largestTheta = 0.0;
        for (int i = 0; i < a.size() - 1; ++i) {
            double theta = (Double)a.elementAt(i + 1) - (Double)a.elementAt(i);
            if (!(theta > largestTheta)) continue;
            largestTheta = theta;
            lowSweep = (Double)a.elementAt(i);
            hiSweep = (Double)a.elementAt(i + 1);
        }
        if (largestTheta < Math.PI) {
            return (double)this.radarDir * Math.PI / 4.0;
        }
        lowSweep += 0.09817477042468103;
        hiSweep -= 0.09817477042468103;
        if (this.radarDir == 1) {
            if (Math.abs(Utils.normalRelativeAngle((double)(lowSweep - r.getRadarHeadingRadians()))) < 0.7853981633974483) {
                this.radarDir = -this.radarDir;
            }
            return Utils.normalRelativeAngle((double)(lowSweep - r.getRadarHeadingRadians()));
        }
        if (Math.abs(Utils.normalRelativeAngle((double)(hiSweep - r.getRadarHeadingRadians()))) < 0.7853981633974483) {
            this.radarDir = -this.radarDir;
        }
        return Utils.normalRelativeAngle((double)(hiSweep - r.getRadarHeadingRadians()));
    }

    public String toString() {
        return new String("NumBots = " + this.bots.size());
    }
}

