/*
 * Decompiled with CFR 0.152.
 */
package ara;

import ara.BulletItem;
import ara.Enemy;
import ara.Shera;
import ara.Util;
import java.awt.geom.Point2D;
import java.util.Random;
import robocode.Bullet;

public class Firing {
    private Shera shera;
    private Point2D.Double TargetPos = null;
    private double Power;
    private int Strategy;
    public Enemy Target = null;
    private Enemy LastTarget = null;
    private long TargetTime = 0L;
    public long LastFire = 0L;

    Firing(Shera s) {
        this.shera = s;
    }

    public void Reset() {
        this.LastTarget = null;
        this.Target = null;
        this.TargetPos = null;
    }

    Point2D.Double GetTargetPos(Enemy e, double power) {
        Point2D.Double p;
        if (e.Stay()) {
            return new Point2D.Double(e.X, e.Y);
        }
        if (e.GuruGuru) {
            return this.GetTargetPosCircle(e, power);
        }
        if (e.Straight() && this.shera.CheckCoord(p = this.GetTargetPosLineSub2(e, power, e.Velocity, Util.normalDegA(90.0 - e.Heading)), 0.0)) {
            return p;
        }
        int idx = e.Roulette2();
        double ev = e.VelVB();
        double eh = e.HeadVB();
        if (Math.abs(ev) < 1.0) {
            ev = e.AveVel > 0.0 ? 8.0 : -8.0;
        }
        return this.GetTargetPosLineSub(e, power, ev * e.Factor[idx], eh);
    }

    public int CountEnemy(Enemy ene) {
        double sx = this.shera.x;
        double sy = this.shera.y;
        double h = Util.Deg(sx, sy, ene.X, ene.Y);
        if (this.TargetPos != null) {
            h = Util.Deg(sx, sy, this.TargetPos.x, this.TargetPos.y);
        }
        int r = 0;
        int i = 0;
        while (i < Shera.EL.Enemies.size()) {
            Enemy e = (Enemy)Shera.EL.Enemies.elementAt(i);
            double he = Util.Deg(sx, sy, e.X, e.Y);
            if (Math.abs(Util.normalDegB(he - h)) < 20.0) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public void Fire() {
        if (this.CanFire()) {
            this.CalcPower();
            Bullet b = this.shera.setFireBullet(this.Power);
            if (b != null) {
                BulletItem bi = new BulletItem(b, this.Target, this.Strategy);
                this.shera.BulletList.add(bi);
                ++this.Target.StatTo.nMiss;
                this.Target.StatTo.Power += this.Power;
                ++Shera.Stat.nMiss;
                Shera.Stat.Power += this.Power;
                this.TargetPos = null;
                this.LastFire = this.shera.getTime();
            }
        }
        this.TargetPos = null;
        if (this.shera.getGunHeat() / this.shera.getGunCoolingRate() > 9.0) {
            return;
        }
        this.Target();
        if (this.Target == null) {
            return;
        }
        this.CalcPower();
        this.TargetPos = this.GetTargetPos(this.Target, this.Power);
        this.VerifyTargetPos();
        if (this.TargetPos != null) {
            double d = Util.normalDegB(Util.Deg(this.shera.getNX(), this.shera.getNY(), this.TargetPos.x, this.TargetPos.y));
            double g = Util.normalDegB(90.0 - this.shera.getGunHeading());
            this.shera.setTurnGunRight(Util.normalDegB(g - d));
            this.TargetTime = this.Target.LastScan;
        }
    }

    private void VerifyTargetPos() {
        Enemy e = Shera.EL.GetNearestEnemy();
        if (e == null || e.Distance < 100.0) {
            return;
        }
        if (e.Stay() || e.Straight()) {
            return;
        }
        double limit = 150.0;
        double nx = this.shera.getNX();
        double ny = this.shera.getNY();
        if (nx < limit && this.TargetPos.x < nx) {
            this.TargetPos.x = nx;
        }
        if (ny < limit && this.TargetPos.y < ny) {
            this.TargetPos.y = ny;
        }
        if (nx > this.shera.FieldWidth - limit && this.TargetPos.x > nx) {
            this.TargetPos.x = nx;
        }
        if (ny > this.shera.FieldHeight - limit && this.TargetPos.y > ny) {
            this.TargetPos.y = ny;
        }
    }

    Point2D.Double GetTargetPosStdDist(Enemy e, double power) {
        double nx = this.shera.getNX();
        double ny = this.shera.getNY();
        double r = Util.Dist(nx, ny, e.X, e.Y);
        double deg = Util.Deg(nx, ny, e.X, e.Y);
        double t = r / this.BulletSpeed(power);
        double max = Math.toDegrees(t * 8.0 / r);
        double meanv = e.AveVel;
        double meana = Math.toDegrees(t * meanv / r);
        Random rand = new Random();
        double a = rand.nextGaussian();
        a *= meana;
        if ((a *= 1.0) > max || a < -max) {
            a = 0.0;
        }
        double x = nx + r * Util.cosDeg(deg + a);
        double y = ny + r * Util.sinDeg(deg + a);
        Point2D.Double ret = new Point2D.Double(x, y);
        return this.shera.CorrectCoord(ret);
    }

    Point2D.Double GetTargetPosRand(Enemy e, double power) {
        double nx = this.shera.getNX();
        double ny = this.shera.getNY();
        double r = Util.Dist(nx, ny, e.X, e.Y);
        double deg = Util.Deg(nx, ny, e.X, e.Y);
        double t = r / this.BulletSpeed(power);
        double max = Math.toDegrees(t * 8.0 / r);
        double a = Math.random() * (max /= 3.0) * 2.0 - max;
        double x = nx + r * Util.cosDeg(deg + a);
        double y = ny + r * Util.sinDeg(deg + a);
        Point2D.Double ret = new Point2D.Double(x, y);
        return this.shera.CorrectCoord(ret);
    }

    Point2D.Double GetTargetPosAveL(Enemy e, double power) {
        double v = e.AveAbsSpeed();
        double h = Util.normalDegA(90.0 - e.Heading);
        return this.GetTargetPosLineSub(e, power, v, h);
    }

    Point2D.Double GetTargetPosLineSub2(Enemy e, double power, double ev, double eh) {
        if (Math.abs(ev) < 0.5) {
            return new Point2D.Double(e.X, e.Y);
        }
        double eb = Util.Deg(this.shera.getNX(), this.shera.getNY(), e.X, e.Y);
        double ed = Util.Dist(this.shera.getNX(), this.shera.getNY(), e.X, e.Y);
        double al = Util.normalDegB(180.0 + eh - eb);
        double s = ev * Util.sinDeg(al);
        double bv = this.BulletSpeed(power);
        double be = Math.toDegrees(Math.asin(s / bv));
        double t = ed / (ev * Util.cosDeg(al) + bv * Util.cosDeg(be));
        double th = Util.normalDegB(eb - be);
        double tx = t * bv * Util.cosDeg(th);
        double ty = t * bv * Util.sinDeg(th);
        double nx = this.shera.getNX() + tx;
        double ny = this.shera.getNY() + ty;
        return new Point2D.Double(nx, ny);
    }

    Point2D.Double GetTargetPosLineSub(Enemy e, double power, double ev, double eh) {
        Point2D.Double ret = this.GetTargetPosLineSub2(e, power, ev, eh);
        if (this.shera.CheckCoord(ret, 0.0)) {
            return ret;
        }
        double vx = ev * Util.cosDeg(eh);
        double vy = ev * Util.sinDeg(eh);
        Point2D.Double v = new Point2D.Double(vx, vy);
        v = Util.Normalize(v);
        if (v.x != Double.NaN) {
            int i = 0;
            while (i < 500) {
                ret.x -= v.x * 3.0;
                ret.y -= v.y * 3.0;
                if (this.shera.CheckCoord(ret, 0.0)) {
                    return ret;
                }
                ++i;
            }
        }
        return new Point2D.Double(e.NX, e.NY);
    }

    Point2D.Double GetTargetPosAveP(Enemy e, double power) {
        return e.AveragePos();
    }

    double BulletSpeed(double power) {
        return 20.0 - 3.0 * power;
    }

    private boolean CanFire() {
        double e;
        if (this.TargetPos == null || this.Target == null) {
            return false;
        }
        if (this.shera.moving.Mode == 2) {
            return false;
        }
        if (this.shera.getGunHeat() != 0.0) {
            return false;
        }
        if (this.Target.Dead) {
            return false;
        }
        if (this.shera.getEnergy() <= 0.13) {
            return false;
        }
        long ls = this.shera.Time - this.TargetTime;
        if (ls > 1L) {
            return false;
        }
        double g = Util.normalDegB(90.0 - this.shera.getGunHeading());
        double d = Util.normalDegB(g - (e = Util.Deg(this.shera.getX(), this.shera.getY(), this.TargetPos.x, this.TargetPos.y)));
        return Math.abs(d) <= 5.0;
    }

    Point2D.Double GetTargetPosLine(Enemy e, double power) {
        double ev = e.Velocity;
        double eh = Util.normalDegA(90.0 - e.Heading);
        return this.GetTargetPosLineSub(e, power, ev, eh);
    }

    Point2D.Double GetTargetPosCircle(Enemy e, double power) {
        double ev = e.Velocity;
        double eh = Util.normalDegA(90.0 - e.Heading);
        double deh = -e.HeadingDef();
        if (Math.abs(deh) < 0.001) {
            return this.GetTargetPosLine(e, power);
        }
        double r = Math.abs(ev / Math.toRadians(deh));
        double a0 = eh - 90.0;
        if (deh < 0.0) {
            a0 += 180.0;
        }
        a0 = Util.normalDegA(a0);
        double cx = e.X - r * Util.cosDeg(a0);
        double cy = e.Y - r * Util.sinDeg(a0);
        Point2D.Double c = new Point2D.Double(cx, cy);
        double bulspeed = this.BulletSpeed(this.Power);
        int tr = (int)Math.ceil(r / bulspeed);
        double nx = this.shera.getNX();
        double ny = this.shera.getNY();
        int t = (int)Math.ceil(Util.Dist(nx, ny, e.X, e.Y) / bulspeed);
        double mindist = Double.MAX_VALUE;
        double ex = e.X;
        double ey = e.Y;
        int mini = 0;
        int i = t - tr - 1;
        while (i <= t + tr + 1) {
            double ty;
            double tx = cx + r * Util.cosDeg(a0 + deh * (double)(i + 1));
            double dist = Math.abs(Util.Dist(nx, ny, tx, ty = cy + r * Util.sinDeg(a0 + deh * (double)(i + 1))) - (double)i * bulspeed);
            if (dist < mindist) {
                mindist = dist;
                mini = i;
                ex = tx;
                ey = ty;
            }
            ++i;
        }
        Point2D.Double ret = new Point2D.Double(ex, ey);
        if (this.shera.CheckCoord(ret, 3.0)) {
            return ret;
        }
        ret = this.shera.CorrectCoord(ret);
        return ret;
    }

    private void Target() {
        Object ene = null;
        double maxscore = Double.NEGATIVE_INFINITY;
        int size = Shera.EL.Enemies.size();
        Enemy ne = Shera.EL.GetNearestEnemy();
        int i = 0;
        while (i < size) {
            Enemy e = (Enemy)Shera.EL.Enemies.elementAt(i);
            double score = 0.0;
            double dist = Util.Dist(e.NX, e.NY, this.shera.getNX(), this.shera.getNY());
            score += -dist;
            if (dist < 300.0) {
                score += 500.0;
            }
            if (dist < 200.0) {
                score += 1000.0;
            }
            if (dist < 100.0) {
                score += 1500.0;
            }
            if (e.Stay()) {
                score += 2000.0;
            }
            if (e.Straight()) {
                score += 1000.0;
            }
            if (ne != null && ne.Distance > 350.0) {
                int ce = this.CountEnemy(e);
                score += (double)(ce * 300);
            }
            if (e.Energy < 50.0) {
                score += (50.0 - e.Energy) * (50.0 - e.Energy) / 5.0;
            }
            if (score > maxscore) {
                maxscore = score;
                this.Target = e;
            }
            ++i;
        }
    }

    void CalcPower() {
        this.Power = 3.0;
        double p = 3.0;
        double ene = this.shera.getEnergy();
        if (this.Target == null) {
            return;
        }
        if (ene < 5.0) {
            this.Power = 0.1;
            return;
        }
        double te = this.Target.Energy;
        if (this.shera.nBot == 1 && this.shera.getEnergy() >= 15.0) {
            te -= 0.9;
        }
        if (te <= 16.0) {
            p = (te + 2.0) / 6.0;
        }
        if (te <= 4.0) {
            p = te / 4.0;
        }
        if (p < 3.0) {
            this.Power = p;
            return;
        }
        if (this.Target.Stay() && te > 16.0) {
            this.Power = 3.0;
            return;
        }
        double dist = Util.Dist(this.shera.x, this.shera.y, this.Target.X, this.Target.Y);
        if (Shera.Melee) {
            int n = this.CountEnemy(this.Target);
            if (n == 1) {
                if (dist > 500.0) {
                    p = Math.min(2.0, p);
                }
                if (dist > 600.0) {
                    p = Math.min(1.0, p);
                }
                if (dist > 700.0) {
                    p = Math.min(0.1, p);
                }
            }
            if (n >= 2) {
                p = dist < 600.0 ? Math.max(3.0, p) : Math.max(2.0, p);
            }
        } else if (dist > 600.0) {
            p = Math.min(0.1, p);
        }
        this.Power = Math.min(3.0, Math.max(p, 0.1));
    }
}

