/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import lazarecki.data.extrapolation.GaussExtrapolator;
import lazarecki.mega.index.FirePowerIndex;
import lazarecki.mega.index.Index;
import lazarecki.mega.index.LastDirectionChangeIndex;
import lazarecki.mega.index.LastVelocityChangeIndex;
import lazarecki.mega.index.LateralVelocityIndex;
import lazarecki.mega.index.VelocityChangeIndex;
import lazarecki.mega.index.WallIndex;
import lazarecki.robot.ModularRobot;
import lazarecki.robot.painter.DataPainterModule;
import lazarecki.robot.painter.DataWavePainterModule;
import lazarecki.robot.painter.GravityPainterModule;
import lazarecki.robot.strategy.AttractorPointModule;
import lazarecki.robot.strategy.FirePowerManagementModule;
import lazarecki.robot.strategy.GravityMovementModule;
import lazarecki.robot.strategy.GuessFactorTargetingModule;
import lazarecki.robot.strategy.HistoryTrackingModule;
import lazarecki.robot.strategy.HitCountModule;
import lazarecki.robot.strategy.IndexedDataModule;
import lazarecki.robot.strategy.RadarLockModule;
import lazarecki.robot.strategy.RepulsorSectionModule;
import lazarecki.robot.strategy.TargetDistanceModule;
import lazarecki.robot.strategy.TargetRepulsionModule;
import lazarecki.robot.strategy.WaveSurfingModule;
import lazarecki.util.RoboUtils;

public class PinkerStinker
extends ModularRobot {
    private static IndexedDataModule targetingDataModule = null;
    private static IndexedDataModule surfingDataModule = null;
    private GuessFactorTargetingModule guessFactorModule;
    private WaveSurfingModule waveSurfingModule;
    private HitCountModule hitCountModule;
    private FirePowerManagementModule fireModule;
    private HistoryTrackingModule historyModule;
    private RadarLockModule lockModule;
    private TargetDistanceModule targetDistance;
    private GravityMovementModule gravityMovementModule;
    private DataPainterModule targetingDataPainter;
    private DataPainterModule surfingDataPainter;
    private GravityPainterModule gravityPainter;
    private DataWavePainterModule myWavesPainter;
    private DataWavePainterModule targetWavesPainter;

    private static IndexedDataModule createSurfingDataModule(PinkerStinker pinker) {
        if (surfingDataModule == null) {
            LinkedList<Index> indexes = new LinkedList<Index>();
            indexes.add(new VelocityChangeIndex(pinker.historyModule, true));
            indexes.add(new LastVelocityChangeIndex(pinker, true));
            indexes.add(new LastDirectionChangeIndex(pinker, true));
            indexes.add(new LateralVelocityIndex(true));
            indexes.add(new WallIndex(pinker.getBattleFieldWidth(), pinker.getBattleFieldHeight(), true));
            GaussExtrapolator extrapolator = new GaussExtrapolator(41, 0.6, 1.0, 1.0);
            surfingDataModule = new IndexedDataModule("Angle", 41, indexes, extrapolator);
            surfingDataModule.initialize(true);
        } else {
            for (Index index : surfingDataModule.getIndexes()) {
                if (index instanceof VelocityChangeIndex) {
                    ((VelocityChangeIndex)index).setHistoryModule(pinker.historyModule);
                    continue;
                }
                if (index instanceof LastVelocityChangeIndex) {
                    ((LastVelocityChangeIndex)index).setRobot(pinker);
                    continue;
                }
                if (!(index instanceof LastDirectionChangeIndex)) continue;
                ((LastDirectionChangeIndex)index).setRobot(pinker);
            }
        }
        return surfingDataModule;
    }

    private static IndexedDataModule createTargetingDataModule(PinkerStinker pinker) {
        if (targetingDataModule == null) {
            LinkedList<Index> indexes = new LinkedList<Index>();
            indexes.add(new VelocityChangeIndex(pinker.historyModule, false));
            indexes.add(new LastVelocityChangeIndex(pinker, false));
            indexes.add(new LastDirectionChangeIndex(pinker, false));
            indexes.add(new LateralVelocityIndex(false));
            indexes.add(new WallIndex(pinker.getBattleFieldWidth(), pinker.getBattleFieldHeight(), false));
            indexes.add(new FirePowerIndex(pinker.fireModule));
            GaussExtrapolator extrapolator = new GaussExtrapolator(41, 0.4, 4.0, 9.0);
            targetingDataModule = new IndexedDataModule("Angle", 41, indexes, extrapolator);
            targetingDataModule.initialize(false);
        } else {
            for (Index index : targetingDataModule.getIndexes()) {
                if (index instanceof VelocityChangeIndex) {
                    ((VelocityChangeIndex)index).setHistoryModule(pinker.historyModule);
                    continue;
                }
                if (index instanceof LastVelocityChangeIndex) {
                    ((LastVelocityChangeIndex)index).setRobot(pinker);
                    continue;
                }
                if (index instanceof LastDirectionChangeIndex) {
                    ((LastDirectionChangeIndex)index).setRobot(pinker);
                    continue;
                }
                if (!(index instanceof FirePowerIndex)) continue;
                ((FirePowerIndex)index).setFireModule(pinker.fireModule);
            }
        }
        return targetingDataModule;
    }

    @Override
    public void init() {
        this.setColors(Color.PINK.brighter(), Color.GRAY.brighter().brighter().brighter(), Color.GRAY.darker(), Color.WHITE, Color.PINK);
        double battleWidth = this.getBattleFieldWidth();
        double battleHeight = this.getBattleFieldHeight();
        this.hitCountModule = new HitCountModule();
        this.fireModule = new FirePowerManagementModule(1.9, 400.0, 3.0);
        this.historyModule = new HistoryTrackingModule(3);
        this.lockModule = new RadarLockModule();
        this.guessFactorModule = new GuessFactorTargetingModule(PinkerStinker.createTargetingDataModule(this));
        this.waveSurfingModule = new WaveSurfingModule(PinkerStinker.createSurfingDataModule(this), this.historyModule);
        this.targetDistance = new TargetDistanceModule(450.0);
        this.gravityMovementModule = new GravityMovementModule();
        this.addStrategist(this.lockModule);
        this.addStrategist(this.historyModule);
        this.addStrategist(this.hitCountModule);
        this.addStrategist(this.fireModule);
        this.addStrategist(surfingDataModule);
        this.addStrategist(this.gravityMovementModule);
        this.addStrategist(targetingDataModule);
        this.addStrategist(this.guessFactorModule);
        this.gravityMovementModule.add(this.waveSurfingModule, 10.0);
        this.gravityMovementModule.add(this.targetDistance, 1.0);
        this.gravityMovementModule.add(new AttractorPointModule(new Point2D.Double(battleWidth * 0.4, battleHeight * 0.4)), 0.05);
        this.gravityMovementModule.add(new AttractorPointModule(new Point2D.Double(battleWidth * 0.4, battleHeight * 0.6)), 0.05);
        this.gravityMovementModule.add(new AttractorPointModule(new Point2D.Double(battleWidth * 0.6, battleHeight * 0.4)), 0.05);
        this.gravityMovementModule.add(new AttractorPointModule(new Point2D.Double(battleWidth * 0.6, battleHeight * 0.6)), 0.05);
        this.gravityMovementModule.add(new RepulsorSectionModule(new Line2D.Double(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, battleHeight)), 100.0), 15.0);
        this.gravityMovementModule.add(new RepulsorSectionModule(new Line2D.Double(new Point2D.Double(0.0, battleHeight), new Point2D.Double(battleWidth, battleHeight)), 100.0), 15.0);
        this.gravityMovementModule.add(new RepulsorSectionModule(new Line2D.Double(new Point2D.Double(battleWidth, battleHeight), new Point2D.Double(battleWidth, 0.0)), 100.0), 15.0);
        this.gravityMovementModule.add(new RepulsorSectionModule(new Line2D.Double(new Point2D.Double(battleWidth, 0.0), new Point2D.Double(0.0, 0.0)), 100.0), 15.0);
        this.gravityMovementModule.add(new TargetRepulsionModule(150.0), 8.0);
        this.targetingDataPainter = new DataPainterModule(targetingDataModule);
        this.surfingDataPainter = new DataPainterModule(surfingDataModule);
        this.gravityPainter = new GravityPainterModule(this.gravityMovementModule);
        this.targetWavesPainter = new DataWavePainterModule(this.waveSurfingModule.getWaves());
        this.myWavesPainter = new DataWavePainterModule(this.guessFactorModule.getWaves());
        this.targetWavesPainter.setHighestValueColor(RoboUtils.cloneTransparentColor(Color.GREEN, 224));
        this.targetWavesPainter.setLowestValueColor(RoboUtils.cloneTransparentColor(Color.GREEN, 0));
        this.myWavesPainter.setHighestValueColor(RoboUtils.cloneTransparentColor(Color.RED, 224));
        this.myWavesPainter.setLowestValueColor(RoboUtils.cloneTransparentColor(Color.RED, 0));
        this.targetingDataPainter.setOrigin(new Point2D.Double(20.0, 80.0));
        this.targetingDataPainter.setHistogramColor(RoboUtils.cloneTransparentColor(Color.RED, 160));
        this.targetingDataPainter.setActiveSegmentColor(RoboUtils.cloneTransparentColor(Color.RED, 160));
        this.targetingDataPainter.setInactiveSegmentColor(RoboUtils.cloneTransparentColor(Color.GRAY, 160));
        this.surfingDataPainter.setOrigin(new Point2D.Double(170.0, 80.0));
        this.surfingDataPainter.setHistogramColor(RoboUtils.cloneTransparentColor(Color.BLUE.brighter().brighter(), 160));
        this.surfingDataPainter.setActiveSegmentColor(RoboUtils.cloneTransparentColor(Color.BLUE.brighter().brighter(), 160));
        this.surfingDataPainter.setInactiveSegmentColor(RoboUtils.cloneTransparentColor(Color.GRAY, 160));
        this.addPainter(this.targetingDataPainter);
        this.addPainter(this.surfingDataPainter);
        this.addPainter(this.gravityPainter);
        this.addPainter(this.myWavesPainter);
        this.setFirePower(0.0);
    }
}

