/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import lazarecki.data.DataIndex;
import lazarecki.data.DataSegmentation;
import lazarecki.data.extrapolation.DataExtrapolator;
import lazarecki.mega.index.Index;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.AbstractDataModule;
import robocode.ScannedRobotEvent;

public class IndexedDataModule
extends AbstractDataModule {
    private List<Index> indexes;
    private DataExtrapolator extrapolator;
    private DataIndex dataIndex;
    private DataSegmentation dataSegments;
    private DataIndex.DataQuery dataQuery;
    private DataSegmentation.DataQueryResult dataSegment;

    public IndexedDataModule(String name, int segments, List<Index> indexes, DataExtrapolator extrapolator) {
        this.indexes = indexes;
        this.extrapolator = extrapolator;
        this.dataIndex = new DataIndex();
        for (Index index : indexes) {
            this.dataIndex.addIndex(index.getName(), index.getSegments());
        }
        this.dataIndex.addIndex(name, segments);
        this.dataSegments = new DataSegmentation(this.dataIndex);
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void initialize(boolean random) {
        if (this.dataIndex.getIndexNames().size() <= 1) {
            this.initDataSegmentWithRandoms(this.dataIndex.createQuery());
            return;
        }
        String[] names = new String[this.dataIndex.getIndexNames().size() - 1];
        int[] inds = new int[this.dataIndex.getIndexNames().size() - 1];
        names = this.dataIndex.getIndexNames().toArray(names);
        Arrays.fill(inds, 0);
        boolean allInitilized = false;
        block0: while (!allInitilized) {
            DataIndex.DataQuery initQuery = this.dataIndex.createQuery();
            int i = 0;
            while (i < inds.length) {
                initQuery.addSegment(names[i], inds[i]);
                ++i;
            }
            if (random) {
                this.initDataSegmentWithRandoms(initQuery);
            } else {
                this.initDataSegmentWithMedian(initQuery);
            }
            allInitilized = true;
            i = inds.length - 1;
            while (i >= 0) {
                if (inds[i] != this.dataIndex.getSegmentsByName(names[i]) - 1) {
                    allInitilized = false;
                    int n = i;
                    inds[n] = inds[n] + 1;
                    int j = i + 1;
                    while (j < inds.length) {
                        inds[j] = 0;
                        ++j;
                    }
                    continue block0;
                }
                --i;
            }
        }
    }

    @Override
    public DataIndex getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public DataIndex.DataQuery getDataQuery() {
        return this.dataQuery;
    }

    @Override
    public DataSegmentation.DataQueryResult getDataSegment() {
        return this.dataSegment;
    }

    @Override
    public DataExtrapolator getExtrapolator() {
        return this.extrapolator;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        RobotInfo me = new RobotInfo(this.getRobot());
        RobotInfo enemy = new RobotInfo(event, this.getRobot());
        this.dataQuery = this.dataIndex.createQuery();
        for (Index index : this.getIndexes()) {
            this.dataQuery.addSegment(index.getName(), index.getSegmentIndex(me, enemy));
        }
        this.dataSegment = this.dataSegments.queryData(this.dataQuery);
    }

    private void initDataSegmentWithRandoms(DataIndex.DataQuery initQuery) {
        Random rand = new Random();
        DataSegmentation.DataQueryResult res = this.dataSegments.queryData(initQuery);
        int index = (int)(rand.nextDouble() * (double)res.getSegments());
        int i = 0;
        while (i < res.getSegments()) {
            double value = res.getValueAt(i);
            double avgValue = this.getExtrapolator().getValue(index, i, value, 1.0);
            res.setValueAt(i, avgValue);
            ++i;
        }
    }

    private void initDataSegmentWithMedian(DataIndex.DataQuery initQuery) {
        DataSegmentation.DataQueryResult res = this.dataSegments.queryData(initQuery);
        int index = (res.getSegments() - 1) / 2;
        int i = 0;
        while (i < res.getSegments()) {
            double value = res.getValueAt(i);
            double avgValue = this.getExtrapolator().getValue(index, i, value, 1.0);
            res.setValueAt(i, avgValue);
            ++i;
        }
    }
}

