/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.StrategicModule;
import lazarecki.util.RoboUtils;
import robocode.StatusEvent;
import robocode.util.Utils;

public class RepulsorSectionModule
extends StrategicModule {
    private Line2D section;
    private double maxRepulsionDistance;

    public RepulsorSectionModule(Line2D section, double maxRepulsionDistance) {
        this.section = section;
        this.maxRepulsionDistance = maxRepulsionDistance;
    }

    public Line2D getSection() {
        return this.section;
    }

    public double getMaxRepulsionDistance() {
        return this.maxRepulsionDistance;
    }

    @Override
    public void onStatus(StatusEvent event) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        double absRepulsionAngle = Utils.normalAbsoluteAngle((double)(RoboUtils.projectAbsoluteAngle(this.getSection().getP1(), this.getSection().getP2()) + 1.5707963267948966));
        double absInvRepulsionAngle = Utils.normalAbsoluteAngle((double)(absRepulsionAngle + Math.PI));
        Point2D towardSectionPoint = RoboUtils.projectPoint(myInfo, absInvRepulsionAngle, this.getMaxRepulsionDistance());
        Line2D.Double towardSectionLine = new Line2D.Double(myInfo.getPosition(), towardSectionPoint);
        if (!towardSectionLine.intersectsLine(this.getSection())) {
            return;
        }
        double distance = this.getSection().ptLineDist(myInfo.getPosition());
        Point2D attractor = RoboUtils.projectPoint(myInfo, absRepulsionAngle, 2.0 * (this.getMaxRepulsionDistance() - distance));
        this.getRobot().setDestination(attractor);
    }
}

