/*
 * Decompiled with CFR 0.152.
 */
package syl.core;

import syl.core.BaseRobot;
import syl.util.Coordinate;

public class Enemy {
    private String name;
    private double heading = 0.0;
    private double oldHeading = 0.0;
    private double bearing = 0.0;
    private double oldBearing = 0.0;
    private double velocity = 0.0;
    private double oldVelocity = 0.0;
    private double energy = 0.0;
    private double oldEnergy = 0.0;
    private double distance = 0.0;
    private double oldDistance = 0.0;
    private long scanTime = 0L;
    private long oldScanTime = 0L;
    private Coordinate coordinate;
    private Coordinate oldCoordinate;

    public Enemy(String name) {
        this.name = name;
    }

    public void update(BaseRobot robot, double distance, double energy, double heading, double bearing, double velocity, long scanTime) {
        this.oldDistance = this.distance;
        this.oldEnergy = this.energy;
        this.oldHeading = this.heading;
        this.oldVelocity = this.velocity;
        this.oldScanTime = this.scanTime;
        this.oldCoordinate = this.coordinate;
        this.oldBearing = this.bearing;
        this.distance = distance;
        this.energy = energy;
        this.heading = heading;
        this.velocity = velocity;
        this.bearing = bearing;
        this.scanTime = scanTime;
        this.coordinate = Coordinate.getCoordinate(robot.getX(), robot.getY(), distance, robot.getEnemyAngle(bearing));
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getBearing() {
        return this.bearing;
    }

    public String getName() {
        return this.name;
    }

    public double getOldDistance() {
        return this.oldDistance;
    }

    public double getOldEnergy() {
        return this.oldEnergy;
    }

    public double getOldHeading() {
        return this.oldHeading;
    }

    public double getOldBearing() {
        return this.oldBearing;
    }

    public long getOldScanTime() {
        return this.oldScanTime;
    }

    public double getOldVelocity() {
        return this.oldVelocity;
    }

    public long getScanTime() {
        return this.scanTime;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Coordinate getOldCoordinate() {
        return this.oldCoordinate;
    }
}

