package ers.nano.lig;

/**
 * Author: ER Samson
 * 
 * First few iterations was built with (ISuckNano 0.1d)
 * 		• Pattern Matching gun
 * 		• Stop-Go Movement with randomizer (using mLen from PM gun)
 * 		• Staying perpendicular to the enemy
 * 
 * The design has evolved to
 * 		• Weighted Moving Average gun
 * 		• Multi-Mode Movement
 * 			• Stop-Go Movement
 * 			• Oscillator Movement
 * 		• Staying perpendicular to the enemy
 * 		Note: can still save code-size on many areas
 * 
 *  -- Credits to the following --
 * Heavy influence coming from both Yatagan and NeophytePRAL as their multi-mode
 * movement really crushes this robot. Obsession to improve came from timmit's TimDog
 * which (I think) features oscillation and destroys ISuckNano (60-40). ISuckNano
 * was built to have minimal weaknesses, a true jack-of-all trades. Goal now is to 
 * create a bot without look-up tables since I'm too dumb to use it D: 
 * Hopefully LigMA is as competitive as ISuckNano in NanoRumble.
 * 
 * Movement:
 * 		• Mark Whiteley      - http://mark.random-article.com/robocode/improved_movement.html
 * 		• Wiki               - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Wiki               - https://robowiki.net/wiki/Oscillator_Movement
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Radar:
 * 		• Wiki               - https://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targetting:
 * 		• Wiki               - https://robowiki.net/wiki/Rolling_Averages
 *		• Exauge             - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Code Shrinking Tips:
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 
 * Symbolic Pattern String (old PM gun):
 *      • Sheldor            - https://robowiki.net/wiki/Foilist
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class LigMA extends AdvancedRobot {

	// ---------- FINAL ----------	
	private static final int	BULLET_POWER	= 2;
	private static final int	ANTIRAM_FACTOR	= 72;
	private static final int	AVERAGE_FACTOR	= 8; //orig 15
	private static final int	ORBIT_DISTANCE	= 160;
	private static final int	DISTANCE_FACTOR	= 3000;

	// ---------- Generic Variables ----------
	private static double 		enemyHealth;
	private static double		fireLatVel;
	private static double		movingLatVel	= 0;
	private static double		moveDistance	= Double.POSITIVE_INFINITY; //ORBIT_DISTANCE;
	private static int			moveMode;//		= 1;

	public void run() {
		// Color Identification
		//setColors(Color.darkGray, Color.black, Color.orange); // Saving 13 code size!

		// Easy targeting and infinite radar movement
		setAdjustGunForRobotTurn(true); // Saving 5 code size!
	    setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		// ---------- Generic Variables ----------	
		int enemyDistance;
		double absoluteBearing;
		double lateralVelocity;
		double bulletPower;
		
		// ---------- Musashi Movement Logic ----------				
		setTurnRightRadians(Math.cos( (absoluteBearing = e.getBearingRadians()) + 
				((ORBIT_DISTANCE - (enemyDistance = (int)e.getDistance())) * 
				(getVelocity() / DISTANCE_FACTOR)))); // Idea from Yatagan

		// ---------- Gun Logic ----------
		// Weighted moving average of lateral velocities of opponent
		lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - 
				(absoluteBearing += getHeadingRadians()));
		
		movingLatVel = (movingLatVel * AVERAGE_FACTOR + lateralVelocity + fireLatVel)
				/ (AVERAGE_FACTOR + 2);


		// Aim. Consider bullet power/speed changes from own gun
		// Energy management with Anti-Ram
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - 
				getGunHeadingRadians() + (movingLatVel / Rules.getBulletSpeed(
				bulletPower = Math.min(BULLET_POWER + (int)(ANTIRAM_FACTOR 
				/ enemyDistance), enemyHealth / 4)))));
				
		if (setFireBullet(bulletPower) != null ) {
			fireLatVel = lateralVelocity;
		}

		// ---------- Stop'n'Go Movement Logic ----------
		// Basic health detection, setAhead logic lifted from John Cleland
		setAhead(moveDistance);
		if ((char)(enemyHealth - 1 - (enemyHealth = e.getEnergy())) < 4
				&& (moveMode % 2) != 0) {
			onHitWall(null);
		}

		// ---------- Radar Logic ---------- 
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());	
	}

	public void onHitWall(HitWallEvent e) {
		moveDistance = -moveDistance;
	}

	/**
	 * Changes One-way to Two-way oscillator movement
	 */	
	public void onDeath(DeathEvent e) {
		moveMode++;
	}
	
	/**
	 * Changes One-way to Two-way every bullet hit
	 */	
	public void onHitByBullet(HitByBulletEvent e) {	
		if (moveMode > 3) {
			moveMode++;
		}
	}
}
