/*
 * Class.java
 *
 * Created on April 7, 2002, 1:15 AM
 */

package tobe.movement;
import tobe.util.*;
import robocode.*;
import tobe.platform.*;
import tobe.statistics.*;

/**
 * Anti-gravity that avoids potential flying shrapnel instead of robots
 *
 * @author  tobe
 * @version 
 */
public class AntiShrapnel implements Movement {
	
        private BearingVector gravity = new BearingVector();
        private BearingVector wall = new BearingVector();
		private BearingVector b = new BearingVector();
        private double wallWeight;
        private double movement = 1000;
		private double turnOffset = Math.PI/6;
		//private double turnOffsetChange = -Math.PI/18;
        private double wait = 0;//try to get a bit more fluid movement
		private java.util.LinkedList shrapnel = new java.util.LinkedList();
        
        public void init(CommandCentre cc) {
        	wait = 0;
        }
        
        public void go(CommandCentre cc) {
			AdvancedRobot bot = cc.getBot();
			double x = bot.getX();
			double y = bot.getY();
			//if(Math.random() < 0.005) movement = -movement;
            wait--;
            if(wait > 0) return;
			double myHeading = bot.getHeadingRadians();
			if(movement < 0) myHeading = BearingVector.normalizeAngle(myHeading+Math.PI);
            //calculate the gravity
			//start with some anti-matter rocket fuel
            gravity.setPolar(myHeading+Math.PI,0.01,x,y);
			
			java.util.Iterator i;

			//robot gravity and add new shrapnel
			//do this before because I want it to move
			double nearestBot = bot.getBattleFieldWidth()+bot.getBattleFieldHeight();
            i = cc.getTargetStatisticsIterator();
			double avgX = x;
			double avgY = y;
            while( i.hasNext() ) {
				TargetStatistics t = (TargetStatistics) i.next();
				if(t.isSeen()) {
					double d = t.getDistance(x,y);
					nearestBot = Math.min(nearestBot, d);
					//if(t != cc.getPreferredTarget()) gravity.add(opp.getBearing(), 1000.0/(opp.getDistance()*opp.getDistance()));
					//else gravity.add(opp.getBearing(), 1000.0/(opp.getDistance()*opp.getDistance()*opp.getDistance()));
					gravity.add(t.getBearing(x,y), (t.getEnergy()-bot.getEnergy())*100.0/(d*d));
					avgX += t.getX();
					avgY += t.getY();
				}
			}
			avgX /= bot.getOthers()+1;
			avgY /= bot.getOthers()+1;
			avgX -= x;//from my viewpoint
			avgY -= x;
			gravity.add(Math.atan2(avgX,avgY), 1000/(avgX*avgX+avgY*avgY));
			
			//calculate gravity
			i = cc.getShrapnelIterator();
			while( i.hasNext() ) {
				Shrapnel s = (Shrapnel) i.next();
				b.setPoints(s.getToX(), s.getToY(), x,y);
				gravity.add(b.getBearing(), s.getPower()*1000.0/(b.getDistance()*b.getDistance()));
				b.setPoints(s.getFromX(), s.getFromY(), x,y);
				//from fluid
				double diff = BearingVector.normalizeAngle(b.getBearing() - s.getBearing());//my position relative to bullets motion
				diff = Math.abs(Math.PI/2 - diff)-Math.PI/4;//get out of way if heading for me, don't move into it otherwise
				if(turnOffset < 0) diff = -diff;
				b.setBearing(b.getBearing()+diff);
				gravity.add(b.getBearing(), s.getPower()*1000.0/(b.getDistance()*b.getDistance()));
            }
			//gravity.setBearing(gravity.getBearing() + turnOffset);

            //double myHeading = bot.getHeadingRadians();
            //if(movement < 0) myHeading = BearingVector.normalizeAngle(myHeading + Math.PI);
            //add a wall repellant if close to wall
            wall.setPolar(myHeading, 10000, x,y);
            if(wall.getToX() < 0) wall.setDistanceToX(0);
            if(wall.getToX() > bot.getBattleFieldWidth()) wall.setDistanceToX(bot.getBattleFieldWidth());
            if(wall.getToY() < 0) wall.setDistanceToY(0);
            if(wall.getToY() > bot.getBattleFieldHeight()) wall.setDistanceToY(bot.getBattleFieldHeight());
			
			wallWeight = 1000*(1+shrapnel.size());//(shrapnel.size()+1)*1000;
			//if(wall.getDistance() < 2*bot.getWidth()) wallWeight *=2;
            //    gravity.add(wall.getBearing(), wallWeight/Math.pow(wall.getDistance(), 2));

            b.setPolar(0,1,x,y);
            b.setDistanceToY(bot.getBattleFieldHeight());
			double d = Math.max(1, b.getDistance()-bot.getWidth());
            //if(b.getDistance() < 2*bot.getWidth()) //wallWeight *= 2;
                gravity.add(b.getBearing(), wallWeight/(d*d*bot.getOthers()));
            b.setPolar(Math.PI,1,x,y);
            b.setDistanceToY(0);
			d = Math.max(1, b.getDistance()-bot.getWidth());
            //if(b.getDistance() < 2*bot.getWidth()) //wallWeight *= 2;
                gravity.add(b.getBearing(), wallWeight/(d*d*bot.getOthers()));
            b.setPolar(Math.PI/2,1,x,y);
            b.setDistanceToX(bot.getBattleFieldWidth());
			d = Math.max(1, b.getDistance()-bot.getWidth());
            //if(b.getDistance() < 2*bot.getWidth()) //wallWeight *= 2;
                gravity.add(b.getBearing(), wallWeight/(d*d*bot.getOthers()));
            b.setPolar(-Math.PI/2,1,x,y);
            b.setDistanceToX(0);
			d = Math.max(1, b.getDistance()-bot.getWidth());
            //if(b.getDistance() < 2*bot.getWidth()) //wallWeight *= 2;
                gravity.add(b.getBearing(), wallWeight/(d*d*bot.getOthers()));
            //now turn away from the gravity-pull
			//turnOffset += turnOffsetChange;
			//if(Math.abs(turnOffset) >= Math.PI/3) turnOffsetChange = -turnOffsetChange;
            double turn = BearingVector.normalizeAngle(gravity.getBearing()-myHeading+turnOffset);
			if(Math.abs(turn) < Math.PI/4) movement = -movement;
			else turn = BearingVector.normalizeAngle(turn+Math.PI);
            /*if(Math.random() < 0.1) {//change direction
                movement = -movement;
				turn = BearingVector.normalizeAngle(turn+Math.PI);  
                bot.setMaxVelocity(2);
            } else bot.setMaxVelocity(4+Math.random()*6);*/
			if(Math.random() < 0.01) turnOffset = -turnOffset;
            bot.setTurnRightRadians(turn);
            bot.setAhead(movement);
			double mv = (Math.PI - Math.abs(turn))/Math.PI;
			//bot.out.println(mv);
			bot.setMaxVelocity(9*mv);
			//bot.setMaxVelocity((Math.PI/2 - Math.abs(turn))/Math.toRadians(80)+4);
            //slow down if heading towards wall
            //wall.setPolar(bot.getHeadingRadians(), movement, bot.getX(), bot.getY());
            //if(wall.getToX() < 0) wall.setDistanceToX(0);
            //if(wall.getToX() > bot.getBattleFieldWidth()) wall.setDistanceToX(bot.getBattleFieldWidth());
            //if(wall.getToY() < 0) wall.setDistanceToY(0);
            //if(wall.getToY() > bot.getBattleFieldHeight()) wall.setDistanceToY(bot.getBattleFieldHeight());
            //bot.setMaxVelocity((8*wall.getAbsoluteDistance())/(3*bot.getWidth()));
			//if(wall.getAbsoluteDistance() < 1.5*bot.getWidth()) turnOffset = -turnOffset;
			//wait = 20;//dont change movement too soon
		wait = 4;
            return;
        }
}
