package tobe.statistics;
import tobe.util.*;
import robocode.*;

/**
 * When we take a shot, we wish to see what has happened when it should have hit.
 * @author Torbjrn Gannholm
 */
	
	public class EvasionCondition extends Condition{
		final AdvancedRobot bot;
		final double heading;
		final double velocity;
		final double x;
		final double y;
		final double time;
		final public String enemyName;
		final double timeToHit;
		
		/** must supply necessary information for follow-up */
		public EvasionCondition(AdvancedRobot me, String enemy, double timeToHit, double when,
				double enemyHeading, double enemyAvgVelocity, double enemyX, double enemyY) {
			super("EvasionCondition");
			bot = me;
			heading = enemyHeading;
			velocity = enemyAvgVelocity;
			x = enemyX;
			y = enemyY;
			time = when;
			this.timeToHit = timeToHit;
			enemyName = enemy;
		}
		
		public boolean test() {
			return time + timeToHit <= bot.getTime();
		}
	}
	