package bvh.two;

/**
 * Constanten zijn apart vastgelegd in een interface
 */
interface Constanten {
   static final double             TWEEPI = 2D * Math.PI; // 360 graden draaien
   static final double             PI = Math.PI; // 180 graden draaien
   static final double             DRIEKWARTPI = 3D * Math.PI / 4D; // 135 graden draaien
   static final double             HALFPI = Math.PI / 2D; //  90 graden draaien
   static final double             DRIEACHTSTEPI = 3D * Math.PI / 8D; //  67.5 graden draaien
   static final double             KWARTPI = Math.PI / 4D; //  45 graden draaien
   static final double             EENACHTSTEPI = Math.PI / 8D; //  22.5 graden draaien
   static final double             EENZESTIENDEPI = Math.PI / 16D; //  11.25 graden draaien
   static final double             BOTGROOTTE = 36D; // de afmetingen van een robot
   static final double             WANDAFSTAND = 44D; // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double             RONDING = 80D; // ronding van slagveld
   static final double             DIAMETERBINNENCIRKEL = 300D;     // straal binnen cirkel
   static final double             MAXIMUM_SNELHEID = 8;
   static final double             MINIMUMVUURKRACHT = 0.1D;
   static final double             STANDAARDVUURKRACHT = 1.9D;
   static final int                GF_MIDDEN = 11; // hoeksegmenten = 2*GF_MIDDEN+1
   static final int                SLAGKARAKTERISERING = 2;
   static final int                POSITIESEGMENTEN = 3;
   static final int                AFSTANDSEGMENTEN = 8;
   static final int                LATERALESNELHEIDSSEGMENTEN = 9;
   static final int                TRANSVERSALESNELHEIDSSEGMENTEN = 9;
} // EINDE CLASS Constanten
