/*
 * Log.java
 *
 * Created on 15 maart 2004, 0:00
 */

package vic;
import java.util.ArrayList;
/**
 *
 * @author  Vic Stewart
 */
public class Log extends Base
{
    ArrayList log;
    Situation Start, End;
    int LastBestIndex;
    int AgeCounter = 0, RepairCounter = 0;
    
    Log()
    {
        log = new ArrayList();
        Start = new Situation();
        End   = new Situation();
        for(int i = 0; i < Situation.NumDimensions; i++)
        {
            Start.setDimension(i, 0  , 0, 127);
              End.setDimension(i, 127, 0, 127);
        }
    }
    
    int getSize()
    {
        return log.size();
    }
    
    int getBestIndex(Situation situation, int OldSummedDistance)
    {
        int bestSummedDistance, SummedDistance, previousDistance, distance;
        int bestIndex=0;

        //System.out.println("getBestIndex, logsize=" + log.size());

        if(log.size()==0) 
        {
            //System.out.println();
            return 0;
        }
        
            //first do an imperfect search to speed up the process
        //test index 0
        bestIndex = 0;
        SummedDistance = ((Observation)log.get(0)).distance(situation) + Start.distance(situation);
        /*
        if(log.size() < 40)
        {
            System.out.println("i=" + 0 + ", D=" + SummedDistance);
        }
         **/
        bestSummedDistance = SummedDistance;
        //then loop, but each iteration skip [inc] records, so that the loop is always less then [maxLoop] iterations long
        int maxLoop = 100;
        int inc = 1;
        if(log.size() >= (maxLoop * 2))
        {
            inc = Math.round(log.size() / maxLoop);
        }
        for (int i = inc ; i < log.size(); i+=inc)
        {
            SummedDistance = ((Observation)log.get(i-1)).distance(situation) + 
                             ((Observation)log.get(i)).distance(situation);
            /*
            if(log.size() < 40)
            {
                System.out.println("i=" + i + ", D=" + SummedDistance);
            }
             **/
            if(SummedDistance < bestSummedDistance) 
            {
                bestIndex = i;
                bestSummedDistance = SummedDistance;
            }
        }
        //test last index
        SummedDistance = ((Observation)log.get(log.size()-1)).distance(situation) + End.distance(situation);
        /*
        if(log.size() < 40)
        {
            System.out.println("(i=" + log.size() + ", D=" + SummedDistance + ")");
        }
         **/
        if(SummedDistance < bestSummedDistance) 
        {
            bestIndex = log.size();
            bestSummedDistance = SummedDistance;
        }

        if(inc>1)
        {

                //now do an inner loop, refining the search
            //int a = bestIndex - inc + 1;
            int a = bestIndex - 300;
            if(a < 0) a = 0;
            //int b = bestIndex + inc - 1;
            int b = bestIndex + 300;
            if(b > (log.size()-1)) b = log.size()-1;

            //System.out.println("first pass: bestIndex=" + bestIndex + ", inc=" + inc + ", a=" + a + ", b=" + b);

            if(a==0)
            {
                previousDistance = Start.distance(situation);
            }
            else
            {
                previousDistance = ((Observation)log.get(a-1)).distance(situation);
            }
            for (int i = a; i <= b; i++)
            {
                distance = ((Observation)log.get(i)).distance(situation);
                SummedDistance = distance + previousDistance;
                /*
                if(inc < 15)
                {
                    System.out.println("i=" + i + ", D=" + SummedDistance);
                }
                 **/
                if(SummedDistance < bestSummedDistance) 
                {
                    bestSummedDistance=SummedDistance;
                    bestIndex = i;
                }
                previousDistance = distance;
            }
            if(b==log.size()-1)
            {
                SummedDistance = End.distance(situation) + ((Observation)log.get(b)).distance(situation);
                /*
                if(inc < 15)
                {
                    System.out.println("(i=" + log.size() + ", D=" + SummedDistance + ")");
                }
                 **/
                if(SummedDistance < bestSummedDistance) 
                {
                    bestSummedDistance=SummedDistance;
                    bestIndex = log.size();
                }
            }
        }
        
        
//        if(OldSummedDistance == -1 || OldSummedDistance > bestSummedDistance)
//        {
            /*
            if(OldSummedDistance != -1)
            {
                System.out.println("        better index found!: oldD=" + OldSummedDistance + " newD=" + bestSummedDistance + " log size=" + log.size());
            }
             **/
            //System.out.println();
            return bestIndex;
 //       }
            /*
        else
        {
            if(OldSummedDistance < bestSummedDistance)
            {
                //System.out.println("        .......NO better or equal index found!: oldD=" + OldSummedDistance + " newD=" + bestSummedDistance + " log size=" + log.size());
                //System.out.println();
                return -2;
            }
            else
            {
                //System.out.println("        equal index found!: oldD=" + OldSummedDistance + " newD=" + bestSummedDistance + " log size=" + log.size());
                //System.out.println();
                return -1;
            }
        }
             **/
    }
   
    void addToLog(int index, Observation obs)
    {
        obs.setAge(AgeCounter++);
        //if(AgeCounter%100==0) System.out.println("AgeCounter=" + AgeCounter);
        log.add(index, obs);
    }
    
    void addObservation(Situation situation, double delta_distance, double delta_heading)
    {
        int index = getBestIndex(situation, -1);
        Observation obs = new Observation(situation, delta_distance, delta_heading);
        addToLog(index, obs);
    }
    
    int Repairs=0, SuccessfulRepairs=0, FailedRepairs=0;
    
    boolean repair(int Index)
    {
        //System.out.println();
        if(log.size()==1) return false;

        Repairs++;
        
        int SummedDistance, newIndex;
            //remove and reinsert this Observation from the log so it may get into a better neighbourhood
        Situation situation = (Situation)log.get(Index);
        if(Index == 0)
        {
            if(log.size()==1)
            {
                SummedDistance = Start.distance(situation) + End.distance(situation);
            }
            else
            {
                SummedDistance = Start.distance(situation) + ((Observation)log.get(Index+1)).distance(situation);
            }
        }
        else if(Index == (log.size()-1))
        {
            SummedDistance = ((Observation)log.get(Index-1)).distance(situation) + End.distance(situation);
        }
        else
        {
            SummedDistance = ((Observation)log.get(Index-1)).distance(situation) + ((Observation)log.get(Index+1)).distance(situation);
        }

        //System.out.println("repairing index " + Index + " SummedDistance = " + SummedDistance + " log size = " + log.size());
        
        Observation obs = (Observation)log.remove(Index);
        newIndex = getBestIndex(situation, SummedDistance);
        
        /*
        if(newIndex == -1)
        {
            //System.out.println("    no repair needed, reinserting at index " + Index);
            addToLog(Index, obs);
            //System.out.println("repairs:" + Repairs + ", faults:" + FailedRepairs + ", Successes:" + SuccessfulRepairs);
            return false;
        }
        else if(newIndex == -2)
        {
            //System.out.println("    repair error worse index found, reinserting at index " + Index);
            addToLog(Index, obs);
            FailedRepairs++;
            //System.out.println("repairs:" + Repairs + ", faults:" + FailedRepairs + ", Successes:" + SuccessfulRepairs);
            return false;
        }
        else
        {
            //System.out.println("    repair needed! new index " + newIndex );
            addToLog(newIndex, obs);
            SuccessfulRepairs++;
            //System.out.println("repairs:" + Repairs + ", faults:" + FailedRepairs + ", Successes:" + SuccessfulRepairs);
            return true;
        }
         **/
        addToLog(newIndex, obs);
        //System.out.println("repairs:" + Repairs + ", faults:" + FailedRepairs + ", Successes:" + SuccessfulRepairs);
        return true;

    }
    
    void reorder()
    {
       // System.out.println("true repairs = " + SuccessfulRepairs + ", repair success ratio = " + 100*((double)SuccessfulRepairs/(double)Repairs) + ", fail ratio = " + 100*((double)FailedRepairs/(double)Repairs));
        /*
        RepairCounter += 1000;
        int Counter=0;
        for(int i = 0; i < log.size(); i++)
        {
            if(((Observation)log.get(i)).getAge() < RepairCounter) 
            {
                Counter++;
                repair(i);
            }
        }
         **/
        //System.out.println("Age Repair Phase: " + Counter + " observations re-inserted");
    }
}
