package kawigi.spare.parts;
import robocode.*;
/**
 * RadarSelector - selects and uses the most appropriate RadarControl object
 */
public class RadarSelector extends PartSelector 
{
	private RadarControl[] radars;
	private AdvancedRobot robot;
	
	public RadarSelector(AdvancedRobot robot, TargetSelector targetter)
	{
		this.robot = robot;
		radars = new RadarControl[2];
		radars[0] = new SpinningRadar(robot);
		radars[1] = new TrackingRadar(robot, targetter);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public Part getSelectedPart()
	{
		if (robot.getOthers() != 1)
			return radars[0];
		else
			return radars[1];
	}
}
