package paulk;
import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
//import java.awt.Color;

public class PaulV3 extends AdvancedRobot
{
	/**
	 * run: PaulV3's default behavior
	 */
	boolean cible;
	ScannedRobotEvent scanne;
	int lastHit;
	double averageHit;
	double bonnePuissance;
	double puissMoy=0.1;
	EnergieManager energieM=null;
	static CanonManager canonM=null;
	static MouvementManager mouvM=null;
	double x,y,dx,dy;
	double X,Y;
	long dernierTempsPuiss=-1;
	double dernierPuiss=0;

	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		cible=false;
		lastHit=-1000;
		averageHit=1.;
		int lastDedans=-1000;
		if (canonM==null)
			canonM=new CanonManager(this);
		else 
			canonM.nouvBot(this);
		if (mouvM==null)
			mouvM=new MouvementManager(this);
		else 
			mouvM.nouvBot(this);
		energieM=new EnergieManager(mouvM,this);
		x=getX();y=getY();
		dx=0;dy=0;
		int sens=1;
		double angle=0;
		X=getBattleFieldWidth();
		Y=getBattleFieldHeight();
		while(true) {
			dx=x-getX();
			dy=y-getY();
			if (!dedans(getX(),getY(),50) && getTime()-lastDedans>9){
				dx=0;dy=0;
				lastDedans=(int)getTime();
			}
			if (getOthers()>1 || scanne==null){
				if (Math.abs(dx)+Math.abs(dy)<25.){
					do{
						x=50+(getBattleFieldWidth()-100)*Math.random();
						y=50+(getBattleFieldHeight()-100)*Math.random();
						dx=x-getX();
						dy=y-getY();
					}while (Math.abs(dx)+Math.abs(dy)>200);
				}
				angle=Utils.normalRelativeAngle(Math.atan2(dx,dy)-getHeadingRadians()+(sens==-1 ? 3.1415:0));
				if (Math.abs(angle)>100*3.14/180){
					out.println("Demi tour! car angle="+angle);
					sens=-sens;
					angle=Utils.normalRelativeAngle(Math.atan2(dx,dy)-getHeadingRadians()+(sens==-1 ? 3.1415:0));
					out.println("Maintenant angle="+angle);
				}
				setTurnRightRadians(angle);
				setAhead(sens*(8-Math.abs(angle)*32/3.14));
			}
			else {
				mouvM.bouge(scanne);
			}
			if (cible){
				if (getGunHeat()<0.1 && Math.atan(getGunTurnRemaining()*3.14/180)*scanne.getDistance()<10){
					canonM.feu(scanne.getName(),bonnePuissance);
				}
			}
			else{
				if (getRadarTurnRemaining()<1.){
					setTurnRadarRight(45.);
				}
			}
			cible=false;
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		energieM.onScannedRobot(e,getTime());
		canonM.onScannedRobot(e);
		if (cible)
			return;
//		out.println(e.getName()+" détecté !");
		scanne=e;
		cible=true;
		double angle=e.getBearing()+getHeading();
		double futurePos=canonM.getFuturePos(e.getName());
		bonnePuissance=puissance(e.getDistance());
		setTurnGunRight(optimise(futurePos-getGunHeading()));
//		out.println("HOT+"+(180/3.14*Math.asin(lateralVelocity/vitesse)));
//		out.println("Canon a décaler de "+optimise(angle-getGunHeading())+" sur la droite.");
		if (getRadarTurnRemaining()<=45.){
			setTurnRadarRight(optimise(angle-getRadarHeading()));
		}
//		out.println("Radar a décaler de "+optimise(angle-getRadarHeading())+" sur la droite.");
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		energieM.onHitByBullet(e);
		mouvM.onHitByBullet(e);
		double angle=e.getBearing()+getHeading();
		if (getTurnRemaining()<2.)
			setTurnRight(optimise(angle-getHeading()+90.));
		lastHit=(int)getTime();
		if (cible)
			return;
		setTurnRadarRight(optimise(angle-getRadarHeading()));
		setTurnGunRight(optimise(angle-getGunHeading()));
	}

	public void onHitRobot(HitRobotEvent e){
		energieM.onHitRobot(e);
//		mouvM.onHitRobot(e);
		double angle=e.getBearing()+getHeading();
		setTurnGunRight(optimise(angle-getGunHeading()));
		setTurnRadarRight(optimise(angle-getRadarHeading()));
		cible=true;
		if ((e.getEnergy()+60<getEnergy() && e.getEnergy()<20) || (getOthers()==1 && getEnergy()>e.getEnergy())){
			out.println("RAMMING sur "+e.getName());
			averageHit=5;
			x=getX()+10*Math.sin(angle*3.14/180);
			y=getY()+10*Math.cos(angle*3.14/180);
			return;
		}
		out.println("Stop ! Je touche "+e.getName());
		x=getX()-dx;
		y=getY()-dy;
	}

	public double optimise(double a){
		double angle=(a+360*100)%360;
		if (angle>180)
			return angle-360;
		return angle;
	}

	public void onBulletHit(BulletHitEvent e){
		energieM.onBulletHit(e);
		averageHit=averageHit*0.6+0.4;
		puissMoy=puissMoy*0.6+e.getBullet().getPower()*0.4;
	}
	
	public void onBulletMissed(BulletMissedEvent e){
		averageHit*=0.6;
	}

	public void onRobotDeath(RobotDeathEvent e){
		energieM.onRobotDeath(e);
	}

	public void onPaint(java.awt.Graphics2D g) {
		canonM.onPaint(g);
		mouvM.onPaint(g);
		g.drawOval((int)x-5,(int)y-5,5,5);
	}

	boolean dedans(double x, double y, double marge){
		return x>marge && x<=getBattleFieldWidth()-marge
			&& y>marge && y<=getBattleFieldHeight()-marge;
	}

	public double puissance(double distance){
		if (dernierTempsPuiss==getTime())
			return dernierPuiss;
//		double puiss=3-2.9*(Math.max(0,distance*distance-40000.))/(1200*1200);
//		return 3;
//		return Math.max(0.1,Math.min(3,Math.sqrt(averageHit)*puiss));
		double pMaxi=0.1,maxi=-1;
		for (double p=0.1;p<=3;p+=0.01){
			double gain=0;
			double a=(0.3-p*0.04)*(1-(distance/(20-3*p))/(900/11.));
			if (getOthers()==1){
				gain=Rules.getBulletDamage(p)*a*2;
			}
			gain=(gain-p+3*p*a)/(Rules.getGunHeat(p)/0.1);
			if (gain>maxi){
				maxi=gain;
				pMaxi=p;
			}
		}
		dernierPuiss=Math.min(pMaxi,getEnergy()/2.);
		dernierTempsPuiss=getTime();
		return dernierPuiss;
	}

	static double limite(double debut,double a,double fin){
		return Math.min(Math.max(debut,a),fin);
	}

	static double distance(double debut,double a,double fin){
		return Math.min(a-debut,fin-a);
	}
}
