package djc.radar;

import djc.*;
import djc.util.MyUtils;
import robocode.*;
import robocode.util.Utils;

/**
 * Pretty much stripped from RadarBot; altered to work within my bot-framework
 */
public class LockRadar extends BaseRadar
{
	private int timeSinceLastScan = 10;
		
	public LockRadar(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "LOCKRADAR";
	}
	
	public void reset() {
	}
	
	// Spin Radar!
	public void doWork() {
		timeSinceLastScan++;
		double radarOffset = Double.POSITIVE_INFINITY;
		if(timeSinceLastScan < 3 && myrobot.theEnemyManager.currentEnemy != null) {
			radarOffset = robocode.util.Utils.normalRelativeAngle(myrobot.getRadarHeadingRadians() - myrobot.theEnemyManager.currentEnemy.absBearing);
			radarOffset += MyUtils.sign(radarOffset) * Math.toRadians(22.5);
		}
		myrobot.setTurnRadarLeftRadians(radarOffset);
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//enemyAbsoluteBearing = myrobot.getHeadingRadians() + e.getBearingRadians();
		timeSinceLastScan = 0;
	}
	
}
