package jam;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.util.*;
import java.io.*;
import java.util.zip.*;
import jam.utils.jUtil;
/*
    RaikoMX 0.32 by Jamougha.

    Credit for ideas or parts of this code go to PEZ, Kawigi, ABC, and probably others who I've forgotten to mention.

    Released under the RWPCL.
*/

public class RaikoMX extends AdvancedRobot {

    static Point2D.Double enemyLocation;
    static Point2D.Double robotLocation;
    static String enemyName;
    static double numWins;
    static Narcissus narc = new Narcissus();
    static Gun gun;
    static boolean testmode = false;
    static double hits = 0, shots = 0;
    static double timeSinceScan = 2;
    boolean hasScanned = false;
    boolean saved = false;
    static double skipped = 0, turns = 0;
    static double bulletCollisions = 0;


    public void run() {
        setColors(Color.red, Color.white, Color.white);
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

        narc.newRound(this);
        if (gun == null) gun = new Gun(this);
        gun.newRound();

        do {
            if (getOthers() == 0 && !narc.inDanger() && !saved && !testmode)
                saveData();
            if (timeSinceScan++ > 1){
                setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                if (hasScanned)
                    narc.doMovement();
                turns++;
            }
            execute();

        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {

        turns++;
        timeSinceScan = 0;
        hasScanned = true;

        /*-------- setup data -----*/
        if (enemyName == null){
            enemyName = e.getName();
            if (!testmode)
                loadData();
        }

        narc.onScannedRobot(e);
        gun.onScannedRobot(e);
        narc.doMovement();

        setTurnRadarRightRadians(Utils.normalRelativeAngle( getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians()) * 2);

    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        narc.onBulletHitBullet(e);
        bulletCollisions++;
    }
    public void onHitByBullet(HitByBulletEvent e) {
        narc.onHitByBullet(e);
    }

    public void onBulletHit(BulletHitEvent e){
        narc.onBulletHit(e);
        hits++;
    }
    public void onWin(WinEvent e){
        numWins++;
        printStats();

    }
    public void onDeath(DeathEvent e){
        printStats();
        if (!testmode)
            saveData();
    }
    public void loadData(){
        try{
            gun.saveData(enemyName);
            narc.saveData(enemyName);
        } catch (Exception e){out.println("Unable to load data.");}
    }
    public void saveData(){

        if (getRoundNum() + 4 > getNumRounds()){
            narc.saveData(enemyName);
            gun.saveData(enemyName);
        }
        saved = true;
    }

    public void onSkippedTurn(SkippedTurnEvent event){
        skipped++;
    }

    public void printStats() {
        out.println("");
        out.println("-----------------------");
        out.println("Statistics for opponent " + enemyName);
        out.println("-----------------------");
        out.println("Win rate         |  " + percent(numWins/(getRoundNum() + 1)));
        out.println("My accuracy      |  " + percent(hits/gun.fired));
        out.println("Enemy accuracy   |  " + percent(narc.getEnemyHitRate()));
        if (testmode){
            out.println("Head on shots      | " + percent(narc.headOnCount/narc.enemyFoundCount));
            out.println("Predict accuracy |  " + percent(narc.getGoodHitRate()));
            out.println("Turns skipped    |  " + percent(skipped/turns));
            out.println("Bullet collisions  |  " + percent(bulletCollisions/gun.fired));

        }

        out.println("");
    }
    public String percent(double frac){
        return (int)(10000*frac)/100d + "%";
    }



}
