package ag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

import robocode.RobocodeFileOutputStream;
import ag.neuralgir.NeuralNet;
import ag.neuralgir.NeuralNetData;
import ag.neuralgir.TrainDataSet;

/**
 * Manages the file handling
 * @author Andree Grosse
 *
 */
public class FileManager {

	Gir mGir;
	
	/**
	 * Constructor.
	 * @param gir
	 */
	public FileManager(Gir gir) {		
		mGir = gir;
	}
		/*
	**
	 * Writes the net Data. Will rewrite the file if it exists. 
	 * @param filename Name of the file
	 * @param dir Directory
	 * @param layersize Layersizes
	 *
	public void writeNetData(String filename, File dir, NeuralNetData data){
		File file = new File(dir + "/" + filename);
		writeNetData(file, data);	
	}
	
	** 
	 * Writes the net Data. Will rewrite the file if it exists. 
	 * @param file
	 * @param layersizes Layersizes
	 *
	public void writeNetData(File file, NeuralNetData data){
		try {
			
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath());
			ObjectOutputStream obj_out = new ObjectOutputStream (file_out);

			NeuralNetData data = new NeuralNetData(net)
			
			obj_out.writeObject(temp);

			file_out.close();
		      
		} catch (Exception e) {
			System.out.println("Exception trying to write: " + e);
		}		
	}
	
	*/
	
	/**
	 * Reads the net data.
	 * @param filename Filename to read from
	 * @param dir Directory of the file
	 * @return The net data
	 */
	public int[] readNetLayersize(String filename, File dir){
		File file = new File(dir + "/" + filename);
		return readNetLayersize(file);	
	}
	
	/**
	 * Reads the net data.
	 * @param file File to be read from
	 * @return The net data
	 */
	public int[] readNetLayersize(File file){
		int[] netdata = null;	
		try	{		
		    FileInputStream file_input = new FileInputStream (file.getAbsolutePath());
		    DataInputStream data_in    = new DataInputStream (file_input);
		    
		    int size = data_in.readInt();
		    if(size < 0)
		    	return null;
		    
		    netdata = new int[size];
		    		    
		    for(int i = 0; i < size; i++)	
		    	try {   	
		    		netdata[i] = data_in.readInt();
		    	}catch (EOFException eof) {
		    		System.out.println ("End of File " + file.getName());
					return null;
		    	}
		
		    data_in.close ();
		} catch  (IOException e) {
			System.out.println ( "IO Exception reading " + file.getName() + ": " + e );
			return null;
		}
        
        return netdata;  	
	}
	
	/**
	 * Writes the nets layersize. Will rewrite file if it exists.
	 * @param filename Filename to write to
	 * @param net the neural net for which the layersize shall be written
	 */
	public void writeNetLayersize(String filename, NeuralNet net){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		writeNetLayersize(file, net);	
	}
	
	/**
	 * Writes the nets Layersize. Will rewrite file if it exists. 
	 * @param file File to write to
	 * @param net the neural net for which the layersize shall be written
	 */
	public void writeNetLayersize(File file, NeuralNet net){
		try {								
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath());
			DataOutputStream data_out = new DataOutputStream (file_out);
				
			int[] layersize = net.getLayerSize();
			data_out.writeInt(layersize.length);
			
			for(int i = 0; i < layersize.length; i++){
				data_out.writeInt(layersize[i]);
			}
			
			file_out.close();
		      
		} catch (IOException e) {
			System.out.println("Exception trying to write: " + e);
		}	
	}
		
	/**
	 * Writes the net. Will rewrite file if it exists.
	 * @param filename Filename to write to
	 * @param net the neural net to be written
	 */
	public void writeNet(String filename, NeuralNet net){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		writeNet(file, net);	
	}
	
	/**
	 * Writes the net in Robocode. Will rewrite file if it exists. 
	 * @param file File to write to
	 * @param net the neural net to be written
	 */
	public void writeNetRC(File file, NeuralNet net){
		try {		
		
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath());
			
			ObjectOutputStream obj_out = new ObjectOutputStream (file_out);
			        	
			NeuralNetData data = new NeuralNetData(net);
						
			obj_out.writeObject(data);
        	
			file_out.close();
			
			/*
			int[] layersize = new int[weights.length+1];
						
			for(int i = 0; i < layersize.length-1; i++){
				layersize[i] = weights[i].length - 1; // bias in layer
			}
			
			layersize[layersize.length-1] = weights[weights.length-1][0].length;
			
			
			writeNetData(file, layersize);			
						
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath(), true);

			DataOutputStream data_out = new DataOutputStream (file_out);
						
			int h, i, k;
			for(h = 0; h < layersize.length-1; h++){			
				for(i = 0; i < layersize[h]+1; i++)
					for(k = 0; k < layersize[h + 1]; k++){
						data_out.writeDouble(weights[h][i][k]);
					}
			}			
			*/
		      
		} catch (IOException e) {
			System.out.println("Exception trying to write: " + e);
		}	
	}
	
	/**
	 * Writes the net. Will rewrite file if it exists. 
	 * @param file File to write to
	 * @param net the neural net to be written
	 */
	public void writeNet(File file, NeuralNet net){
		try {					
			FileOutputStream file_out = new FileOutputStream(file.getAbsolutePath());
			
			ObjectOutputStream obj_out = new ObjectOutputStream (file_out);
			
        	
			NeuralNetData data = new NeuralNetData(net);
						
			obj_out.writeObject(data);
        	
			file_out.close();
			
			/*
			int[] layersize = new int[weights.length+1];
						
			for(int i = 0; i < layersize.length-1; i++){
				layersize[i] = weights[i].length - 1; // bias in layer
			}
			
			layersize[layersize.length-1] = weights[weights.length-1][0].length;
			
			
			writeNetData(file, layersize);			
						
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath(), true);

			DataOutputStream data_out = new DataOutputStream (file_out);
						
			int h, i, k;
			for(h = 0; h < layersize.length-1; h++){			
				for(i = 0; i < layersize[h]+1; i++)
					for(k = 0; k < layersize[h + 1]; k++){
						data_out.writeDouble(weights[h][i][k]);
					}
			}			
			*/
		      
		} catch (IOException e) {
			System.out.println("Exception trying to write: " + e);
		}	
	}
	
	/**
	 * Reads net.
	 * @param filename Filename to read from
	 * @return Net weights
	 */
	public NeuralNet readNet(String filename){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		return readNet(file);	
	}
	
	/**
	 * Reads net.
	 * @param file File to be read
	 * @return Net weights
	 */
	public NeuralNet readNet(File file){
		NeuralNet net = null;
		try	{		
		    FileInputStream file_input = new FileInputStream (file.getAbsolutePath());
		    ObjectInputStream obj_in    = new ObjectInputStream (file_input);
	    	
		    NeuralNetData data = (NeuralNetData)obj_in.readObject();
		    
		    net = new NeuralNet(data);
		    // create weights array
		    //weights = new double[layersize.length - 1][][];
/*
		    // create weights for layer 0 to H-2 (with bias neurons)
			for(h = 0; h < layersize.length - 1; h++){								
				weights[h] = new double[layersize[h]+1][layersize[h+1]];
			}			
						    
			// read weights
				
			for(h = 0; h < layersize.length - 1; h++){				
				for(i = 0; i < layersize[h]+1; i++)
					for(k = 0; k < layersize[h + 1]; k++){
						weights[h][i][k] = data_in.readDouble();
						}
			}
			
			*/
		    obj_in.close ();
		} catch  (Exception e) {
			System.out.println ( "Exception reading " + file.getName() + ": " + e );
			return null;
		}
        
        return net;  	
	}
	
	/**
	 * Reads trainig data.
	 * @param filename Filename to read from
	 * @return A Vector with all TrainingData sets in this file
	 */
	public Vector<TrainDataSet> readTrainData(String filename){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		return readTrainData(file);	
	}

	/**
	 * Reads trainig data.
	 * @param file
	 * @return A Vector with all TrainingData sets in this file
	 */
	public Vector<TrainDataSet> readTrainData(File file){
		Vector<TrainDataSet> traindata = new Vector<TrainDataSet>();	
		try	{		
		    FileInputStream file_input = new FileInputStream (file.getAbsolutePath());
		    DataInputStream data_in    = new DataInputStream (file_input);
		    
		    // read the net layer length
		    int size = data_in.readInt();		    
		    int in = data_in.readInt();
		    // skip the hidden layer size information (1 Integer = 4 Bytes)
		    data_in.skip(4 * (size - 2));
		    int out = data_in.readInt();
		    		    		    
		    int i;
		    TrainDataSet data;
		    
		    while(data_in.available() > 0){
		    	try {   	
		    		data = new TrainDataSet(in, out, 0);
		    		// read input and output
		    		for(i = 0; i < in; i++)
		    			data.getInput()[i] = data_in.readDouble();
		    		for(i = 0; i < out; i++)
		    			data.getOutput()[i] = data_in.readDouble();
		    		
		    		traindata.add(data);
		    	}catch (EOFException eof) {
		    		System.out.println ("End of File " + file.getName());
				    data_in.close ();
					return traindata;
		    	}
		    }
		} catch  (IOException e) {
			System.out.println ( "IO Exception reading " + file.getName() + ": " + e );
			return traindata;
		} 	
	    return traindata;
	}
		
	// for the gunstats
	
	/**
	 * Appends training data to a file. File will be created
	 * if it does not exist.
	 * @param filename
	 * @param write
	 */
	public void appendDataSet(String filename, double[] write){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		appendDataSet(file, write);	
	}
	
	/**
	 * Appends training data to a file. File will be created
	 * if it does not exist.
	 * @param file
	 * @param write
	 */
	public void appendDataSet(File file, double[] write) {
			
		try {		
			
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath(), true);

			DataOutputStream data_out = new DataOutputStream (file_out);

			// Write the data to the file
			for(int i = 0; i < write.length; i++)	
		    	data_out.writeDouble(write[i]);

			file_out.close ();
		      
		} catch (IOException e) {
			System.out.println("IOException trying to write: " + e);
		}		
	}	
	
	/**
	 * Reads a range of double values from a file.
	 * @param filename
	 * @param start
	 * @param end
	 * @return An array containig the read double values
	 */
	public double[] readDouble(String filename, int start, int end){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		return readDouble(file, start, end);	
	}
	
	/**
	 * Reads a range of double values from a file.
	 * @param file
	 * @param start
	 * @param end
	 * @return An array containig the read double values
	 */
	public double[] readDouble(File file, int start, int end){
		if(end <= start)
			return null;
		
		double[] stats;
		
		try	{		
		    FileInputStream file_input = new FileInputStream (file.getAbsolutePath());
		    DataInputStream data_in    = new DataInputStream (file_input );

		    
		    // skip "start" double values (1 double = 8 bytes)
		    data_in.skipBytes(8 * start);
		    
		    stats = new double[end - start + 1];
		    
		    for(int i = 0; i < end - start + 1; i++)	
		    	try {   	
		          stats[i] = data_in.readDouble();
		    	}catch (EOFException eof) {
		    		System.out.println ("End of File " + file.getName());
					return null;
		    	}
		
		    	data_in.close ();
		} catch  (IOException e) {
			System.out.println ( "IO Exception reading " + file.getName() +": " + e );
			return null;
		}
        
        return stats;    
	}
	
	/**
	 * Reads the complete file as an Vector
	 * @param filename
	 * @return A Vector
	 */	
	public Vector readVector(String filename){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		return readVector(file);	
	}

	/**
	 * Reads the complete file as an Vector
	 * @param file File to be read
	 * @return A Vector
	 */
	public Vector readVector(File file){
	    Vector vec = new Vector();
		
		try	{		
		    FileInputStream file_input = new FileInputStream (file.getAbsolutePath());
		    ObjectInputStream obj_in    = new ObjectInputStream (file_input );
 		    
		    vec = (Vector)obj_in.readObject();		    
		    
		    obj_in.close ();
		    
		} catch  (Exception e) {
			System.out.println ( "Exception reading " + file.getName() +": " + e );
			return vec;
		}
        
        return vec;    
	}

	/** 
	 * Writes a Vector. Will rewrite the file if it exists. 
	 * @param filename
	 * @param ints Vector
	 */
	public void writeVector(String filename, Vector ints){
		File file = new File(mGir.getDataDirectory() + "/" + filename);
		writeVector(file, ints);	
	}
	
	/** 
	 * Writes a Vector. Will rewrite the file if it exists. 
	 * @param file File to write to
	 * @param vec Vector to be written
	 */
	public void writeVector(File file, Vector vec){
		try {
			
			RobocodeFileOutputStream file_out = new RobocodeFileOutputStream(file.getAbsolutePath());

			ObjectOutputStream obj_out = new ObjectOutputStream(file_out);

	    	obj_out.writeObject(vec);

			file_out.close();
		      
		} catch (IOException e) {
			System.out.println("IOException trying to write: " + e);
		}		
	}
}
