
package ags.rougedc.waves;

import ags.utils.kdtree.HyperPoint;
import ags.utils.kdtree.KDEntry;

/**
 * Stores KD-Tree entries for enemy firepower
 * 
 * @author Alexander Schultz
 */
public class FirepowerEntry implements KDEntry {
    private static final long serialVersionUID = 1L;
    private final HyperPoint position;
    private final double firepower;
    
    public FirepowerEntry(double firepower, double myenergy, double enemyenergy, double distance) {
        this.position = new HyperPoint(myenergy, enemyenergy, distance); 
        this.firepower = firepower;
    }
    
    public double getFirepower() {
        return firepower;
    }
    
    public HyperPoint getPosition() {
        return position;
    }
}
