package tzu.gun;

import tzu.util.*;
import tzu.intel.*;

/**
 * Provides all the data necessary to aim at, and hopefully shoot, an
 * enemy robot.
 */

public class FireSolution {

    public static final int AIM_ESTIMATED       = 0;
    public static final int AIM_PREDICTED       = 1;
    public static final int AIM_PATTERN         = 2;
    public static final int AIM_AVERAGE         = 3;
    public static final int AIM_LINEAR          = 4;
    public static final String[] AIM_METHODS = {
        "Estimated", "Predicted", "Pattern", "Average" };


    public Bot      target;
    public double   gunAngle;
    public double   expectedHitX;
    public double   expectedHitY;
    public int      method;
    public long     timeToImpact;

    /**
     * Create a new FireSolution object.
     * @param intendedTarget    The target we hope to hit.
     * @param angleOfGun        Absolute heading the gun should be at.
     * @param aimingMethod      Aiming technique used.
     * @param expectedX         X coordinate where we expect to hit the target.
     * @param expectedY         Y coordinate where we expect to hit the target.
     */
    public FireSolution(Bot intendedTarget,
                        double angleOfGun,
                        int aimingMethod,
                        double expectedX,
                        double expectedY,
                        long timeToImpact) {

        target              = intendedTarget;
        gunAngle            = angleOfGun;
        expectedHitX        = expectedX;
        expectedHitY        = expectedY;
        method              = aimingMethod;
        this.timeToImpact   = timeToImpact;
    }

    public double getExpectedHitX() { return expectedHitX;  }
    public double getExpectedHitY() { return expectedHitY;  }
    public double getGunAngle()     { return gunAngle;      }
    public int getMethod()          { return method;        }
    public Bot getTarget()          { return target;        }
    public long getTimeToImpact()   { return timeToImpact;  }

    public void setExpectedHitX(double value)   { expectedHitX = value; }
    public void setExpectedHitY(double value)   { expectedHitY = value; }
    public void setGunAngle(double value)       { gunAngle = value;     }
    public void setMethod(int value)            { method = value;       }
    public void setTarget(Bot value)            { target = value;       }
    public void setTimeToImpact(long value)     { timeToImpact = value; }

    public String toString() {
        return
            "FireSolution: Aim Method="     +
            AIM_METHODS[method]             +
            "  Expected hit x="             +
            Math.round(expectedHitX)        +
            "  Expected hit y="             +
            Math.round(expectedHitY);
    }
}
