package ags.rougedc.movement;

import java.util.List;

import ags.rougedc.robots.VirtualRobot;
import ags.rougedc.waves.EnemyWave;

/**
 * A robot driver for a stopped bot
 * 
 * @author Alexander Schultz
 */
public class StoppedDriver implements RobotDriver {
    private double acceleration;
    
    public void run(VirtualRobot bot, List<EnemyWave> waves) {
        acceleration = -bot.getVelocity().magnitude;
    }
    
    public double getAcceleration() {
        return acceleration;
    }
    
    public double getAngularVelocity() {
        return 0;
    }

}
