package ags.rougedc.painters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import ags.rougedc.waves.*;

public class WavePainter {
    public static void paint(Graphics2D g, Color color, List<?> waves) {
        g.setColor(color);
        for (Object w : waves) {
            if (w instanceof Wave)
                drawWave(g, (Wave)w);
        }
    }
    
    private static void drawWave(Graphics2D g, Wave w) {
        ags.utils.points.AbsolutePoint p = w.getOrigin();
        g.drawOval((int)(p.x-w.getRadius()), (int)(p.y-w.getRadius()), (int)(w.getRadius()*2), (int)(w.getRadius()*2));
    }
}
