package ags.rougedc.robots;

import ags.utils.points.AbsolutePoint;

public class IntentRobotPredictor extends VirtualRobotPredictor {
    private double move, turn;
    private VirtualRobot robot;
    
    public IntentRobotPredictor(VirtualRobot robot, AbsolutePoint fieldcorner) {
        super(null, fieldcorner);
        this.robot = robot;
    }

    @Override
    public double getAcceleration() {
        return move-this.getVelocity().magnitude;
    }

    @Override
    public double getAngularVelocity() {
        return turn;
    }

    public void setMove(double arg0) {
        move = arg0;
    }
    
    public void setTurnBody(double arg0) {
        turn = arg0;
    }
    
    public AbsolutePoint getNextLocation() {
        reset(robot);
        
        return super.move();
    }
    
    public final AbsolutePoint move() {
        throw new UnsupportedOperationException("Use getNextLocation() instead.");
    }
}
