package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;


public class SurfBufferA extends SurfBuffer {

	
	
	
	
	public SurfBufferA(int weight) {
		super(weight);
	}



	private static double[][][][] surfStats = new double[BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	
	
	
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegWallProximity(),wave.getSegLateralVelocity(),wave.getSegInitialDistance()));
	}
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 3)
			throw new IllegalArgumentException("args length must be 3");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]], this.getWeight());
	}

}
