package bvh.fry;

import java.awt.geom.*;
/**
 * Utils
 *
 * Algemene hulpfuncties (overgenomen uit forums op de RobocodeRepository website)
 */
class BotUtils implements Constanten {

   /**
   * bepaal richting van bot tot doel-positie
   *
   * @param oorsprong de positie waar vandaan de hoek moet worden berekend
   * @param doel de positie waar naar de hoek moet worden berekend.
   *
   * @return de berekende hoek in radialen
   */
   public static double bepaalRichting(Point2D.Double oorsprong, Point2D.Double doel) {
      return Math.atan2((doel.x - oorsprong.x), (doel.y - oorsprong.y));
   }

   /**
   * bereken nieuwe positie op basis van opgegeven positie, richting en afstand.
   *
   * @param pos de start positie
   * @param richting de richting in radialen naar de te berekenen positie.
   * @param afstand de afstand tot de te berekenen positie.
   *
   * @return de berekende positie
   */
   public static Point2D.Double projecteerPositie(Point2D.Double pos, double richting, double afstand) {
      return new Point2D.Double(pos.x + afstand * Math.sin(richting), pos.y + afstand * Math.cos(richting));
   }

   public static int maxMin(int waarde, int minimum, int maximum) {
      return Math.max(minimum, Math.min(maximum, waarde));
   }

   public static double maxMin(double waarde, double minimum, double maximum) {
      return Math.max(minimum, Math.min(maximum, waarde));
   }

   /**
    * berekend de snelheid van de kogel op basis van de kracht van de kogel.
    *
    * @param kanonVuurkracht de kracht van de kogel.
    *
    * @return de snelheid van de kogel
    */
   public static double berekenKogelSnelheid(double kanonVuurkracht) {
      return (20D - 3D * kanonVuurkracht);
   }

   /**
    * berekend de benodigde vuurkracht van de kogel om, op  basis van de energie
    * van het doel, het doel met n kogel uit te schakelen.
    *
    * @param energie de energie van de tegenstander.
    *
    * @return de minimum kracht van de kogel
    */
   public static double berekenMinimumVuurkracht(double energie) {
      return (energie == 0D ? 0.1D : (energie <= 12D ? energie / 4D : (energie + 2D) / 6D));
   }

} // einde Utils
