package stelo;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's

/**
 * Wang - a robot by Stelokim
 *
 * 'Wang' means king in the Korean language.
 *
 * Features:
 *   sharp 90-degree turn
 *   wall avoiding
 *   linear/circular targeting
 *   corner movement
 *
 */
public class Wang extends AdvancedRobot
{
	private static double wallMargin = 100;
	private double lastAbsBearing;
	private double radarturn = 1;
	private int numFire = 0;
	private int numHit = 0;
	private double lastEnemyHeading;
	private double lastW;
	private double lastEnemyVelocity;
	private boolean turn = true;
	
	private double leftBound = wallMargin;
	private double bottomBound = wallMargin;
	private static double cornerSize = 200;
	
	/**
	 * run: Wang's default behavior
	 */
	public void run() {

		setColors(Color.cyan, null, null);

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

		// find nearest corner
		if (getX() > getBattleFieldWidth() / 2)
			leftBound = getBattleFieldWidth() - cornerSize;
		
		if (getY() > getBattleFieldHeight() / 2)
			bottomBound = getBattleFieldHeight() - cornerSize;

		while(true) {
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
        double absBearing = e.getBearingRadians() + getHeadingRadians();
		
		lastAbsBearing = absBearing;
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2); // 2 original

        // setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * getOthers()); // 2 original

        // setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()) * 2); // stelo
		
		move();

        // gun code would go here...

		double maxPower = 3;
		
		//if (getOthers() > 3)
		//	maxPower = 1.7;
		
		double bulletPower;
		bulletPower = Math.min(getEnergy() - 2, e.getEnergy() / 4);
		
		if (bulletPower <= 0)
			bulletPower = 0.1;
		else if (bulletPower > maxPower)
			bulletPower = maxPower;
		// CircularTargeting (quadratic)
		
	
		radarturn=-radarturn;
		double w=e.getHeadingRadians()-lastEnemyHeading;
		double dw = w - lastW;
		// System.out.println(dw);
		
		lastEnemyHeading=e.getHeadingRadians();
		lastW = w;
		
		double enemyX = getX() + e.getDistance() * Math.sin(absBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absBearing);
		if (Math.random() < 0.1) {
			// HeadOnTargeting
			if (getGunHeat() == 0) {
				System.out.println("HeadOnTargeting");
			}
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
		}
		else if (w != 0) {
			if (getGunHeat() == 0) {
				System.out.println("CircularTargeting");
			}
			
			double absbearing=e.getBearingRadians()+getHeadingRadians();
			double eX=e.getDistance()*Math.sin(absbearing);
			double eY=e.getDistance()*Math.cos(absbearing);

			double db=0;
			double ww=lastEnemyHeading;  // enemy's starting heading
			
			do
			{
				// db+=11; //11 is the velocity of a fire(3) bullet.
				db += (20.0 - 3.0 * bulletPower);
				double dx=e.getVelocity()*Math.sin(ww);
				double dy=e.getVelocity()*Math.cos(ww);
				ww+=w;  // turn w radians for next step
				w += dw;
				
				eX+=dx;
				eY+=dy;
				
				
			}while (db< Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
		
			setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - getGunHeadingRadians())));
			// setTurnRightRadians(e.getBearingRadians() + .5*Math.PI);		
		}
		else
		{
			if (getGunHeat() == 0) {
				System.out.println("LinearTargeting");
			}
			// LinearTargeting (quadratic)
			//This code goes in your onScannedRobot() event handler
			
			
			double myX = getX();
			double myY = getY();
			double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
			//double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
			//double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
			double enemyHeading = e.getHeadingRadians();
			double enemyVelocity = e.getVelocity();
			
			double dV = enemyVelocity - lastEnemyVelocity;
			// System.out.println(dV);
			
			lastEnemyVelocity = enemyVelocity;
		
			double deltaTime = 0;
			double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
			double predictedX = enemyX, predictedY = enemyY;

			while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				predictedX += Math.sin(enemyHeading) * enemyVelocity;	
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
					predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
					break;
				}
				
				enemyVelocity += dV;
				if (enemyVelocity > 8)
					enemyVelocity = 8;
				else if(enemyVelocity < -8)
					enemyVelocity = -8;
			}
			
			double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
			// setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
			setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
			
		}	

		// public void fire(double power) Fires a bullet. The valid range for power is .1 to 3. The bullet will travel in the direction the gun is pointing. The bullet will do (4 * power) damage if it hits another robot. If power is greater than 1, it will do an additional 2 * (power - 1) damage. You will get (3 * power) back if you hit the other robot. An event will be generated when the bullet hits a robot, wall, or other bullet. This call executes immediately. 		
		if (getEnergy() > 0.1 && getGunHeat() == 0 ) {										
			setFire(bulletPower);
			numFire++;
			System.out.println("Hit rate: " + ((double) numHit / numFire) + "\tDistance: " + e.getDistance());
		}
	}
	
	private void move() {
		// sharp 90 degree movement
		if (getTurnRemaining() == 0)
			setMaxVelocity(8);
		if (!(getDistanceRemaining() < 20 && getTurnRemaining() == 0) )
			return;
		
		int direction;
		double angle = -1;
		double x, y, w, h;
		x = getX();
		y = getY();
		
		direction = (int) (Math.random() * 4);
		if (y < bottomBound + cornerSize - wallMargin && direction == 0) {
			// up
			angle = 0;
		} else if (y > bottomBound && direction == 1) {
			// down
			angle = Math.PI;
		} else if (x > leftBound && direction == 2) {
			// left
			angle = -Math.PI  / 2;
		} else if (x < leftBound + cornerSize - wallMargin && direction == 3) {
			// right
			angle = Math.PI / 2;
		}
		
		if (angle == -1)
			return;
		angle -= getHeadingRadians();
		double moveAmount = wallMargin - 10;
		
		if (angle >= Math.PI) {
			angle -= Math.PI;
			moveAmount *= -1;
		} else if (angle <= -Math.PI) {
			angle += Math.PI;
			moveAmount *= -1;
		}
				
		//out.println(angle);
		if (angle == 0) {
			setMaxVelocity(8);
		} else
			setMaxVelocity(2);
			
		//if (getDistanceRemaining() == 0 && getTurnRemaining() == 0) {
			setTurnRightRadians(Utils.normalRelativeAngle(angle) );
			setAhead(moveAmount);
		//}
		
	}
	
	public void onBulletHit(BulletHitEvent event) {
		numHit++;
	}
		
}
