package bayen.nut;
import robocode.*;

/**
 * MyClass - a class by (your name here)
 */
public class GunEnemy
{
	public double[][][][][][][] aimFactors = new double[5][5][5][5][5][5][25];
	private AdvancedRobot dBot;
	private String name = "";
	private double energy = 100.0;
	private double heading = 0.0;
	private double velocity = 0.0;
	private double distance = 0.0;
	private double x = 0.0;
	private double y = 0.0;
	private long lastTime = 0;
	public GunEnemy(AdvancedRobot robot, ScannedRobotEvent e) {
		dBot = robot;
		update(e);
	}
	public void copy(EnemyRobot e) {
		name = e.getName();
		energy = e.getEnergy();
		heading = e.getHeadingRadians();
		velocity = e.getVelocity();
		distance = e.getDistance();
		x = dBot.getX() + e.getDistance() * Math.sin(e.getBearing() + dBot.getHeading());
		y = dBot.getY() + e.getDistance() * Math.cos(e.getBearing() + dBot.getHeading());
		lastTime = dBot.getTime();
	}
	public void update(ScannedRobotEvent e) {
		name = e.getName();
		energy = e.getEnergy();
		heading = e.getHeadingRadians();
		velocity = e.getVelocity();
		distance = e.getDistance();
		x = dBot.getX() + e.getDistance() * Math.sin(e.getBearing() + dBot.getHeading());
		y = dBot.getY() + e.getDistance() * Math.cos(e.getBearing() + dBot.getHeading());
		lastTime = dBot.getTime();
		customUpdates(e);
	}
	public void customUpdates(ScannedRobotEvent e) {
		
	}
	public void setDefaultRobot(AdvancedRobot robot) {
		dBot = robot;
	}
	public String getName() {
		return name;
	}
	public String getName(AdvancedRobot robot) {
		return name;
	}
	public double getEnergy() {
		return energy;
	}
	public double getEnergy(AdvancedRobot robot) {
		return energy;
	}
	public double getHeadingRadians() {
		return heading;
	}
	public double getHeadingRadians(AdvancedRobot robot) {
		return heading;
	}
	public double getHeading() {
		return Math.toDegrees(getHeadingRadians());
	}
	public double getHeading(AdvancedRobot robot) {
		return Math.toDegrees(getHeadingRadians(robot));
	}
	public double getVelocity() {
		return velocity;
	}
	public double getVelocity(AdvancedRobot robot) {
		return velocity;
	}
	public double getDistance() {
		return distance;
	}
	public double getDistance(AdvancedRobot robot) {
		return distance;
	}
	public double getX() {
		return x;
	}
	public double getX(AdvancedRobot robot) {
		return x;
	}
	public double getY() {
		return y;
	}
	public double getY(AdvancedRobot robot) {
		return y;
	}
	public double getBearingRadians() {
		double bearing = Math.atan2(x - dBot.getX(), y - dBot.getY()) - dBot.getHeadingRadians();
		while(bearing < 0.0){
		 	bearing += 2.0 * Math.PI;
		}
		while(bearing >= 2.0 * Math.PI){
		 	bearing -= 2.0 * Math.PI;
		}
		return bearing;
	}
	public double getBearingRadians(AdvancedRobot robot) {
		double bearing = Math.atan2(x - robot.getX(), y - robot.getY()) - robot.getHeadingRadians();
		while(bearing < 0.0){
		 	bearing += 2.0 * Math.PI;
		}
		while(bearing >= 2.0 * Math.PI){
		 	bearing -= 2.0 * Math.PI;
		}
		return bearing;
	}
	public double getBearing() {
		return Math.toDegrees(getBearingRadians());
	}
	public double getBearing(AdvancedRobot robot) {
		return Math.toDegrees(getBearingRadians(robot));
	}
}
