package bayen.nut;
import robocode.*;
import java.util.*;


/**
This is the Score class for duels. This code is
basically what is included in Fractal and Cake to keep
score.

Instantiate this once on match start, and at the top
of all the needed events just pass them to the instance.
Call printScore at any time to print the scores to
the console. Call getScore(id) at any time to get the
score of the requested robot (0 = self, 1 = enemy).

If you'd like to use this in your robot, feel free to,
but give credit! -- Vuen
*/

/**
 * SCORE by Vuen
 */
public class Score {
    
    Robot robot;
    
    public Score(Robot robot) {
        this.robot = robot;
    }
    
    
    
    public double enemyEnergy;
    public double myEnergy;
    public String enemyName;
    
    public double[] bullet = new double[2];
    public double[] curbullet = new double[2];
    public double[] survival = new double[2];
    
    
    
    public void onScannedRobot(ScannedRobotEvent e) {
        myEnergy = robot.getEnergy();
        enemyEnergy = e.getEnergy();
        if (enemyName == null) enemyName = e.getName();
    }
    
    public void onBulletHit(BulletHitEvent e) {
        if (e.getEnergy() < 0.001) return; //ignore if enemy dead

        curbullet[0] += 4 * e.getBullet().getPower() + 2 * Math.max(e.getBullet().getPower() - 1, 0);
    }
    
    public void onHitByBullet(HitByBulletEvent e) {
        if (e.getPower() * 4 + Math.max(0, e.getPower() - 1) * 2 > myEnergy) return; //ignore if self dead
            //this works regardless of order of hitbybullet and scan

        curbullet[1] += 4 * e.getBullet().getPower() + 2 * Math.max(e.getBullet().getPower() - 1, 0);
    }
    
    public void onWin(WinEvent e) {
        survival[0] += 60;
        
        curbullet[0] += enemyEnergy;
        
        bullet[0] += curbullet[0] * 1.2;
        bullet[1] += curbullet[1];
        
        curbullet[0] = 0; curbullet[1] = 0;
    }
    
    public void onDeath(DeathEvent e) {
        survival[1] += 60;
        
        curbullet[1] += myEnergy;
        
        bullet[0] += curbullet[0];
        bullet[1] += curbullet[1] * 1.2;
        
        curbullet[0] = 0; curbullet[1] = 0;
    }
    
    
    
    /** returns the score of the requested robot: 0=self, 1=enemy */
    public int getScore(int id) {
        return (int)Math.round(bullet[id] + curbullet[id] + survival[id]);
    }
    
    /** prints the scorecard to the console */
    public void printScore() {
        if (enemyName == null) return;

        System.out.println("  ***********SCORECARD***********");
        System.out.print("  ");
        for (int i = 0; i < Math.max(robot.getName().length(), enemyName.length()); i++) System.out.print(" ");
        System.out.println(" Total Survival Bullet");
        
        String p0 = "  " + robot.getName();
        String p1 = "  " + enemyName;
        
        String pTemp = " " + Math.round(bullet[0] + survival[0] + curbullet[0]);
        for (int i = robot.getName().length(); i < Math.max(robot.getName().length(), enemyName.length()) + 7 - pTemp.length(); i++) p0 += " ";
        
        pTemp = (" " + Math.round(bullet[1] + survival[1] + curbullet[1]));
        for (int i = enemyName.length(); i < Math.max(robot.getName().length(), enemyName.length()) + 7 - pTemp.length(); i++) p1 += " ";
        
        p0 += Math.round(bullet[0] + survival[0] + curbullet[0]) + "  ";
        p1 += Math.round(bullet[1] + survival[1] + curbullet[1]) + "  ";
        pTemp = (" " + Math.round(survival[0]));
        for (int i = 0; i < 8 - pTemp.length(); i++) p0 += " ";
        pTemp = (" " + Math.round(survival[1]));
        for (int i = 0; i < 8 - pTemp.length(); i++) p1 += " ";
        
        p0 += Math.round(survival[0]) + "  ";
        p1 += Math.round(survival[1]) + "  ";
        pTemp = (" " + Math.round(bullet[0] + curbullet[0]));
        for (int i = 0; i < 6 - pTemp.length(); i++) p0 += " ";

        pTemp = (" " + Math.round(bullet[1] + curbullet[1]));
        for (int i = 0; i < 6 - pTemp.length(); i++) p1 += " ";
        
        p0 += Math.round(bullet[0] + curbullet[0]);
        p1 += Math.round(bullet[1] + curbullet[1]);
        
        if (bullet[0] + survival[0] + curbullet[0] >= bullet[1] + survival[1] + curbullet[1]) {
            System.out.println(p0); System.out.println(p1);
        } else {
            System.out.println(p1); System.out.println(p0);
        }
    }
    
}