package jok;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;

/**
 * Pheonix - a robot by H.Jewkes
 */
public class PheonixM extends AdvancedRobot
{
	Hashtable targets = new Hashtable();
	Hashtable dead = new Hashtable();
	
	Movement movement;
	MovementAntiGrav antiGrav;
	
	public void run()
	{
		antiGrav = new MovementAntiGrav(this,targets);
		
		setColors(Color.black,Color.red,Color.white);
		execute();
		setColors(Color.green,Color.green,Color.green);
		
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		
		while(true)
		{
			radar();
			move();
			gun();
			
			execute();
		}
	}
	
	
	
	private int radarDirection = 1;
	public void radar()
	{
		if(getRadarTurnRemaining() == 0)
		{
			double maxBearingAbs = 0, maxBearing = 0;
			int scannedBots=0;
			Enumeration e = targets.elements();
			while(e.hasMoreElements())
			{
				Enemy tmp = (Enemy)e.nextElement();
				if(tmp != null && getTime()-tmp.getTime()<=10)
				{
					double bearing = BotMath.normaliseBearing(getHeading() + tmp.getBearing() - getRadarHeading());
					if(Math.abs(bearing)>maxBearingAbs)
					{
						maxBearingAbs=Math.abs(bearing);
						maxBearing=bearing;
					}
					scannedBots ++;
				}
			}
			double radarTurn=180*radarDirection;
			if(scannedBots==getOthers()) radarTurn=maxBearing+BotMath.sign(maxBearing)*180/8;
			
			setTurnRadarRight(radarTurn);
			radarDirection=BotMath.sign(radarTurn);
		}
	}
	
	public void move()
	{
		if(getOthers() > 1)
		{
			movement = antiGrav;
		}
		else
		{
			movement = antiGrav;
		}
		movement.move();
	}
	
	void gun()
	{
		Enemy target = null;
		Enumeration e = targets.elements();
		while(e.hasMoreElements())
		{
			Enemy tmp = (Enemy)e.nextElement();
			if(target == null) target = tmp;
			else if(tmp.getDistance() < target.getDistance())
			{
				target = tmp;
			}
		}
		
		if(target != null)
		{
			if(getEnergy() > .1 && !(getOthers() == 1 && target.getEnergy() == 0))
			{
				target.fire();
			}
		}
	}
	
	
		
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if(movement != null) movement.onScannedRobot(e);
		Enemy en = new Enemy();
		if (targets.containsKey(e.getName())) en = (Enemy)targets.get(e.getName());
		else targets.put(e.getName(),en);
		en.update(e,this);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		if(movement != null) movement.onBulletHit(e);
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		if(movement != null) movement.onHitByBullet(e);
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		Enemy enemy = (Enemy)targets.get(e.getName());
		dead.put(e.getName(),enemy);
		targets.remove(e.getName());
	}
	
	public void onDeath(DeathEvent e)
	{
		reviveEnemies();
	}
	
	public void onWin(WinEvent e)
	{
		reviveEnemies();
		
		victoryDance();
	}
	
	void reviveEnemies()
	{
		Enumeration en = dead.elements();
		while(en.hasMoreElements())
		{
			Enemy tmp = (Enemy)en.nextElement();
			targets.put(tmp.getName(),tmp);
		}
	}
	
	void victoryDance()
	{			
		double firePower = 3;
		if(getX() < getBattleFieldWidth()/2)
		{
			setTurnRight(BotMath.normaliseHeading(-90-getHeading()));
			setAhead(1000);
			setTurnGunRight(BotMath.normaliseHeading(90-getGunHeading()));
		}
		else
		{
			setTurnRight(BotMath.normaliseHeading(90-getHeading()));
			setAhead(1000);
			setTurnGunRight(BotMath.normaliseHeading(-90-getGunHeading()));
		}
		
		while(true)
		{
			if(getGunHeat() == 0)
			{
				fireBullet(firePower);
				if(firePower == 3) firePower = 1/3;
				else firePower = 3;
			}
			execute();
		}
	}
}
