package nat.gfx.renderables;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

import nat.gfx.Renderable;
import nat.utils.M;

import nat.utils.Point;

public class Arrow extends Renderable {
	public Point p1, p2;
	public Color color;
	
	public Arrow(Point p1, Point p2, Color color) {
		this.p1 = p1;
		this.p2 = p2;
		this.color = color;
	}
	
	public Arrow(Point p1, double angle, double distance, Color color) {
		this.p1 = p1;
		this.p2 = M.project(p1, angle, distance);
		this.color = color;
	}

	@Override
	public void render(Graphics2D g) {
		if (color != null)
			g.setColor(color);
		double angle = M.getAngle(p1, p2);
		Point2D a1 = M.project(p2, angle - M.PI - M.QUARTER_PI/2, 12d);
		Point2D a2 = M.project(p2, angle - M.PI + M.QUARTER_PI/2, 12d);
		g.draw(new Line2D.Double(p1, p2));
		g.draw(new Line2D.Double(a1, p2));
		g.draw(new Line2D.Double(a2, p2));
	}
}
