package theo.simple.enemy;
import theo.simple.Bones;
import theo.simple.utils.botUtils;
import java.awt.geom.Point2D;
import robocode.util.Utils;
import robocode.*;
/**
 * Enemy - a class by Damij
 */
public class Enemy
{
	AdvancedRobot bot;
	
	public Point2D.Double pos;
	
	public String name;

	public double x,y,velocity;
	public double lastVelocity,latVelocity;
	public double lastHeading,changeHead;
	public double headChangeRate;
	public double absBearing,absAngle;
	public double bearing,heading;
	public double distance,botWidth;
	public double energy,lastEnergy;
	public double latHeading,energyDelta;
	
	public static double dirChangeRatio;
	
	long scanTime,lastScanTime;
	public static long timeSinceDirChange,maxTime;
	
	public static int latDirection = 1,lastLatDirection = 1;
	
	static{
		timeSinceDirChange = 0;
	}


/*	public Enemy (AdvancedRobot bot){
		this.bot = bot;
	}	
*/
	public Enemy (AdvancedRobot bot, ScannedRobotEvent e){
		this.bot = bot;
		this.update(e);
	}

	/*public void setAbsAngs(Point2D.Double source){
		this.absBearing = Utils.normalRelativeAngle(Math.atan2(this.pos.x-source.x,this.pos.y-source.y));
		this.absAngle = Utils.normalAbsoluteAngle(this.absBearing);
	}
	
	public Enemy (ScannedRobotEvent e){
		update(e);
	}
	
	public Enemy (){ } */

	public void update(ScannedRobotEvent e){
		timeSinceDirChange ++;
		this.lastVelocity = this.velocity;
		this.lastHeading = this.heading;
		this.heading = e.getHeadingRadians();
		this.bearing = e.getBearingRadians();
		this.changeHead = Utils.normalRelativeAngle(this.heading-this.lastHeading);
		
		this.lastScanTime = this.scanTime;
		this.scanTime = bot.getTime();
		this.headChangeRate = changeHead / (double) scanTime;
		
		this.distance = e.getDistance();
		this.botWidth = 36.0d/this.distance;
		this.velocity = e.getVelocity();
		
		this.absBearing = Utils.normalRelativeAngle(bot.getHeadingRadians() + this.bearing);
		this.absAngle = Utils.normalAbsoluteAngle(this.absBearing);
		
		this.pos = botUtils.project(new Point2D.Double(bot.getX(),bot.getY()),this.distance,this.absBearing);
		
		this.latHeading = Utils.normalRelativeAngle(this.heading-this.absBearing);
		this.latVelocity = this.velocity*Math.sin(this.latHeading);
		
		this.lastLatDirection = this.latDirection;
		
		if(this.latVelocity!=0){
			this.latDirection = (this.latVelocity<0?-1:1);
		}

		if(this.latDirection!=this.lastLatDirection){
			timeSinceDirChange = 0;
		}
		
		this.maxTime = (long)((800d*2d+600d*2d)/8.0d);
		this.dirChangeRatio = ((double)timeSinceDirChange)/(double)maxTime;

		this.energy = e.getEnergy();
		this.energyDelta = this.lastEnergy-this.energy;
		//System.out.println("Check: " + this.energyDelta + " last: " + this.lastEnergy + " curr: " + this.energy);
		this.lastEnergy = this.energy;
		
		
		this.name = e.getName();
	}

}
