package robar.nano;
import java.awt.Color;

import robocode.*;
import robocode.util.*;

public class MosquitoPM extends AdvancedRobot{

	//Made by HUNRobar
	//You can contact me at testwiki.roborumble.org, or via e-mail to robar06@gmail.com
    //Global
    
    static String enemyLog = "0000000000000000000088888888888888888888"; //The list where enemy lateral velocites are stored

    //Constants
    static final double FIREPOWER = 2.5; //The firepower of the bot
    static final double BULLETVEL = 20-3*FIREPOWER; //The velocity of the bullet fired at FIREPOWER
    static final int PATTERN_DEPTH = 30; //The lenght of the pattern we try to find each turn in enemyLog
    static final int MOVEAMOUNT = 1000000; //The amount of pixels the bot will move in stop and go
    //static final int DEATHLIMIT = 3;

    //Variables
    static double prevEnergy; //It stores the energy of the enemy
    static int direction = MOVEAMOUNT; //It's the direction and the movement packed together
    static int moveMode = 1; //1 - reverse; -1 - non-reverse movement

    public void run(){
    	
        setAdjustGunForRobotTurn(true); //This sets the gun independent from the body.

    	
        //Radar locking (maybe from Moebius)
        setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e){

            //Local variables
 
            double absB; //absolute bearing
            int index; //index of the match of the pm gun
            int matchLenght = PATTERN_DEPTH; //the number of data a pattern contains
            int i;

            //Mosquito movement, only distancing and turn-trick extracted
            if(prevEnergy > (prevEnergy = e.getEnergy()) ){

                setMaxVelocity(Math.random()*16.0);
                setAhead(direction*=-moveMode);
                //setTurnRightRadians(Math.cos(absB)-0.00000017*direction);
            }
            //setTurnRightRadians(Math.cos(absB = e.getBearingRadians()));
            setTurnRightRadians(Math.cos(absB = e.getBearingRadians())-0.00000012);
            //setTurnRightRadians(Math.cos(absB = e.getBearingRadians())- Math.signum(e.getDistance() - 200.0) *0.00000017 *direction);
            //setTurnRight(e.getBearing()+90-Math.signum(e.getDistance()-200)*0.00001*direction);
            //setTurnRightRadians(Math.cos(absB = e.getBearingRadians()));
            

            //Symbolic PM gun
            enemyLog = String.valueOf( (char)(e.getVelocity() * Math.sin(e.getHeadingRadians() - ( absB+=getHeadingRadians() )))).concat(enemyLog);


            while((index = enemyLog.indexOf(enemyLog.substring(0, matchLenght--), i = (int) (e.getDistance() / BULLETVEL))) < 0);


            do{
                absB += Math.asin(((short)enemyLog.codePointAt(index--))/e.getDistance());
            }while(--i > 0);

            //Turning gun
            setTurnGunRightRadians(Utils.normalRelativeAngle(absB-getGunHeadingRadians()));

            //Fire in the hall!
            setFire(FIREPOWER);
            
            //Infinite-radar lock 2. part
            setTurnRadarLeft(getRadarTurnRemaining());
    }
    //If we move one-way then bounce off walls
    public void onHitWall(HitWallEvent e){
        direction*=moveMode;
    }

    //If died, switch between one-way and reversional movement
    public void onDeath(DeathEvent e){
        moveMode=-moveMode;
    }

}
