package cx;
import robocode.*;
import cx.utils.MultiWave;
import java.awt.Color;
import java.util.Vector;
import java.util.Hashtable;
import java.awt.geom.Point2D;
import java.io.*;
import java.util.zip.*;
/**
 *+++++++++++++++++++++++++++Author Info++++++++++++++++++++++++++
 *--
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 *--
 * For living,I fish out a cigaret,smoke and spit a circle smog...
 * CigaretBH (Cigaret Burning Herself to make me happy,It's Burning...)
 * The chase bullets looks like the burining sparks out from cigaret.
 *++++++++++++++++++++++++++++++++Versions++++++++++++++++++++++++
 *--
  *--------------------version 1.0 2003.4.24--------------
 * 1.0:Almost the same to Cigaret's movement.
 * use MultiWave to analyse different power bullet's shoot angle.
 * It has a ChaseBullets shoot strategy,can fool some simple movement.
 *--
  *--------------------version 1.03 2003.7.1--------------
 * 1.03:as Cigaret 1.23,for some similar movement tweaked,not tested much.
 * hope it can do better.
 *+++++++++++++++++++++++++++++++++future++++++++++++++++++++++++++++++++
 *--
 * future:well,what the better?!
 *--
 *+++++++++++++++++++++++++++++++++Open Source+++++++++++++++++++++++++++
 *--
 * This bot is open source. 
 * - Don't just copy-paste the code .
 * - Don't just copy-paste and then improve.(I don't want to fight modified versions of my own bot)
 * - Maybe some useful skill in this codes,if you use,Make your bot open source
 * - And preferably give credit.:)
 *
 * If you want to know more or suggest,
 * email me or post messages on www.robochina.org or www.robocoderepository's forums.
 * every messages will be pleasent.
 *--
 */
public class CigaretBH extends AdvancedRobot
{
	private static Vector    waves=new Vector();
	private static Hashtable data;
	private static double    preDiffAngle;           //what angle the gun should turn
	private static double    power;                  //what power i should fire
	private static double    enemyEnergy;            //enemy's energy
	private static double    lastEnemyBulletPower;   //enemy's last bullet's power
	private static long      enemyLastFireTime;      //enemy last fire time
	private static double    lastBulletWillHitTime;  //my last big power bullet predicted travel time
	private static boolean   canRam=true;            //can ram it (is enemy can anti-ram?)

    private static MultiWave aimWave=new MultiWave();   //stord the aiming info
    private static double    normalBulletScore=100d;    //init score
	private static double    chaseBulletScore=110d;     //init score
	private static double    normalBulletRounds=1d;     //init rounds
	private static double    chaseBulletRounds=1d;      //init rounds
    private static boolean   isUseChase;                //is use chase shoot strategy
	private static String    enemyName;                 //enemy name

	public void run( ) {
		setColors(Color.gray,Color.black,new Color(180,15,16));
		setAdjustGunForRobotTurn(true);
	    setAdjustRadarForGunTurn(true);
	    setAdjustRadarForRobotTurn(true);
        init();
		do{
			turnRadarRightRadians(5);	
		}
		while(true);
	} 
	public void init(){
        lastBulletWillHitTime=0;
		aimWave.setDeath(0d);
        isUseChase=chaseBulletScore/(double)chaseBulletRounds>normalBulletScore/(double)normalBulletRounds;
		if(isUseChase){
			chaseBulletRounds++;
		}else{
			normalBulletRounds++;
		}
		if(chaseBulletRounds>=1000d){
			chaseBulletRounds/=2d;
			chaseBulletScore/=2d;
		}
		if(normalBulletRounds>=1000d){
			normalBulletRounds/=2d;
			normalBulletScore/=2d;
		}
		while(waves.size()>3500) waves.remove(0);   //max size 3500
	}
    public void onBulletHit(BulletHitEvent e){
		enemyEnergy=e.getEnergy();
	}
    public void onHitByBullet(HitByBulletEvent e){
		enemyEnergy+=e.getPower()*3d;
	}
    public void onHitRobot(HitRobotEvent e){
		enemyEnergy-=0.6d;
	}
	public void onWin(WinEvent e){
		if(isUseChase){
			chaseBulletScore+=(getEnergy()-1d); //prefer normal bullet
			normalBulletScore+=1d;
		}else{
			normalBulletScore+=getEnergy();
			chaseBulletScore+=1d;
		}
		save();
	}
	public void onDeath(DeathEvent e){
		if(isUseChase){
			chaseBulletScore-=enemyEnergy;
			normalBulletScore+=2d;
		}else{
			normalBulletScore-=enemyEnergy;
			chaseBulletScore+=2d;
		}
		save();
	}
    // -------------------- function for event handle ---------------
   	public void onScannedRobot( ScannedRobotEvent e ) {
		//first load data
		if(enemyName==null){
			enemyName=e.getName();
			load();
		}

	    int i;
        long time=getTime();
		double myX,myY,ex,ey,nextX,nextY,moveAngle,L,disA,disAngle,moveDistance,moveDirection,edistance,absBearing,energyChange;
		ex=(myX=getX())+Math.sin(absBearing=MultiWave.standardAngle(e.getBearingRadians()+getHeadingRadians()))*(edistance=(moveDistance=e.getDistance()));
		ey=(myY=getY())+Math.cos(absBearing)*edistance;


		// Radar turn grabed from David Alves.
		setTurnRadarRightRadians(Math.sin(absBearing - getRadarHeadingRadians()));

		//++++++++++++++++++++++++++++++++movement++++++++++++++++++++++++++++++++
		energyChange=enemyEnergy-e.getEnergy();
        enemyEnergy=e.getEnergy();
		if(Math.abs(energyChange-1.55)<1.46){
			//if enemy fire when i am ramming,so it can anti-ram,i will never ram it
			if(time-enemyLastFireTime>50 && edistance<200d){
				canRam=false;
			}
			lastEnemyBulletPower=energyChange;
			enemyLastFireTime=time;
		}
		boolean isRam=enemyEnergy<3.1d && time-enemyLastFireTime>50 && canRam;
		if((Math.abs(energyChange-1.55)<1.46 || edistance<200) && Math.abs(getDistanceRemaining())<53d || isRam){ 
			disAngle=8d/(20d-lastEnemyBulletPower*3d)+30d/edistance;
			moveDistance=Math.max(170,moveDistance);
			if(isRam)
				moveDistance=0d;
			double xieAngle=Math.abs((absBearing+Math.PI*2)%(Math.PI/2d));
			boolean isCloseToCenter=Point2D.distance(myX,myY,getBattleFieldWidth()/2d,getBattleFieldHeight()/2d)<Point2D.distance(0d,0d,getBattleFieldWidth()/2d,getBattleFieldHeight()/2d)/2d;
			do{
				moveAngle=absBearing+Math.PI+(disA=Math.random()*disAngle*2-disAngle);
				L=moveDistance;
				if(xieAngle<Math.PI/8d || xieAngle>Math.PI*7d/8d || isCloseToCenter){
    				L=moveDistance/Math.cos(disA);
				}
				//disAngle+=0.023; 
				if(distanceToWall(nextX=ex+Math.sin(moveAngle)*L,nextY=ey+Math.cos(moveAngle)*L)>23){
            		moveDirection = 1;
             		moveDistance=Point2D.distance(myX,myY,nextX,nextY);
            		moveAngle = MultiWave.standardAngle(Math.atan2(nextX-myX,nextY-myY)-getHeadingRadians());
            	   	if (Math.abs(moveAngle)>Math.PI/2) {		//if angle is biger than PI / 2
	        	    // this cool usage from DrLoco.
	            		moveAngle+=Math.acos(moveDirection=-1);	//switch direction and add PI to turn angle
                	}
            		setAhead(moveDirection*moveDistance);	//move towards point
                	setTurnRightRadians(MultiWave.standardAngle(moveAngle));
					break;
				}
				moveDistance*=0.96d; 
			}while(moveDistance>10d);
		}
		// halpPI angle to enemy if i stop
		if(getDistanceRemaining()==0){
    	   	if ( Math.abs( moveAngle = MultiWave.standardAngle( absBearing+Math.PI/2 - getHeadingRadians() ) ) > Math.PI / 2 )
                 moveAngle += Math.PI;
        	setTurnRightRadians( MultiWave.standardAngle( moveAngle ) );	//make turn
		}
    	setMaxVelocity( Math.abs(getTurnRemaining()) > 45 ? 0d : 8d );
		//------------------------------end of movement code------------------

        //++++++++++++++++++++++++++++++++Aiming and Shooting++++++++++++++++++
		//if i have enough energy and last gun turn have completed so fire
		boolean bullet=false;
		lastBulletWillHitTime--;
		if((getEnergy()-power>0.1d && Math.abs(preDiffAngle)<0.35d || edistance<120d) && (time-enemyLastFireTime>160 || (getEnergy()<enemyEnergy && edistance<120d) || !isRam)){		   
		   if(setFireBullet(power)!=null){
			   bullet=true;
               lastBulletWillHitTime=aimWave.getWillHitDistance(power)/bulletVelocity(power);
		   }
		}
		//-----------------patten analyser------------------------------------
		double ev=e.getVelocity();
		int wavesSize=waves.size();
		//use 201,201*11>2000,usually > battleFiledWidth and battleFiledHeight
		for(i=wavesSize-1;i>=0 && i>wavesSize-201;i--)
			((MultiWave)waves.elementAt(i)).test(ex,ey,time);

		waves.add(new MultiWave(myX,myY,bullet,time,absBearing,edistance,ev*Math.sin(e.getHeadingRadians()-absBearing),Point2D.distance(ex,ey,getBattleFieldWidth()/2,getBattleFieldHeight()/2)/75d));
        preDiffAngle=0;
        if(getGunHeat()<0.4d){
            //-------------find match wave---------------
	    	double matchValue=Double.POSITIVE_INFINITY;//very large
			MultiWave matchWave=null;
			double matchDir=1;
    		for(i=74;i<wavesSize;i++){
	    		double comVal,comValD;
    			MultiWave wave=(MultiWave)waves.elementAt(i);
	    		if(wave.isHit(3d)){//is a succeded wave
		    	    comVal=comValD=wave.isFired;
				    int j=0; 
					double div=0d;
					double dir=1d;
					do{
						comVal+=MultiWave.getComVal(waves.elementAt(wavesSize-j),waves.elementAt(i-j))/(div=div*2+1);
						comValD+=MultiWave.getComValD(waves.elementAt(wavesSize-j),waves.elementAt(i-j))/(div);
					}while((j+=6)<73);

					if(comValD<comVal){
                		comVal=comValD;
						dir= -1d;
					}
					if(comVal<=matchValue){
                    	ex=myX+Math.sin(moveAngle=absBearing+wave.getWillHitDiffAngle(3d)*dir)*(comValD=wave.getWillHitDistance(3d));   //matched wave's velocity is distance(not v)
                    	ey=myY+Math.cos(moveAngle)*comValD;
		        	    if(distanceToWall(ex,ey)>18d){
				        	matchValue=comVal;
				    		matchWave=wave;
							matchDir=dir;
    			    	}
					}
	    		}
    		}
	    	if(matchWave!=null){
		    	aimWave=matchWave.resultWave(matchDir);
		       	if(e.getEnergy()==0d)
			      	aimWave.setDeath(edistance);
			}
	    	power=Math.min(getEnergy()/5d,Math.min(3,enemyEnergy/6d));
			if(edistance<120) power=3d;
			if(e.getEnergy()==0d && !canRam){
				power=Math.max(0.1,Math.min(getEnergy()-1d,3d));
			}
            preDiffAngle=aimWave.getWillHitDiffAngle(power);
            //if use chase bullet?
			if(isUseChase){
	        	for(double chasePower=3d;chasePower>0;chasePower-=0.1){
	        		if(aimWave.getWillHitDistance(chasePower)/bulletVelocity(chasePower)<=lastBulletWillHitTime){
                        preDiffAngle=aimWave.getWillHitDiffAngle(chasePower);
		    	    	power=chasePower;
		    	    	break;
		            }
	        	}	
			}
		}
        //turn gun
        setTurnGunLeftRadians(preDiffAngle=MultiWave.standardAngle(getGunHeadingRadians()-absBearing-preDiffAngle));
		//-----------------------------end of Aiming and Shooting code-----------------------------------
		scan();
    }
	//---------------------------------------utils functions---------------------------------------
    public double bulletVelocity(double power){
		return 20d-power*3d;
	}
	public double distanceToWall(double x,double y){
		return Math.min(xDistanceToWall(x),yDistanceToWall(y));
	}
	/**
	 * return the min x distance to wall of (bx,by)
	 */
	public double xDistanceToWall(double bx){
		return Math.min(bx,getBattleFieldWidth()-bx);
	}
	/**
	 * return the min x distance to wall of (bx,by)
	 */
	public double yDistanceToWall(double by){
		return Math.min(by,getBattleFieldHeight()-by);
    }
	/**
	 * save all datas as a Hashtable Object
	 */
	public void save(){
		out.println("normalBulletAvScore:"+normalBulletScore+"/"+normalBulletRounds+"="+normalBulletScore/normalBulletRounds);
		out.println("chaseBulletAvScore :"+chaseBulletScore+"/"+chaseBulletRounds+"="+chaseBulletScore/chaseBulletRounds);
		try {
			ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile("score.zip"))));
			float[] score=new float[4];
			score[0]=(float)normalBulletScore;
			score[1]=(float)chaseBulletScore;
			score[2]=(float)normalBulletRounds;
			score[3]=(float)chaseBulletRounds;
			data.put(enemyName,score);
			out.writeObject(data);
			out.close();
		} catch (Exception e) {
			out.println("can not save data : "+e.getMessage());
		}
	}
	/**
	 * load datas
	 */
    public void load(){
		try{
			ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile("score.zip"))));
			data=(Hashtable)in.readObject();
			in.close();
			float[] score=(float[])data.get(enemyName);
			if(score!=null){
		    	normalBulletScore = (double)(score[0]);
		    	chaseBulletScore = (double)(score[1]);
		    	normalBulletRounds = (double)(score[2]);
		    	chaseBulletRounds = (double)(score[3]);
			}else{
				out.println("this is no "+enemyName+"'s data,creat and add!");
			}
		}catch(Exception e) {
			out.println("can not read data :"+e.getMessage());
			data=new Hashtable();
		}
	}
}
