package vuen.cfCake;
import vuen.Cake;
import robocode.*;

public class cMovLine {
	private Cake oRobot = null;
	private cMovControl oMovControl = null;
	private cComControl oComControl = null;
	
	private int mPhase = 0;
	private double mDirection = 1;//Math.round(Math.random()) * 2 - 1;
	private double CTurnDelay = 25;
	private double mTurnDelay = 0;
	private double CDistance = 50;
	
	public cMovLine(Cake pRobot, cMovControl pMovControl, cComControl pComControl) {
		oRobot = pRobot;
		oMovControl = pMovControl;
		oComControl = pComControl;
	}
	
	public void doInit() {
		oRobot.setMaxTurnRate(10);
		oRobot.setMaxVelocity(4);
		oRobot.setTurnRight(0);
		oRobot.setAhead(100);
		mPhase = 0;
		oMovControl.mMovAntiGrav.doSetup(45,1,300);
	}
	
	public void doUnInit() {
	}
	
	public void doTurn() {
		//oRobot.out.println("Line Turn!");
		if (oMovControl.mMovWall.isRobotHeadingToWall(getFixedHeading(), 40)) {
			mDirection *= -1;
			oRobot.setAhead(oRobot.getDistanceRemaining() * -1);
		}
		if (mPhase == 0) {
			if (oRobot.getTurnRemaining() == 0) {
				if (Math.round(oRobot.getHeading()) % 90 == 0) {
				//NASTY non-start bug, old line was: (all that changed was the position of % 90
				//if (oRobot.normalRelativeAngle(Math.round(oRobot.getHeading() % 90)) == 0) {
					mPhase = 1;
				} else {
					doSetVelocity();
					oRobot.setTurnLeft(oRobot.normalRelative90Angle(oRobot.getHeading() % 90));
				}
			}
		} else if (mPhase == 1) {
			doTurnRobot(false);
			doSetVelocity();
			oRobot.setAhead(10000 * mDirection);
		}
	}
	
	public void doSetVelocity() {
		//oRobot.setMaxVelocity(Math.sin(oRobot.getTime() / 3) * 3 + 5);
		//oRobot.out.println(Math.abs(oRobot.normalRelative90Angle(oRobot.getTurnRemaining())));
		//oRobot.setMaxVelocity(45 - );
		//oRobot.setMaxVelocity(  10 - (Math.abs(oRobot.getTurnRemaining()) + 50) / 90  );
		//if (oRobot.getTurnRemaining() != 0) oRobot.setMaxVelocity(0); else oRobot.setMaxVelocity(8);
		oRobot.setMaxVelocity(8 - Math.abs(oRobot.normalRelative90Angle(oRobot.getTurnRemaining())) / 8);
		//;
	}
	
	public void doTurnRobot(boolean pForceFlip) {
		//oRobot.out.println("[" + oRobot.getTime() + "] Heading: " + getFixedHeading() + "  X: " + oRobot.getX() + "  Y: " + oRobot.getY());
		if (oRobot.getTurnRemaining() != 0 || mTurnDelay + CTurnDelay > oRobot.getTime()) return;
		doReconfigureGrid();
		oMovControl.mMovAntiGrav.doCompute();
		//oRobot.out.println("*******************************");
		//oRobot.out.println("        " + oMovControl.mMovAntiGrav.mGrid[0][0]);
		//oRobot.out.println(oMovControl.mMovAntiGrav.mGrid[3][0] + "  " + oMovControl.mMovAntiGrav.mGrid[1][0]);
		//oRobot.out.println("        " + oMovControl.mMovAntiGrav.mGrid[2][0]);
		//oRobot.out.println("*******************************");
		int pDirection = 1;
		//oRobot.out.println(oRobot.normalAbsoluteAngle(getFixedHeading()));
		//oRobot.out.println(Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() + 90) / 90));
		//oRobot.out.println(oMovControl.mMovAntiGrav.mGrid[(int)(oRobot.normalAbsoluteAngle(getFixedHeading() + 90) / 90)][0] + " , " + oMovControl.mMovAntiGrav.mGrid[(int)(oRobot.normalAbsoluteAngle(getFixedHeading() - 90) / 90)][0]);
		//if (oMovControl.mMovWall.isPolarNearWall(getFixedHeading() + 90, CDistance, 20) || ((oMovControl.mMovWall.isPolarNearWall(getFixedHeading() - 90, CDistance, 20) == false) && oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() + 90) / 90)][0] > oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() - 90) / 90)][0])) pDirection = -1;
		if (oMovControl.mMovWall.isPolarNearWall(getFixedHeading() + 90, CDistance, 20) || (!oMovControl.mMovWall.isPolarNearWall(getFixedHeading() - 90, CDistance, 20) && Math.min(Math.min(oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() + 90) / 45)][0],oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() + 90 - 45) / 45)][0]),oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() + 90 + 45) / 45)][0]) > Math.min(Math.min(oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() - 90) / 45)][0],oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() - 90 - 45) / 45)][0]),oMovControl.mMovAntiGrav.mGrid[(int)Math.round(oRobot.normalAbsoluteAngle(getFixedHeading() - 90 + 45) / 45)][0]))) pDirection = -1;
		if (pForceFlip) {
			mDirection *= -1;
			oRobot.setTurnRight(-90 * pDirection);
		} else {
			//oRobot.setTurnRight(90 * pDirection);
			oRobot.setTurnRight(90 * (Math.round(Math.random()) * 2 - 1) * pDirection);
			mDirection *= oRobot.getTurnRemaining() / 90 * pDirection;
		}
		mTurnDelay = oRobot.getTime();
	}
	
	public void doReconfigureGrid() {
		double pDistance = 100000;
		for (int iEnemy = 0; iEnemy < oComControl.mComEnemy.mTotalNames; iEnemy++) {
			if (oComControl.isEnemyValid(iEnemy) && oComControl.mComEnemy.mEnemyDistance[iEnemy] < pDistance) pDistance = oComControl.mComEnemy.mEnemyDistance[iEnemy];
		}
		oMovControl.mMovAntiGrav.mDistance = pDistance;
		//oRobot.out.println(pDistance);
	}
	
	public double getFixedHeading() {
		// || getFixedHeading() == 360
		return oRobot.normalAbsoluteAngle(Math.round(oRobot.getHeading() + 90 * (mDirection - 1)));
		//return Math.round(oRobot.getHeading());
	}
	
	public void onHitRobot(HitRobotEvent e) {
		//oRobot.out.println("Hit Robot!");
		//if (oRobot.normalRelativeAngle(getFixedHeading() - e.getBearing()) < 90 && oRobot.normalRelativeAngle(getFixedHeading() - e.getBearing()) > -90)
		if (e.isMyFault()) mDirection *= -1;
		oRobot.setAhead(10000 * mDirection);
		//mPhase = 0;
	}
	
	public void onHitWall(HitWallEvent e) {
		mDirection *= -1;
		oRobot.setAhead(10000 * mDirection);
	}
	
	public void onHitByBullet(HitByBulletEvent e) {
	}
	
	public void onBulletHit(BulletHitEvent e) {
	}
}