package extra;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;

public class LightSauce extends AdvancedRobot{
  boolean movingForward;
	public void run(){
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		while(true){
          back(250);
          ahead(250);
		}
	}
	public void onScannedRobot(ScannedRobotEvent e){
	double absoluteBearing = getHeading() + e.getBearing();
	double bearingFromGun = normalRelativeAngleDegrees(absoluteBearing - getGunHeading());
	setTurnRight(e.getBearing() + 90);
    setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
if (getGunHeat() == 0){
				setFire(Math.min(3 - Math.abs(bearingFromGun), getEnergy() - .1));
			}
		
		else{
			setTurnGunRight(bearingFromGun);
		}
		if (bearingFromGun == 0) {
			scan();
		}
	}
	
public void reverseDirection() {
		if (movingForward) {
			setBack(250);
			movingForward = false;
		} else {
			setAhead(250);
			movingForward = true;
		}
	}
	public void onHitWall(HitWallEvent e) {
     reverseDirection();
	}	
}