/*
 * Created on 2004-9-26
 */
package tide.util;

import java.awt.geom.Point2D;

/**
 * Wave is a tool to gather the infomation of shooting. 
 * @author iiley(Chen Jing)
 */
public class Wave {
	//draw wave in robocodeGL or not
	private static final boolean doGL = true;
	//statist factors size
	private final int FACTORS;
	//bullet power
	private double power;
	//wave fired time
	private long   startTime;
	//target's direction when wave fired
	private double targetDirection;
	//target's absBearing when wave fired
	private double originBearing;
	//rate times when the wave hit target
	private int    rateTimes;
	//if the wave traveled over the target 
	private boolean flyoff;
	//is the wave fired when a real bullet fired
	private boolean realBullet;
	//the statist of the wave use to stat
	private Statist statist;
	//the start point of this wave(the position of bot when fire)
	private Point2D.Double startPoint=new Point2D.Double();

	//private WavePainter painter;
	
	public Wave(Statist statist, Point2D startPoint, double fpower, double targetD, double originBearing, long time){
		this.statist = statist;
		this.power=fpower;
		this.startPoint.setLocation(startPoint);
		this.originBearing=originBearing;
		this.targetDirection=targetD;
		this.startTime = time;
		this.flyoff = false;
		this.realBullet = false;
		this.rateTimes = 1;
		FACTORS = statist.size();
		
		//painter = new WavePainter(this);
	}
	
	/**
	 * Test the wave.
	 * Must test waves every tick before it flyed off.
	 * It return true when the wave hitted its target,
	 * otherwish return false.
	 * @param time the time when the menthod be calling
	 * @param targetPos the target's position when the menthod be calling
	 * @return is the wave hitted the target this time.
	 */
	public boolean test(long time, Point2D targetPos){
		boolean flag = testInner(time, targetPos);
		
		//do GL 
		/*if (doGL && realBullet) {
			painter.creatGLElements();
			painter.draw(time);
			if(this.getRemainTime(time, targetPos) <= -2){
				painter.removeGLElements();
			}
		}*/
		return flag;
	}
	
	
	/**
	 * In fact the test method call this method to test wave.
	 * Then the test method can draw wave.
	 * @param time
	 * @param enemyPos
	 * @return is the wave hitted the target this time.
	 */
	private boolean testInner(long time, Point2D enemyPos){
		if(time < startTime || flyoff){
			return false;
		}
		if(traveledDistance(time)-enemyPos.distance(startPoint) > -10d){  //is the wave hit enemy?
			flyoff = true;
			int index = getFactorIndex(enemyPos);
        	rate(index);
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * Return the distance of this wave traveled for start time to this time.
	 * @param time the time of count end.
	 * @return the distance of this wave traveled for start time to this time.
	 */
	public double traveledDistance(long time){
		return Utils.bulletVelocity(power)*(time-startTime);
	}
	
	/**
	 * Return how many time left the wave can hit the target.
	 * @param time current time.
	 * @param targetPos target's position
	 * @return time left of the wave can hit the target.
	 */
	public long getRemainTime(long time, Point2D targetPos){
		double remainDist = targetPos.distance(startPoint) - traveledDistance(time);
		return (long)Math.ceil(remainDist/Utils.bulletVelocity(power));
	}
	
	/*public float getFactorByAngle(double angle){
		int index = StatistUtil.getIndex(angle, originBearing, power, targetDirection, FACTORS);
		if(index < 0 || index >= FACTORS){
			return Float.MAX_VALUE;
		}
		return statist.getFactor(index);
	}*/
	
	/**
	 * Return the index that relative to the angle from wave's position the this position
	 * @param pos
	 * @return the index that relative to the angle from wave's position the this position
	 */
	public int getFactorIndex(Point2D pos){
		return StatistUtils.getIndex(MathUtils.heading(startPoint, pos), originBearing, power, targetDirection, FACTORS);
	}
	
	public float getFactor(Point2D pos){
		return getFactor(getFactorIndex(pos));
	}
	
	public float getFactor(int index){		
		return statist.getFactor(index);
	}
	
	/**
	 * @return the heading of the highest factor.
	 */
	public double getHighestFactorHeading(){
		int index = statist.getHighestFactorIndex();
		return MathUtils.anglePI(
				originBearing + StatistUtils.getAngle(targetDirection, index, power, FACTORS));
	}
	
	public double getHighestFactor(){
		return statist.getFactor(statist.getHighestFactorIndex());
	}
	
	public int getDirection(){
		return (int)targetDirection;
	}
	
	/**
	 * Set the rate times.
	 * When the wave hit its target,it will rete the statist rate times.
	 * Default value is 1,means rate once.
	 * @param times
	 */
	public void setRateTimes(int times){
		this.rateTimes = times;
	}
	
	/**
	 * disable this wave,then it will not travel or be rate.
	 */
	public void disable(){
		flyoff = true;
	}
	
	/**
	 * Set is this wave fired when a real bullet fired.
	 * @param isReal
	 */
	public void setRealBullet(boolean isReal){
		this.realBullet = isReal;
	}
	
	/**
	 * @return is this wave fired when a real bullet fired.
	 */
	public boolean isRealBullet(){
		return realBullet;
	}
	
	public void rate(int index){
		for(int i=0; i<rateTimes; i++){
			statist.rate(index);
		}
	}
	
	/**
	 * Rate this target position's hit angle's index to be the highest.
	 * @param targetPos the position of wave should hitted.
	 */
	public void rateHit(Point2D targetPos){
		statist.rateHit(getFactorIndex(targetPos));
	}

	
	public long getStartTime(){
		return startTime;
	}
	
	public int getFactorsAmount(){
		return FACTORS;
	}
	
	public Point2D getStartPosition(){
		return startPoint;
	}
	
	public double getAbsBearing(){
		return originBearing;
	}
	
	public double getMaxEscapAngle(){
		return StatistUtils.maxEscapAngle(power);
	}
	
	public double getPower(){
		return power;
	}
	
	public void setPower(double power){
		this.power = power;
	}
	
	public String toString(){
		return "time:"+startTime+"power:"+power+","+startPoint.toString();
	}
}
