/*
 * Created on May 28, 2003
 *
 * v 0.4.1
 * Changed radar to that from Moebius.  Codesize is down to 151.  Must
 * either improve movement or targeting.
 * 
 * v 0.4
 * Trying to move parallel to the enemy.
 * 
 * v 0.3
 * Trying to approach last enemy position obliquely
 * May need to refine this some, but it seems to help.
 * 
 * v 0.2.2
 * Radar should restart if no robots found for 16 turns.
 * This cost me 16 bytes.
 * 
 * v 0.2
 * Radar modified based on concepts in David Alves' DuelistMicro.
 * Thanks, David!
 * Checks in at 187 bytes.  I'm definitely going to have to
 * beef it up!
 * 
 * v 0.1
 * My first nano.  Semi-random oscillating movement,
 * head-on targeting, simple radar scans.  I still have lots
 * of room for growth
 */
package jep.nano;
import robocode.*;

/**
 * @author johnp
 *
 * Experiment in the nanobot world.
 */
public class Hawkwing extends AdvancedRobot {
	
	private int direction = -1;
	
	public void run() {
		setAdjustGunForRobotTurn(true);
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		while (true) {
			if (getOthers() > 0) {
				setFire(3);
			}
			execute();
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double bearingPlusHeading = e.getBearingRadians() + getHeadingRadians();
		setTurnGunRightRadians(normalRelativeAngleRadians(bearingPlusHeading - getGunHeadingRadians()));
		setTurnRightRadians(normalRelativeAngleRadians(getHeadingRadians() - e.getHeadingRadians()));
		setAhead(100*direction);
		setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	}
	
	public void onHitWall(HitWallEvent e) {
		setTurnRightRadians(Math.PI/2 - e.getBearingRadians());
		setAhead(100*(direction *= -1));
	}
	
	public double normalRelativeAngleRadians(double angle) {
		return ((angle + 7*Math.PI) % (2*Math.PI)) - Math.PI;

	}
}
