package trab.crusader;

import trab.utils.*;

import robocode.*;
//import robocode.util.Utils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
/*
import robocode.robocodeGL.*;
import robocode.robocodeGL.system.*;
*/
import java.util.ArrayList;


public class CrusaderGun extends Object {
  
  private final int DIST_SEGMENTS = 5;
  private final int VEL_SEGMENTS = 3;
  
  private ArrayList lists[][] = new ArrayList[ DIST_SEGMENTS ][ VEL_SEGMENTS ]; 
  
  private final boolean TC = false;
  
  private AdvancedRobot robot;
  
  private final int MAX_FRAMES = 100000;
  private final int MAX_FRAMES_PER_SEGMENT = 12000;
  private ArrayList movie;
  private ArrayList currentList;
  private ArrayList bestList;

  double oldHeading;
  double enemyY;
  double enemyX;
  
  double bulletPower = 1.91;

  private int eVel = 0;
  private int eOldVel = 0;
  private double eOldHeading = 0;
  
  private long deccelTime = 0;
  
  private long accelTime = 0;
  private long turnTime = 0;
  
  private double sin[] = new double[360];
  private double cos[] = new double[360];
  
  private int velSeg;
  private int distSeg;
  
  Rectangle2D.Double battleField;
/*
  static final int NUM_GL_POINTS = 60;
  PointGL glPoint[];
  robocode.robocodeGL.system.GLRenderer renderer;
  */
  public CrusaderGun(AdvancedRobot robot ) {
    
    battleField = new Rectangle2D.Double(18, 18, robot.getBattleFieldWidth() - 18 * 2, robot.getBattleFieldHeight() - 18 * 2);
    
    this.robot = robot;
    
    movie = new ArrayList();
    movie.ensureCapacity( MAX_FRAMES + 2000 ); // +2000 since i only delete entrys in roundInit
    
    robot.out.println( "CruasaderGun() is constructed" );
  
    bestList = new ArrayList(); // bestRating should come first
    bestList.ensureCapacity( 500 );
  
    for ( int i = 0; i < DIST_SEGMENTS; i++ ) {
      for ( int j = 0; j < VEL_SEGMENTS; j++ ) {
        lists[i][j] = new ArrayList();
        lists[i][j].ensureCapacity( MAX_FRAMES_PER_SEGMENT + 2000 );
      }  
    }
  
    for ( int i = 0; i < 360; i++ ) {
      sin[i] = Math.sin( Math.toRadians( i ) );
      cos[i] = Math.cos( Math.toRadians( i ) );
    }
  /*
    glPoint = new PointGL[NUM_GL_POINTS];
    renderer = robocode.robocodeGL.system.GLRenderer.getInstance();
    //renderer = robocode.robocodeGL.GLRenderer.getInstance();
    for ( int i = 0; i < NUM_GL_POINTS; i++ )
    {
      glPoint[i] = new PointGL();
      glPoint[i].setColor( new Color( (float)(NUM_GL_POINTS-i)/(float)NUM_GL_POINTS, (float)i/(float)NUM_GL_POINTS, 0f ) );
      glPoint[i].setSize(3);

      renderer.addRenderElement( glPoint[i] );
    }
    */
  }
  
  public void roundInit() {
    /*
    for ( int i = 0; i < NUM_GL_POINTS; i++ )
    {
      
      glPoint[i] = new PointGL();
      glPoint[i].setColor( new Color( (float)(NUM_GL_POINTS-i)/(float)NUM_GL_POINTS, (float)i/(float)NUM_GL_POINTS, 0f ) );
      glPoint[i].setSize(3);
      
      renderer.addRenderElement( glPoint[i] );
    }
    */
    oldHeading = 0;
    enemyY = enemyX = 0;
    
    robot.out.println( "movie.size() = " + movie.size() );
    //robot.out.println( "CruasaderGun() is initialized for the round." );
    for ( int i = 0; i < DIST_SEGMENTS; i++ ) {
      for ( int j = 0; j < VEL_SEGMENTS; j++ ) {
        while ( lists[i][j].size() > MAX_FRAMES_PER_SEGMENT )
           lists[i][j].remove( 0 );
      }  
    }
    
    
    while ( movie.size() > MAX_FRAMES ){
      movie.remove( 0 );
      //robot.out.println( "Had to trim size in roundInit()." );
    }
    
    accelTime = deccelTime = robot.getTime();
  }
  
  private int getDistSegment( double dist ) {
    if ( dist <= 200 ) // very close
      return 0;
    if ( dist <= 350 ) // close
      return 1;
    if ( dist <= 500 ) // medium range
      return 2;
    if ( dist <= 650 ) // medium to longe range
      return 3;
    return  4; // long range
  }
  private int getVelSegment( double vel ) {
    if ( vel <= 2 ) // "slow"
      return 0;
    if ( vel <= 6 ) // "medium speed"
      return 1;
    return 2; // "fast"
  }
  
  
  private void aim() {
    /*
    bestList.clear();
    bestList.ensureCapacity( 500 );
    */
    int movieSize = movie.size();
    int currentSize = currentList.size();
    
    double rating; // lower is better
    double ratingAt50 = 999999;
    
    Frame currentFrame = (Frame)currentList.get( currentSize - 1 );
    Frame movieFrame;
    
    //double bestRate = 999999;
    int startFrameIndex = 0;
    
    //srobot.out.println( "currentList: [" + distSeg + "][" + velSeg + "].size = " + currentSize + " movieSize = " + movieSize );
    
    int NUM_MOVIES = (int)Math.min( 100, (double)currentSize * .1 );
    
    Rating[] ratings = new Rating[ NUM_MOVIES ];
    for ( int i = 0; i < NUM_MOVIES; ++i )
      ratings[i] = new Rating( 999999, 0 );
    //robot.out.println( "--- New AIM() --- MovieSize= " + movie.size() + " starting at - " );
    int minFrame = (currentSize>40?40:2);
    for ( int i = currentSize - (currentSize>100?50:2); i >= minFrame; --i ) {
      
      movieFrame = ( Frame )currentList.get( i );
      rating = currentFrame.rate( movieFrame );
      // age
      //rating *= 1d + (movieSize-i) / 10000d; // 10000 ticks old is half 
    
      if ( rating < ratingAt50 ) {
      
        int j = -1;
        for( int l = 0; l < NUM_MOVIES; l++ ) { // linear search, what about binary?
          if ( rating < ratings[l].rating ) {
            j = l;
            l = NUM_MOVIES;  
          }
        }
        if ( j > -1 ) {
        
          for ( int k = NUM_MOVIES-1; k > j; --k ) {
            ratings[k].rating = ratings[k-1].rating;
            ratings[k].frameNum = ratings[k-1].frameNum;
          }
          
          ratings[j].rating = rating;
          ratings[j].frameNum = movieFrame.sampNum;
          
          if ( j == NUM_MOVIES-1 )
            ratingAt50 = rating;
        }
      }
    }
    
    int[] angleHits = new int[120];
    double currentBearing = Math.atan2( enemyX-robot.getX(),enemyY-robot.getY() );
    double predBearing;
    double a;
    double rate;
    double maxA = Math.toDegrees( Math.asin( 8.0D / (20 - bulletPower * 3 ) ) );
    int aa;
    int numOk = 0;
    for ( int i = 0; i < NUM_MOVIES; i++ ) {
      
      Point2D predicted = playMovie( ratings[i].frameNum );
      
      if ( battleField.contains( predicted ) ) {
        numOk++;
        predBearing = Math.atan2( predicted.getX()-robot.getX(),predicted.getY()-robot.getY() );
        a = Math.toDegrees( Utils.normalRelativeAngle( predBearing-currentBearing ) );
        //a = Math.toDegrees( Utils.normalRelativeAngle( predBearing-currentBearing ) );
        //robot.out.println( "1: Frame: " + ratings[i].frameNum + " Added hit at a=" + a + "  rating=" + 1d/ratings[i].rating );
        a = Math.max( -maxA, Math.min( maxA, a ) );
        
        // exp
        /*
        if ( a > 30 )
          robot.out.println( a );
        */
        //rate = 1;
        //rate = Math.random()*10;
        //rate = 1d / Math.sqrt(i);
        rate = 1d;
        //rate = 1d / ratings[i].rating;
        aa = (int)Math.round(a+60);
        
        angleHits[ aa+4 ] += rate / 25; //1 / ratings[i].rating;
        angleHits[ aa+3 ] += rate / 16; //1 / ratings[i].rating;
        angleHits[ aa+2 ] += rate / 9;  //1 / ratings[i].rating;
        angleHits[ aa+1 ] += rate / 4;  //1 / ratings[i].rating;
        
        angleHits[ aa ] += rate;  //1 / ratings[i].rating;
        
        angleHits[ aa-1 ] += rate / 4;  //1 / ratings[i].rating;  
        angleHits[ aa-2 ] += rate / 9;  //1 / ratings[i].rating;
        angleHits[ aa-3 ] += rate / 16;  //1 / ratings[i].rating;
        angleHits[ aa-4 ] += rate / 25;  //1 / ratings[i].rating; 
      }
    }
    /*
    // smooth it
    double[] ah = new double[90];
    for ( int i = 0; i < 90; i++ ) {
      for ( int j = 0; j < 90; j++ ) {
        ah[i] += angleHits[j] / Math.pow( (Math.abs( i-j )+1), 2 );   
      }
    }*/
    
    /*
    if ( robot.getTime() > 200 ) {
      robot.out.println( "--- Ratings ---" );
      for ( int i = 0; i < 50; ++i ) {
        robot.out.println( i + " : " + Utils.sloppyRound(ratings[i].rating,2) );  
      }  
    }*/
    int best = 60;
    if ( numOk > 0 ) {
      double hitsAtBest = angleHits[60];
      for ( int i = 20; i < angleHits.length-20; i++  )
        if ( angleHits[i] > hitsAtBest ) {
          best = i;
          hitsAtBest = angleHits[i];  
        }
    }
    
    //robot.out.println( "Fireing at: " + (best-60) );  
    double relativeAngle = Utils.normalRelativeAngle( Math.toRadians( best-60 ) );
    
    //robot.out.println( "best angle = " + (int)Math.toDegrees( relativeAngle ) + " \thits = " + ah[best] );
    
    double turnAngle = Math.atan2( enemyX-robot.getX(), enemyY-robot.getY() ) + relativeAngle - robot.getGunHeadingRadians();
    //double turnAngle = Math.atan2( eX-mX,eY-mY ) - robot.getGunHeadingRadians();
    robot.setTurnGunRightRadians( Utils.normalRelativeAngle( turnAngle ) ); 
    
    if ( robot.getGunHeat() == 0 && TC && robot.getGunTurnRemaining() < 5 ) {
      robot.setFire( 3 );
    }
    else if ( robot.getGunHeat() == 0 && robot.getEnergy()-bulletPower > 0.1 && robot.getGunTurnRemaining() < 5 ) {
      robot.setFire( bulletPower );
    }
  }

  private Point2D playMovie( int f ) {
    
    int movieSize = movie.size();
    Frame currentFrame = (Frame)movie.get( movieSize - 1 );
    Frame startFrame = (Frame)movie.get( f );
    Frame thisFrame;
    double robotVel = robot.getVelocity();
    double mX = robot.getX() + sin[ (int)robot.getHeadingRadians() ] * robotVel;
    double mY = robot.getY() + cos[ (int)robot.getHeadingRadians() ] * robotVel;
    double eX = enemyX; // enemy predicted position X
    double eY = enemyY; // enemy predicted position Y
    
    double radi = 0;
    double heading = currentFrame.heading;
    
    //eX = eY = mX = mY = 0;
    double distSqr = (eX-mX)*(eX-mX) + (eY-mY)*(eY-mY);
    int nextFrame = f;
    
    //robot.out.println( "\n--- New Path: ---" );
    //int ite = 0;
    int degHeading;
    double bulletSpeed = 20 - bulletPower * 3;
    
    while ( radi*radi < distSqr - 18*18 ) { // distances squared
      if ( nextFrame < movieSize-1 )
        ++nextFrame;
        
      thisFrame = (Frame)movie.get( nextFrame );
      
      heading += thisFrame.headingDelta;
      //currentFrame.velocity;
      degHeading = (int)Math.toDegrees( Utils.normalAbsoluteAngle( heading ) );
      eX += sin[ degHeading ] * thisFrame.velocity;
      eY += cos[ degHeading ] * thisFrame.velocity;
      
      /*
      eX += Math.sin( heading ) * thisFrame.velocity;
      eY += Math.cos( heading ) * thisFrame.velocity;
      */
      //robot.out.println( (int)eX + " : " + (int)eY );
      
      radi += bulletSpeed;
      
      //glPoint[ite].setPosition( eX, eY );
      //ite++;
    }
    return new Point2D.Double( eX, eY );
  }

  public void onScannedRobot( ScannedRobotEvent e ) {
	  
	  double curBearing = Utils.normalRelativeAngle( robot.getHeadingRadians() + e.getBearingRadians() );
		double distance = e.getDistance();
		double eX = enemyX = robot.getX() + Math.sin( curBearing ) * distance;
		double eY = enemyY = robot.getY() + Math.cos( curBearing ) * distance;
		
	  Frame newFrame = new Frame( movie.size()+1 );
	  newFrame.position[0] = eX;
	  newFrame.position[1] = eY;
	  
	  eVel = (int)e.getVelocity();
	  
	  currentList = lists[ distSeg = getDistSegment( distance ) ][ velSeg = getVelSegment( Math.abs(eVel) ) ];
	  
	  long currentTime = robot.getTime();
	  if ( eVel != eOldVel )
	    accelTime = currentTime;
	  if ( Math.abs(eVel) < Math.abs(eOldVel) )
	    deccelTime = currentTime; 
	    
	  Frame depthFrame;;
	  int depth = newFrame.sampleDepths[0];
	  double rotAngle = 0;
	  double curAngle;
	  double newAngle;
	  int useAngle;
	  for ( int i = 0, n = newFrame.sampleDepths.length, m = movie.size(); i < n && newFrame.sampleDepths[i] < m; ++i ) {
	    
	    depth = newFrame.sampleDepths[i];
	    depthFrame = (Frame)movie.get( m-1-depth );
	    
	    newFrame.vectors[0][i] = eX - depthFrame.position[0];
	    newFrame.vectors[1][i] = eY - depthFrame.position[1];
	    // manhatten
	    //newFrame.vectors[2][i] = Math.abs( newFrame.vectors[0][i] ) + Math.abs( newFrame.vectors[1][i] ); 
	    // true distance
	    newFrame.vectors[2][i] = Math.sqrt( newFrame.vectors[0][i]*newFrame.vectors[0][i]+newFrame.vectors[1][i]*newFrame.vectors[1][i] ); 
	    //rotate first vector to face east, and rotate the rest by the same angle.
	    
	    curAngle = Math.atan2( newFrame.vectors[0][i], newFrame.vectors[1][i] );
	    
	    if ( i == 0 )
	      rotAngle = -curAngle;
	    
	    newAngle = curAngle + rotAngle;
	    useAngle = (int)Math.toDegrees( Utils.normalAbsoluteAngle( newAngle ) );
	    
	    newFrame.vectors[0][i] = cos[ useAngle ] * newFrame.vectors[2][i];
	    newFrame.vectors[1][i] = sin[ useAngle ] * newFrame.vectors[2][i];
	  }
	  
	  newFrame.distanceToMe = distance; 
	  newFrame.distanceToWall = Math.min(Math.min(eX, 800 - eX), Math.min(eY, 600 - eY));
	  newFrame.heading = e.getHeadingRadians();
	  
	  if ( newFrame.heading != eOldHeading )
	    turnTime = currentTime;
	  
	  //newFrame.headingDelta = oldHeading - newFrame.heading;
	  newFrame.headingDelta = newFrame.heading - oldHeading;
	  oldHeading = newFrame.heading;
	  //newFrame.velocity = Math.abs( e.getVelocity() );
	  newFrame.velocity = eVel;
	  newFrame.oldVelocity = eOldVel;
	  newFrame.timeSinceVelChange = currentTime - accelTime;
	  newFrame.timeSinceDeccel = currentTime - deccelTime;
	  newFrame.timeSinceTurn = currentTime - turnTime;
	  
	  //newFrame.relativeBearingToMe = e.getHeadingRadians() - curBearing; // fix this
	  //robot.out.println( "timeSinceTurn = " + newFrame.timeSinceTurn );
	  
	  movie.add( newFrame );
	  currentList.add( newFrame );
	  
	  //if ( movie.size() > 80 && robot.getTime() > 20  )
	  if ( distance < 75 ) {// rammer?
	    // hot and full power
	    
	    robot.setTurnGunRightRadians( Utils.normalRelativeAngle( e.getBearingRadians() + robot.getHeadingRadians()-robot. getGunHeadingRadians() ) );
	    bulletPower = 3;
	    if ( robot.getGunHeat() == 0 )
	      robot.setFire( bulletPower );
	  }
	  else {
	    if ( robot.getGunHeat()/robot.getGunCoolingRate() < 3 && movie.size() > 30 && robot.getEnergy() > 0.0 && !TC )
  	  //if ( robot.getGunHeat() <= robot.getGunCoolingRate() && robot.getGunHeat() > 0 && movie.size() > 30 && !TC )
  	    aim();
  	  else
  	    robot.setTurnGunRightRadians( Utils.normalRelativeAngle( e.getBearingRadians() + robot.getHeadingRadians()-robot. getGunHeadingRadians() ) );
  	 
  	  //bulletPower = Math.min(Math.min(e.getEnergy() / 4, robot.getEnergy() / 7), distance < 150 ? 3 : 1.91 );
  	  
  	  if ( TC )
  	    bulletPower = 3;
  	  else {
  	    bulletPower = Math.min(Math.min(e.getEnergy() / 4, robot.getEnergy() / 7), distance < 150 ? 3 : 1.91 );
  	  }  
	  }  
	  
	  eOldHeading = newFrame.heading;
	  eOldVel = eVel;
	}
  
  public void onBulletHit(BulletHitEvent e) {
  
  }


  private class Frame extends Object {
    //private final int NUM_VECTORS = 8;
    //public int sampleDepths[] = { 1, 2, 4, 8, 16, 32, 64 ,128 };
    // {1, 2, 3, 4, 5, 6, 7, 10, 15, 20, 30, 40}; AXE'S
    public int sampleDepths[] = { 1, 2, 3, 4, 5, 6, 7, 10, 15, 20, 30, 40 }; // sum = 143
    //public int sampleDepths[] = { 1, 2, 4, 6, 10, 20, 30, 40 };
    //public int sampleDepths[] = { 1, 2, 3, 5, 10, 20, 30, 40 };
    
    // pm signature
    public double[] position;  
    public double[][] vectors;
    public double distanceToMe;
    public double distanceToWall;
    public double heading;
    public double timeSinceVelChange;
    public double timeSinceDeccel;
    public double timeSinceTurn;
    public double relativeBearingToMe;
    public double oldVelocity;
    
    // for playback
    public double velocity;
    public double headingDelta;
    
    public int sampNum;
    
    public Frame( int n ) {
      position = new double[2]; // 0 = x, 1 = y
      vectors = new double[3][ sampleDepths.length ]; // 0 = x, 1 = y, 2 = length squared
      sampNum = n;
    }
    
    public double rate( Frame f ) {
      /*
      double fX, fY;
      double cX, cY;
      */
      double lenDiff = 0;
      //double depth = 1;
      
      for ( int i = 0; i < sampleDepths.length; ++i ) {
        
        // abs differense of len^2  
        //lenDiff += Math.abs( ( vectors[0][i] * vectors[0][i] + vectors[1][i] * vectors[1][i] ) - ( f.vectors[0][i] * f.vectors[0][i] + f.vectors[1][i] * f.vectors[1][i] ) );
        //lenDiff += ( Math.pow(vectors[0][i] - f.vectors[0][i],2) + Math.pow(vectors[1][i] - f.vectors[1][i],2) ) / sampleDepths[i];
        lenDiff += ( Math.abs(vectors[0][i] - f.vectors[0][i]) + Math.abs(vectors[1][i] - f.vectors[1][i]) ) / sampleDepths[i];
        
        //lenDiff += (Math.abs( vectors[2][i] ) -  Math.abs(f.vectors[2][i] )) / sampleDepths[i];
        //depth *= 2;
      }
      
      double rate = 0;
      double penalty = 0;
      
      rate += lenDiff / sampleDepths.length; // (256*256);//(143*143) ; /// sampleDepths.length;// / (128*128);// / 100;/// 200;
      /*
      penalty += rate * ( Math.abs( timeSinceDeccel - f.timeSinceDeccel ) / 200d );
      penalty += rate * ( Math.abs( distanceToMe - f.distanceToMe ) / 20000d );
      penalty += rate * ( Math.abs( distanceToWall - f.distanceToWall ) / 20000d );
      penalty += rate * ( Math.abs( velocity - f.velocity ) / 200d );
      penalty += rate * ( Math.abs( oldVelocity - f.oldVelocity ) / 200d ); // me=2763 > 2167
      */
      //penalty += rate * ( Math.abs( timeSinceDeccel - f.timeSinceDeccel ) / 200d );
      penalty += rate * Math.abs( timeSinceVelChange - f.timeSinceVelChange ) / 200d;
      penalty += rate * ( Math.abs( distanceToMe - f.distanceToMe ) / ( 800d * 8d ) );
      penalty += rate * ( Math.abs( distanceToWall - f.distanceToWall ) / 300d );
      penalty += rate * ( Math.abs( velocity - f.velocity ) / 8d );
      penalty += rate * ( Math.abs( oldVelocity - f.oldVelocity ) / 8d ); // me=3440 > 2221
      /*
      rate += Math.abs( distanceToMe - f.distanceToMe ) / (800 * 8);
      rate += Math.abs( distanceToWall - f.distanceToWall ) / 300;
      
      rate += Math.abs( velocity - f.velocity ) / 8;
      rate += Math.abs( oldVelocity - f.oldVelocity ) / 8;
      
      //rate += Math.abs( timeSinceVelChange - f.timeSinceVelChange );
      rate += Math.abs( timeSinceDeccel - f.timeSinceDeccel ) ; //* 100; 
      //rate += Math.abs( timeSinceTurn - f.timeSinceTurn );
      */
      rate += penalty;
      
      //double age = sampNum - f.sampNum;
      //double agef = 1d + age > 300 ? Math.pow( (age-300.0d) / 2000.0d, 2 ) : 0;
      //rate *= agef;
      
      // axe's way
      //rate /= 1D + (( age < 100 ) ? 3D * ( 1D - Math.pow( (double)age/(100d), 0.5 ) ): 0);
      
      return rate;
    }
  }
  
  private class Rating /*implements Comparable*/ {
    public double rating;
    public int frameNum;   
  
    public Rating( double r, int f ) {
      rating = r;
      frameNum = f;
    }
    
    public Rating() {
      rating = 9999999;
    }
    /*
    public int compareTo( Object o ) {
      
      return rating - (Rating(o)).rating; // returns rating diff
    }
    */
  }
  
}