package ntw;

public class GuessFactor
{
    private String name;
    private int[] guessFactors;

    /**
     *  The resolution of the guess factors.  21 gives from -1 to 1 in
     *  increments of 0.1.
     */
    public static final int GUESS_FACTORS = 20;

    public static final double FACTOR_INCREMENT = 2.0 / (double)GUESS_FACTORS;

    private GuessFactor()
    {
    }

    /**
     *  Constructs a GuessFactor container with the name of a target robot.
     */
    public GuessFactor( String name )
    {
        this.name = name;
        guessFactors = new int[GUESS_FACTORS + 1];

        for ( int i = 0; i < GUESS_FACTORS + 1; i++ )
        {
            guessFactors[i] = 0;
        }
    }

    private double indexToFactor( int index )
    {
        double idx = (double)index;
        return idx * FACTOR_INCREMENT - 1.0;
    }

    private int factorToIndex( double factor )
    {
        return (int)Math.round( ( factor + 1.0 ) / FACTOR_INCREMENT );
    }

    public double getBestGuess()
    {
        double bestGuess = 0.0;
        double largestHits = 0;
        for ( int i = 0; i < GUESS_FACTORS + 1; i++ )
        {
            if ( guessFactors[i] > largestHits )
            {
                bestGuess = indexToFactor( i );
                largestHits = guessFactors[i];
            }
        }
        return bestGuess;
    }

    public void hitFactor( double factor )
    {
        int idx = factorToIndex( factor );
        guessFactors[idx] += 1;
        //System.out.println( idx + " " + guessFactors[idx] );
    }

    public String getName()
    {
        return name;
    }
}
