package fromHell.scanning;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Scanning {
    private static AdvancedRobot _robot;
    protected static final double NARROW_RADARLOCK_MULTIPLIER = 2;

    public Scanning(AdvancedRobot robot) {
	_robot = robot;
    }

    public void run() {
	_robot.turnRadarRightRadians(Double.POSITIVE_INFINITY);
	do {
	    if (_robot.getRadarTurnRemaining() == 0 && _robot.getOthers() > 0) {
		if (_robot.getTime() > 9) {
		    _robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
	    }
	    _robot.scan();
	} while (true);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
	double radarTurn = _robot.getHeadingRadians() + scannedRobotEvent.getBearingRadians() - _robot.getRadarHeadingRadians();
	_robot.setTurnRadarRightRadians(Utils.normalRelativeAngle(NARROW_RADARLOCK_MULTIPLIER * radarTurn));
    }
}
