package djc;
import robocode.*;

/**
 * AimedGun - a gun that aims at an enemy before firing.
 */
public class AimedGun extends Gun
{
    /* ********************************************************************************** */
    /*                                   CONSTANTS                                        */
    /* ********************************************************************************** */
    public static final double FIRE_ANGLE_THRESHHOLD = Math.toRadians(3.0);

    /* ********************************************************************************** */
    /*                                MEMBER VARIABLES                                    */
    /* ********************************************************************************** */

    public AimedGun(StrategyBot _s, GunManager _gm) 
    {
	super(_s, _gm);
	name = GunManager.AIMED;
    }
    
    /** Resets the Gun */
    public void reset() {}

    /** Scanned a robot */
    public void onScannedRobot(ScannedRobotEvent e){}
    
    /** Turn gun and fire at the enemy */
    public void setGunRotation()
    {
	// No need to re-target if only 1 bot left...
	Target tmpTarget = self.currentTarget;
	int remaining = self.getOthers();
	if(self.currentTarget == null || remaining > 1) {
	    if(self.currentTarget != null)
		self.currentTarget.deselectTarget();
	    self.currentTarget = findBestTarget();
	    if(self.currentTarget != null)
		self.currentTarget.selectTarget(self.getTime());
	} else if (remaining == 1 && self.currentTarget != null) {
	    if(self.currentTarget.isAlive == false) {
		self.currentTarget.deselectTarget();
		self.currentTarget = findBestTarget();
		if(self.currentTarget != null)
		    self.currentTarget.selectTarget(self.getTime());
	    }
	}

	if(self.currentTarget == null || remaining == 0) {
	    return;
	}

	double targetDist = self.myPos.distanceFrom(self.currentTarget.position);
	double gunPowerLevel = self.currentGun.computeFirePower(targetDist, self.currentTarget);
	if(self.getEnergy() < gunPowerLevel) gunPowerLevel = self.getEnergy() - .1;
	try {
	    double aimGunBearing = self.currentTarget.aimHere(self.myPos, gunPowerLevel, targetDist,
							      self.getTime(), self.getBattleFieldWidth(),
							      self.getBattleFieldHeight());
	    double gunTurnAngle = MathHelper.normalizeBearing(aimGunBearing - 
							      self.getGunHeadingRadians());
	    self.setTurnGunRightRadians(gunTurnAngle);
	    //self.out.println("gpl=" + gunPowerLevel + "ggtr=" + self.getGunTurnRemaining() +
	    //	     "ggh=" + self.getGunHeat());
	    if(gunPowerLevel < .098) return;
	    if(self.getGunTurnRemaining() <= FIRE_ANGLE_THRESHHOLD && self.getGunHeat() == 0) {
		if(self.currentTarget.shouldFire(gunPowerLevel)) {
		    self.fire(gunPowerLevel, GunManager.AIMED + "." + self.currentTarget.targetMode);
		    self.currentTarget.firedAtTarget(gunPowerLevel, targetDist, self.getTime(), self.myPos);
		}
	    }
	} catch (Exception targetingException) {
	    //self.out.println("AimHere failed!!! " + targetingException.toString());
	    //targetingException.printStackTrace(self.out);
	    // aimHere failed, so move gun to track the target
	    double aimGunBearing = self.myPos.headingTo(self.currentTarget.position);
	    double gunTurnAngle = MathHelper.normalizeBearing(aimGunBearing - self.getGunHeadingRadians());
	    self.setTurnGunRightRadians(gunTurnAngle);
	}
    }

    /**
     * findBestTarget
     *
     *  @return Target that is best to attack
     *
     *  Derived TacticalStrategy classes are expected 
     *  to implement this function.
     */
    public Target findBestTarget()
    {
	Target t = null;
	t = findOneShotKillTarget(); // Point slut
	if(t == null)
	    return findNearestTarget();
	else
	    return t;
    }

    /**
     * Computes the FirePower to use when shooting a target.
     *
     * @author Dan Cieslak
     */
    public double computeFirePower(double targetDist, Target t)
    {
	if(t.energy < .1) return .1;            // Enemy Disabled
	if(self.getOthers() == 1) {
	    if(self.getEnergy() > 12) {
		if(t.getHitRate() > 1.0 / 7.0) {
		    return MathHelper.getPowerToKill(t.energy);  // Shoot to kill
		} else {
		    return 1.0;
		}
	    }
	    else
		return .5;
	} else { // melee - conserve energy
	    if(targetDist < 300) return 3.0;
	    else if (targetDist < 500) return 2.0;
	    else if (targetDist < 800) return 1.0;
	    else return .1;
	}
    }


}
