package SHAM;

/**
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar Period 3, JAVA
 * Programming Due: 06/05/09 Robocode, JAVA, Second Semester Final Project
 * 
 * Basic, root helper class, sets up positioning for enemy robots.
 */
import robocode.*;


public class AdvancedEnemyBot extends EnemyBot
{
    private double x, y;


    public AdvancedEnemyBot()
    {
        reset();
    }


    public double getX()
    {

        return x;
    }


    public double getY()
    {
        return y;
    }


    public double getBearingRadians()
    {
        return Math.toRadians( getBearing() );
    }


    public double getHeadingRadians()
    {
        return Math.toRadians( getHeading() );
    }


    public void update( ScannedRobotEvent e, Robot robot )
    {
        super.update( e );
        double absBearingDeg = ( robot.getHeading() + e.getBearing() );
        if ( absBearingDeg < 0 )
        {
            absBearingDeg += 360;
        }
        // yes, you use the _sine_ to get the X value because 0 deg is North
        x = robot.getX() + Math.sin( Math.toRadians( absBearingDeg ) )
            * e.getDistance();
        // yes, you use the _cosine_ to get the Y value because 0 deg is North
        y = robot.getY() + Math.cos( Math.toRadians( absBearingDeg ) )
            * e.getDistance();

    }


    public double getFutureX( long when )
    {
        return x + Math.sin( Math.toRadians( getHeading() ) ) * getVelocity()
            * when;
    }


    public double getFutureY( long when )
    {
        return y + Math.cos( Math.toRadians( getHeading() ) ) * getVelocity()
            * when;
    }


    public void reset()
    {
        super.reset();
        x = 0.0;
        y = 0.0;
    }

}