package matt;

import robocode.*;
import java.awt.geom.Point2D;

public class Wave {
    public boolean active;
    public double radius;
    public double GF;
    public double distanceTo;
    
    public Bullet bullet;
    public Point2D.Double origin;

    public Wave(){
        this.active = false;
    }
    public Wave(Point2D.Double origin, double radius, double distanceTo, double GF, Bullet bullet){
        this.origin = origin;
        this.radius = radius;
        this.GF = GF;
        this.bullet = bullet;
        this.distanceTo = distanceTo;
        this.active = true;
    }
    
    public void update(Bullet bullet){
        this.radius = Point2D.distance(this.origin.x, this.origin.y, bullet.getX(), bullet.getY());
        this.active = true;
    }
    
    public void kill(){
        this.active = false;
    }
    
    public Point2D.Double getOrigin(){
        return this.origin;
    }
    
    public Bullet getBullet(){
        return this.bullet;
    }
    
    public double getGF(){
        return this.GF;
    }
    
    public double getRadius(){
        return this.radius;
    }
    
    public double getDistanceTo(){
        return this.distanceTo;
    }
    
    public boolean getStatus(){
        return this.active;
    }
}
