/*
 * Created on 16/10/2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package axeBots.gunner;

import java.text.DecimalFormat;

import axeBots.AxeBot;
import axeBots.Okami;
import axeBots.okami.*;
import axeBots.util.*;

import java.awt.geom.*;

import axeBots.data.*;
/**
 * @author Marcos
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class AxeGunner
    implements Comparable, AxeVBListener { // implements Runnable{

    private AxeTarget target= null;
    private AxeBot me= null;
    private Point2D.Double result= null;
    private double firePower= 0;
    private int id;
    private AimStatHolder vBRatings= null;
	private BitRater bTRatings= new BitRater();
    private BotData botData= null;
    

    public final static int LAST_BIT= 31;
    public final static int GAP= 8;

    public final static double PRECISION= 0.5;
    public final static double POWER_LIMIT= 8;

    private double targetDist= 0;
    private double targetAngle= 0;
    private int jumpAmt= 1;
    private String vbDbgInfo= "";

    /**
     * 
     */
    public AxeGunner(AxeTarget target, AxeBot me, int id) {
        super();
        this.target= target;
        this.me= me;
        this.id= id;
        vBRatings= new AimStatHolder(id);
        botData= StaticDataCenter.get(target.getName());

        //		thread = new Thread(this);
        //		thread.setDaemon(true);
        //		//t.setName(this.toString());
        //		thread.setPriority(Thread.MAX_PRIORITY);
        //		thread.start();
        //		me.out.println(this+" started! "+me.getTime() );
    }

    public Point2D.Double aim(double firepwr) {
        if (ready()) {

            this.targetAngle= target.getAngle();
            this.targetDist= target.getDistance();
            this.firePower= firepwr;
            //me.out.println(this +" aiming:" + firepwr + " at " + me.getTime());
            long deltams= System.currentTimeMillis();
            this.result= guess();
            deltams= System.currentTimeMillis() - deltams;
//            me.out.println(
//                this
//                    + " aiming:"
//                    + firepwr
//                    + " at "
//                    + me.getTime()
//                    + " delta ms:"
//                    + deltams
//                    + " interpolated size:"
//                    + getBotData().getInterpolated().size());
            //RoboMath.normalAbsoluteAngle(Math.toDegrees(guess()));
        } else {
            me.out.println("not ready..");
            this.result= null;
        }
        return result;
    }

    //    public synchronized void die(){
    //    	this.die = true;
    //		this.notify();
    //		
    //    }

    protected abstract Point2D.Double guess();

    /**
     * @return
     */
    public Okami getMe() {
        return (Okami)me;
    }

    /**
     * @return
     */
    public Point2D.Double getResult() {
        return result;
    }

    /**
     * @return
     */
    public AxeTarget getTarget() {
        return target;
    }
    /* (non-Javadoc)
     * @see robocode.Condition#test()
     */

    /**
     * @return
     */
    public double getFirePower() {
        return firePower;
    }

    /**
     * @return
     */
    public int getId() {
        return id;
    }

    public void startVB() {

        if (result != null) {
            AxeVB vb=
                new AxeVB(
                    me,
                    target,
                    this,
                    RoboMath.getBulletVelocity(firePower),
                    this.getId(),
                    result,
                    this.targetAngle,
                    this.targetDist,
                    me.getOthers(),
                    vbDbgInfo);
        }
    }

    /**
     * @return
     */
    public long getRating() {
        return vBRatings.get(
            me.getOthers(),
            target.getAngle(),
            target.getDistance());
    }

    /**
     * @param l
     */

    public long getNowRatings() {
        return vBRatings.get(
            me.getOthers(),
            target.getAngle(),
            target.getDistance());
    }

    public int compareTo(Object obj) {
        int cont= 0;
        AxeGunner him= (AxeGunner)obj;
        int myHits= 0;
        int hisHits= 0;

        long myRate= this.getNowRatings();
        long hisRate= him.getNowRatings();

        while ((myHits == hisHits) && (cont < LAST_BIT)) {
            myHits= this.getRatings().getHits(myRate, cont, cont + GAP);
            hisHits= him.getRatings().getHits(hisRate, cont, cont + GAP);
            cont += GAP;
        }

        return hisHits - myHits;
    }

    public String toString() {
        return "AxeGunner "
            + Stratego.getStratName(this.id)
            + " against "
            + this.target.getName();
        //+ " results: \r\n"
        //+ this.ratings;
    }

    /* (non-Javadoc)
     * @see axeBots.musashi.gunner.AxeVBListener#updateVB(boolean)
     */
    public void updateVB(AxeVB source) {
        if (source.getHit() == null) {
            return;
        }
        boolean hit= source.getHit().booleanValue();
        double opps= source.getOpps();
        double angle= source.getTargetAngle();
        double dist= source.getTargetDistance();
        if (hit) {
            vBRatings.hit(opps, angle, dist);
        } else {
            vBRatings.miss(opps, angle, dist);
        }

    }
    
	public void updateBT(BulletTracker bt) {
		bTRatings.set( bt.hitTarget());
		}

    public boolean ready() {
        return true;
    }

    public double setFirePower(double dist) {

        if (AxeBot.TC) {
            return 3.0;
        }
        
        

        double life= AxeBot.getIt().getEnergy();
        double damage= target.getLastEnergy();
        double pwr= 0.1;
        
//		if(life < 8){
//			return pwr;
//		}

        //getMe().out.println("setFirePower. life:" + life);
        //finalizer!
        if ((life > damage * 3) && (RoboMath.getBulletDamage(3) >= damage)) {
            pwr= RoboMath.bulletDamageToEnergy(damage);
            pwr= (pwr<0.1)?0.1:pwr;
        } else {

            //if (life > POWER_LIMIT) {
            pwr= (Math.pow((life>30)?300:200, 1.5) * 3) / Math.pow(dist, 1.5);
            //pwr=3;
            //}
            //long r= this.getNowRatings();
            //getMe().out.println("setFirePower. getNowRatings:" + r);
            int rate= bTRatings.count(0, 8);//this.getRatings().getHits(r, 0, 4);
            //getMe().out.println("setFirePower. rate:" + rate);


            double slice= 3.0 / 8;
            pwr += rate * slice;
            
            //pwr += 1;
            if (life <= POWER_LIMIT) {
                pwr= 0.1;
            }
//            else if (life <= 20) {
//			pwr=(pwr>1)?1:pwr;
//		}



            double max;

            if (damage <= 4) {
                max= damage / 4;
            } else {
                max= (damage + 2) / 6;
            }

            if (max > 3) {
                max= 3;
            } else if (max < 0.1) {
                max= 0.1;
            }

            if (pwr > max) {
                pwr= max;
            } else if (pwr < 0.1) {
                pwr= 0.1;
            }
        }
        
        
        //getMe().out.println("setFirePower. pwr:" + pwr);
        return pwr;
    }

    /**
     * @return
     */
    public AimStatHolder getRatings() {
        return vBRatings;
    }

    /**
     * @return
     */
    public int getJumpAmt() {
        return jumpAmt;
    }

    /**
     * @param i
     */
    public void setJumpAmt(int i) {
        jumpAmt= i;
    }

    /* (non-Javadoc)
     * @see axeBots.musashi.gunner.AxeVBListener#setImpactAngle(axeBots.musashi.gunner.AxeVB)
     */
    public void setImpactAngle(AxeVB source) {}

    /**
     * @return
     */
    public String getVbDbgInfo() {
        return vbDbgInfo;
    }

    /**
     * @param string
     */
    public void setVbDbgInfo(String string) {
        vbDbgInfo= string;
    }

    /**
     * @return
     */
    public BotData getBotData() {
        return botData;
    }

}
