package axeBots.pilot.waves;

import java.awt.Color;
import java.awt.geom.*;
import java.util.ArrayList;

import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.robocodeGL.EllipseGL;
import robocode.robocodeGL.system.GLRenderer;

import axeBots.AxeBot;
import axeBots.Okami;
import axeBots.data.SegmentedGFs;
import axeBots.okami.AxeTarget;
import axeBots.okami.AxeVector;
import axeBots.util.RoboMath;

// This Class is originally based on PEZ's code published on the page:
// http://robowiki.dyndns.org/perl/robowiki?EnemyWave
// All credits to PEZ. Thanks, PEZ! 

// This code is released under the RoboWiki Public Code Licence (RWPCL), datailed on:
// http://robowiki.dyndns.org/?RWPCL
//
// $Id: EnemyWave.java,v 1.1 2003/10/15 21:13:17 peter Exp $

public class EnemyWave extends Condition {

    private boolean hit;
    private double bulletPower;
    private double bulletVel;
    private double fireTime;
    private Point2D.Double center;
    private Point2D.Double myOriginalPos;
    private AxeTarget him;
    private EllipseGL ellipse;
    private GLRenderer renderer;
    private boolean passMiddle=false;
    private boolean remove= false;
    private boolean dangerZone= false;
    private double distToMe= 0;
    private int dir= -1; //normal, re= 1;

    private static ArrayList radar= new ArrayList();

    private static final int TIME_FASE= 2;
    private static ArrayList lastGFs=new ArrayList();

    private Color hiliteCl= new Color(0, 255, 255);
    private Color normalCl= new Color(0, 64, 64);
    private Color hitCl= new Color(255, 0, 0);
    private Color bulHitBullCl= new Color(255, 255, 255);
    private boolean hitBull;

    public EnemyWave(double bulletPower, double fireTime, AxeTarget him) {
        fireTime -= TIME_FASE;
        this.him= him;
        this.fireTime= fireTime;
        this.bulletPower= bulletPower;
        this.bulletVel= RoboMath.getBulletVelocity(this.bulletPower);
        this.center= him.getPos((int)this.fireTime);
        this.myOriginalPos= AxeBot.getIt().getPos((int)this.fireTime);
        //System.out.println(""+him.);
        this.dir= AxeBot.getIt().getDirection((int)fireTime);

        AxeBot.getIt().addCustomEvent(this);
        radar.add(this);
        if (AxeBot.GL) {

            renderer= GLRenderer.getInstance();
            ellipse= new EllipseGL();
            this.draw();
            ellipse.setLineWidth(1.0);
            ellipse.setColor(normalCl);
            //ellipse.addLabel(new LabelGL("This is an ellipse"));
            renderer.addRenderElement(ellipse);
        }
        distToMe= center.distance(myOriginalPos);

    }

    public boolean isActive() {
        return (!remove);
    }

    private boolean powerIsEqual(double power) {
        return (int)Math.round(power * 1000)
            == (int)Math.round(bulletPower * 1000);
    }
    //
    //    public double shortestDistance() {
    //        return Math.abs(gunLocation.distance(currentTargetLocation) - distance());
    //    }
    //
    //    public void updateMoveFactor() {
    //        double visitedFactor = Math.abs(Bot.visitIndexToFactor(visitedIndex, factorVisits.length));
    //        int mostVisitedIndex = Bot.mostVisitedIndex(factorVisits);
    //        double mostVisitedFactor = Math.abs(Bot.visitIndexToFactor(mostVisitedIndex, factorVisits.length));
    //        if (visitedFactor >= 0.9) {
    //            moveFactor[0] *= (float)(1.01);
    //        }
    //        else if (Math.random() < 0.05) {
    //            moveFactor[0] *= (float)(0.99);
    //        }
    //    }

    /* (non-Javadoc)
     * @see robocode.Condition#test()
     */
    public boolean test() {
        //		if (triggerTest(0)) {
        //			System.out.println("==> wave:"+this+" GF:"+this.getGF() );
        //				}
        Point2D.Double myPos = AxeBot.getIt().pos();
        distToMe= center.distance(myPos);
        if (remove) {
            if (AxeBot.GL) {

                ellipse.remove();
            }
            AxeBot.getIt().removeCustomEvent(this);
            if (!radar.remove(this)) {
                System.out.println("************* NAO REMOVEU DO RADAR!!!");
            } else {
                //      System.out.println("* removing:" + this);
            }
            return false;
        }

        this.draw();

        //        if (triggerTest(- (0 * this.bulletVel))) {
        //            AxeBot.getIt().getMyPilot().synchro();
        //        }

        if (triggerTest(-20)) {
            dangerZone= true;
            if (AxeBot.GL) {

                ellipse.setColor(hiliteCl);
            }
        }
        
        if (triggerTest(0)|| hit) {
        	passMiddle=true;
            lastGFs.add(new Integer ( this.getGF(myPos)));
        }

        if (triggerTest(20) || hit || hitBull ) {
            remove= true;

        }
        
        
        return false;
    }

    public static void clear() {
        radar= new ArrayList();
    }

    public static EnemyWave getWave(double pw, Point2D.Double pt) {

        EnemyWave ret= null;

        for (int i= 0; i < radar.size(); i++) {
            EnemyWave ew= (EnemyWave)radar.get(i);
            double dist= pt.distance(ew.center);
            if ((ew.isActive())
                && (ew.powerIsEqual(pw))
                && ((ret == null)
                    || (bulletDist(pt, ew)) < bulletDist(pt, ret))) {
                ret= ew;

            }
        }
        //System.out.println("getWave:" + ret);
        return ret;
    }

    public static EnemyWave getLastWave() {
        return (radar.isEmpty())
            ? null
            : (EnemyWave)radar.get(radar.size() - 1);
    }
    public static EnemyWave getCurrentWave(Point2D.Double pt) {

        EnemyWave ret= null;

        for (int i= 0; i < radar.size(); i++) {
            EnemyWave ew= (EnemyWave)radar.get(i);
            if (ew.isActive() && !ew.isPassMiddle() 
                && ((ret == null)
                    || (bulletDist(pt, ew) < bulletDist(pt, ret)))) {
                ret= ew;

            }
        }
        //System.out.println("getCurrentWave:" + ret);
        return ret;
    }
    
    public static int countCurrentWaves() {

        int ret= 0;

        for (int i= 0; i < radar.size(); i++) {
            EnemyWave ew= (EnemyWave)radar.get(i);
            if (ew.isActive() && !ew.isPassMiddle() 
                ) {
                ret++;

            }
        }
        //System.out.println("getCurrentWave:" + ret);
        return ret;
    }

    public static EnemyWave getNextWave(Point2D.Double pt) {

        EnemyWave ret= null;

        for (int i= 0; i < radar.size(); i++) {
            EnemyWave ew= (EnemyWave)radar.get(i);
            if ((ew.isActive())
                && (!ew.isDangerZone())
                && ((ret == null)
                    || (bulletDist(pt, ew) < bulletDist(pt, ret)))) {
                ret= ew;

            }
        }
        //System.out.println("getCurrentWave:" + ret);
        return ret;
    }

    private static double bulletDist(Point2D.Double pt, EnemyWave ew) {
        return Math.abs(pt.distance(ew.center) - ew.bulletTravel());
    }

    //    public static Point2D.Double getCloserWaveCenter() {
    //        return (radar.size() == 0)
    //            ? null
    //            : ((EnemyWave)radar.get(radar.size() - 1)).hisPos;
    //    }
    public int getArcLen(Point2D.Double pos) {
        double ray= pos.distance(center);
        double arcAng= SegmentedGFs.getGFArcWdt(this.bulletPower, ray);

        return (int) (ray * 2 * Math.PI * (arcAng / 360D));
    }

//    //todo o array, comecando dos gfs negativos
//    public Point2D.Double[] getWaveLinearGFs(int arcLen, Point2D.Double pos) {
//        Point2D.Double[] gfPts= new Point2D.Double[SegmentedGFs.GF_QT];
//        double slcLen= arcLen / (double)SegmentedGFs.GF_QT;
//        double start= -arcLen / 2D;
//        double end= start + slcLen;
//
//        for (int i= 0; i < SegmentedGFs.GF_QT; i++) {
//            gfPts[i]= new Point2D.Double(start, end);
//            start += slcLen;
//            end += slcLen;
//        }
//        return gfPts;
//    }

    public int getWaveLinearGF(double arcLen, double linearPos) {
        double slcLen= arcLen / (double)SegmentedGFs.GF_QT;
        return (int) ((linearPos + (arcLen / 2D)) / slcLen);

    }

    public double getWaveLinearPos(Point2D.Double pos) {
        return (int) ((this.getArcLen(pos) / 2D) * this.getRealGF(pos));
    }

    public double gfToLinear(double gf, double arcLen) {
        double slcLen= arcLen / (double)SegmentedGFs.GF_QT;
        return (int) ((gf * slcLen) - (arcLen / 2D) + (slcLen / 2D));
    }

    public int getDangerStartTime(long time, Point2D.Double pos) {
        double dim= 20;
        double d= pos.distance(center) - bulletTravel() - dim;
        return (int) (time + (int)Math.ceil(d / bulletVel));
    }

    public int getDangerEndTime(long time, Point2D.Double pos) {
        double dim= 20;
        double d= pos.distance(center) - bulletTravel() + dim;
        return (int) (time + (int)Math.ceil(d / bulletVel));
    }

    public void hit() {
        hit= true;
        if (AxeBot.GL) {
            
            ellipse.setColor(hitCl);
        }
    }

    public void hitBull() {
        hitBull= true;
        if (AxeBot.GL) {
            ellipse.setColor(bulHitBullCl);
        }
    }

    public double getDistance() {
        return center.distance(myOriginalPos);
    }

    //    public int getGF() {
    //        Okami me= AxeBot.getIt();
    //
    //        double dist= getDistance();
    //        AxeVector originalAngle= new AxeVector(hisPos, myPos);
    //
    //        AxeVector nowAngle= new AxeVector(hisPos, me.pos());
    //        double angularDelta= originalAngle.getDiffTheta(nowAngle);
    //
    //        angularDelta=
    //            AxeBot.getIt().adjustDirection(
    //                (int)this.fireTime,
    //                him,
    //                angularDelta);
    //
    //        int gf= SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
    //        //- (int) (SegmentedGFs.GF_QT / 2D);
    //
    //        return gf;
    //    }

    public int getGF(HitByBulletEvent e) {
        Okami me= AxeBot.getIt();

        double dist= getDistance();
        AxeVector originalAngle= new AxeVector(center, myOriginalPos);

        AxeVector nowAngle=
            new AxeVector(
                center,
                new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        double angularDelta= nowAngle.getDiffTheta(originalAngle);

        angularDelta=
            ((this.dir * angularDelta) < 0)
                ? -Math.abs(angularDelta)
                : Math.abs(angularDelta);

        int gf= SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
        //- (int) (SegmentedGFs.GF_QT / 2D);

        return gf;
    }

    public int getGF(Point2D.Double pos) {

        double dist= getDistance();
        AxeVector originalAngle= new AxeVector(center, myOriginalPos);

        AxeVector nowAngle=
            new AxeVector(center, new Point2D.Double(pos.getX(), pos.getY()));
        double angularDelta= nowAngle.getDiffTheta(originalAngle);

        angularDelta=
            ((this.dir * angularDelta) < 0)
                ? -Math.abs(angularDelta)
                : Math.abs(angularDelta);

        int gf= SegmentedGFs.getGF(this.bulletPower, angularDelta, dist);
        //- (int) (SegmentedGFs.GF_QT / 2D);

        return gf;
    }
    // gf entre -1 e 1
    public double getRealGF(Point2D.Double pos) {

        double dist= getDistance();
        AxeVector originalAngle= new AxeVector(center, myOriginalPos);

        AxeVector nowAngle=
            new AxeVector(center, new Point2D.Double(pos.getX(), pos.getY()));
        double angularDelta= nowAngle.getDiffTheta(originalAngle);

        angularDelta=//*=this.dir;
            ((this.dir * angularDelta) < 0)
                ? -Math.abs(angularDelta)
                : Math.abs(angularDelta);
        //				AxeBot.getIt().adjustDirection(
        //					(int)this.fireTime,
        //					him,
        //					angularDelta);

        double gf= SegmentedGFs.getRealGF(this.bulletPower, angularDelta, dist);
        //- (int) (SegmentedGFs.GF_QT / 2D);

        return gf;
    }

    private boolean triggerTest(double distanceDelta) {
        return bulletTravel()
            >= center.distance(AxeBot.getIt().pos()) + distanceDelta;
    }

    private double bulletTravel() {
        return bulletVel * (double) (AxeBot.getIt().getTime() - fireTime);
    }

    private void draw() {
        //ellipse= new EllipseGL();
        if (AxeBot.GL) {

            ellipse.setFrame(
                center.x - (this.bulletTravel()),
                center.y + (this.bulletTravel()),
                this.bulletTravel() * 2,
                this.bulletTravel() * 2);
        }
        //ellipse.setLineWidth(1.0);
        //ellipse.setColor(Color.cyan);

    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "EnemyWave from "
            + him.getName()
            + " bulletPw:"
            + this.bulletPower
            + " fired at:"
            + this.fireTime;
    }

    /**
     * @return
     */
    public Point2D.Double getCenter() {
        return center;
    }

    /**
     * @return
     */
    public double getVel() {
        return bulletVel;
    }

    /**
     * @return
     * 
     * @author Marcos Machado
     * @since 18/02/2004
     * @modified
     */
    public Point2D.Double getMyOriginalPos() {
        return myOriginalPos;
    }

    /**
     * @return
     */
    public int getDir() {
        return dir;
    }

    /**
     * @return
     */
    public int getMyGF() {
        return getGF(AxeBot.getIt().pos());
    }

    /**
     * @return
     */
    public double getBulletPower() {
        return bulletPower;
    }

    /**
     * @return
     */
    public AxeTarget getOwner() {
        return him;
    }

    /**
     * @return
     */
    public boolean isDangerZone() {
        return dangerZone;
    }

    /**
     * @return
     */
    public static ArrayList getLastGFs() {
        // TODO Auto-generated method stub
        return EnemyWave.lastGFs ;
    }

	/**
	 * @return Returns the fireTime.
	 */
	public double getFireTime() {
		return fireTime;
	}
	/**
	 * @return Returns the passMiddle.
	 */
	public boolean isPassMiddle() {
		return passMiddle;
	}
}
