package fw;


import java.awt.Color;
import robocode.*;


/**
 * Number 1
 */
public class Number1 extends AdvancedRobot {
	boolean movingForward=true;
	boolean movingBackward;
	double lastdist;
	String lastname;
	int shotnum=0;
	double bearing;
	double turn=0;
	TurnCompleteCondition a;
	boolean a2=false;
	double lastenergy=0;

	public void run() {
		// Set colors
		setBodyColor(new Color(0, 0, 0));
		setGunColor(new Color(255, 0, 0));
		setRadarColor(new Color(255, 0, 0));
		setBulletColor(new Color(255, 0, 0));
		setScanColor(new Color(155, 0, 0));

		// Loop forever
		while (true) {
			if(movingForward) {
				setAhead(40000);
			}
			else if(movingBackward){
				setBack(40000);
			}
			else {
				setAhead(0);
			}
			setTurnRadarRight(Double.POSITIVE_INFINITY);
	
			if(lastdist<300) {
				if(bearing>0) {
					if(bearing<45) {
						setTurnLeft(10);
						System.out.println("Turn: left 10");
					}
					else if(bearing>90) {
						setTurnRight(130);
						System.out.println("Turn: right 130");
					}
					else if(bearing<90) {
						setTurnRight(90);
						System.out.println("Turn: right 90");
					}
				}
				else {
					if(bearing>(-45)) {
						setTurnRight(10);
						System.out.println("Turn: right 10");
					}
					else if(bearing<(-90)) {
						setTurnLeft(130);
						System.out.println("Turn: left 130");
					}
					else if(bearing>(-90)) {
						setTurnLeft(90);
						System.out.println("Turn: left 90");
					}
				}
			}
			else {
				setTurnRight(bearing+10);
			}
			waitFor(new TurnCompleteCondition(this));
		}
	}

	/**
	 * onHitWall:  Handle collision with wall.
	 */	
	public void onHitWall(HitWallEvent e) {
		avoid();
	}

	/**
	 * reverseDirection:  Switch from ahead to back & vice versa
	 */	
	public void reverseDirection() {
		if (movingForward) {
			setBack(40000);
			movingForward = false;
			movingBackward = true;
		} 
		else if(movingBackward) {
			setAhead(40000);
			movingForward = true;
			movingBackward = false;
		}
		
	}
	public void stop() {
		movingForward=false;
		movingBackward=false;
		setAhead(0);
	}
	public void start() {
		if(!(movingForward || movingBackward)) {
			movingForward=true;
			movingBackward=false;
			setAhead(40000);
			execute();
		}
	}
		

	/**
	 * onScannedRobot:  Fire!
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double heading=robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians());
				
		if(a2 && a.test()) {
			reverseDirection();
			a2=false;
		}
			
		
		if(lastname!=e.getName()) {
			System.out.println("New Target: "+e.getName());
		}
		System.out.println("Saw: "+e.getName());
		System.out.println("Dist: "+e.getDistance());
		System.out.println("Shotcount: "+String.valueOf(shotnum));
		System.out.println("Bearing: "+String.valueOf(e.getBearing()));
		System.out.println("MyHeading: "+String.valueOf(getHeading()));
		System.out.println("Energy: "+String.valueOf(e.getEnergy()));
		/*
		if(hasFired(e.getEnergy())) {
			System.out.println("Enemy has fired!!!");
			switchm();
		}
		*/

		bearing=e.getBearing();
		lastdist=e.getDistance();
		lastname=e.getName();
		
		
		absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));

		if(heading<=0.3) {
			if(lastdist<=100 || ((lastdist<=200) && (heading<=0.01))) {
				fire(3);
			}
			else if(lastdist<=150) {
				fire(2);
			}
			else if((lastdist<=400) || (heading<0.05)) {
				fire(1);
			}
			else {
				System.out.println("Too far away...");
			}
		}

		if(lastdist>=300) {
			setTurnRight(bearing+20);
		}
				
		setTurnRadarLeft(getRadarTurnRemaining());
//		start();
	}

	public void onRobotDeath(RobotDeathEvent e) {
		System.out.println(e.getName()+" got killed");
		if(e.getName()==lastname) {
			System.out.println("Searching for new target...");
		}
	}

	public void onBulletHit(BulletHitEvent e) {
		shotnum=0;
   	}

	public void avoid() {
		System.out.println("Avoiding!");
		start();
		if(movingForward) {
			setTurnRight(100);
			reverseDirection();			
			execute();
			a2=true;
			a = new TurnCompleteCondition(this);
		}
	}
	/**
	 * onHitRobot:  Back up!
	 */	
	public void onHitRobot(HitRobotEvent e) {
			avoid();
	}
	public void onWin(WinEvent e) {
		System.out.println("I won!");
		stop();
	}

	public boolean hasFired(double energy) {
		if((lastenergy-3)==energy) {
			lastenergy=energy;
			return true;
		}
		else if((lastenergy-2)==energy) {
			lastenergy=energy;
			return true;
		}
		else if((lastenergy-1)==energy) {
			lastenergy=energy;
			return true;
		}
		else {
			return false;
		}
	}

	public void fire(int power) {
		if(getGunHeat()==0.0) {
			if(!(shotnum>10)) {
				System.out.println("Fire: "+String.valueOf(power));
				shotnum=shotnum+power;
				super.fire(power);
			}
			else {
				System.out.println("Shotcount: "+String.valueOf(shotnum));
				System.out.println("Fire: 0.1");
				super.fire(0.1);
			}
		}
		else {
			System.out.println("Cannot Fire! Gun to hot!");
		}
	}	
	public void switchm() {
		if(!a2) {
			if(movingForward || movingBackward) {
				stop();
			}
			else {
				start();
			}
		}
	}
			
		
}