/*
 * Created on Jun 14, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package jekl.utils;

import java.awt.geom.*;

/**
 * @author Jim
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Enemy {
	private Point2D.Double location;
	private Point2D.Double lastLocation;
	private int direction = 1;
	private double energy = 100D;
	private double absBearing, velocity, distance, heading, lastVelocity, closingVelocity;
	private double lastAbsBearing, lastEnergy, latVel, lastLatVel, lastClosingVelocity;
	private double lastShot = 3;
	private int accellIndex;
	private String name;
	private double bearing;

	public Enemy(String _name) {
		this.name = _name;
		location = new Point2D.Double();
		lastLocation = new Point2D.Double();
	}
	/**
	 * @return
	 */
	public double getAbsBearing() {
		return absBearing;
	}

	/**
	 * @return
	 */
	public int getDirection() {
		return direction;
	}

	/**
	 * @return
	 */
	public double getDistance() {
		return distance;
	}

	/**
	 * @return
	 */
	public double getEnergy() {
		return energy;
	}

	/**
	 * @return
	 */
	public double getEnergyDrop() {
		return lastEnergy - energy;
	}

	/**
	 * @return
	 */
	public double getHeading() {
		return heading;
	}

	/**
	 * @return
	 */
	public Point2D.Double getLastLocation() {
		return lastLocation;
	}

	/**
	 * @return
	 */
	public double getLastShot() {
		return lastShot;
	}

	/**
	 * @return
	 */
	public Point2D.Double getLocation() {
		return location;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return
	 */
	public double getVelocity() {
		return velocity;
	}

	/**
	 * @param d
	 */
	public void setAbsBearing(double d) {
		lastAbsBearing = absBearing;
		absBearing = d;
	}

	/**
	 * @param i
	 */
	public void setDirection(int i) {
		direction = i;
	}

	/**
	 * @param d
	 */
	public void setDistance(double d) {
		distance = d;
	}

	/**
	 * @param d
	 */
	public void setEnergy(double d) {
		lastEnergy = energy;
		energy = d;
	}

	/**
	 * @param d
	 */
	public void setHeading(double d) {
		heading = d;
	}

	/**
	 * @param d
	 */
	public void setLastShot(double d) {
		lastShot = d;
	}

	/**
	 * @param double1
	 */
	public void setLocation(Point2D.Double double1) {
		lastLocation.setLocation(location);
		location = double1;
	}

	public void setLocation(double x, double y) {
		setLocation(new Point2D.Double(x, y));
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @param d
	 */
	public void setVelocity(double d) {
		lastVelocity = velocity;
		velocity = d;
		accellIndex = (Math.round(velocity) == Math.round(lastVelocity) ? 0 : (Math.abs(velocity) - Math.abs(lastVelocity) > 0 ? 2 : 1));
	}

	/**
	 * @return
	 */
	public double getLastAbsBearing() {
		return lastAbsBearing;
	}

	/**
	 * @return
	 */
	public double getLatVel() {
		return latVel;
	}

	/**
	 * @param d
	 */
	public void setLatVel(double d) {
		lastLatVel = latVel;
		latVel = d;
	}

	/**
	 * @return
	 */
	public double getLastLatVel() {
		return lastLatVel;
	}

	/**
	 * @return
	 */
	public int getAccellIndex() {
		return accellIndex;
	}

	/**
	 * @return
	 */
	public double getLastVelocity() {
		return lastVelocity;
	}

	/**
	 * @param d
	 */
	public void setClosingVelocity(double d) {
		lastClosingVelocity = closingVelocity;
		closingVelocity = d;
	}

	/**
	 * @return
	 */
	public double getClosingVelocity() {
		return closingVelocity;
	}

	/**
	 * @return Returns the bearing.
	 */
	public double getBearing() {
		return bearing;
	}
	/**
	 * @param bearing The bearing to set.
	 */
	public void setBearing(double bearing) {
		this.bearing = bearing;
	}
	/**
	 * @return Returns the lastClosingVelocity.
	 */
	public double getLastClosingVelocity() {
		return lastClosingVelocity;
	}
}
