package ar.horizon.components;

import static java.lang.Math.*;
import static ar.horizon.util.Util.*;

import java.awt.geom.*;

import ar.horizon.*;
import robocode.*;

/**
 * Raiko 0.41 by Jamougha.
 * 
 * Credit for ideas or parts of this code go to PEZ, Kawigi and probably others
 * who I've forgotten to mention.
 * 
 * Released under the RWPCL.
 * 
 * @author Modified to be plugged into MC2K7 bots by Simonton. See <a
 *         href="http://old.robowiki.net/?MovementChallenge2K7">the old wiki
 *         entry on MC2K7</a>.
 */
public class RaikoGun extends Component {
	private static double bearingDirection = 1, lastLatVel, lastVelocity,
			enemyEnergy, enemyDistance, lastVChangeTime, enemyLatVel,
			enemyVelocity;

	private static Point2D.Double enemyLocation;
	private static final int GF_ZERO = 15;
	private static final int GF_ONE = 30;
	private static String enemyName;
	private static int[][][][][][] guessFactors =
			new int[3][5][3][3][8][GF_ONE + 1];

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		if (enemyName == null) {
			enemyName = e.getName();
		}

		Point2D.Double robotLocation =
				new Point2D.Double(robot.getX(), robot.getY());
		double theta;
		double enemyAbsoluteBearing =
				robot.getHeadingRadians() + e.getBearingRadians();
		enemyDistance = e.getDistance();
		enemyLocation =
				project(robotLocation, enemyAbsoluteBearing, enemyDistance);
		enemyEnergy = e.getEnergy();

		Rectangle2D.Double BF = new Rectangle2D.Double(18, 18, 764, 564);

		MicroWave w = new MicroWave();

		lastLatVel = enemyLatVel;
		lastVelocity = enemyVelocity;
		enemyLatVel =
				(enemyVelocity = e.getVelocity())
						* sin(e.getHeadingRadians() - enemyAbsoluteBearing);

		int distanceIndex = (int) enemyDistance / 140;

		double bulletPower = distanceIndex == 0 ? 3 : 2;
		theta = min(robot.getEnergy() / 4, min(enemyEnergy / 4, bulletPower));
		if (theta == bulletPower) {
			robot.addCustomEvent(w);
		}
		bulletPower = theta;
		w.bulletVelocity = 20D - 3D * bulletPower;

		int accelIndex = (int) round(abs(enemyLatVel) - abs(lastLatVel));

		if (enemyLatVel != 0) {
			bearingDirection = enemyLatVel > 0 ? 1 : -1;
		}
		w.bearingDirection =
				bearingDirection * asin(8D / w.bulletVelocity) / GF_ZERO;

		double moveTime = w.bulletVelocity * lastVChangeTime++ / enemyDistance;
		int bestGF =
				moveTime < .1 ? 1 : moveTime < .3 ? 2 : moveTime < 1 ? 3 : 4;

		int vIndex = (int) abs(enemyLatVel / 3);

		if (abs(abs(enemyVelocity) - abs(lastVelocity)) > .6) {
			lastVChangeTime = 0;
			bestGF = 0;

			accelIndex = (int) round(abs(enemyVelocity) - abs(lastVelocity));
			vIndex = (int) abs(enemyVelocity / 3);
		}

		if (accelIndex != 0) {
			accelIndex = accelIndex > 0 ? 1 : 2;
		}

		w.firePosition = robotLocation;
		w.enemyAbsBearing = enemyAbsoluteBearing;
		// now using PEZ' near-wall segment
		w.waveGuessFactors =
				guessFactors[accelIndex][bestGF][vIndex][BF.contains(project(
						robotLocation, enemyAbsoluteBearing
								+ w.bearingDirection * GF_ZERO, enemyDistance)) ? 0
						: BF.contains(project(robotLocation,
								enemyAbsoluteBearing + .5 * w.bearingDirection
										* GF_ZERO, enemyDistance)) ? 1 : 2][distanceIndex];

		bestGF = GF_ZERO;

		for (int gf = GF_ONE; gf >= 0 && enemyEnergy > 0; gf--) {
			if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF]) {
				bestGF = gf;
			}
		}

		robot.setTurnGunRightRadians(normalRelativeAngle(enemyAbsoluteBearing
				- robot.getGunHeadingRadians() + w.bearingDirection
				* (bestGF - GF_ZERO)));

		if (robot.getEnergy() > 1 || distanceIndex == 0) {
			robot.setFire(bulletPower);
		}
	}

	private class MicroWave extends Condition {
		Point2D.Double firePosition;
		int[] waveGuessFactors;
		double enemyAbsBearing, distance, bearingDirection, bulletVelocity;

		@Override
		public boolean test() {
			if ((RaikoGun.enemyLocation).distance(firePosition) <= (distance +=
					bulletVelocity)
					+ bulletVelocity) {
				try {
					waveGuessFactors[(int) round((normalRelativeAngle(absoluteBearing(
							firePosition, RaikoGun.enemyLocation)
							- enemyAbsBearing))
							/ bearingDirection + GF_ZERO)]++;
				} catch (ArrayIndexOutOfBoundsException e) {
				}
				robot.removeCustomEvent(this);
			}
			return false;
		}
	}
}
