/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.LUTable_2x2D;

class GF_TimeAcceleration
extends LUTable_2x2D {
    protected double[] getDoubleIndices(double velocity, double angle) {
        double[] indices = new double[2];
        indices[this.VELOC] = (velocity + 8.0) / 0.5;
        indices[this.ANGLE] = 57.29577951308232 * angle / 5.0;
        return indices;
    }

    GF_TimeAcceleration() {
        this.t_max = 30;
        this.t_step = 3;
        this.initXTable0();
        this.initXTable1();
        this.initYTable0();
        this.initYTable1();
    }

    /*
     * Opcode count of 35386 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initXTable0() {
        float[][][] newlut_x = new float[][][]{new float[][]{{36.0f, 35.999084f, 35.96698f, 35.87135f, 35.69686f, 35.434036f, 35.084194f, 34.649994f, 34.13474f, 33.542355f, 32.877346f, 32.144775f, 31.35022f, 30.499723f, 29.59976f, 28.657179f, 27.679155f, 26.67313f, 25.646759f, 24.607859f, 23.56433f, 22.524117f, 21.495136f, 20.48522f, 19.502052f, 18.553118f, 17.645638f, 16.786516f, 15.982295f, 15.239093f, 14.562567f, 13.957866f, 13.429591f, 12.981763f, 12.617791f, 12.340445f, 12.151834f}, {34.5f, 34.499672f, 34.473515f, 34.39368f, 34.244907f, 34.019733f, 33.718307f, 33.342915f, 32.89642f, 32.382217f, 31.804222f, 31.166832f, 30.474895f, 29.733683f, 28.948833f, 28.12632f, 27.272404f, 26.393581f, 25.496542f, 24.588114f, 23.67521f, 22.764778f, 21.863747f, 20.978973f, 20.117191f, 19.284962f, 18.488615f, 17.734213f, 17.027498f, 16.373848f, 15.778236f, 15.245198f, 14.77879f, 14.38256f, 14.059525f, 13.812142f, 13.642296f}, {33.0f, 32.999954f, 32.979023f, 32.912895f, 32.786762f, 32.5959f, 32.339615f, 32.019863f, 31.639074f, 31.200148f, 30.706423f, 30.16166f, 29.570002f, 28.935951f, 28.264336f, 27.560266f, 26.829102f, 26.076406f, 25.307907f, 24.529455f, 23.746973f, 22.966415f, 22.193726f, 21.434782f, 20.695362f, 19.98109f, 19.297407f, 18.649513f, 18.04234f, 17.480507f, 16.96829f, 16.50959f, 16.107897f, 15.766268f, 15.487302f, 15.273123f, 15.12536f}, {31.5f, 31.5f, 31.48372f, 31.429308f, 31.323324f, 31.163414f, 30.948986f, 30.681671f, 30.363506f, 29.99691f, 29.584673f, 29.129934f, 28.636154f, 28.10709f, 27.546768f, 26.959452f, 26.349615f, 25.721893f, 25.08107f, 24.432016f, 23.779676f, 23.129013f, 22.484978f, 21.852472f, 21.236313f, 20.641186f, 20.07162f, 19.531954f, 19.02629f, 18.55848f, 18.132084f, 17.750345f, 17.41617f, 17.132103f, 16.900305f, 16.722538f, 16.600159f}, {30.0f, 30.0f, 29.987669f, 29.94324f, 29.85548f, 29.723158f, 29.54728f, 29.329182f, 29.070526f, 28.773281f, 28.439709f, 28.072348f, 27.673992f, 27.247677f, 26.796644f, 26.324327f, 25.83432f, 25.330353f, 24.816261f, 24.29596f, 23.773403f, 23.252571f, 22.737427f, 22.231894f, 21.739815f, 21.264938f, 20.810879f, 20.381088f, 19.97884f, 19.607195f, 19.268984f, 18.966776f, 18.702875f, 18.47929f, 18.29772f, 18.159546f, 18.065823f}, {28.5f, 28.5f, 28.490932f, 28.455008f, 28.383781f, 28.276018f, 28.135368f, 27.963245f, 27.76096f, 27.53005f, 27.272274f, 26.989595f, 26.684164f, 26.358305f, 26.014498f, 25.655357f, 25.28362f, 24.902113f, 24.51374f, 24.121458f, 23.728252f, 23.337114f, 22.951021f, 22.57291f, 22.205662f, 21.852068f, 21.514822f, 21.19649f, 20.899494f, 20.626095f, 20.378372f, 20.158215f, 19.967293f, 19.807064f, 19.678745f, 19.583315f, 19.521498f}, {27.0f, 27.0f, 26.993576f, 26.964931f, 26.908548f, 26.822884f, 26.714128f, 26.584715f, 26.43563f, 26.268011f, 26.08313f, 25.882395f, 25.667334f, 25.439583f, 25.200876f, 24.95303f, 24.697931f, 24.43752f, 24.173779f, 23.908716f, 23.644346f, 23.382685f, 23.125721f, 22.875412f, 22.63366f, 22.402308f, 22.183115f, 21.977749f, 21.787773f, 21.614635f, 21.45965f, 21.324f, 21.208715f, 21.114674f, 21.042591f, 20.993017f, 20.966326f}, {25.5f, 25.5f, 25.495665f, 25.473335f, 25.430096f, 25.364643f, 25.284435f, 25.194452f, 25.095379f, 24.98797f, 24.873041f, 24.751467f, 24.624176f, 24.492132f, 24.356344f, 24.217844f, 24.077686f, 23.936935f, 23.796667f, 23.657946f, 23.521826f, 23.389347f, 23.261515f, 23.139303f, 23.023642f, 22.915411f, 22.815435f, 22.724474f, 22.64322f, 22.572292f, 22.51223f, 22.463491f, 22.426447f, 22.401377f, 22.388474f, 22.387835f, 22.399466f}, {25.0f, 25.0f, 24.99726f, 24.980536f, 24.94874f, 24.902113f, 24.844093f, 24.77961f, 24.709194f, 24.63338f, 24.552746f, 24.467905f, 24.379503f, 24.288214f, 24.19473f, 24.099766f, 24.00404f, 23.908285f, 23.813227f, 23.719591f, 23.62809f, 23.53942f, 23.454252f, 23.37324f, 23.296997f, 23.226105f, 23.161102f, 23.102484f, 23.050697f, 23.006134f, 22.969135f, 22.939981f, 22.918896f, 22.906038f, 22.901506f, 22.905334f, 22.917494f}, {23.5f, 23.5f, 23.498426f, 23.486736f, 23.464804f, 23.435408f, 23.402779f, 23.37452f, 23.35102f, 23.332462f, 23.318983f, 23.310688f, 23.307638f, 23.309858f, 23.31733f, 23.329998f, 23.347763f, 23.370495f, 23.398016f, 23.430119f, 23.466558f, 23.50706f, 23.55131f, 23.598976f, 23.649694f, 23.70308f, 23.758722f, 23.816204f, 23.875082f, 23.934912f, 23.995237f, 24.0556f, 24.115538f, 24.174597f, 24.232327f, 24.288288f, 24.342056f}, {22.0f, 22.0f, 21.99923f, 21.992004f, 21.978601f, 21.964752f, 21.955452f, 21.961237f, 21.982538f, 22.019194f, 22.070925f, 22.137337f, 22.217924f, 22.312075f, 22.419071f, 22.5381f, 22.668255f, 22.808544f, 22.957901f, 23.11519f, 23.279213f, 23.44872f, 23.622425f, 23.799002f, 23.977108f, 24.15539f, 24.332489f, 24.507057f, 24.677765f, 24.843317f, 25.002449f, 25.153954f, 25.296675f, 25.429527f, 25.5515f, 25.661665f, 25.759184f}, {20.5f, 20.5f, 20.499733f, 20.496405f, 20.490456f, 20.490463f, 20.50249f, 20.540127f, 20.604097f, 20.693913f, 20.80889f, 20.948153f, 21.110643f, 21.295122f, 21.500187f, 21.724276f, 21.965687f, 22.222578f, 22.492996f, 22.774885f, 23.066097f, 23.364418f, 23.667574f, 23.97326f, 24.279152f, 24.582918f, 24.882248f, 25.174862f, 25.458536f, 25.73111f, 25.990509f, 26.234758f, 26.462f, 26.670504f, 26.858685f, 27.025108f, 27.16851f}, {21.0f, 21.0f, 21.0f, 21.0f, 21.000343f, 21.006428f, 21.021618f, 21.05717f, 21.11512f, 21.195026f, 21.296278f, 21.418108f, 21.55959f, 21.71964f, 21.897049f, 22.090462f, 22.298407f, 22.519302f, 22.751467f, 22.993134f, 23.242462f, 23.497557f, 23.756475f, 24.017246f, 24.277887f, 24.536413f, 24.790857f, 25.039282f, 25.279797f, 25.51057f, 25.729849f, 25.935963f, 26.127342f, 26.30253f, 26.460196f, 26.599138f, 26.7183f}, {19.5f, 19.5f, 19.500097f, 19.502853f, 19.50991f, 19.529314f, 19.566338f, 19.634958f, 19.7368f, 19.871086f, 20.036795f, 20.232668f, 20.457212f, 20.70872f, 20.985273f, 21.284773f, 21.604937f, 21.943329f, 22.297373f, 22.664375f, 23.041542f, 23.426003f, 23.814833f, 24.205072f, 24.593752f, 24.977911f, 25.354628f, 25.721035f, 26.074345f, 26.411867f, 26.731035f, 27.029417f, 27.304743f, 27.554918f, 27.778038f, 27.972404f, 28.13654f}, {18.0f, 18.0f, 18.000086f, 18.005032f, 18.018234f, 18.050402f, 18.109127f, 18.210857f, 18.356647f, 18.545387f, 18.77564f, 19.045652f, 19.35337f, 19.696453f, 20.072289f, 20.478016f, 20.910547f, 21.36659f, 21.842676f, 22.33518f, 22.840355f, 23.354357f, 23.87327f, 24.393148f, 24.910034f, 25.419994f, 25.91915f, 26.403696f, 26.86995f, 27.314362f, 27.73355f, 28.124323f, 28.483707f, 28.808968f, 29.09763f, 29.347496f, 29.556664f}, {16.5f, 16.5f, 16.500032f, 16.506596f, 16.525381f, 16.569754f, 16.650108f, 16.78499f, 16.974785f, 17.218046f, 17.51292f, 17.857166f, 18.248163f, 18.682934f, 19.15817f, 19.670258f, 20.215296f, 20.789139f, 21.387417f, 22.00558f, 22.638922f, 23.282621f, 23.93178f, 24.581459f, 25.226711f, 25.862629f, 26.484371f, 27.087206f, 27.666544f, 28.217978f, 28.73731f, 29.220589f, 29.664135f, 30.064575f, 30.41886f, 30.724293f, 30.97855f}, {18.0f, 18.0f, 18.0f, 18.003805f, 18.015364f, 18.044138f, 18.09772f, 18.192766f, 18.33201f, 18.51439f, 18.738522f, 19.002693f, 19.3049f, 19.642838f, 20.013935f, 20.415369f, 20.844086f, 21.29682f, 21.770126f, 22.260405f, 22.763922f, 23.276846f, 23.795275f, 24.31526f, 24.832848f, 25.344095f, 25.845116f, 26.332092f, 26.80132f, 27.249228f, 27.672407f, 28.067638f, 28.431911f, 28.762455f, 29.056753f, 29.312567f, 29.527948f}, {16.5f, 16.5f, 16.500032f, 16.506596f, 16.525381f, 16.569754f, 16.650108f, 16.78499f, 16.974785f, 17.218046f, 17.51292f, 17.857166f, 18.248163f, 18.682934f, 19.15817f, 19.670258f, 20.215296f, 20.789139f, 21.387417f, 22.00558f, 22.638922f, 23.282621f, 23.93178f, 24.581459f, 25.226711f, 25.862629f, 26.484371f, 27.087206f, 27.666544f, 28.217978f, 28.73731f, 29.220589f, 29.664135f, 30.064575f, 30.41886f, 30.724293f, 30.97855f}, {15.0f, 15.0f, 15.000172f, 15.010063f, 15.037412f, 15.099074f, 15.210367f, 15.388401f, 15.631975f, 15.939235f, 16.307842f, 16.734991f, 17.21743f, 17.75149f, 18.333103f, 18.957848f, 19.620964f, 20.317408f, 21.041878f, 21.78886f, 22.552673f, 23.3275f, 24.107445f, 24.886572f, 25.65895f, 26.418705f, 27.160051f, 27.877348f, 28.565136f, 29.21818f, 29.83151f, 30.40046f, 30.920698f, 31.388266f, 31.799603f, 32.15158f, 32.44152f}, {13.5f, 13.5f, 13.500482f, 13.514272f, 13.551775f, 13.632685f, 13.779383f, 14.003866f, 14.304426f, 14.678775f, 15.124064f, 15.636905f, 16.213394f, 16.849142f, 17.539314f, 18.278656f, 19.06154f, 19.88201f, 20.73382f, 21.610487f, 22.505339f, 23.411568f, 24.322273f, 25.230526f, 26.129416f, 27.012098f, 27.871857f, 28.702148f, 29.496653f, 30.249325f, 30.954437f, 31.60662f, 32.200912f, 32.73279f, 33.198208f, 33.59362f, 33.916023f}, {12.0f, 12.0f, 12.001028f, 12.019284f, 12.06879f, 12.172427f, 12.358037f, 12.632249f, 12.992977f, 13.437474f, 13.962359f, 14.563637f, 15.236732f, 15.976519f, 16.77737f, 17.63319f, 18.537466f, 19.483313f, 20.463537f, 21.470675f, 22.49706f, 23.534887f, 24.576252f, 25.613232f, 26.637934f, 27.642561f, 28.619463f, 29.56121f, 30.460634f, 31.310886f, 32.1055f, 32.838425f, 33.504086f, 34.097412f, 34.61389f, 35.049595f, 35.401203f}, {10.5f, 10.5f, 10.501874f, 10.525167f, 10.588776f, 10.719346f, 10.947208f, 11.274409f, 11.698461f, 12.216133f, 12.823488f, 13.515904f, 14.28811f, 15.134229f, 16.047821f, 17.021935f, 18.049156f, 19.121666f, 20.231304f, 21.369623f, 22.527962f, 23.697504f, 24.869349f, 26.034575f, 27.184319f, 28.309826f, 29.402534f, 30.454126f, 31.456598f, 32.40232f, 33.284096f, 34.095215f, 34.829502f, 35.48137f, 36.04586f, 36.51867f, 36.89621f}, {9.0f, 9.0f, 9.003084f, 9.032028f, 9.112051f, 9.274332f, 9.547771f, 9.9312f, 10.421701f, 11.015542f, 11.708201f, 12.49441f, 13.368181f, 14.322868f, 15.351204f, 16.445362f, 17.597015f, 18.7974f, 20.037378f, 21.307516f, 22.598145f, 23.89944f, 25.201504f, 26.494423f, 27.768358f, 29.013613f, 30.22071f, 31.380466f, 32.48405f, 33.523067f, 34.48961f, 35.376316f, 36.17644f, 36.8839f, 37.4933f, 38.000015f, 38.400177f}, {7.5f, 7.5f, 7.504722f, 7.540628f, 7.638948f, 7.838273f, 8.160597f, 8.603469f, 9.163518f, 9.836481f, 10.617238f, 11.499845f, 12.477586f, 13.543019f, 14.688037f, 15.903924f, 17.181427f, 18.510824f, 19.881996f, 21.28451f, 22.70769f, 24.140703f, 25.572647f, 26.992622f, 28.389822f, 29.753613f, 31.073614f, 32.339783f, 33.54248f, 34.67255f, 35.7214f, 36.68104f, 37.54417f, 38.304222f, 38.95541f, 39.49278f, 39.912235f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.41205f, 6.786551f, 7.292056f, 7.924718f, 8.679724f, 9.551326f, 10.53289f, 11.616948f, 12.795249f, 14.058824f, 15.398057f, 16.802757f, 18.262232f, 19.765375f, 21.300745f, 22.856659f, 24.421274f, 25.982683f, 27.529003f, 29.048466f, 30.529505f, 31.960852f, 33.33161f, 34.63135f, 35.85018f, 36.978825f, 38.00869f, 38.931942f, 39.74155f, 40.43136f, 40.996113f, 41.43152f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 4.996546f, 5.426493f, 5.997795f, 6.706104f, 7.546031f, 8.511182f, 9.594213f, 10.78688f, 12.080107f, 13.464051f, 14.928181f, 16.461351f, 18.051897f, 19.687712f, 21.356344f, 23.045097f, 24.741117f, 26.431498f, 28.10337f, 29.744017f, 31.340948f, 32.882008f, 34.355473f, 35.750126f, 37.05535f, 38.26122f, 39.35855f, 40.338993f, 41.195087f, 41.920315f, 42.50916f, 42.957138f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.592638f, 4.081278f, 4.721512f, 5.508467f, 6.436153f, 7.497511f, 8.684464f, 9.987975f, 11.398128f, 12.904188f, 14.494694f, 16.157541f, 17.880074f, 19.649183f, 21.451405f, 23.273024f, 25.100174f, 26.918953f, 28.715515f, 30.47619f, 32.187576f, 33.83665f, 35.410862f, 36.89823f, 38.287437f, 39.567905f, 40.729893f, 41.764557f, 42.66402f, 43.42144f, 44.03105f, 44.488213f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.314911f, 2.694157f, 3.235554f, 3.934982f, 4.787116f, 5.785471f, 6.922451f, 8.1894f, 9.576678f, 11.073726f, 12.66915f, 14.35081f, 16.105906f, 17.92108f, 19.782518f, 21.676056f, 23.587278f, 25.501642f, 27.404577f, 29.281603f, 31.118431f, 32.901085f, 34.615993f, 36.25011f, 37.790997f, 39.22692f, 40.546963f, 41.741074f, 42.800163f, 43.71617f, 44.48213f, 45.0922f, 45.54175f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.37877f, 1.805539f, 2.401221f, 3.161283f, 4.07994f, 5.150201f, 6.36392f, 7.711861f, 9.183764f, 10.768427f, 12.453791f, 14.227029f, 16.074644f, 17.982576f, 19.936304f, 21.920961f, 23.92144f, 25.922516f, 27.90896f, 29.865656f, 31.77771f, 33.63057f, 35.410137f, 37.102867f, 38.695873f, 40.177036f, 41.535084f, 42.759678f, 43.8415f, 44.772316f, 45.54504f, 46.153793f, 46.593945f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.936725f, 1.398285f, 2.031857f, 2.832621f, 3.794481f, 4.910117f, 6.171039f, 7.56765f, 9.089321f, 10.724472f, 12.460657f, 14.284663f, 16.18261f, 18.14005f, 20.14209f, 22.173489f, 24.21879f, 26.262426f, 28.288843f, 30.28262f, 32.22858f, 34.11192f, 35.9183f, 37.633972f, 39.245884f, 40.741768f, 42.110233f, 43.34087f, 44.42431f, 45.35231f, 46.117805f, 46.71497f, 47.13926f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.49938f, 0.996222f, 1.668136f, 2.51001f, 3.515435f, 4.676761f, 5.985148f, 7.430638f, 9.002233f, 10.687968f, 12.475017f, 14.349776f, 16.297981f, 18.304802f, 20.354967f, 22.432875f, 24.522707f, 26.608562f, 28.674564f, 30.70499f, 32.684387f, 34.59769f, 36.43034f, 38.168385f, 39.798603f, 41.308582f, 42.686832f, 43.922863f, 45.00727f, 45.9318f, 46.689415f, 47.274353f, 47.682156f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.530478f, 1.040598f, 1.725453f, 2.579832f, 3.59723f, 4.769906f, 6.088934f, 7.544277f, 9.124858f, 10.818646f, 12.612754f, 14.493526f, 16.446648f, 18.457254f, 20.510044f, 22.589396f, 24.679482f, 26.764397f, 28.828274f, 30.855404f, 32.83036f, 34.738113f, 36.564144f, 38.29455f, 39.91617f, 41.416656f, 42.78459f, 44.009563f, 45.082253f, 45.99449f, 46.739338f, 47.311127f, 47.705505f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.562581f, 1.085958f, 1.783725f, 2.650571f, 3.679899f, 4.863875f, 6.193489f, 7.65862f, 9.24812f, 10.94989f, 12.75098f, 14.637682f, 16.595636f, 18.609941f, 20.66527f, 22.745977f, 24.836227f, 26.920115f, 28.981777f, 31.005526f, 32.97596f, 34.87808f, 36.697407f, 38.420105f, 40.033054f, 41.523983f, 42.881546f, 44.095406f, 45.15633f, 46.05624f, 46.78829f, 47.346905f, 47.727837f}}, new float[][]{{57.0f, 56.999084f, 56.96698f, 56.87135f, 56.69686f, 56.434036f, 56.084194f, 55.649994f, 55.138542f, 54.557716f, 53.921482f, 53.24018f, 52.519f, 51.763428f, 50.97921f, 50.17232f, 49.3489f, 48.515213f, 47.6776f, 46.842445f, 46.0161f, 45.204853f, 44.41488f, 43.65219f, 42.922592f, 42.231632f, 41.584576f, 40.986343f, 40.44149f, 39.954163f, 39.528065f, 39.166447f, 38.87206f, 38.647137f, 38.493397f, 38.412006f, 38.40359f}, {54.0f, 53.999672f, 53.973515f, 53.89368f, 53.744907f, 53.519733f, 53.21924f, 52.848408f, 52.413666f, 51.926014f, 51.398975f, 50.84606f, 50.271492f, 49.679634f, 49.074993f, 48.46217f, 47.845833f, 47.230663f, 46.621353f, 46.022533f, 45.438766f, 44.87449f, 44.334f, 43.82141f, 43.340622f, 42.895294f, 42.48882f, 42.124283f, 41.804466f, 41.531803f, 41.308365f, 41.135857f, 41.015587f, 40.94847f, 40.935024f, 40.975346f, 41.06913f}, {51.0f, 50.999954f, 50.979023f, 50.912895f, 50.786762f, 50.5959f, 50.340225f, 50.027317f, 49.66323f, 49.26211f, 48.836803f, 48.404873f, 47.969856f, 47.535072f, 47.10383f, 46.6794f, 46.265026f, 45.863857f, 45.478943f, 45.113216f, 44.76946f, 44.450287f, 44.158134f, 43.895218f, 43.66354f, 43.46487f, 43.300713f, 43.172318f, 43.080666f, 43.02645f, 43.010094f, 43.031708f, 43.091133f, 43.18792f, 43.32133f, 43.490345f, 43.693684f}, {48.0f, 48.0f, 47.983723f, 47.92931f, 47.823322f, 47.663414f, 47.449043f, 47.188576f, 46.88963f, 46.568157f, 46.237476f, 45.919006f, 45.616375f, 45.331886f, 45.067703f, 44.825836f, 44.608124f, 44.41623f, 44.25161f, 44.115517f, 44.008984f, 43.93283f, 43.887627f, 43.873722f, 43.89122f, 43.939987f, 44.019657f, 44.129616f, 44.269035f, 44.436848f, 44.631775f, 44.85234f, 45.09686f, 45.363472f, 45.65015f, 45.954716f, 46.274845f}, {48.0f, 48.0f, 47.98767f, 47.943237f, 47.85548f, 47.72316f, 47.54728f, 47.33162f, 47.08284f, 46.809853f, 46.523792f, 46.242542f, 45.974663f, 45.722202f, 45.487076f, 45.271076f, 45.075844f, 44.902863f, 44.753456f, 44.628757f, 44.529716f, 44.457085f, 44.41142f, 44.393063f, 44.402157f, 44.438633f, 44.502216f, 44.59242f, 44.708553f, 44.849735f, 45.014896f, 45.202778f, 45.411945f, 45.64081f, 45.887627f, 46.15052f, 46.427494f}, {45.0f, 45.0f, 44.990932f, 44.955006f, 44.88378f, 44.77602f, 44.63537f, 44.465656f, 44.27648f, 44.077267f, 43.88195f, 43.710484f, 43.571663f, 43.46654f, 43.395924f, 43.360348f, 43.36008f, 43.395126f, 43.465218f, 43.56982f, 43.70814f, 43.879128f, 44.08147f, 44.31364f, 44.573864f, 44.860165f, 45.17036f, 45.50209f, 45.85283f, 46.219913f, 46.600544f, 46.99182f, 47.390778f, 47.794365f, 48.19952f, 48.603157f, 49.002205f}, {42.0f, 42.0f, 41.993576f, 41.96493f, 41.908546f, 41.822884f, 41.714127f, 41.58662f, 41.452744f, 41.322727f, 41.21358f, 41.147522f, 41.133614f, 41.171963f, 41.26228f, 41.40387f, 41.595665f, 41.836197f, 42.123642f, 42.45581f, 42.830173f, 43.243877f, 43.693783f, 44.17646f, 44.688236f, 45.225216f, 45.783318f, 46.358284f, 46.945747f, 47.541237f, 48.140213f, 48.738125f, 49.330418f, 49.912586f, 50.4802f, 51.02894f, 51.554623f}, {39.0f, 39.0f, 38.995663f, 38.973335f, 38.930096f, 38.864643f, 38.784435f, 38.695618f, 38.61271f, 38.54736f, 38.519764f, 38.554688f, 38.66149f, 38.83937f, 39.086964f, 39.402393f, 39.783257f, 40.226654f, 40.72921f, 41.2871f, 41.89608f, 42.551517f, 43.248417f, 43.98148f, 44.74513f, 45.533546f, 46.340736f, 47.160557f, 47.986763f, 48.81307f, 49.633186f, 50.44088f, 51.229992f, 51.994522f, 52.728653f, 53.426796f, 54.083637f}, {40.0f, 40.0f, 39.997257f, 39.980537f, 39.948742f, 39.902115f, 39.844093f, 39.77963f, 39.717583f, 39.6667f, 39.643967f, 39.66413f, 39.747128f, 39.892933f, 40.100437f, 40.36806f, 40.69377f, 41.075085f, 41.5091f, 41.99252f, 42.521656f, 43.092484f, 43.700665f, 44.341564f, 45.010307f, 45.701805f, 46.41079f, 47.131874f, 47.859562f, 48.588318f, 49.3126f, 50.02689f, 50.725754f, 51.403873f, 52.056087f, 52.677433f, 53.26318f}, {37.0f, 37.0f, 36.998425f, 36.986736f, 36.9648f, 36.935406f, 36.90278f, 36.874542f, 36.86151f, 36.874767f, 36.934044f, 37.058743f, 37.26667f, 37.556286f, 37.925385f, 38.37116f, 38.89021f, 39.478596f, 40.131832f, 40.84495f, 41.612522f, 42.42871f, 43.287296f, 44.181747f, 45.10526f, 46.050804f, 47.01118f, 47.979084f, 48.947147f, 49.908f, 50.854332f, 51.778942f, 52.674793f, 53.535065f, 54.35321f, 55.123005f, 55.83859f}, {34.0f, 34.0f, 33.99923f, 33.992004f, 33.978603f, 33.964752f, 33.955452f, 33.961266f, 33.995125f, 34.07088f, 34.21097f, 34.440598f, 34.77342f, 35.206898f, 35.737743f, 36.36191f, 37.07465f, 37.87054f, 38.743523f, 39.68695f, 40.693645f, 41.755943f, 42.86577f, 44.014664f, 45.19389f, 46.394474f, 47.607277f, 48.82307f, 50.032597f, 51.226654f, 52.396156f, 53.5322f, 54.62614f, 55.66965f, 56.654793f, 57.574066f, 58.420475f}, {31.0f, 31.0f, 30.999733f, 30.996405f, 30.990456f, 30.990463f, 31.00249f, 31.040161f, 31.11878f, 31.255434f, 31.475882f, 31.81031f, 32.267952f, 32.845325f, 33.538033f, 34.34081f, 35.247536f, 36.251316f, 37.344513f, 38.518803f, 39.76525f, 41.07437f, 42.436203f, 43.840374f, 45.276203f, 46.73276f, 48.198967f, 49.663654f, 51.115685f, 52.544f, 53.937733f, 55.286274f, 56.579365f, 57.807163f, 58.96032f, 60.030064f, 61.00825f}, {33.0f, 33.0f, 33.0f, 33.0f, 33.000343f, 33.006428f, 33.021618f, 33.05717f, 33.121544f, 33.23055f, 33.404163f, 33.66299f, 34.030167f, 34.503662f, 35.079872f, 35.75441f, 36.52215f, 37.37724f, 38.313175f, 39.322834f, 40.39853f, 41.532078f, 42.71485f, 43.937847f, 45.19176f, 46.467045f, 47.753994f, 49.04282f, 50.323704f, 51.586906f, 52.82281f, 54.02201f, 55.175377f, 56.274136f, 57.309925f, 58.274857f, 59.161594f}, {30.0f, 30.0f, 30.000097f, 30.002853f, 30.00991f, 30.029314f, 30.066338f, 30.134958f, 30.24759f, 30.42218f, 30.683237f, 31.059132f, 31.563955f, 32.193867f, 32.944073f, 33.808865f, 34.78166f, 35.85505f, 37.020874f, 38.270256f, 39.593685f, 40.981094f, 42.42192f, 43.9052f, 45.419643f, 46.953724f, 48.495766f, 50.034035f, 51.556828f, 53.052547f, 54.509815f, 55.917538f, 57.265003f, 58.541958f, 59.73868f, 60.84607f, 61.855686f}, {27.0f, 27.0f, 27.000086f, 27.005032f, 27.018234f, 27.050402f, 27.109127f, 27.210896f, 27.373428f, 27.617266f, 27.97189f, 28.470715f, 29.11817f, 29.909327f, 30.838165f, 31.897615f, 33.079613f, 34.375168f, 35.774414f, 37.2667f, 38.84068f, 40.484364f, 42.185246f, 43.93038f, 45.70649f, 47.500053f, 49.297424f, 51.08492f, 52.848934f, 54.57605f, 56.253113f, 57.867367f, 59.406525f, 60.85887f, 62.213356f, 63.459667f, 64.58832f}, {24.0f, 24.0f, 24.000032f, 24.006596f, 24.025381f, 24.069754f, 24.150108f, 24.285677f, 24.499437f, 24.81675f, 25.27283f, 25.899647f, 26.694664f, 27.651827f, 28.763851f, 30.022274f, 31.417519f, 32.938965f, 34.575035f, 36.31328f, 38.140465f, 40.042686f, 42.00547f, 44.013874f, 46.052616f, 48.10618f, 50.158936f, 52.19526f, 54.199654f, 56.156864f, 58.052f, 59.87063f, 61.59892f, 63.22371f, 64.73264f, 66.11423f, 67.357956f}, {27.0f, 27.0f, 27.0f, 27.003805f, 27.015364f, 27.044138f, 27.09772f, 27.192766f, 27.344341f, 27.574009f, 27.910133f, 28.38631f, 29.011757f, 29.781717f, 30.690329f, 31.730679f, 32.894844f, 34.173973f, 35.558327f, 37.037365f, 38.59984f, 40.233852f, 41.92697f, 43.66631f, 45.43863f, 47.230442f, 49.028114f, 50.81796f, 52.58636f, 54.319855f, 56.005253f, 57.629723f, 59.18091f, 60.647f, 62.016838f, 63.28f, 64.42687f}, {24.0f, 24.0f, 24.000032f, 24.006596f, 24.025381f, 24.069754f, 24.150108f, 24.285677f, 24.499437f, 24.81675f, 25.27283f, 25.899647f, 26.694664f, 27.651827f, 28.763851f, 30.022274f, 31.417519f, 32.938965f, 34.575035f, 36.31328f, 38.140465f, 40.042686f, 42.00547f, 44.013874f, 46.052616f, 48.10618f, 50.158936f, 52.19526f, 54.199654f, 56.156864f, 58.052f, 59.87063f, 61.59892f, 63.22371f, 64.73264f, 66.11423f, 67.357956f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.689766f, 23.47814f, 24.453142f, 25.60735f, 26.931978f, 28.416948f, 30.050955f, 31.821568f, 33.715305f, 35.71776f, 37.81369f, 39.98714f, 42.221577f, 44.499992f, 46.805042f, 49.119186f, 51.424812f, 53.704376f, 55.940525f, 58.11624f, 60.214966f, 62.220726f, 64.11826f, 65.89313f, 67.531815f, 69.02185f, 70.3519f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.166502f, 21.12716f, 22.292336f, 23.653162f, 25.199284f, 26.91893f, 28.799019f, 30.825237f, 32.982166f, 35.25339f, 37.621624f, 40.068844f, 42.576424f, 45.125282f, 47.696014f, 50.269066f, 52.824844f, 55.343903f, 57.80707f, 60.195602f, 62.491318f, 64.67674f, 66.73525f, 68.65117f, 70.40992f, 71.99812f, 73.40368f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.795599f, 17.70852f, 18.851978f, 20.217272f, 21.794006f, 23.570187f, 25.532291f, 27.665388f, 29.953245f, 32.37845f, 34.92254f, 37.566162f, 40.28919f, 43.0709f, 45.890125f, 48.725407f, 51.55517f, 54.357872f, 57.11219f, 59.79716f, 62.392345f, 64.87799f, 67.23519f, 69.446f, 71.49359f, 73.36238f, 75.03815f, 76.50813f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.729102f, 15.809373f, 17.134634f, 18.6948f, 20.477995f, 22.47065f, 24.657598f, 27.022196f, 29.546448f, 32.211143f, 34.996f, 37.879826f, 40.84067f, 43.856003f, 46.902874f, 49.958096f, 52.998417f, 56.000694f, 58.94208f, 61.800194f, 64.553276f, 67.18038f, 69.66151f, 71.97778f, 74.11157f, 76.04663f, 77.76824f, 79.2633f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.735696f, 12.722091f, 13.976973f, 15.490789f, 17.252022f, 19.247263f, 21.461332f, 23.877375f, 26.477007f, 29.24044f, 32.14665f, 35.173508f, 38.29798f, 41.496296f, 44.74411f, 48.0167f, 51.289165f, 54.5366f, 57.73428f, 60.85788f, 63.883625f, 66.78848f, 69.550354f, 72.14821f, 74.56229f, 76.77421f, 78.767136f, 80.52591f, 82.03715f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.109654f, 11.248527f, 12.667099f, 14.354577f, 16.298117f, 18.482927f, 20.89238f, 23.508139f, 26.310295f, 29.277523f, 32.38724f, 35.61578f, 38.938572f, 42.330326f, 45.76523f, 49.21714f, 52.65979f, 56.066975f, 59.412766f, 62.671696f, 65.81897f, 68.83063f, 71.683754f, 74.35663f, 76.82892f, 79.0818f, 81.09813f, 82.862564f, 84.36167f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.531666f, 9.827688f, 11.414226f, 13.279202f, 15.408425f, 17.78569f, 20.392902f, 23.210224f, 26.21621f, 29.387983f, 32.701405f, 36.13126f, 39.65144f, 43.23516f, 46.85514f, 50.483837f, 54.09363f, 57.657047f, 61.14697f, 64.53683f, 67.80084f, 70.914154f, 73.85307f, 76.59524f, 79.119774f, 81.40747f, 83.44092f, 85.204636f, 86.6852f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.33177f, 7.456824f, 8.890436f, 10.621696f, 12.637427f, 14.92229f, 17.458893f, 20.227932f, 23.208334f, 26.377415f, 29.711058f, 33.183887f, 36.76948f, 40.440544f, 44.169136f, 47.926888f, 51.685192f, 55.415455f, 59.08928f, 62.678703f, 66.15642f, 69.49595f, 72.67188f, 75.66006f, 78.43771f, 80.98372f, 83.2787f, 85.30519f, 87.04777f, 88.493164f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.161716f, 6.418893f, 7.992527f, 9.870643f, 12.038945f, 14.480933f, 17.178022f, 20.109684f, 23.253609f, 26.585867f, 30.0811f, 33.712708f, 37.453053f, 41.273663f, 45.145466f, 49.03899f, 52.92461f, 56.77275f, 60.554127f, 64.23996f, 67.80219f, 71.21372f, 74.44858f, 77.48215f, 80.291336f, 82.85477f, 85.15294f, 87.16835f, 88.885666f, 90.29182f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.465459f, 5.827713f, 7.510924f, 9.502282f, 11.78663f, 14.346583f, 17.16266f, 20.213428f, 23.475668f, 26.924553f, 30.533834f, 34.276043f, 38.122704f, 42.044533f, 46.011684f, 49.993973f, 53.961082f, 57.882828f, 61.72936f, 65.4714f, 69.080475f, 72.529106f, 75.79107f, 78.841515f, 81.65724f, 84.21682f, 86.50076f, 88.49169f, 90.17445f, 91.53625f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.791081f, 5.259561f, 7.053321f, 9.15871f, 11.559704f, 14.238031f, 17.173307f, 20.343193f, 23.723564f, 27.288694f, 31.011448f, 34.863495f, 38.81552f, 42.837444f, 46.89866f, 50.968254f, 55.015263f, 59.008877f, 62.91871f, 66.715f, 70.36886f, 73.85248f, 77.13934f, 80.20444f, 83.02444f, 85.57788f, 87.84534f, 89.80955f, 91.45556f, 92.77084f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334024f, 3.533641f, 5.071674f, 6.936418f, 9.113681f, 11.586891f, 14.337228f, 17.343758f, 20.583601f, 24.0321f, 27.663008f, 31.448694f, 35.360344f, 39.36819f, 43.44173f, 47.54996f, 51.661617f, 55.745407f, 59.77025f, 63.70551f, 67.52124f, 71.18841f, 74.6791f, 77.96674f, 81.02632f, 83.83455f, 86.370056f, 88.61354f, 90.547935f, 92.158516f, 93.43302f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.018692f, 3.286244f, 4.894095f, 6.830008f, 9.079249f, 11.624701f, 14.446991f, 17.52464f, 20.834223f, 24.350555f, 28.046875f, 31.895048f, 35.86579f, 39.928883f, 44.0534f, 48.207954f, 52.360924f, 56.480705f, 60.535942f, 64.49577f, 68.33006f, 72.00963f, 75.50647f, 78.79396f, 81.8471f, 84.64264f, 87.1593f, 89.377945f, 91.28168f, 92.856f, 94.08895f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.101724f, 3.395166f, 5.028077f, 6.988031f, 9.260111f, 11.827024f, 14.669236f, 17.765116f, 21.0911f, 24.621878f, 28.330578f, 32.188972f, 36.1677f, 40.236477f, 44.36434f, 48.519875f, 52.67145f, 56.787476f, 60.83662f, 64.78807f, 68.611755f, 72.27857f, 75.76061f, 79.03138f, 82.06598f, 84.84132f, 87.336266f, 89.531845f, 91.41134f, 92.96045f, 94.16738f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.186722f, 3.505998f, 5.1639f, 7.147811f, 9.442633f, 12.030898f, 14.89291f, 18.006887f, 21.34913f, 24.894203f, 28.615124f, 32.483574f, 36.470116f, 40.544407f, 44.675438f, 48.83177f, 52.981777f, 57.09387f, 61.136745f, 65.07965f, 68.89256f, 72.54647f, 76.013565f, 79.26746f, 82.283394f, 85.03841f, 87.511536f, 89.68396f, 91.53915f, 93.062965f, 94.243835f}}, new float[][]{{69.0f, 68.999084f, 68.96698f, 68.871346f, 68.69686f, 68.43404f, 68.08419f, 67.649994f, 67.13854f, 66.55772f, 65.921486f, 65.24249f, 64.542984f, 63.844063f, 63.173767f, 62.565884f, 62.0298f, 61.5696f, 61.188778f, 60.890232f, 60.676243f, 60.548435f, 60.50778f, 60.554585f, 60.688496f, 60.908497f, 61.21291f, 61.59942f, 62.065086f, 62.60636f, 63.219128f, 63.89872f, 64.63997f, 65.43723f, 66.28445f, 67.175156f, 68.102585f}, {64.5f, 64.49967f, 64.47352f, 64.393684f, 64.2449f, 64.01974f, 63.71924f, 63.348408f, 62.913666f, 62.426014f, 61.898975f, 61.34794f, 60.796658f, 60.26841f, 59.79434f, 59.409378f, 59.12024f, 58.929127f, 58.837486f, 58.846024f, 58.95467f, 59.162598f, 59.468227f, 59.869232f, 60.362556f, 60.94445f, 61.610485f, 62.355587f, 63.17409f, 64.05977f, 65.00587f, 66.0052f, 67.05016f, 68.13279f, 69.24485f, 70.377884f, 71.523254f}, {60.0f, 59.999954f, 59.979023f, 59.912895f, 59.786762f, 59.5959f, 59.340225f, 59.027317f, 58.66323f, 58.26211f, 57.836803f, 57.406242f, 56.99557f, 56.630787f, 56.34677f, 56.179085f, 56.131805f, 56.205296f, 56.39899f, 56.71142f, 57.1402f, 57.682076f, 58.33292f, 59.087776f, 59.940907f, 60.88581f, 61.915302f, 63.02154f, 64.19611f, 65.430084f, 66.71405f, 68.038246f, 69.39259f, 70.76678f, 72.15036f, 73.53279f, 74.90356f}, {55.5f, 55.5f, 55.483723f, 55.42931f, 55.323322f, 55.163414f, 54.949043f, 54.688576f, 54.38963f, 54.068157f, 53.737476f, 53.419872f, 53.142063f, 52.933403f, 52.833176f, 52.87695f, 53.066257f, 53.399666f, 53.874634f, 54.487545f, 55.233738f, 56.107533f, 57.10228f, 58.210403f, 59.423477f, 60.732265f, 62.12681f, 63.596493f, 65.13013f, 66.71606f, 68.34219f, 69.99616f, 71.66539f, 73.337166f, 74.99876f, 76.637535f, 78.24101f}, {57.0f, 57.0f, 56.98767f, 56.943237f, 56.85548f, 56.72316f, 56.54728f, 56.33162f, 56.08284f, 55.809853f, 55.523792f, 55.242542f, 54.982124f, 54.767853f, 54.629795f, 54.60333f, 54.70926f, 54.946785f, 55.314095f, 55.808395f, 56.425922f, 57.161976f, 58.01096f, 58.966408f, 60.021046f, 61.166855f, 62.39511f, 63.696465f, 65.06101f, 66.47837f, 67.93775f, 69.42805f, 70.93792f, 72.45588f, 73.97036f, 75.46985f, 76.94293f}, {52.5f, 52.5f, 52.490932f, 52.455006f, 52.38378f, 52.27602f, 52.13537f, 51.965656f, 51.77648f, 51.577267f, 51.38195f, 51.210484f, 51.081947f, 51.02466f, 51.073074f, 51.26775f, 51.62021f, 52.127773f, 52.786575f, 53.591606f, 54.53673f, 55.614765f, 56.8175f, 58.135784f, 59.55958f, 61.07806f, 62.67966f, 64.352196f, 66.08293f, 67.8587f, 69.665985f, 71.49104f, 73.31996f, 75.13885f, 76.93384f, 78.69128f, 80.39779f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.89709f, 48.496445f, 49.27467f, 50.225853f, 51.342747f, 52.616856f, 54.038483f, 55.59681f, 57.279972f, 59.075165f, 60.968723f, 62.946236f, 64.99265f, 67.0924f, 69.22949f, 71.38767f, 73.55052f, 75.70156f, 77.82443f, 79.90298f, 81.92137f, 83.86426f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.492977f, 45.339474f, 46.388874f, 47.63319f, 49.06295f, 50.667274f, 52.433956f, 54.34955f, 56.399467f, 58.56812f, 60.838997f, 63.194813f, 65.617645f, 68.08905f, 70.59022f, 73.10211f, 75.60562f, 78.081696f, 80.511475f, 82.87648f, 85.158714f, 87.3408f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721203f, 47.394836f, 48.25573f, 49.297333f, 50.511715f, 51.889637f, 53.420612f, 55.092987f, 56.894035f, 58.810047f, 60.826443f, 62.927876f, 65.09836f, 67.32136f, 69.57997f, 71.857f, 74.13512f, 76.39699f, 78.62539f, 80.80337f, 82.91435f, 84.94227f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.34998f, 44.291817f, 45.44453f, 46.799347f, 48.345955f, 50.072582f, 51.966095f, 54.012074f, 56.194954f, 58.49812f, 60.90404f, 63.394413f, 65.95028f, 68.552185f, 71.18033f, 73.81471f, 76.43529f, 79.0221f, 81.55548f, 84.01613f, 86.38533f, 88.64506f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 39.996475f, 41.213203f, 42.664234f, 44.33853f, 46.223347f, 48.30434f, 50.56567f, 52.99013f, 55.559265f, 58.253525f, 61.052402f, 63.9346f, 66.87818f, 69.86074f, 72.85958f, 75.851875f, 78.81486f, 81.725975f, 84.56307f, 87.30456f, 89.929565f, 92.41812f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.932377f, 37.15525f, 38.64332f, 40.38525f, 42.367786f, 44.575844f, 46.992615f, 49.59971f, 52.37728f, 55.304195f, 58.358173f, 61.515976f, 64.75356f, 68.0463f, 71.36913f, 74.69677f, 78.003876f, 81.26529f, 84.45619f, 87.55229f, 90.53003f, 93.366745f, 96.04085f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.26786f, 40.493435f, 41.958794f, 43.652782f, 45.562515f, 47.673447f, 49.969524f, 52.43326f, 55.045918f, 57.787605f, 60.637455f, 63.57378f, 66.574234f, 69.61598f, 72.67587f, 75.73062f, 78.75698f, 81.73191f, 84.632774f, 87.4375f, 90.12473f, 92.67403f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.28952f, 36.549923f, 38.08012f, 39.868473f, 41.901363f, 44.163322f, 46.637135f, 49.303974f, 52.143547f, 55.134235f, 58.253284f, 61.476955f, 64.78071f, 68.13941f, 71.52749f, 74.91917f, 78.28863f, 81.61023f, 84.85869f, 88.009285f, 91.03805f, 93.92191f, 96.63894f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.367138f, 33.921383f, 35.76543f, 37.885246f, 40.264694f, 42.88567f, 45.72822f, 48.770718f, 51.99f, 55.361572f, 58.859776f, 62.45798f, 66.12881f, 69.844315f, 73.57623f, 77.29615f, 80.97577f, 84.58707f, 88.10258f, 91.49553f, 94.74011f, 97.81163f, 100.68671f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.484184f, 30.00542f, 31.84626f, 33.992695f, 36.428387f, 39.1348f, 42.091335f, 45.275497f, 48.663048f, 52.228207f, 55.94384f, 59.78167f, 63.71249f, 67.70638f, 71.732956f, 75.76156f, 79.76153f, 83.70244f, 87.554276f, 91.28774f, 94.87441f, 98.287f, 101.49953f, 104.48754f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.159756f, 33.669456f, 35.470875f, 37.550304f, 39.89192f, 42.47789f, 45.288544f, 48.30249f, 51.496788f, 54.847126f, 58.328007f, 61.912945f, 65.574646f, 69.28525f, 73.01652f, 76.74004f, 80.4275f, 84.05081f, 87.58242f, 90.99543f, 94.26387f, 97.36288f, 100.26885f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.484184f, 30.00542f, 31.84626f, 33.992695f, 36.428387f, 39.1348f, 42.091335f, 45.275497f, 48.663048f, 52.228207f, 55.94384f, 59.78167f, 63.71249f, 67.70638f, 71.732956f, 75.76156f, 79.76153f, 83.70244f, 87.554276f, 91.28774f, 94.87441f, 98.287f, 101.49953f, 104.48754f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.169931f, 28.017937f, 30.200672f, 32.701527f, 35.501465f, 38.57918f, 41.911247f, 45.47231f, 49.235264f, 53.171467f, 57.250973f, 61.442722f, 65.71482f, 70.03475f, 74.369644f, 78.6865f, 82.95247f, 87.13508f, 91.20251f, 95.12379f, 98.86908f, 102.40989f, 105.71926f, 108.772f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.668606f, 24.468496f, 26.63013f, 29.137056f, 31.970196f, 35.107986f, 38.526546f, 42.19986f, 46.09997f, 50.197197f, 54.460354f, 58.857002f, 63.353672f, 67.916145f, 72.509705f, 77.09938f, 81.650246f, 86.12767f, 90.497574f, 94.7267f, 98.78286f, 102.63519f, 106.254364f, 109.61285f, 112.68507f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.801813f, 22.91075f, 25.393288f, 28.23053f, 31.400883f, 34.880222f, 38.642063f, 42.65778f, 46.89681f, 51.326885f, 55.9143f, 60.624134f, 65.42055f, 70.26703f, 75.12671f, 79.962585f, 84.73786f, 89.4162f, 93.96199f, 98.34063f, 102.51881f, 106.46472f, 110.14833f, 113.54161f, 116.61874f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.50222f, 19.49699f, 21.891338f, 24.667046f, 27.802982f, 31.275288f, 35.057533f, 39.12093f, 43.43456f, 47.965588f, 52.67953f, 57.540516f, 62.511547f, 67.554794f, 72.63187f, 77.70413f, 82.73299f, 87.68015f, 92.50799f, 97.17974f, 101.65987f, 105.91426f, 109.910545f, 113.6183f, 117.00933f, 120.0578f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.031857f, 18.30763f, 20.992035f, 24.064642f, 27.502064f, 31.278145f, 35.364143f, 39.72896f, 44.339382f, 49.160316f, 54.155075f, 59.28564f, 64.51298f, 69.79729f, 75.098366f, 80.37586f, 85.589615f, 90.69994f, 95.66795f, 100.45583f, 105.027145f, 109.34711f, 113.38283f, 117.10361f, 120.48112f, 123.48966f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977049f, 15.067856f, 17.591951f, 20.530125f, 23.860014f, 27.55628f, 31.590788f, 35.932835f, 40.549374f, 45.40527f, 50.46357f, 55.685776f, 61.032143f, 66.46198f, 71.93397f, 77.406456f, 82.8378f, 88.18665f, 93.41232f, 98.47504f, 103.33625f, 107.958984f, 112.308044f, 116.350334f, 120.05509f, 123.39413f, 126.34202f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.85443f, 14.189629f, 16.9648f, 20.158821f, 23.747385f, 27.703182f, 31.996103f, 36.59348f, 41.46032f, 46.559586f, 51.852467f, 57.298683f, 62.85679f, 68.484474f, 74.13892f, 79.777084f, 85.356064f, 90.8334f, 96.16739f, 101.31746f, 106.2444f, 110.91072f, 115.280914f, 119.32171f, 123.00236f, 126.294846f, 129.17412f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.184278f, 13.723386f, 16.706015f, 20.109463f, 23.907831f, 28.072208f, 32.570904f, 37.36968f, 42.43201f, 47.71937f, 53.191525f, 58.80682f, 64.52252f, 70.295135f, 76.08073f, 81.83525f, 87.51493f, 93.07653f, 98.47773f, 103.677414f, 108.63601f, 113.31579f, 117.68113f, 121.69881f, 125.33825f, 128.57175f, 131.37471f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294694f, 10.571663f, 13.316139f, 16.507235f, 20.120663f, 24.128925f, 28.501514f, 33.205154f, 38.204044f, 43.460144f, 48.93345f, 54.582306f, 60.36372f, 66.233696f, 72.14755f, 78.06029f, 83.9269f, 89.70274f, 95.34386f, 100.80731f, 106.05152f, 111.03658f, 115.72455f, 120.07974f, 124.06902f, 127.66203f, 130.8314f, 133.55305f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.887195f, 10.317616f, 13.217477f, 16.564709f, 20.333838f, 24.496176f, 29.020046f, 33.87102f, 39.01218f, 44.404396f, 50.006634f, 55.776253f, 61.669342f, 67.64106f, 73.64594f, 79.638306f, 85.57253f, 91.403465f, 97.08673f, 102.57906f, 107.83868f, 112.82554f, 117.501686f, 121.83154f, 125.78215f, 129.32344f, 132.42847f, 135.0736f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.512803f, 10.097296f, 13.152906f, 16.656378f, 20.581049f, 24.897049f, 29.571531f, 34.56892f, 39.85118f, 45.378113f, 51.107655f, 56.9962f, 62.99893f, 69.07017f, 75.163704f, 81.23316f, 87.232346f, 93.11561f, 98.838165f, 104.35647f, 109.62852f, 114.61419f, 119.27554f, 123.5771f, 127.48613f, 130.97287f, 134.0108f, 136.57678f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.456418f, 10.139377f, 13.293133f, 16.893682f, 20.913626f, 25.322367f, 30.086353f, 35.169327f, 40.532604f, 46.13537f, 51.93498f, 57.887295f, 63.947018f, 70.06802f, 76.20374f, 82.307465f, 88.33273f, 94.23371f, 99.96547f, 105.4844f, 110.74849f, 115.717674f, 120.35415f, 124.62262f, 128.4906f, 131.92865f, 134.91061f, 137.41377f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.414549f, 10.195992f, 13.447802f, 17.14523f, 21.260134f, 25.7612f, 30.61417f, 35.782112f, 41.225697f, 46.90349f, 52.77228f, 58.78741f, 64.90309f, 71.072784f, 77.24954f, 83.38634f, 89.43648f, 95.35392f, 101.09363f, 106.61191f, 111.866776f, 116.81823f, 121.42859f, 125.662766f, 129.48854f, 132.8768f, 135.80174f, 138.2411f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.606349f, 10.423849f, 13.709982f, 17.439737f, 21.584728f, 26.113409f, 30.991316f, 36.181324f, 41.643932f, 47.33757f, 53.218903f, 59.24317f, 65.364525f, 71.536385f, 77.71177f, 83.84368f, 89.88546f, 95.791115f, 101.51571f, 107.01567f, 112.24914f, 117.17629f, 121.75962f, 125.96425f, 129.75818f, 133.11253f, 136.00179f, 138.40395f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.800906f, 10.654344f, 13.974658f, 17.736582f, 21.911482f, 26.467585f, 31.370218f, 36.58207f, 42.063473f, 47.77271f, 53.66633f, 59.699482f, 65.82625f, 72.0f, 78.17375f, 84.30052f, 90.33367f, 96.227295f, 101.93653f, 107.41793f, 112.62978f, 117.53242f, 122.08852f, 126.26342f, 130.02534f, 133.34566f, 136.1991f, 138.56393f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.595146f, 64.707985f, 65.05897f, 65.64543f, 66.46291f, 67.50519f, 68.76433f, 70.23074f, 71.89329f, 73.73929f, 75.754715f, 77.92422f, 80.231285f, 82.65836f, 85.18698f, 87.79789f, 90.47122f, 93.18663f, 95.923454f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.350456f, 61.83191f, 62.5734f, 63.569286f, 64.812f, 66.29206f, 67.99822f, 69.91749f, 72.03526f, 74.33543f, 76.80047f, 79.41163f, 82.14904f, 84.99186f, 87.918465f, 90.90657f, 93.93344f, 96.976036f, 100.01121f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.03575f, 58.885193f, 60.0171f, 61.42286f, 63.09177f, 65.01113f, 67.16634f, 69.54099f, 72.117004f, 74.87479f, 77.79335f, 80.85047f, 84.02289f, 87.28646f, 90.61635f, 93.987206f, 97.37338f, 100.74911f, 104.08869f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.240116f, 55.12867f, 56.328278f, 57.82981f, 59.62184f, 61.69073f, 64.02074f, 66.594124f, 69.391304f, 72.391f, 75.57037f, 78.90522f, 82.37018f, 85.93886f, 89.584114f, 93.278206f, 96.993004f, 100.70024f, 104.37171f, 107.97947f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.710136f, 57.639736f, 58.861286f, 60.36548f, 62.140877f, 64.17396f, 66.44926f, 68.949455f, 71.655525f, 74.54687f, 77.60149f, 80.79613f, 84.106476f, 87.50735f, 90.97285f, 94.47661f, 97.99197f, 101.492165f, 104.95056f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.832855f, 55.147156f, 56.77237f, 58.69613f, 60.90379f, 63.37856f, 66.10159f, 69.05218f, 72.20785f, 75.54459f, 79.03701f, 82.65853f, 86.381584f, 90.17785f, 94.01842f, 97.87406f, 101.715454f, 105.513336f, 109.23882f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.592518f, 50.9515f, 52.65333f, 54.685055f, 57.03121f, 59.673946f, 62.59314f, 65.76659f, 69.17012f, 72.77785f, 76.56231f, 80.494705f, 84.545105f, 88.682686f, 92.87595f, 97.092995f, 101.30172f, 105.4701f, 109.56641f, 113.559456f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.81025f, 48.515896f, 50.582924f, 52.995605f, 55.735573f, 58.78198f, 62.111637f, 65.6992f, 69.51738f, 73.53711f, 77.72778f, 82.05753f, 86.493385f, 91.00159f, 95.54784f, 100.09752f, 104.61603f, 109.068954f, 113.422424f, 117.643295f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.817333f, 51.53741f, 53.59588f, 55.977066f, 58.662853f, 61.6328f, 64.8643f, 68.33276f, 72.01179f, 75.87338f, 79.888145f, 84.025536f, 88.25405f, 92.54153f, 96.855316f, 101.162605f, 105.430595f, 109.626816f, 113.71933f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.762375f, 47.524994f, 49.656536f, 52.14078f, 54.958824f, 58.08921f, 61.50812f, 65.18954f, 69.10544f, 73.22603f, 77.519936f, 81.95449f, 86.49594f, 91.109726f, 95.76072f, 100.41354f, 105.03277f, 109.58326f, 114.030365f, 118.34025f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.14344f, 45.305717f, 47.853806f, 50.768314f, 54.027065f, 57.605255f, 61.47565f, 65.608795f, 69.97324f, 74.53577f, 79.26164f, 84.114914f, 89.05863f, 94.055176f, 99.06653f, 104.05454f, 108.981255f, 113.809166f, 118.50155f, 123.022675f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.02664f, 43.5634f, 46.499233f, 49.811794f, 53.47588f, 57.463596f, 61.744602f, 66.28631f, 71.05415f, 76.011856f, 81.12167f, 86.344734f, 91.641266f, 96.97098f, 102.2933f, 107.56772f, 112.75411f, 117.81299f, 122.70586f, 127.39548f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.326378f, 44.454975f, 46.975857f, 49.869843f, 53.11491f, 56.686356f, 60.557003f, 64.697395f, 69.07601f, 73.65954f, 78.41309f, 83.3005f, 88.284546f, 93.32732f, 98.39043f, 103.43535f, 108.423676f, 113.31746f, 118.079445f, 122.673386f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.44198f, 43.00266f, 45.966682f, 49.31149f, 53.011623f, 57.038925f, 61.362743f, 65.95017f, 70.766304f, 75.774475f, 80.93657f, 86.21331f, 91.56454f, 96.94952f, 102.32727f, 107.65687f, 112.89776f, 118.01004f, 122.95481f, 127.694435f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.150497f, 38.713833f, 41.713154f, 45.12563f, 48.92529f, 53.083214f, 57.567764f, 62.344803f, 67.37798f, 72.62899f, 78.05787f, 83.62329f, 89.28291f, 94.99365f, 100.71206f, 106.39459f, 111.998024f, 117.4797f, 122.797905f, 127.912155f, 132.78354f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.555275f, 37.514343f, 40.918526f, 44.74191f, 48.955395f, 53.526924f, 58.421696f, 63.60246f, 69.02979f, 74.662384f, 80.45737f, 86.370636f, 92.35719f, 98.371475f, 104.36771f, 110.300255f, 116.12397f, 121.794525f, 127.268776f, 132.50505f, 137.4635f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80485f, 38.301025f, 41.236324f, 44.588406f, 48.33176f, 52.4379f, 56.875572f, 61.611008f, 66.60816f, 71.82901f, 77.23381f, 82.781425f, 88.42965f, 94.13549f, 99.85552f, 105.5462f, 111.16424f, 116.66686f, 122.0122f, 127.15957f, 132.0698f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.555275f, 37.514343f, 40.918526f, 44.74191f, 48.955395f, 53.526924f, 58.421696f, 63.60246f, 69.02979f, 74.662384f, 80.45737f, 86.370636f, 92.35719f, 98.371475f, 104.36771f, 110.300255f, 116.12397f, 121.794525f, 127.268776f, 132.50505f, 137.4635f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.603668f, 33.556953f, 36.985466f, 40.863117f, 45.160393f, 49.844585f, 54.88005f, 60.228466f, 65.84912f, 71.69924f, 77.73431f, 83.90839f, 90.17449f, 96.48493f, 102.79168f, 109.04674f, 115.20251f, 121.21213f, 127.02987f, 132.61147f, 137.91441f, 142.89838f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.755373f, 33.133934f, 36.990944f, 41.297047f, 46.01947f, 51.12228f, 56.566635f, 62.3111f, 68.31196f, 74.523544f, 80.898575f, 87.388535f, 93.94403f, 100.51518f, 107.05196f, 113.50464f, 119.82409f, 125.96223f, 131.87233f, 137.50943f, 142.83061f, 147.79538f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.814663f, 29.113235f, 32.920856f, 37.20855f, 41.94368f, 47.09021f, 52.608974f, 58.45797f, 64.59268f, 70.96643f, 77.53069f, 84.23552f, 91.02988f, 97.86206f, 104.68008f, 111.43203f, 118.066536f, 124.533104f, 130.78252f, 136.76721f, 142.44165f, 147.76263f, 152.68968f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.273993f, 28.950947f, 33.138187f, 37.803844f, 42.912407f, 48.425f, 54.299667f, 60.4917f, 66.95397f, 73.6373f, 80.49082f, 87.46238f, 94.49891f, 101.54687f, 108.55261f, 115.46282f, 122.22491f, 128.7874f, 135.10037f, 141.11577f, 146.7878f, 152.0733f, 156.93205f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.377102f, 24.89323f, 28.950523f, 33.518105f, 38.561207f, 44.04146f, 49.91714f, 56.143547f, 62.67328f, 69.45665f, 76.44203f, 83.57626f, 90.805046f, 98.073364f, 105.325905f, 112.50747f, 119.5634f, 126.44f, 133.08493f, 139.44763f, 145.47966f, 151.13512f, 156.37097f, 161.14737f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.060602f, 24.900614f, 29.281733f, 34.17062f, 39.530064f, 45.31928f, 51.494205f, 58.007847f, 64.81063f, 71.85079f, 79.07474f, 86.42749f, 93.8531f, 101.29505f, 108.6967f, 116.001724f, 123.15452f, 130.10065f, 136.78726f, 143.16345f, 149.1807f, 154.79321f, 159.95827f, 164.63657f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.266966f, 20.859842f, 25.024578f, 29.729483f, 34.938744f, 40.61272f, 46.708225f, 53.17887f, 59.97541f, 67.04612f, 74.33719f, 81.79312f, 89.35718f, 96.97179f, 104.579f, 112.120926f, 119.54016f, 126.78024f, 133.78607f, 140.50432f, 146.88387f, 152.87614f, 158.43558f, 163.51982f, 168.09021f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.10901f, 20.964891f, 25.391832f, 30.356146f, 35.820045f, 41.741955f, 48.076797f, 54.776367f, 61.789673f, 69.06334f, 76.542015f, 84.16877f, 91.88557f, 99.63368f, 107.35414f, 114.98819f, 122.47773f, 129.76575f, 136.7968f, 143.51736f, 149.87628f, 155.82518f, 161.31876f, 166.31523f, 170.77657f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.027233f, 21.14636f, 25.835167f, 31.05797f, 36.77502f, 42.94281f, 49.514397f, 56.43977f, 63.666218f, 71.13874f, 78.80048f, 86.59312f, 94.457344f, 102.33331f, 110.16108f, 117.88107f, 125.43453f, 132.76399f, 139.81364f, 146.52985f, 152.8615f, 158.76038f, 164.18163f, 169.08397f, 173.43011f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.183025f, 21.497576f, 26.379133f, 31.790546f, 37.69063f, 44.03449f, 50.773834f, 57.85738f, 65.23121f, 72.83921f, 80.62348f, 88.52477f, 96.482956f, 104.43747f, 112.32776f, 120.09379f, 127.67645f, 135.01804f, 142.06267f, 148.75674f, 155.0493f, 160.89246f, 166.24174f, 171.05646f, 175.29993f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.470752f, 17.382027f, 21.891632f, 26.965248f, 32.56426f, 38.646053f, 45.16435f, 52.069534f, 59.309055f, 66.82781f, 74.568596f, 82.47248f, 90.47932f, 98.52817f, 106.557785f, 114.50704f, 122.31546f, 129.9236f, 137.27354f, 144.30939f, 150.97757f, 157.22733f, 163.01111f, 168.28491f, 173.00856f, 177.14615f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.660719f, 17.695873f, 22.32697f, 27.518763f, 33.23174f, 39.42242f, 46.04369f, 53.04516f, 60.37354f, 67.97305f, 75.78587f, 83.75254f, 91.812416f, 99.90416f, 107.96619f, 115.93715f, 123.75637f, 131.36435f, 138.7032f, 145.71704f, 152.35251f, 158.5591f, 164.28957f, 169.50032f, 174.15169f, 178.20828f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.869179f, 18.027937f, 22.780107f, 28.089527f, 33.915787f, 40.214546f, 46.937862f, 54.034573f, 61.45067f, 69.1297f, 77.01324f, 85.04127f, 93.15271f, 101.28581f, 109.37869f, 117.36975f, 125.19817f, 132.80438f, 140.13048f, 147.12073f, 153.72191f, 159.88379f, 165.55948f, 170.70578f, 175.28352f, 179.25787f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.159769f, 18.364187f, 23.159462f, 28.509098f, 34.37238f, 40.704685f, 47.45782f, 54.58039f, 62.01819f, 69.714615f, 77.611084f, 85.6475f, 93.76271f, 101.89494f, 109.982315f, 117.96327f, 125.77708f, 133.36426f, 140.66708f, 147.62996f, 154.19989f, 160.32689f, 165.96432f, 171.06929f, 175.60294f, 179.53076f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.453865f, 18.703766f, 23.541937f, 28.931559f, 34.83161f, 41.197193f, 47.979855f, 55.127983f, 62.58717f, 70.300644f, 78.20971f, 86.25417f, 94.3728f, 102.50382f, 110.58534f, 118.555855f, 126.354706f, 133.92255f, 141.20177f, 148.13696f, 154.67538f, 160.76724f, 166.36618f, 171.4296f, 175.91895f, 179.80005f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.29852f, 67.67462f, 69.44895f, 71.608f, 74.13534f, 77.01174f, 80.21531f, 83.72166f, 87.50411f, 91.533875f, 95.78028f, 100.21102f, 104.792366f, 109.48944f, 114.26652f, 119.08723f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.940987f, 64.371475f, 66.225334f, 68.48846f, 71.14361f, 74.170586f, 77.54635f, 81.24522f, 85.23903f, 89.49739f, 93.9879f, 98.67638f, 103.52714f, 108.503265f, 113.56689f, 118.679474f, 123.80212f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.496307f, 62.39004f, 64.72223f, 67.475105f, 70.62773f, 74.15611f, 78.033394f, 82.230064f, 86.71419f, 91.45163f, 96.40635f, 101.540634f, 106.8154f, 112.190506f, 117.62505f, 123.077675f, 128.50687f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.403316f, 60.723137f, 63.49409f, 66.69509f, 70.30177f, 74.28669f, 78.61951f, 83.26726f, 88.19457f, 93.36394f, 98.73602f, 104.26994f, 109.92357f, 115.65389f, 121.41729f, 127.1699f, 132.86794f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.018574f, 63.352585f, 66.11772f, 69.29293f, 72.85405f, 76.77398f, 81.02289f, 85.568436f, 90.37602f, 95.40907f, 100.62927f, 105.996895f, 111.471085f, 117.01019f, 122.572044f, 128.11433f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.166344f, 59.53808f, 62.36997f, 65.64046f, 69.32465f, 73.394516f, 77.81908f, 82.56467f, 87.59515f, 92.87226f, 98.355835f, 104.00413f, 109.774155f, 115.62202f, 121.50319f, 127.372925f, 133.18655f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.226124f, 58.086823f, 61.418716f, 65.19645f, 69.39127f, 73.97126f, 78.90155f, 84.14462f, 89.66058f, 95.40744f, 101.34146f, 107.41749f, 113.58927f, 119.809845f, 126.03187f, 132.208f, 138.29118f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.86986f, 53.67244f, 56.97981f, 60.7668f, 65.00459f, 69.660934f, 74.700386f, 80.084595f, 85.77258f, 91.72106f, 97.88476f, 104.21677f, 110.6689f, 117.19205f, 123.73656f, 130.25264f, 136.69069f, 143.00171f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.963467f, 56.77926f, 60.0762f, 63.829197f, 68.00969f, 72.58585f, 77.52287f, 82.783165f, 88.326706f, 94.1113f, 100.09292f, 106.226036f, 112.46399f, 118.7593f, 125.06405f, 131.33026f, 137.51024f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.68185f, 56.01443f, 59.83398f, 64.111435f, 68.81423f, 73.90658f, 79.34973f, 85.10225f, 91.12037f, 97.35828f, 103.7685f, 110.30225f, 116.90981f, 123.54089f, 130.14502f, 136.67195f, 143.07199f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.18778f, 51.519035f, 55.37147f, 59.715767f, 64.51887f, 69.74421f, 75.35203f, 81.299644f, 87.541794f, 94.030975f, 100.71779f, 107.55135f, 114.47967f, 121.44999f, 128.40927f, 135.30457f, 142.08337f, 148.6941f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.96852f, 50.764626f, 55.087654f, 59.904705f, 65.17912f, 70.87075f, 76.93629f, 83.32957f, 90.00192f, 96.90259f, 103.97904f, 111.17742f, 118.44294f, 125.720314f, 132.95416f, 140.0894f, 147.07176f, 153.84808f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.47679f, 54.262875f, 58.549255f, 63.303314f, 68.48887f, 74.06645f, 79.99362f, 86.225266f, 92.71395f, 99.4103f, 106.26335f, 113.22094f, 120.230125f, 127.237564f, 134.18991f, 141.03427f, 147.71855f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.37881f, 50.1805f, 54.513557f, 59.345005f, 64.63808f, 70.352486f, 76.44474f, 82.86848f, 89.57481f, 96.51269f, 103.629326f, 110.87055f, 118.18126f, 125.50581f, 132.78845f, 139.97377f, 147.00708f, 153.83485f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.75543f, 50.104908f, 54.986332f, 60.362553f, 66.19265f, 72.43225f, 79.03387f, 85.947266f, 93.11983f, 100.49696f, 108.02253f, 115.639244f, 123.289154f, 130.91403f, 138.45584f, 145.8572f, 153.06177f, 160.01471f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.32152f, 45.597336f, 50.4394f, 55.81086f, 61.670837f, 67.97474f, 74.67458f, 81.719376f, 89.05551f, 96.62716f, 104.37668f, 112.2451f, 120.172554f, 128.09868f, 135.96318f, 143.70619f, 151.26878f, 158.59338f, 165.62428f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.150986f, 49.417717f, 54.221626f, 59.526142f, 65.29091f, 71.47204f, 78.02249f, 84.892426f, 92.02955f, 99.37955f, 106.886475f, 114.4932f, 122.141846f, 129.77419f, 137.33214f, 144.75818f, 151.9958f, 158.98991f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.32152f, 45.597336f, 50.4394f, 55.81086f, 61.670837f, 67.97474f, 74.67458f, 81.719376f, 89.05551f, 96.62716f, 104.37668f, 112.2451f, 120.172554f, 128.09868f, 135.96318f, 143.70619f, 151.26878f, 158.59338f, 165.62428f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.516212f, 46.372105f, 51.788345f, 57.723724f, 64.13306f, 70.967575f, 78.17526f, 85.701256f, 93.48828f, 101.47708f, 109.60685f, 117.81572f, 126.041214f, 134.22073f, 142.292f, 150.19365f, 157.86548f, 165.24915f, 172.28842f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.44073f, 42.221497f, 47.594208f, 53.517967f, 59.947697f, 66.834465f, 74.12585f, 81.766365f, 89.69786f, 97.85997f, 106.19059f, 114.6263f, 123.102905f, 131.5559f, 139.92094f, 148.13438f, 156.1337f, 163.85802f, 171.24855f, 178.24904f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.207794f, 37.885384f, 43.187916f, 49.07503f, 55.50193f, 62.419697f, 69.77569f, 77.513916f, 85.575485f, 93.89905f, 102.42125f, 111.07724f, 119.80114f, 128.52655f, 137.18707f, 145.71678f, 154.05078f, 162.12563f, 169.87988f, 177.25452f, 184.1934f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.578392f, 38.71427f, 44.46878f, 50.79813f, 57.65415f, 64.98466f, 72.733864f, 80.8428f, 89.24973f, 97.8907f, 106.699936f, 115.6104f, 124.55426f, 133.46346f, 142.2702f, 150.90744f, 159.30946f, 167.41232f, 175.15434f, 182.47661f, 189.32338f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.1479f, 39.74083f, 45.944576f, 52.711933f, 59.99139f, 67.72755f, 75.861534f, 84.331436f, 93.0728f, 102.0191f, 111.10224f, 120.2531f, 129.40202f, 138.4794f, 147.41614f, 156.14423f, 164.59723f, 172.71083f, 180.42326f, 187.67584f, 194.41336f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.658003f, 34.985954f, 40.96091f, 47.537403f, 54.665382f, 62.290596f, 70.35501f, 78.79726f, 87.55308f, 96.55585f, 105.73703f, 115.02677f, 124.354355f, 133.6488f, 142.83937f, 151.85612f, 160.63043f, 169.09552f, 177.18695f, 184.84317f, 192.00587f, 198.62059f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.249483f, 35.96444f, 42.318962f, 49.26468f, 56.748737f, 64.71418f, 73.10037f, 81.843506f, 90.87703f, 100.1322f, 109.538574f, 119.02457f, 128.51799f, 137.94658f, 147.23857f, 156.32329f, 165.13155f, 173.59633f, 181.6532f, 189.24088f, 196.30157f, 202.78157f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.00924f, 37.031757f, 43.685715f, 50.92047f, 58.68096f, 66.90813f, 75.53936f, 84.50896f, 93.748665f, 103.18816f, 112.75561f, 122.37819f, 131.98267f, 141.49596f, 150.84564f, 159.96057f, 168.77138f, 177.21101f, 185.21523f, 192.72313f, 199.67755f, 206.02557f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.202753f, 31.86016f, 38.188366f, 45.139206f, 52.659782f, 60.69286f, 69.1773f, 78.04853f, 87.23904f, 96.67888f, 106.2962f, 116.01782f, 125.76975f, 135.47777f, 145.068f, 154.46742f, 163.60454f, 172.4098f, 180.8162f, 188.75975f, 196.18f, 203.02045f, 209.22908f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.82892f, 32.714996f, 39.26537f, 46.43018f, 54.1549f, 62.38074f, 71.0451f, 80.08203f, 89.42277f, 98.996216f, 108.72951f, 118.548584f, 128.37871f, 138.14505f, 147.77332f, 157.1902f, 166.32404f, 175.10533f, 183.46724f, 191.34613f, 198.68202f, 205.4191f, 211.50609f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.506315f, 33.61987f, 40.390827f, 47.76766f, 55.69422f, 64.11019f, 72.951515f, 82.15091f, 91.63835f, 101.34165f, 111.18695f, 121.09932f, 131.00333f, 140.82358f, 150.48537f, 159.91513f, 169.04112f, 177.79388f, 186.1068f, 193.9166f, 201.16385f, 207.79338f, 213.75478f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.12571f, 34.379704f, 41.28532f, 48.79f, 56.836636f, 65.363976f, 74.30714f, 83.598045f, 93.16599f, 102.93816f, 112.84019f, 122.7967f, 132.73193f, 142.57025f, 152.23682f, 161.65804f, 170.7622f, 179.48004f, 187.74521f, 195.4948f, 202.66982f, 209.21567f, 215.08253f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067047f, 28.766363f, 35.160023f, 42.199368f, 49.83082f, 57.9963f, 66.63367f, 75.677185f, 85.05803f, 94.7048f, 104.54408f, 114.50099f, 124.499756f, 134.46428f, 144.31871f, 153.98807f, 163.39874f, 172.47914f, 181.16014f, 189.37567f, 197.06322f, 204.16425f, 210.62476f, 216.39555f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469412f, 29.222376f, 35.666214f, 42.75188f, 50.425453f, 58.628532f, 67.29868f, 76.36993f, 85.77322f, 95.43699f, 105.28771f, 115.2504f, 125.24923f, 135.20811f, 145.05125f, 154.70374f, 164.09212f, 173.14491f, 181.79324f, 189.9713f, 197.61684f, 204.67165f, 211.08206f, 216.79929f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.875912f, 29.68228f, 36.176018f, 43.30771f, 51.02307f, 59.263393f, 67.96596f, 77.06453f, 86.48987f, 96.170235f, 106.03197f, 116.0f, 125.998474f, 135.95131f, 145.78273f, 155.41794f, 164.78358f, 173.80841f, 182.4237f, 190.56393f, 198.16713f, 205.17542f, 211.53548f, 217.1989f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.928154f, 72.57518f, 75.7658f, 79.475716f, 83.6767f, 88.336784f, 93.420494f, 98.889145f, 104.701126f, 110.81219f, 117.17583f, 123.743614f, 130.46558f, 137.29053f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.0954f, 72.29157f, 76.033485f, 80.29266f, 85.03669f, 90.22947f, 95.83147f, 101.800064f, 108.08983f, 114.652885f, 121.43929f, 128.3974f, 135.47426f, 142.616f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.0562f, 68.22583f, 71.97214f, 76.26663f, 81.07661f, 86.36547f, 92.09297f, 98.215515f, 104.68651f, 111.456696f, 118.474556f, 125.68668f, 133.0382f, 140.47311f, 147.93489f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.906223f, 67.5641f, 71.80371f, 76.592766f, 81.89484f, 87.66957f, 93.87301f, 100.45794f, 107.37425f, 114.56931f, 121.98836f, 129.57492f, 137.27127f, 145.01883f, 152.75864f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.596924f, 70.26012f, 74.484505f, 79.23795f, 84.48428f, 90.183556f, 96.29241f, 102.76434f, 109.55011f, 116.59805f, 123.85455f, 131.26436f, 138.7711f, 146.31764f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.281845f, 70.52026f, 75.3179f, 80.63826f, 86.440834f, 92.68147f, 99.31267f, 106.283966f, 113.542305f, 121.03245f, 128.69739f, 136.47879f, 144.31743f, 152.15366f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.803783f, 66.02504f, 70.83973f, 76.21122f, 82.09862f, 88.45712f, 95.23834f, 102.39067f, 109.85967f, 117.58849f, 125.51833f, 133.58882f, 141.73856f, 149.90549f, 158.02748f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.266182f, 66.00082f, 71.32907f, 77.210396f, 83.60003f, 90.44934f, 97.70621f, 105.3154f, 113.219f, 121.356865f, 129.66705f, 138.08633f, 146.55061f, 154.99548f, 163.35667f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.43614f, 69.15765f, 74.44875f, 80.26919f, 86.574646f, 93.31715f, 100.44537f, 107.90508f, 115.63949f, 123.589745f, 131.69533f, 139.89456f, 148.12503f, 156.32411f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.219048f, 64.94002f, 70.26269f, 76.14654f, 82.5468f, 89.41475f, 96.69813f, 104.34151f, 112.286705f, 120.47327f, 128.83887f, 137.31987f, 145.8517f, 154.36945f, 162.80827f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.27835f, 65.60483f, 71.52793f, 78.0026f, 84.979546f, 92.40567f, 100.224464f, 108.37641f, 116.79948f, 125.42956f, 134.20097f, 143.04695f, 151.90019f, 160.69331f, 169.35938f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.41351f, 60.642838f, 66.50656f, 72.96006f, 79.95421f, 87.43579f, 95.34786f, 103.6302f, 112.21978f, 121.05122f, 130.05733f, 139.16954f, 148.31851f, 157.43462f, 166.44849f, 175.2915f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.98946f, 64.21374f, 70.04524f, 76.43958f, 83.34811f, 90.718216f, 98.49384f, 106.61579f, 115.02226f, 123.64927f, 132.43115f, 141.30109f, 150.19156f, 159.03491f, 167.76384f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.793053f, 60.009914f, 65.866f, 72.31672f, 79.313f, 86.80159f, 94.72549f, 103.0244f, 111.635155f, 120.49223f, 129.52821f, 138.67433f, 147.861f, 157.01826f, 166.07645f, 174.96663f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.445816f, 61.301136f, 67.78585f, 74.85059f, 82.44161f, 90.50112f, 98.9678f, 107.77719f, 116.86226f, 126.15386f, 135.58128f, 145.07278f, 154.55612f, 163.9591f, 173.2102f, 182.23898f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.463955f, 62.88255f, 69.918495f, 77.51825f, 85.62397f, 94.173965f, 103.10317f, 112.34363f, 121.825005f, 131.47514f, 141.22061f, 150.98723f, 160.70067f, 170.287f, 179.67328f, 188.78806f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.624622f, 60.381573f, 66.77491f, 73.755974f, 81.27164f, 89.2647f, 97.67434f, 106.43654f, 115.48462f, 124.749725f, 134.16133f, 143.64781f, 153.13698f, 162.55661f, 171.835f, 180.90157f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.463955f, 62.88255f, 69.918495f, 77.51825f, 85.62397f, 94.173965f, 103.10317f, 112.34363f, 121.825005f, 131.47514f, 141.22061f, 150.98723f, 160.70067f, 170.287f, 179.67328f, 188.78806f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.267555f, 58.690907f, 65.76351f, 73.43155f, 81.63665f, 90.316376f, 99.40467f, 108.83236f, 118.527695f, 128.41689f, 138.42468f, 148.4749f, 158.49107f, 168.39694f, 178.11716f, 187.57771f, 196.7066f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904156f, 54.231247f, 61.24153f, 68.88166f, 77.09348f, 85.81451f, 94.978355f, 104.51528f, 114.35272f, 124.41579f, 134.6279f, 144.91135f, 155.18787f, 165.37923f, 175.40787f, 185.1975f, 194.67358f, 203.764f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.57441f, 56.49815f, 64.08784f, 72.2857f, 81.02935f, 90.25224f, 99.88419f, 109.85189f, 120.079475f, 130.4891f, 141.00157f, 151.53685f, 162.01477f, 172.35559f, 182.4806f, 192.31276f, 201.77722f, 210.80196f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.770947f, 51.499153f, 58.931343f, 67.010956f, 75.676506f, 84.86204f, 94.49764f, 104.509995f, 114.82288f, 125.357834f, 136.03465f, 146.77211f, 157.48845f, 168.10214f, 178.53241f, 188.69986f, 198.52711f, 207.93939f, 216.86504f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.40406f, 53.650517f, 61.58459f, 70.1459f, 79.26927f, 88.88529f, 98.92077f, 109.299324f, 119.94197f, 130.76772f, 141.69417f, 152.63817f, 163.51642f, 174.24614f, 184.74568f, 194.93512f, 204.73691f, 214.07645f, 222.88266f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.155724f, 55.82912f, 64.17355f, 73.12551f, 82.61687f, 92.575386f, 102.925285f, 113.587776f, 124.48173f, 135.52423f, 146.63123f, 157.7182f, 168.70078f, 179.49536f, 190.0198f, 200.19402f, 209.94055f, 219.18524f, 227.85773f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.686546f, 50.06687f, 58.162083f, 66.910576f, 76.24576f, 86.096596f, 96.388115f, 107.04199f, 117.977135f, 129.11034f, 140.35684f, 151.63109f, 162.84724f, 173.91997f, 184.76498f, 195.29976f, 205.4441f, 215.12083f, 224.25627f, 232.78093f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.16492f, 51.887653f, 60.311417f, 69.3721f, 79.00075f, 89.12408f, 99.66505f, 110.543434f, 121.676445f, 132.97935f, 144.36613f, 155.75012f, 167.0447f, 178.16388f, 189.02306f, 199.53958f, 209.6334f, 219.22774f, 228.24953f, 236.63013f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.746155f, 53.807747f, 62.55576f, 71.923615f, 81.84001f, 92.22948f, 103.012955f, 114.10837f, 125.431274f, 136.89551f, 148.41379f, 159.8985f, 171.2622f, 182.41843f, 193.28227f, 203.77103f, 213.80492f, 223.30753f, 232.20657f, 240.4343f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575317f, 47.143456f, 55.448734f, 64.42794f, 74.01273f, 84.13017f, 94.70326f, 105.65153f, 116.89165f, 128.33807f, 139.9037f, 151.5005f, 163.04022f, 174.43504f, 185.59822f, 196.44481f, 206.89227f, 216.86108f, 226.27538f, 235.0635f, 243.15858f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.775894f, 48.596245f, 57.14268f, 66.35015f, 76.14858f, 86.4634f, 97.21612f, 108.32488f, 119.705154f, 131.27032f, 142.93237f, 154.60255f, 166.19205f, 177.61264f, 188.77742f, 199.60141f, 210.00224f, 219.90076f, 229.22163f, 237.8939f, 245.8516f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.725525f, 49.700428f, 58.39301f, 67.73711f, 77.66162f, 88.091f, 98.945885f, 110.14366f, 121.5991f, 133.22502f, 144.93295f, 156.63379f, 168.23846f, 179.65868f, 190.8075f, 201.60008f, 211.9543f, 221.79135f, 231.03636f, 239.61897f, 247.47386f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.698746f, 50.82704f, 59.664436f, 69.14368f, 79.19262f, 89.73479f, 100.68995f, 111.974724f, 123.50323f, 135.18773f, 146.93929f, 158.66849f, 170.28604f, 181.70355f, 192.8341f, 203.59302f, 213.89838f, 223.67177f, 232.83882f, 241.32974f, 249.07994f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.28236f, 51.466053f, 60.353985f, 69.87852f, 79.967155f, 90.54312f, 101.525925f, 112.831985f, 124.37525f, 136.06787f, 147.82086f, 159.54478f, 171.15039f, 182.54936f, 193.65495f, 204.38264f, 214.65079f, 224.38123f, 233.49992f, 241.93747f, 249.62965f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.87029f, 52.109028f, 61.047115f, 70.61652f, 80.74442f, 91.35374f, 102.36372f, 113.69058f, 125.24812f, 136.94836f, 148.70229f, 160.42041f, 172.01357f, 183.39352f, 194.47368f, 205.1697f, 215.40016f, 225.08725f, 234.1572f, 242.541f, 250.17485f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.93912f, 72.67252f, 76.09977f, 80.22643f, 85.0211f, 90.447296f, 96.46371f, 103.02456f, 110.07991f, 117.576065f, 125.45598f, 133.65968f, 142.12473f, 150.78671f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.12037f, 72.44086f, 76.47369f, 81.20309f, 86.59306f, 92.6026f, 99.18595f, 106.29302f, 113.86972f, 121.85838f, 130.19821f, 138.82573f, 147.67528f, 156.67952f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.05742f, 68.27453f, 72.18972f, 76.82921f, 82.16257f, 88.1492f, 94.743546f, 101.89542f, 109.55038f, 117.650185f, 126.13318f, 134.9348f, 143.98808f, 153.22409f, 162.57257f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.911724f, 67.63778f, 72.0832f, 77.257675f, 83.12276f, 89.633804f, 96.74127f, 104.39105f, 112.52494f, 121.081024f, 129.99419f, 139.19661f, 148.61823f, 158.18736f, 167.83118f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.60789f, 70.35746f, 74.81848f, 79.98867f, 85.82868f, 92.29407f, 99.335625f, 106.89976f, 114.928894f, 123.36194f, 132.1347f, 141.18042f, 150.43027f, 159.81381f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.31172f, 70.68509f, 75.78719f, 81.59109f, 88.05261f, 95.12258f, 102.747185f, 110.86841f, 119.42444f, 128.35016f, 137.57764f, 147.03665f, 156.6552f, 166.36009f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.807514f, 66.08971f, 71.09757f, 76.84102f, 83.27824f, 90.360245f, 98.033134f, 106.23851f, 114.91394f, 123.99338f, 133.40773f, 143.08536f, 152.9526f, 162.93436f, 172.95467f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.279045f, 66.105675f, 71.67963f, 77.986626f, 84.97868f, 92.602585f, 100.80031f, 109.50946f, 118.66376f, 128.19354f, 138.02626f, 148.08711f, 158.29951f, 168.58574f, 178.86751f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.461105f, 69.30694f, 74.88896f, 81.17961f, 88.13102f, 95.69028f, 103.79986f, 112.39804f, 121.41939f, 130.79524f, 140.45424f, 150.32289f, 160.32607f, 170.38763f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.22278f, 65.004684f, 70.52052f, 76.77634f, 83.72642f, 91.31787f, 99.49292f, 108.18935f, 117.34097f, 126.87814f, 136.72827f, 146.8164f, 157.06575f, 167.39832f, 177.73547f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.297836f, 65.73498f, 71.93093f, 78.858025f, 86.46355f, 94.689606f, 103.4736f, 112.74869f, 122.44427f, 132.48656f, 142.79912f, 153.30348f, 163.91968f, 174.56694f, 185.16423f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.414444f, 60.68914f, 66.71783f, 73.511826f, 81.02494f, 89.19999f, 97.97475f, 107.28245f, 117.05224f, 127.20978f, 137.67775f, 148.3765f, 159.2246f, 170.13947f, 181.03807f, 191.83743f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.997074f, 64.297104f, 70.34741f, 77.1406f, 84.6253f, 92.74452f, 101.436485f, 110.63503f, 120.27017f, 130.26855f, 140.55411f, 151.04852f, 161.67197f, 172.34355f, 182.9821f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.79307f, 60.04344f, 66.04175f, 72.80596f, 80.29465f, 88.45083f, 97.212425f, 106.512764f, 116.28105f, 126.442955f, 136.92113f, 147.63583f, 158.50552f, 169.44746f, 180.3784f, 191.21513f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.45503f, 61.39134f, 68.10369f, 75.57625f, 83.7522f, 92.56932f, 101.960526f, 111.854324f, 122.17543f, 132.84529f, 143.78268f, 154.9044f, 166.12578f, 177.36142f, 188.52582f, 199.534f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.397705f, 78.485435f, 87.254425f, 96.63794f, 106.56457f, 116.95875f, 127.74139f, 138.83041f, 150.14145f, 161.5884f, 173.08412f, 184.54117f, 195.87233f, 206.99136f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.629494f, 60.452164f, 67.04707f, 74.409065f, 82.48335f, 91.208466f, 100.51801f, 110.34113f, 120.60307f, 131.22574f, 142.12828f, 153.2277f, 164.43958f, 175.67853f, 186.85905f, 197.89604f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.397705f, 78.485435f, 87.254425f, 96.63794f, 106.56457f, 116.95875f, 127.74139f, 138.83041f, 150.14145f, 161.5884f, 173.08412f, 184.54117f, 195.87233f, 206.99136f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.27852f, 58.78825f, 66.09749f, 74.18227f, 82.98106f, 92.426895f, 102.44788f, 112.967766f, 123.90648f, 135.18077f, 146.70483f, 158.39096f, 170.15022f, 181.89313f, 193.53029f, 204.97314f, 216.13463f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904633f, 54.272987f, 61.440506f, 69.41214f, 78.13408f, 87.539955f, 97.55818f, 108.11252f, 119.12263f, 130.50473f, 142.17218f, 154.03621f, 166.0065f, 177.99197f, 189.9014f, 201.64413f, 213.13083f, 224.27405f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.587276f, 56.603016f, 64.43839f, 73.06193f, 82.408005f, 92.405495f, 102.978294f, 114.04595f, 125.52423f, 137.32578f, 149.36078f, 161.53763f, 173.76366f, 185.94583f, 197.99142f, 209.80876f, 221.3079f, 232.40135f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.77125f, 51.538723f, 59.124344f, 67.53096f, 76.7022f, 86.568275f, 97.0541f, 108.07986f, 119.561646f, 131.41208f, 143.54097f, 155.85602f, 168.26347f, 180.66893f, 192.97797f, 205.09691f, 216.93353f, 228.39772f, 239.40225f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.413273f, 53.74072f, 61.902435f, 70.871544f, 80.57986f, 90.95349f, 101.9135f, 113.37646f, 125.25514f, 137.45914f, 149.89557f, 162.46977f, 175.08607f, 187.64845f, 200.0613f, 212.23012f, 224.06233f, 235.46788f, 246.35995f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.182247f, 55.983475f, 64.62334f, 74.049965f, 84.191605f, 94.97108f, 106.30634f, 118.11114f, 130.29561f, 142.76704f, 155.43051f, 168.18965f, 180.94733f, 193.60648f, 206.07076f, 218.24529f, 230.03741f, 241.35739f, 252.1191f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.68929f, 50.12591f, 58.406048f, 67.51752f, 77.39372f, 87.959496f, 99.13443f, 110.833466f, 122.967575f, 135.44441f, 148.169f, 161.04454f, 173.973f, 186.856f, 199.5955f, 212.09454f, 224.258f, 235.99329f, 247.21112f, 257.82608f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.175884f, 51.984997f, 60.645393f, 70.122826f, 80.34515f, 91.2346f, 102.70827f, 114.67885f, 127.05523f, 139.74323f, 152.64629f, 165.66618f, 178.70386f, 191.66005f, 204.43619f, 216.93503f, 229.06143f, 240.72313f, 251.83134f, 262.30157f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.771122f, 53.957035f, 62.995964f, 72.83404f, 83.396385f, 94.602615f, 106.36744f, 118.601326f, 131.21117f, 144.101f, 157.17271f, 170.32683f, 183.46323f, 196.48195f, 209.2839f, 221.77167f, 233.8502f, 245.42757f, 256.41565f, 266.73087f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575794f, 47.185196f, 55.64771f, 64.95841f, 75.05333f, 85.85563f, 97.28309f, 109.24876f, 121.66155f, 134.42702f, 147.44798f, 160.62537f, 173.85887f, 187.04779f, 200.09175f, 212.89146f, 225.34953f, 237.37112f, 248.86478f, 259.74298f, 269.92297f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.779625f, 48.66091f, 57.400517f, 66.97995f, 77.3282f, 88.36652f, 100.0109f, 112.17272f, 124.75942f, 137.6752f, 150.82178f, 164.09909f, 177.4061f, 190.64151f, 203.7046f, 216.49597f, 228.91824f, 240.8769f, 252.28093f, 263.04352f, 273.08276f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.73314f, 49.78379f, 58.695175f, 68.43813f, 78.93881f, 90.1173f, 101.88853f, 114.1629f, 126.84701f, 139.84431f, 153.0559f, 166.38123f, 179.71886f, 192.96732f, 206.02576f, 218.79478f, 231.17725f, 243.07889f, 254.40913f, 265.08176f, 275.01553f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.711613f, 50.931904f, 60.01499f, 69.919914f, 80.57128f, 91.88804f, 103.78405f, 116.168785f, 128.94798f, 142.0244f, 155.2985f, 168.66927f, 182.03494f, 195.2938f, 208.34494f, 221.08902f, 233.42908f, 245.27116f, 256.52518f, 267.10547f, 276.9315f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.298367f, 51.58305f, 60.730255f, 70.69385f, 81.398f, 92.761246f, 104.697105f, 117.11473f, 129.91963f, 143.01434f, 156.29921f, 169.67313f, 183.03432f, 196.28108f, 209.3126f, 222.02972f, 234.33565f, 246.1367f, 257.3431f, 267.86954f, 277.63593f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.889774f, 52.239185f, 61.450115f, 71.471954f, 82.22843f, 93.63768f, 105.61287f, 118.06287f, 130.89291f, 144.00537f, 157.30043f, 170.67693f, 184.03305f, 197.26717f, 210.27852f, 222.96812f, 235.23938f, 246.9989f, 258.1572f, 268.62933f, 278.33563f}}};
        this.lut_x0 = newlut_x;
    }

    /*
     * Opcode count of 20224 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initXTable1() {
        float[][][] newlut_x = new float[][][]{new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.93912f, 72.67252f, 76.10099f, 80.27513f, 85.238686f, 91.00988f, 97.54967f, 104.80828f, 112.73048f, 121.25597f, 130.31985f, 139.85316f, 149.78336f, 160.03482f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.12037f, 72.44086f, 76.4813f, 81.28645f, 86.89523f, 93.30362f, 100.46314f, 108.31932f, 116.81236f, 125.877625f, 135.44612f, 145.44502f, 155.79823f, 166.42696f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.05742f, 68.27453f, 72.18972f, 76.848694f, 82.29272f, 88.55219f, 95.59897f, 103.37942f, 111.83431f, 120.89933f, 130.50546f, 140.57959f, 151.04507f, 161.82225f, 172.82909f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.911724f, 67.63778f, 72.08322f, 77.29121f, 83.298515f, 90.12305f, 97.722916f, 106.0403f, 115.01188f, 124.56939f, 134.64009f, 145.14732f, 156.01114f, 167.14886f, 178.47571f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.60789f, 70.35746f, 74.8197f, 80.03737f, 86.046265f, 92.85665f, 100.421585f, 108.68348f, 117.57947f, 127.04183f, 136.99858f, 147.37392f, 158.08888f, 169.06194f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.31172f, 70.68509f, 75.797264f, 81.68482f, 88.37846f, 95.86071f, 104.07463f, 112.95772f, 122.44236f, 132.45639f, 142.92357f, 153.76425f, 164.89594f, 176.2339f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.807514f, 66.08971f, 71.09757f, 76.86918f, 83.437775f, 90.819725f, 98.97172f, 107.83172f, 117.33228f, 127.401115f, 137.9616f, 148.93332f, 160.23282f, 171.7741f, 183.46928f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.279045f, 66.105675f, 71.681526f, 78.040344f, 85.20923f, 93.187126f, 101.91705f, 111.33256f, 121.362f, 131.92903f, 142.95325f, 154.35072f, 166.03474f, 177.91638f, 189.9052f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.461105f, 69.30694f, 74.896576f, 81.26297f, 88.43318f, 96.3913f, 105.07705f, 114.42434f, 124.36203f, 134.81448f, 145.70215f, 156.94217f, 168.449f, 180.13507f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.22278f, 65.004684f, 70.52052f, 76.8045f, 83.88595f, 91.77735f, 100.4315f, 109.78255f, 119.75932f, 130.28589f, 141.28214f, 152.66437f, 164.34598f, 176.23805f, 188.25009f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.297836f, 65.73498f, 71.93581f, 78.92862f, 86.73571f, 95.342705f, 104.68532f, 114.69245f, 125.28794f, 136.39114f, 147.91757f, 159.7795f, 171.88663f, 184.14684f, 196.46681f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.414444f, 60.68914f, 66.71783f, 73.53011f, 81.1506f, 89.59396f, 98.8167f, 108.74862f, 119.31413f, 130.43283f, 142.0201f, 153.98773f, 166.24466f, 178.69762f, 191.2518f, 203.81168f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.997074f, 64.297104f, 70.34772f, 77.180176f, 84.8183f, 93.26452f, 102.46218f, 112.34128f, 122.82662f, 133.83842f, 145.29286f, 157.10278f, 169.17828f, 181.42747f, 193.75713f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.79307f, 60.04344f, 66.04175f, 72.817856f, 80.3957f, 88.79304f, 97.97585f, 107.874245f, 118.41288f, 129.51157f, 141.08582f, 153.04756f, 165.30576f, 177.76712f, 190.33679f, 202.91913f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.45503f, 61.39134f, 68.10438f, 75.62023f, 83.95726f, 93.11039f, 103.016136f, 113.5991f, 124.77874f, 136.46997f, 148.58383f, 161.0281f, 173.7081f, 186.5273f, 199.38815f, 212.19278f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.5884f, 97.388664f, 107.90897f, 119.06926f, 130.7846f, 142.96582f, 155.52023f, 168.35226f, 181.36427f, 194.45723f, 207.5315f, 220.48753f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.629494f, 60.452164f, 67.04707f, 74.44073f, 82.65359f, 91.687675f, 101.48519f, 111.97159f, 123.06705f, 134.68713f, 146.7434f, 159.14409f, 171.79485f, 184.59937f, 197.46022f, 210.27951f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.5884f, 97.388664f, 107.90897f, 119.06926f, 130.7846f, 142.96582f, 155.52023f, 168.35226f, 181.36427f, 194.45723f, 207.5315f, 220.48753f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.27852f, 58.78825f, 66.09871f, 74.230965f, 83.19864f, 92.98947f, 103.533844f, 114.75149f, 126.557045f, 138.86067f, 151.56871f, 164.58446f, 177.80885f, 191.14125f, 204.48018f, 217.72414f, 230.77231f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904633f, 54.272987f, 61.440506f, 69.42815f, 78.251076f, 87.91623f, 98.37352f, 109.543365f, 121.34075f, 133.6759f, 146.45493f, 159.58058f, 172.95297f, 186.47032f, 200.02975f, 213.52808f, 226.86255f, 239.9317f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.587276f, 56.603016f, 64.44029f, 73.11565f, 82.63855f, 92.990036f, 104.09504f, 115.86906f, 128.22247f, 141.06128f, 154.28775f, 167.80124f, 181.4989f, 195.27647f, 209.02913f, 222.65216f, 236.04192f, 249.0965f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.77125f, 51.538723f, 59.124344f, 67.545876f, 76.81504f, 86.93586f, 97.856285f, 109.4932f, 121.75804f, 134.55746f, 147.79407f, 161.3671f, 175.17326f, 189.1075f, 203.06374f, 216.93578f, 230.61804f, 244.0064f, 256.99896f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.413273f, 53.74072f, 61.903122f, 70.91553f, 80.78492f, 91.49456f, 102.9691f, 115.12123f, 127.858444f, 141.08382f, 154.6967f, 168.59348f, 182.6684f, 196.81433f, 210.92363f, 224.8889f, 238.60387f, 251.96416f, 264.86807f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.182247f, 55.983475f, 64.63174f, 74.13671f, 84.50156f, 95.68436f, 107.60018f, 120.15833f, 133.26324f, 146.81519f, 160.71101f, 174.84496f, 189.10947f, 203.39598f, 217.59575f, 231.60072f, 245.30432f, 258.60223f, 271.39328f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.68929f, 50.12591f, 58.406048f, 67.54249f, 77.543015f, 88.399704f, 100.04485f, 112.38984f, 125.340706f, 138.79889f, 152.66197f, 166.82443f, 181.1785f, 195.61491f, 210.02383f, 224.29556f, 238.32152f, 251.99493f, 265.21176f, 277.8714f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.175884f, 51.984997f, 60.64661f, 70.171524f, 80.56273f, 91.79717f, 103.79422f, 116.46257f, 129.7058f, 143.42313f, 157.51016f, 171.85968f, 186.36247f, 200.90817f, 215.38608f, 229.686f, 243.69911f, 257.31876f, 270.44128f, 282.96683f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.771122f, 53.957035f, 63.00358f, 72.917404f, 83.69855f, 95.303635f, 107.64463f, 120.627625f, 134.15381f, 148.12024f, 162.42061f, 176.9461f, 191.58618f, 206.22939f, 220.76431f, 235.08032f, 249.06845f, 262.62225f, 275.6386f, 288.0184f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575794f, 47.185196f, 55.64771f, 64.97442f, 75.17033f, 86.231895f, 98.09843f, 110.6796f, 123.87968f, 137.59819f, 151.73073f, 166.16974f, 180.80534f, 195.52614f, 210.2201f, 224.77539f, 239.08125f, 253.02878f, 266.51184f, 279.42786f, 291.67847f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.779625f, 48.66091f, 57.400517f, 67.00811f, 77.48774f, 88.826004f, 100.94949f, 113.76592f, 127.17777f, 141.08295f, 155.37564f, 169.94705f, 184.68633f, 199.48123f, 214.21922f, 228.7881f, 243.07701f, 256.97717f, 270.38284f, 283.19196f, 295.30704f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.73314f, 49.78379f, 58.69548f, 68.4777f, 79.13181f, 90.6373f, 102.91422f, 115.86914f, 129.40346f, 143.41418f, 157.79466f, 172.43547f, 187.22517f, 202.05122f, 216.80078f, 231.36157f, 245.6228f, 259.47595f, 272.81555f, 285.5401f, 297.55273f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.711613f, 50.931904f, 60.016895f, 69.97363f, 80.80183f, 92.47258f, 104.900795f, 117.99188f, 131.64622f, 145.75989f, 160.22548f, 174.93288f, 189.77017f, 204.62445f, 219.38263f, 233.93242f, 248.16309f, 261.9663f, 275.23703f, 287.8743f, 299.7819f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.298367f, 51.58305f, 60.733475f, 70.75566f, 81.64884f, 93.37956f, 105.86084f, 118.99769f, 132.69012f, 146.83395f, 161.32152f, 176.04257f, 190.88507f, 205.73604f, 220.48248f, 235.01215f, 249.21448f, 262.98135f, 276.20804f, 288.79382f, 300.64297f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.889774f, 52.239185f, 61.454987f, 71.54255f, 82.50059f, 94.29077f, 106.82458f, 120.00662f, 133.73659f, 147.90996f, 162.41888f, 177.15294f, 192.0f, 206.84706f, 221.58112f, 236.09004f, 250.26341f, 263.99338f, 277.1754f, 289.70923f, 301.49942f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.93912f, 72.67252f, 76.10099f, 80.27513f, 85.238686f, 91.029366f, 97.679825f, 105.21128f, 113.58591f, 122.73997f, 132.60379f, 143.10231f, 154.15562f, 165.67961f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.12037f, 72.44086f, 76.4813f, 81.28645f, 86.89554f, 93.34319f, 100.65614f, 108.839325f, 117.83806f, 127.58386f, 138.00256f, 149.01488f, 160.537f, 172.48122f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.05742f, 68.27453f, 72.18972f, 76.848694f, 82.29272f, 88.55707f, 95.66956f, 103.65158f, 112.48741f, 122.11104f, 132.44922f, 143.42326f, 154.94968f, 166.9407f, 179.3051f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.911724f, 67.63778f, 72.08322f, 77.29121f, 83.298515f, 90.13494f, 97.82397f, 106.38251f, 115.7753f, 125.93087f, 136.77191f, 148.21594f, 160.17584f, 172.5606f, 185.27594f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.60789f, 70.35746f, 74.8197f, 80.03737f, 86.046265f, 92.87614f, 100.551735f, 109.08648f, 118.43489f, 128.52583f, 139.28252f, 150.62306f, 162.46117f, 174.70673f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.31172f, 70.68509f, 75.797264f, 81.68482f, 88.379395f, 95.90701f, 104.28589f, 113.50948f, 123.51309f, 134.22058f, 145.55046f, 157.4165f, 169.7284f, 182.39246f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.807514f, 66.08971f, 71.09757f, 76.86918f, 83.437775f, 90.82893f, 99.06192f, 108.14956f, 118.05793f, 128.7117f, 140.02979f, 151.92606f, 164.30997f, 177.08727f, 190.1607f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.279045f, 66.105675f, 71.681526f, 78.040344f, 85.20923f, 93.209206f, 102.05655f, 111.75394f, 122.244705f, 133.449f, 145.28157f, 157.65234f, 170.46718f, 183.62856f, 197.03629f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.461105f, 69.30694f, 74.896576f, 81.26297f, 88.43349f, 96.43087f, 105.27005f, 114.94434f, 125.387726f, 136.52072f, 148.2586f, 160.51204f, 173.18777f, 186.18933f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.22278f, 65.004684f, 70.52052f, 76.8045f, 83.88595f, 91.78656f, 100.521706f, 110.100395f, 120.48497f, 131.59647f, 143.35033f, 155.6571f, 168.42311f, 181.55122f, 194.9415f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.297836f, 65.73498f, 71.93581f, 78.92862f, 86.73571f, 95.37437f, 104.85555f, 115.17165f, 126.25512f, 138.0216f, 150.38155f, 163.24089f, 176.50175f, 190.06322f, 203.8221f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.414444f, 60.68914f, 66.71783f, 73.53011f, 81.1506f, 89.59824f, 98.88429f, 109.013565f, 119.95553f, 131.62845f, 143.94348f, 156.80692f, 170.12083f, 183.78394f, 197.6922f, 211.73982f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.997074f, 64.297104f, 70.34772f, 77.180176f, 84.8183f, 93.27944f, 102.57502f, 112.70886f, 123.628815f, 135.25177f, 147.48926f, 160.24817f, 173.43137f, 186.93855f, 200.66692f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.79307f, 60.04344f, 66.04175f, 72.817856f, 80.3957f, 88.79458f, 98.027016f, 108.09824f, 118.98639f, 130.61285f, 142.88918f, 155.72192f, 169.01341f, 182.66249f, 196.56529f, 210.61601f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.45503f, 61.39134f, 68.10438f, 75.62023f, 83.95726f, 93.12752f, 103.137405f, 113.98416f, 125.60732f, 137.91843f, 150.82379f, 164.22517f, 178.02058f, 192.10506f, 206.37138f, 220.71098f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.63184f, 131.87056f, 144.74956f, 158.1708f, 172.03217f, 186.22815f, 200.65073f, 215.19011f, 229.73566f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.629494f, 60.452164f, 67.04707f, 74.44073f, 82.65359f, 91.69864f, 101.582535f, 112.305565f, 123.81777f, 136.03154f, 148.85391f, 162.18732f, 175.93025f, 189.97815f, 204.22409f, 218.55966f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.63184f, 131.87056f, 144.74956f, 158.1708f, 172.03217f, 186.22815f, 200.65073f, 215.19011f, 229.73566f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.27852f, 58.78825f, 66.09871f, 74.230965f, 83.19864f, 93.008965f, 103.663994f, 115.15449f, 127.412476f, 140.34467f, 153.85265f, 167.8336f, 182.18112f, 196.78604f, 211.53717f, 226.32228f, 241.02882f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904633f, 54.272987f, 61.440506f, 69.42815f, 78.251076f, 87.91944f, 98.43533f, 109.794205f, 121.95907f, 134.83965f, 148.33789f, 162.35109f, 176.77258f, 191.49263f, 206.39919f, 221.37881f, 236.3175f, 251.10158f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.587276f, 56.603016f, 64.44029f, 73.11565f, 82.63855f, 93.01211f, 104.23453f, 116.29043f, 129.10518f, 142.58125f, 156.61607f, 171.10286f, 185.93134f, 200.98865f, 216.1602f, 231.33055f, 246.38422f, 261.20663f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.77125f, 51.538723f, 59.124344f, 67.545876f, 76.81504f, 86.93861f, 97.91533f, 109.73717f, 122.36499f, 135.70543f, 149.65697f, 164.1134f, 178.96474f, 194.09793f, 209.39781f, 224.74794f, 240.0315f, 255.13214f, 269.935f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.413273f, 53.74072f, 61.903122f, 70.91553f, 80.78492f, 91.51169f, 103.09037f, 115.506294f, 128.68704f, 142.53229f, 156.93666f, 171.79054f, 186.9809f, 202.39209f, 217.90686f, 233.4071f, 248.77487f, 263.89322f, 278.64706f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.182247f, 55.983475f, 64.63174f, 74.13671f, 84.50203f, 95.7261f, 107.79916f, 120.68881f, 134.30385f, 148.54063f, 163.29083f, 178.44218f, 193.87938f, 209.48491f, 225.14003f, 240.72559f, 256.12296f, 271.215f, 285.88678f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.68929f, 50.12591f, 58.406048f, 67.54249f, 77.543015f, 88.40732f, 100.12822f, 112.69201f, 126.041725f, 140.07608f, 154.68826f, 169.76707f, 185.19774f, 200.86282f, 216.64311f, 232.41852f, 248.06895f, 263.47534f, 278.5204f, 293.08963f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.175884f, 51.984997f, 60.64661f, 70.171524f, 80.56273f, 91.816666f, 103.92438f, 116.86557f, 130.56123f, 144.90714f, 159.7941f, 175.10883f, 190.73476f, 206.55296f, 222.44307f, 238.28415f, 253.95563f, 269.33826f, 284.3149f, 298.7717f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.771122f, 53.957035f, 63.00358f, 72.917404f, 83.69885f, 95.3432f, 107.83763f, 121.14763f, 135.1795f, 149.82648f, 164.97707f, 180.51598f, 196.32494f, 212.28365f, 228.27063f, 244.16423f, 259.84348f, 275.18906f, 290.08417f, 304.41547f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575794f, 47.185196f, 55.64771f, 64.97442f, 75.17033f, 86.235115f, 98.16024f, 110.93045f, 124.49799f, 138.76192f, 153.61368f, 168.94025f, 184.62495f, 200.54845f, 216.58954f, 232.62614f, 248.53621f, 264.19864f, 279.4943f, 294.30667f, 308.5231f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.779625f, 48.66091f, 57.400517f, 67.00811f, 77.48774f, 88.83522f, 101.039696f, 114.08377f, 127.90342f, 142.39354f, 157.44383f, 172.93979f, 188.76346f, 204.7944f, 220.91064f, 236.9895f, 252.90862f, 268.54684f, 283.78516f, 298.50757f, 312.60205f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.73314f, 49.78379f, 58.69548f, 68.4777f, 79.13181f, 90.65222f, 103.02706f, 116.236725f, 130.20566f, 144.82753f, 159.99106f, 175.58086f, 191.47827f, 207.5623f, 223.71056f, 239.80014f, 255.70857f, 271.3148f, 286.50006f, 301.14877f, 315.14944f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.711613f, 50.931904f, 60.016895f, 69.97363f, 80.80183f, 92.49465f, 105.04028f, 118.41326f, 132.52893f, 147.27986f, 162.5538f, 178.2345f, 194.2026f, 210.33661f, 226.51372f, 242.61081f, 258.50537f, 274.07645f, 289.20554f, 303.77747f, 317.68137f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.298367f, 51.58305f, 60.733475f, 70.75566f, 81.64884f, 93.40609f, 106.0152f, 119.44748f, 133.61458f, 148.40869f, 163.71721f, 179.42363f, 195.40843f, 211.54993f, 227.7253f, 243.81143f, 259.6859f, 275.2279f, 290.31915f, 304.8448f, 318.69424f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.889774f, 52.239185f, 61.454987f, 71.54255f, 82.50059f, 94.32243f, 106.99482f, 120.48583f, 134.70377f, 149.54042f, 164.88286f, 180.61433f, 196.61513f, 212.76344f, 228.93639f, 245.01088f, 260.8646f, 276.37683f, 291.4296f, 305.9083f, 319.70273f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.93912f, 72.67252f, 76.10099f, 80.27513f, 85.238686f, 91.029366f, 97.679825f, 105.216156f, 113.6565f, 123.01213f, 133.25688f, 144.31403f, 156.0994f, 168.52328f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.12037f, 72.44086f, 76.4813f, 81.28645f, 86.89554f, 93.34319f, 100.65614f, 108.85425f, 117.9509f, 127.95145f, 138.80476f, 150.42822f, 162.73338f, 175.6266f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.05742f, 68.27453f, 72.18972f, 76.848694f, 82.29272f, 88.55707f, 95.66956f, 103.65158f, 112.51907f, 122.28127f, 132.92842f, 144.39046f, 156.58012f, 169.40468f, 182.7665f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.911724f, 67.63778f, 72.08322f, 77.29121f, 83.298515f, 90.13494f, 97.82397f, 106.38405f, 115.82647f, 126.15487f, 137.34541f, 149.31723f, 161.9792f, 175.23494f, 188.9836f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.60789f, 70.35746f, 74.8197f, 80.03737f, 86.046265f, 92.87614f, 100.551735f, 109.09135f, 118.505486f, 128.798f, 139.93561f, 151.83476f, 164.40492f, 177.5504f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.31172f, 70.68509f, 75.797264f, 81.68482f, 88.379395f, 95.90701f, 104.28589f, 113.52777f, 123.63875f, 134.61455f, 146.39241f, 158.88268f, 171.9903f, 185.61551f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.807514f, 66.08971f, 71.09757f, 76.86918f, 83.437775f, 90.82893f, 99.06192f, 108.150246f, 118.10191f, 128.91676f, 140.57086f, 152.98166f, 166.05473f, 179.69057f, 193.7854f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.279045f, 66.105675f, 71.681526f, 78.040344f, 85.20923f, 93.209206f, 102.05655f, 111.76011f, 122.32153f, 133.73595f, 145.9584f, 158.89658f, 172.45201f, 186.5215f, 200.99802f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.461105f, 69.30694f, 74.896576f, 81.26297f, 88.43349f, 96.43087f, 105.27005f, 114.95926f, 125.500565f, 136.8883f, 149.06079f, 161.92538f, 175.38417f, 189.33472f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.22278f, 65.004684f, 70.52052f, 76.8045f, 83.88595f, 91.78656f, 100.521706f, 110.10108f, 120.52895f, 131.80153f, 143.8914f, 156.7127f, 170.1679f, 184.15453f, 198.5662f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.297836f, 65.73498f, 71.93581f, 78.92862f, 86.73571f, 95.37437f, 104.85555f, 115.18262f, 126.35246f, 138.35558f, 151.13226f, 164.5853f, 178.61226f, 193.10645f, 207.9575f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.414444f, 60.68914f, 66.71783f, 73.53011f, 81.1506f, 89.59824f, 98.88429f, 109.013565f, 119.9854f, 131.79327f, 144.41277f, 157.75974f, 171.7326f, 186.22504f, 201.12672f, 216.32426f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.997074f, 64.297104f, 70.34772f, 77.180176f, 84.8183f, 93.27944f, 102.57502f, 112.7116f, 123.68785f, 135.49573f, 148.0962f, 161.39613f, 175.29427f, 189.68486f, 204.45839f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.79307f, 60.04344f, 66.04175f, 72.817856f, 80.3957f, 88.79458f, 98.027016f, 108.09824f, 119.007126f, 130.74762f, 143.30132f, 156.59093f, 170.51534f, 184.96858f, 199.84064f, 215.01833f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.45503f, 61.39134f, 68.10438f, 75.62023f, 83.95726f, 93.12752f, 103.137405f, 113.98789f, 125.67199f, 138.17627f, 151.45358f, 165.40479f, 179.9237f, 194.89984f, 210.21922f, 225.76524f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.65133f, 132.00072f, 145.15254f, 159.02623f, 173.51617f, 188.51208f, 203.89987f, 219.5624f, 235.38045f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.629494f, 60.452164f, 67.04707f, 74.44073f, 82.65359f, 91.69864f, 101.582535f, 112.306786f, 123.86647f, 136.24911f, 149.41649f, 163.27327f, 177.71397f, 192.62872f, 207.90399f, 223.42354f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.65133f, 132.00072f, 145.15254f, 159.02623f, 173.51617f, 188.51208f, 203.89987f, 219.5624f, 235.38045f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.27852f, 58.78825f, 66.09871f, 74.230965f, 83.19864f, 93.008965f, 103.663994f, 115.15936f, 127.48307f, 140.61684f, 154.50574f, 169.0453f, 184.12488f, 199.6297f, 215.44177f, 231.44073f, 247.50485f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904633f, 54.272987f, 61.440506f, 69.42815f, 78.251076f, 87.91944f, 98.43533f, 109.794205f, 121.985596f, 134.99399f, 148.78767f, 163.27554f, 178.34732f, 193.88832f, 209.78026f, 225.90218f, 242.1314f, 258.3444f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.587276f, 56.603016f, 64.44029f, 73.11565f, 82.63855f, 93.01211f, 104.23453f, 116.2966f, 129.182f, 142.8682f, 157.29292f, 172.34709f, 187.91615f, 203.8816f, 220.12193f, 236.51355f, 252.9317f, 269.25143f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.77125f, 51.538723f, 59.124344f, 67.545876f, 76.81504f, 86.93861f, 97.91533f, 109.73717f, 122.38995f, 135.85472f, 150.09717f, 165.02383f, 180.52112f, 196.47107f, 212.75229f, 229.2409f, 245.81139f, 262.33765f, 278.6939f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.413273f, 53.74072f, 61.903122f, 70.91553f, 80.78492f, 91.51169f, 103.09037f, 115.510025f, 128.75171f, 142.79012f, 157.56645f, 172.97017f, 188.88402f, 205.18687f, 221.7547f, 238.46138f, 255.17976f, 271.78262f, 288.1436f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.182247f, 55.983475f, 64.63174f, 74.13671f, 84.50203f, 95.7261f, 107.79916f, 120.70482f, 134.42085f, 148.91692f, 164.10617f, 179.87303f, 196.0975f, 212.65608f, 229.42278f, 246.26997f, 263.06943f, 279.69333f, 296.01514f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.68929f, 50.12591f, 58.406048f, 67.54249f, 77.543015f, 88.40732f, 100.12822f, 112.692314f, 126.0813f, 140.26909f, 155.20827f, 170.79277f, 186.90398f, 203.41928f, 220.21298f, 237.15727f, 254.12321f, 270.98166f, 287.6043f, 303.86465f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.175884f, 51.984997f, 60.64661f, 70.171524f, 80.56273f, 91.816666f, 103.92438f, 116.87044f, 130.63182f, 145.17929f, 160.44719f, 176.32053f, 192.67851f, 209.39664f, 226.34767f, 243.4026f, 260.43164f, 277.3052f, 293.8948f, 310.07428f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.771122f, 53.957035f, 63.00358f, 72.917404f, 83.69885f, 95.3432f, 107.83763f, 121.16255f, 135.29234f, 150.19406f, 165.77927f, 181.92932f, 198.52133f, 215.42903f, 232.52373f, 249.67531f, 266.75327f, 283.62762f, 300.16992f, 316.2543f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575794f, 47.185196f, 55.64771f, 64.97442f, 75.17033f, 86.235115f, 98.16024f, 110.93045f, 124.52452f, 138.91628f, 154.06348f, 169.8647f, 186.19969f, 202.94414f, 219.9706f, 237.1495f, 254.3501f, 271.44147f, 288.29358f, 304.7781f, 320.76965f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.779625f, 48.66091f, 57.400517f, 67.00811f, 77.48774f, 88.83522f, 101.039696f, 114.08446f, 127.9474f, 142.59859f, 157.98491f, 173.99539f, 190.50822f, 207.39772f, 224.53532f, 241.79063f, 259.03232f, 276.12915f, 292.95102f, 309.3699f, 325.26083f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.73314f, 49.78379f, 58.69548f, 68.4777f, 79.13181f, 90.65222f, 103.02706f, 116.23947f, 130.2647f, 145.07149f, 160.598f, 176.72882f, 193.34117f, 210.30862f, 227.50204f, 244.79057f, 262.04266f, 279.12698f, 295.9135f, 312.2745f, 328.08545f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.711613f, 50.931904f, 60.016895f, 69.97363f, 80.80183f, 92.49465f, 105.04028f, 118.419426f, 132.60576f, 147.5668f, 163.23064f, 179.47873f, 196.18742f, 213.22957f, 230.47545f, 247.79381f, 265.05286f, 282.12125f, 298.86905f, 315.16882f, 330.89655f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.298367f, 51.58305f, 60.733475f, 70.75566f, 81.64884f, 93.40609f, 106.0152f, 119.45587f, 133.70132f, 148.71864f, 164.4305f, 180.71747f, 197.45563f, 214.51756f, 231.77344f, 249.09193f, 266.34122f, 283.39005f, 300.10864f, 316.36978f, 332.04968f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.889774f, 52.239185f, 61.454987f, 71.54255f, 82.50059f, 94.32243f, 106.99482f, 120.496796f, 134.8011f, 149.87439f, 165.63358f, 181.95874f, 198.72563f, 215.80666f, 233.0718f, 250.38966f, 267.62848f, 284.65698f, 301.34564f, 317.56744f, 333.19888f}}, new float[][]{{72.0f, 71.999084f, 71.96698f, 71.871346f, 71.69686f, 71.43404f, 71.08419f, 70.649994f, 70.13854f, 69.55772f, 68.921486f, 68.24249f, 67.542984f, 66.84406f, 66.17377f, 65.567314f, 65.06606f, 64.72133f, 64.60002f, 64.77858f, 65.33113f, 66.330185f, 67.844864f, 69.93912f, 72.67252f, 76.10099f, 80.27513f, 85.238686f, 91.029366f, 97.679825f, 105.216156f, 113.6565f, 123.01213f, 133.28854f, 144.48425f, 156.5786f, 169.49048f}, {66.5f, 66.49967f, 66.47352f, 66.393684f, 66.2449f, 66.01974f, 65.71924f, 65.34841f, 64.913666f, 64.42602f, 63.898975f, 63.34794f, 62.796658f, 62.26841f, 61.79434f, 61.413338f, 61.172707f, 61.13271f, 61.365376f, 61.944748f, 62.943726f, 64.43052f, 66.4693f, 69.12037f, 72.44086f, 76.4813f, 81.28645f, 86.89554f, 93.34319f, 100.65614f, 108.85425f, 117.9509f, 127.95419f, 138.8638f, 150.6722f, 163.34033f, 176.77457f}, {61.0f, 60.999954f, 60.979023f, 60.912895f, 60.786762f, 60.5959f, 60.340225f, 60.027317f, 59.66323f, 59.26211f, 58.836803f, 58.406242f, 57.99557f, 57.630787f, 57.34677f, 57.187145f, 57.206707f, 57.475243f, 58.067413f, 59.055428f, 60.50727f, 62.487385f, 65.05742f, 68.27453f, 72.18972f, 76.848694f, 82.29272f, 88.55707f, 95.66956f, 103.65158f, 112.51907f, 122.28127f, 132.93939f, 144.4878f, 156.91411f, 170.1554f, 184.1109f}, {56.0f, 56.0f, 55.983723f, 55.92931f, 55.823322f, 55.663414f, 55.449043f, 55.188576f, 54.88963f, 54.568157f, 54.237476f, 53.919872f, 53.642063f, 53.433403f, 53.333176f, 53.390938f, 53.669384f, 54.241657f, 55.17984f, 56.55228f, 58.424057f, 60.857903f, 63.911724f, 67.63778f, 72.08322f, 77.29121f, 83.298515f, 90.13494f, 97.82397f, 106.38405f, 115.82647f, 126.15487f, 137.36617f, 149.452f, 162.39133f, 176.10396f, 190.48552f}, {58.0f, 58.0f, 57.98767f, 57.943237f, 57.85548f, 57.72316f, 57.54728f, 57.33162f, 57.08284f, 56.809853f, 56.523792f, 56.242542f, 55.982124f, 55.767853f, 55.629795f, 55.60333f, 55.7333f, 56.07955f, 56.715008f, 57.71033f, 59.133446f, 61.050236f, 63.522823f, 66.60789f, 70.35746f, 74.8197f, 80.03737f, 86.046265f, 92.87614f, 100.551735f, 109.09135f, 118.505486f, 128.798f, 139.96727f, 152.005f, 164.88412f, 178.51758f}, {53.0f, 53.0f, 52.990932f, 52.955006f, 52.88378f, 52.77602f, 52.63537f, 52.465656f, 52.27648f, 52.077267f, 51.88195f, 51.710484f, 51.581947f, 51.52466f, 51.573074f, 51.769535f, 52.16907f, 52.839474f, 53.851147f, 55.272808f, 57.170628f, 59.60567f, 62.63491f, 66.31172f, 70.68509f, 75.797264f, 81.68482f, 88.379395f, 95.90701f, 104.28589f, 113.52777f, 123.63875f, 134.61884f, 146.46f, 159.14761f, 172.63168f, 186.81111f}, {48.0f, 48.0f, 47.993576f, 47.96493f, 47.908546f, 47.822884f, 47.714127f, 47.58662f, 47.452744f, 47.322727f, 47.21358f, 47.147522f, 47.147366f, 47.245205f, 47.48118f, 47.906303f, 48.586643f, 49.5932f, 50.995483f, 52.858395f, 55.24325f, 58.20809f, 61.807514f, 66.08971f, 71.09757f, 76.86918f, 83.437775f, 90.82893f, 99.06192f, 108.150246f, 118.10191f, 128.91676f, 140.58798f, 153.10294f, 166.4398f, 180.51917f, 195.23386f}, {43.5f, 43.5f, 43.495663f, 43.473335f, 43.430096f, 43.364643f, 43.284435f, 43.195618f, 43.11271f, 43.04736f, 43.019764f, 43.054688f, 43.1794f, 43.43071f, 43.855827f, 44.515053f, 45.478966f, 46.816418f, 48.592724f, 50.869938f, 53.707905f, 57.1612f, 61.279045f, 66.105675f, 71.681526f, 78.040344f, 85.20923f, 93.209206f, 102.05655f, 111.76011f, 122.32153f, 133.73602f, 145.99387f, 159.07797f, 172.95139f, 187.51773f, 202.66615f}, {46.0f, 46.0f, 45.997257f, 45.980537f, 45.948742f, 45.902115f, 45.844093f, 45.77963f, 45.717583f, 45.6667f, 45.643967f, 45.66413f, 45.75017f, 45.930714f, 46.239952f, 46.721504f, 47.434406f, 48.44873f, 49.832253f, 51.65025f, 53.966206f, 56.8383f, 60.320164f, 64.461105f, 69.30694f, 74.896576f, 81.26297f, 88.43349f, 96.43087f, 105.27005f, 114.95926f, 125.500565f, 136.89105f, 149.11983f, 162.16934f, 175.99112f, 190.48268f}, {41.5f, 41.5f, 41.498425f, 41.486736f, 41.4648f, 41.435406f, 41.40278f, 41.374542f, 41.36151f, 41.374767f, 41.434044f, 41.558743f, 41.77485f, 42.11651f, 42.626186f, 43.35919f, 44.38202f, 45.76306f, 47.568977f, 49.8616f, 52.69898f, 56.1357f, 60.22278f, 65.004684f, 70.52052f, 76.8045f, 83.88595f, 91.78656f, 100.521706f, 110.10108f, 120.52895f, 131.80153f, 143.90852f, 156.83398f, 170.55295f, 184.98312f, 200.01465f}, {37.0f, 37.0f, 36.99923f, 36.992004f, 36.978603f, 36.964752f, 36.955452f, 36.961266f, 36.995125f, 37.07088f, 37.21097f, 37.440598f, 37.789917f, 38.299908f, 39.023315f, 40.028137f, 41.38344f, 43.154408f, 45.40306f, 48.189f, 51.567734f, 55.589046f, 60.297836f, 65.73498f, 71.93581f, 78.92862f, 86.73571f, 95.37437f, 104.85555f, 115.18262f, 126.35246f, 138.3568f, 151.18097f, 164.80287f, 179.17485f, 194.1924f, 209.74123f}, {33.0f, 33.0f, 32.999733f, 32.996407f, 32.990456f, 32.990463f, 33.002487f, 33.04016f, 33.118782f, 33.255436f, 33.47588f, 33.810448f, 34.296604f, 34.983994f, 35.936657f, 37.222843f, 38.90826f, 41.056515f, 43.72823f, 46.97859f, 50.85836f, 55.414444f, 60.68914f, 66.71783f, 73.53011f, 81.1506f, 89.59824f, 98.88429f, 109.013565f, 119.9854f, 131.79327f, 144.42284f, 157.85347f, 172.05847f, 186.96317f, 202.45416f, 218.41356f}, {36.0f, 36.0f, 36.0f, 36.0f, 36.000343f, 36.006428f, 36.021618f, 36.05717f, 36.121544f, 36.23055f, 36.404163f, 36.66299f, 37.037075f, 37.56386f, 38.291397f, 39.282784f, 40.606274f, 42.32912f, 44.514015f, 47.219822f, 50.50176f, 54.41216f, 58.997074f, 64.297104f, 70.34772f, 77.180176f, 84.8183f, 93.27944f, 102.57502f, 112.7116f, 123.68785f, 135.49573f, 148.12117f, 161.54541f, 175.73448f, 190.59529f, 206.01476f}, {32.0f, 32.0f, 32.000095f, 32.002853f, 32.00991f, 32.029312f, 32.066338f, 32.13496f, 32.24759f, 32.42218f, 32.68324f, 33.05913f, 33.58512f, 34.308506f, 35.29106f, 36.60109f, 38.304127f, 40.46272f, 43.137424f, 46.38431f, 50.254173f, 54.79307f, 60.04344f, 66.04175f, 72.817856f, 80.3957f, 88.79458f, 98.027016f, 108.09824f, 119.007126f, 130.74762f, 143.30681f, 156.6646f, 170.79483f, 185.63348f, 201.06854f, 216.98256f}, {28.0f, 28.0f, 28.000086f, 28.005032f, 28.018234f, 28.050402f, 28.109127f, 28.210896f, 28.373428f, 28.617266f, 28.97189f, 29.473114f, 30.166899f, 31.11452f, 32.384266f, 34.042652f, 36.15423f, 38.7785f, 41.970993f, 45.78359f, 50.264442f, 55.45503f, 61.39134f, 68.10438f, 75.62023f, 83.95726f, 93.12752f, 103.137405f, 113.98789f, 125.67199f, 138.17627f, 151.48175f, 165.56433f, 180.3832f, 195.83844f, 211.81242f, 228.1836f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.65133f, 132.00072f, 145.15742f, 159.09682f, 173.78833f, 189.16519f, 205.11157f, 221.50615f, 238.22412f}, {28.0f, 28.0f, 28.0f, 28.003805f, 28.015364f, 28.044138f, 28.09772f, 28.192766f, 28.344341f, 28.574009f, 28.910133f, 29.38691f, 30.048197f, 30.953262f, 32.17072f, 33.7668f, 35.80607f, 38.349724f, 41.4539f, 45.170475f, 49.54787f, 54.629494f, 60.452164f, 67.04707f, 74.44073f, 82.65359f, 91.69864f, 101.582535f, 112.306786f, 123.86647f, 136.24911f, 149.43599f, 163.40343f, 178.11697f, 193.48415f, 209.388f, 225.70747f}, {24.5f, 24.5f, 24.500032f, 24.506596f, 24.525381f, 24.569754f, 24.650108f, 24.785677f, 24.999437f, 25.31675f, 25.77283f, 26.412655f, 27.294132f, 28.485403f, 30.05412f, 32.063835f, 34.57476f, 37.644497f, 41.326393f, 45.66793f, 50.71156f, 56.495613f, 63.052788f, 70.40867f, 78.58278f, 87.58962f, 97.43736f, 108.12655f, 119.65133f, 132.00072f, 145.15742f, 159.09682f, 173.78833f, 189.16519f, 205.11157f, 221.50615f, 238.22412f}, {21.0f, 21.0f, 21.000172f, 21.010063f, 21.037413f, 21.099075f, 21.210367f, 21.39316f, 21.676178f, 22.094017f, 22.690985f, 23.526838f, 24.67072f, 26.189419f, 28.14809f, 30.608543f, 33.62755f, 37.25763f, 41.54787f, 46.54234f, 52.27852f, 58.78825f, 66.09871f, 74.230965f, 83.19864f, 93.008965f, 103.663994f, 115.15936f, 127.48307f, 140.61684f, 154.5374f, 169.21555f, 184.6041f, 200.5969f, 217.07222f, 233.90471f, 250.96623f}, {18.0f, 18.0f, 18.000483f, 18.01427f, 18.051775f, 18.132685f, 18.279383f, 18.517263f, 18.881805f, 19.417673f, 20.182507f, 21.244156f, 22.671822f, 24.53031f, 26.880976f, 29.781898f, 33.28829f, 37.449123f, 42.308243f, 47.904633f, 54.272987f, 61.440506f, 69.42815f, 78.251076f, 87.91944f, 98.43533f, 109.794205f, 121.985596f, 134.99399f, 148.79607f, 163.36229f, 178.65727f, 194.6016f, 211.07408f, 227.94937f, 245.09903f, 262.39255f}, {15.0f, 15.0f, 15.001028f, 15.019284f, 15.06879f, 15.172427f, 15.358265f, 15.659872f, 16.120161f, 16.797503f, 17.762238f, 19.082523f, 20.823887f, 23.050243f, 25.820831f, 29.190063f, 33.20787f, 37.92085f, 43.369305f, 49.587276f, 56.603016f, 64.44029f, 73.11565f, 82.63855f, 93.01211f, 104.23453f, 116.2966f, 129.182f, 142.86827f, 157.32838f, 172.52849f, 188.41553f, 204.87782f, 221.79007f, 239.02356f, 256.44714f, 273.9282f}, {12.5f, 12.5f, 12.501874f, 12.525167f, 12.588776f, 12.719346f, 12.951168f, 13.326875f, 13.902042f, 14.744023f, 15.922212f, 17.504961f, 19.556028f, 22.135303f, 25.298958f, 29.100235f, 33.586006f, 38.797634f, 44.77125f, 51.538723f, 59.124344f, 67.545876f, 76.81504f, 86.93861f, 97.91533f, 109.73717f, 122.38995f, 135.85472f, 150.10478f, 165.1072f, 180.82329f, 197.17209f, 214.0295f, 231.2672f, 248.75403f, 266.35687f, 283.9418f}, {10.0f, 10.0f, 10.003084f, 10.032028f, 10.112051f, 10.274332f, 10.560828f, 11.025218f, 11.736382f, 12.766074f, 14.182034f, 16.048985f, 18.4289f, 21.380833f, 24.957895f, 29.20836f, 34.176064f, 39.900364f, 46.413273f, 53.74072f, 61.903122f, 70.91553f, 80.78492f, 91.51169f, 103.09037f, 115.510025f, 128.75171f, 142.79012f, 157.59462f, 173.1297f, 189.34349f, 206.12547f, 223.3479f, 240.87971f, 258.5875f, 276.3365f, 293.99155f}, {8.0f, 8.0f, 8.004722f, 8.040627f, 8.138948f, 8.338272f, 8.689612f, 9.259151f, 10.118049f, 11.33527f, 12.977525f, 15.109595f, 17.790926f, 21.076609f, 25.01761f, 29.66122f, 35.047768f, 41.211758f, 48.182247f, 55.983475f, 64.63174f, 74.13671f, 84.50203f, 95.7261f, 107.79916f, 120.70482f, 134.42085f, 148.92014f, 164.16798f, 180.12389f, 196.71582f, 213.81982f, 231.30574f, 249.04047f, 266.88904f, 284.71564f, 302.38458f}, {6.0f, 6.0f, 6.006852f, 6.051458f, 6.171405f, 6.414792f, 6.84559f, 7.536021f, 8.556631f, 9.976975f, 11.862044f, 14.272991f, 17.267271f, 20.899414f, 25.217579f, 30.264404f, 36.07728f, 42.68929f, 50.12591f, 58.406048f, 67.54249f, 77.543015f, 88.40732f, 100.12822f, 112.692314f, 126.0813f, 140.26909f, 155.22319f, 170.90561f, 187.27156f, 204.22147f, 221.62633f, 239.35367f, 257.2686f, 275.23474f, 293.1154f, 310.77444f}, {4.5f, 4.5f, 4.509539f, 4.564839f, 4.711228f, 5.00751f, 5.523836f, 6.332988f, 7.505522f, 9.108013f, 11.203765f, 13.853539f, 17.113884f, 21.035484f, 25.663994f, 31.040901f, 37.201996f, 44.175884f, 51.984997f, 60.64661f, 70.171524f, 80.56273f, 91.816666f, 103.92438f, 116.87044f, 130.63182f, 145.17929f, 160.47885f, 176.49077f, 193.15771f, 210.36382f, 227.97812f, 245.86658f, 263.89304f, 281.92032f, 299.81122f, 317.42957f}, {3.0f, 3.0f, 3.012846f, 3.081089f, 3.25931f, 3.617604f, 4.230565f, 5.169331f, 6.502256f, 8.294998f, 10.611235f, 13.509139f, 17.042156f, 21.2592f, 26.205494f, 31.9192f, 38.43233f, 45.771122f, 53.957035f, 63.00358f, 72.917404f, 83.69885f, 95.3432f, 107.83763f, 121.16255f, 135.29234f, 150.19681f, 165.8383f, 182.1733f, 199.12828f, 216.577f, 234.38663f, 252.42162f, 270.54474f, 288.61804f, 306.504f, 324.06647f}, {2.0f, 2.0f, 2.016838f, 2.100529f, 2.315387f, 2.735897f, 3.434529f, 4.481465f, 5.944711f, 7.890412f, 10.379431f, 13.468322f, 17.209553f, 21.65193f, 26.837315f, 32.801743f, 39.575794f, 47.185196f, 55.64771f, 64.97442f, 75.17033f, 86.235115f, 98.16024f, 110.93045f, 124.52452f, 138.91628f, 154.07187f, 169.95143f, 186.50964f, 203.65741f, 221.26443f, 239.1967f, 257.31772f, 275.48962f, 293.57407f, 311.43344f, 328.9318f}, {1.0f, 1.0f, 1.021579f, 1.124162f, 1.382501f, 1.870204f, 2.659059f, 3.819243f, 5.419096f, 7.522015f, 10.187497f, 13.471437f, 17.42601f, 22.096695f, 27.523443f, 33.74114f, 40.779625f, 48.66091f, 57.400517f, 67.00811f, 77.48774f, 88.83522f, 101.039696f, 114.08446f, 127.9474f, 142.59859f, 158.00203f, 174.11667f, 190.8933f, 208.2263f, 225.9838f, 244.0306f, 262.2294f, 280.44165f, 298.52878f, 316.35315f, 333.77905f}, {0.5f, 0.5f, 0.527436f, 0.65069f, 0.944339f, 1.481647f, 2.334328f, 3.573213f, 5.264675f, 7.47134f, 10.252216f, 13.663461f, 17.754913f, 22.570934f, 28.150675f, 34.52899f, 41.73314f, 49.78379f, 58.69548f, 68.4777f, 79.13181f, 90.65222f, 103.02706f, 116.23947f, 130.2647f, 145.07149f, 160.62297f, 176.87811f, 193.78137f, 211.21904f, 229.05841f, 247.16371f, 265.39713f, 283.61993f, 301.6934f, 319.48f, 336.8444f}, {0.0f, 7.6E-5f, 0.035464f, 0.181391f, 0.512246f, 1.101085f, 2.020596f, 3.339961f, 5.12464f, 7.436624f, 10.335486f, 13.875346f, 18.104763f, 23.067123f, 28.801828f, 35.341415f, 42.711613f, 50.931904f, 60.016895f, 69.97363f, 80.80183f, 92.49465f, 105.04028f, 118.419426f, 132.60576f, 147.56688f, 163.2661f, 179.66013f, 196.68681f, 214.22578f, 232.14359f, 250.30382f, 268.5683f, 286.798f, 304.8542f, 322.5995f, 339.89877f}, {0.0f, 4.76E-4f, 0.041739f, 0.198974f, 0.546484f, 1.157595f, 2.104941f, 3.45698f, 5.278922f, 7.632874f, 10.578203f, 14.168163f, 18.450932f, 23.469889f, 29.264116f, 35.86519f, 43.298367f, 51.58305f, 60.733475f, 70.75566f, 81.64884f, 93.40609f, 106.0152f, 119.45587f, 133.70132f, 148.71912f, 164.47223f, 180.91644f, 197.9861f, 215.55817f, 233.4989f, 251.67177f, 269.93845f, 288.15994f, 306.19757f, 323.91406f, 341.17453f}, {0.0f, 0.001218f, 0.048698f, 0.217577f, 0.582069f, 1.216112f, 2.191595f, 3.576592f, 5.436063f, 7.832567f, 10.824579f, 14.464828f, 18.80111f, 23.87713f, 29.730976f, 36.393593f, 43.889774f, 52.239185f, 61.454987f, 71.54255f, 82.50059f, 94.32243f, 106.99482f, 120.496796f, 134.8011f, 149.87561f, 165.68228f, 182.17632f, 199.28822f, 216.89261f, 234.85551f, 253.04024f, 271.30835f, 289.52087f, 307.53915f, 325.22607f, 342.44702f}}};
        this.lut_x1 = newlut_x;
    }

    /*
     * Opcode count of 35386 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initYTable0() {
        float[][][] newlut_y = new float[][][]{new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.354363f, -7.213483f, -8.017705f, -8.760907f, -9.437433f, -10.042134f, -10.570409f, -11.018237f, -11.382209f, -11.659555f, -11.848166f, -11.946605f, -11.954123f, -11.870663f, -11.696859f, -11.434036f, -11.084193f, -10.649992f, -10.134739f, -9.542354f, -8.877346f, -8.144775f, -7.350219f, -6.499723f, -5.59976f, -4.657179f, -3.679154f, -2.673129f, -1.64676f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.882808f, -4.715039f, -5.511385f, -6.265787f, -6.972502f, -7.626153f, -8.221764f, -8.754802f, -9.22121f, -9.61744f, -9.940475f, -10.187858f, -10.357704f, -10.448722f, -10.460219f, -10.392108f, -10.244906f, -10.019734f, -9.718307f, -9.342916f, -8.89642f, -8.382218f, -7.804222f, -7.166831f, -6.474896f, -5.733684f, -4.948834f, -4.12632f, -3.272403f, -2.393582f, -1.496543f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.304638f, -4.018909f, -4.702593f, -5.350487f, -5.957661f, -6.519494f, -7.031709f, -7.490409f, -7.892102f, -8.233732f, -8.512698f, -8.726877f, -8.87464f, -8.95486f, -8.966929f, -8.910754f, -8.786763f, -8.595901f, -8.339617f, -8.019864f, -7.639075f, -7.200148f, -6.706423f, -6.161659f, -5.570001f, -4.935951f, -4.264337f, -3.560267f, -2.829102f, -2.076406f, -1.307907f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.763688f, -3.358815f, -3.92838f, -4.468047f, -4.97371f, -5.44152f, -5.867917f, -6.249655f, -6.583829f, -6.867897f, -7.099696f, -7.277462f, -7.399842f, -7.465905f, -7.475147f, -7.4275f, -7.323324f, -7.163414f, -6.948986f, -6.681671f, -6.363505f, -5.99691f, -5.584673f, -5.129935f, -4.636154f, -4.10709f, -3.546767f, -2.959452f, -2.349614f, -1.721894f, -1.081069f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.735061f, -3.189122f, -3.618912f, -4.02116f, -4.392804f, -4.731017f, -5.033223f, -5.297124f, -5.52071f, -5.702281f, -5.840454f, -5.934177f, -5.982738f, -5.985766f, -5.943239f, -5.85548f, -5.723158f, -5.547279f, -5.329182f, -5.070527f, -4.773281f, -4.439709f, -4.072347f, -3.673992f, -3.247676f, -2.796643f, -2.324327f, -1.83432f, -1.330354f, -0.816262f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.147932f, -2.485178f, -2.80351f, -3.100506f, -3.373905f, -3.621627f, -3.841786f, -4.032707f, -4.192936f, -4.321254f, -4.416686f, -4.478503f, -4.506237f, -4.499675f, -4.458868f, -4.384126f, -4.276019f, -4.135368f, -3.963245f, -3.760959f, -3.53005f, -3.272275f, -2.989596f, -2.684165f, -2.358305f, -2.014497f, -1.655358f, -1.28362f, -0.902113f, -0.513741f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.597692f, -1.816886f, -2.022251f, -2.212226f, -2.385365f, -2.540349f, -2.676f, -2.791285f, -2.885326f, -2.957409f, -3.006984f, -3.033674f, -3.037275f, -3.017761f, -2.975281f, -2.910156f, -2.822884f, -2.714128f, -2.584715f, -2.435632f, -2.268011f, -2.08313f, -1.882395f, -1.667333f, -1.439583f, -1.200876f, -0.95303f, -0.69793f, -0.437519f, -0.173779f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.084589f, -1.184565f, -1.275526f, -1.35678f, -1.427707f, -1.487769f, -1.536508f, -1.573554f, -1.598623f, -1.611526f, -1.612165f, -1.600533f, -1.576721f, -1.540909f, -1.49337f, -1.434466f, -1.364644f, -1.284436f, -1.194453f, -1.09538f, -0.98797f, -0.873041f, -0.751468f, -0.624175f, -0.492132f, -0.356344f, -0.217844f, -0.077686f, 0.063064f, 0.203333f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.773896f, -0.838898f, -0.897516f, -0.949303f, -0.993866f, -1.030865f, -1.060018f, -1.081104f, -1.093962f, -1.098494f, -1.094666f, -1.082507f, -1.062109f, -1.033629f, -0.997281f, -0.953344f, -0.902151f, -0.844092f, -0.77961f, -0.709193f, -0.63338f, -0.552746f, -0.467906f, -0.379504f, -0.288214f, -0.194731f, -0.099765f, -0.00404f, 0.091715f, 0.186772f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.296921f, -0.241277f, -0.183797f, -0.124917f, -0.065088f, -0.004762f, 0.055599f, 0.115537f, 0.174596f, 0.232326f, 0.288288f, 0.342056f, 0.393221f, 0.441393f, 0.486206f, 0.527319f, 0.564418f, 0.597222f, 0.62548f, 0.648978f, 0.667537f, 0.681016f, 0.689312f, 0.692362f, 0.690142f, 0.68267f, 0.670003f, 0.652236f, 0.629506f, 0.601984f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.15539f, 0.332488f, 0.507057f, 0.677766f, 0.843316f, 1.002449f, 1.153953f, 1.296674f, 1.429527f, 1.5515f, 1.661665f, 1.759184f, 1.843315f, 1.913417f, 1.968956f, 2.009511f, 2.034772f, 2.044547f, 2.038762f, 2.017461f, 1.980806f, 1.929075f, 1.862664f, 1.782076f, 1.687925f, 1.580928f, 1.4619f, 1.331746f, 1.191456f, 1.042098f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.582918f, 0.882248f, 1.174863f, 1.458536f, 1.73111f, 1.990508f, 2.234758f, 2.462f, 2.670504f, 2.858685f, 3.025109f, 3.16851f, 3.287796f, 3.382061f, 3.450586f, 3.49285f, 3.508532f, 3.497511f, 3.459872f, 3.395902f, 3.306087f, 3.19111f, 3.051847f, 2.889358f, 2.704878f, 2.499814f, 2.275724f, 2.034314f, 1.777422f, 1.507003f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.790857f, 1.039281f, 1.279796f, 1.510571f, 1.729849f, 1.935962f, 2.127342f, 2.302531f, 2.460196f, 2.599138f, 2.718299f, 2.816772f, 2.893807f, 2.948819f, 2.981389f, 2.991269f, 2.978383f, 2.94283f, 2.88488f, 2.804974f, 2.703721f, 2.581891f, 2.440411f, 2.280359f, 2.102951f, 1.909539f, 1.701593f, 1.480698f, 1.248534f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.354628f, 1.721036f, 2.074345f, 2.411868f, 2.731035f, 3.029416f, 3.304743f, 3.554918f, 3.778038f, 3.972405f, 4.136539f, 4.269192f, 4.369354f, 4.436263f, 4.469409f, 4.468539f, 4.433662f, 4.365042f, 4.263201f, 4.128914f, 3.963205f, 3.767332f, 3.542788f, 3.291282f, 3.014726f, 2.715227f, 2.395063f, 2.056672f, 1.702628f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.419995f, 1.919149f, 2.403696f, 2.86995f, 3.314362f, 3.73355f, 4.124323f, 4.483707f, 4.808968f, 5.09763f, 5.347496f, 5.556663f, 5.723542f, 5.84686f, 5.925681f, 5.959404f, 5.947772f, 5.890873f, 5.789142f, 5.643352f, 5.454612f, 5.22436f, 4.954347f, 4.646628f, 4.303546f, 3.927712f, 3.521985f, 3.089453f, 2.633409f, 2.157323f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.86263f, 2.484371f, 3.087205f, 3.666544f, 4.217978f, 4.73731f, 5.220589f, 5.664136f, 6.064575f, 6.418859f, 6.724293f, 6.978549f, 7.179696f, 7.3262f, 7.416947f, 7.451247f, 7.428839f, 7.349893f, 7.215009f, 7.025215f, 6.781954f, 6.487079f, 6.142834f, 5.751837f, 5.317066f, 4.841829f, 4.329742f, 3.784704f, 3.210861f, 2.612582f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 1.845115f, 2.332092f, 2.80132f, 3.249228f, 3.672407f, 4.067638f, 4.431911f, 4.762455f, 5.056753f, 5.312567f, 5.527949f, 5.70126f, 5.83118f, 5.916722f, 5.957234f, 5.952408f, 5.90228f, 5.807233f, 5.667989f, 5.485609f, 5.261479f, 4.997306f, 4.695101f, 4.357163f, 3.986065f, 3.58463f, 3.155915f, 2.70318f, 2.229873f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.86263f, 2.484371f, 3.087205f, 3.666544f, 4.217978f, 4.73731f, 5.220589f, 5.664136f, 6.064575f, 6.418859f, 6.724293f, 6.978549f, 7.179696f, 7.3262f, 7.416947f, 7.451247f, 7.428839f, 7.349893f, 7.215009f, 7.025215f, 6.781954f, 6.487079f, 6.142834f, 5.751837f, 5.317066f, 4.841829f, 4.329742f, 3.784704f, 3.210861f, 2.612582f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.418706f, 3.160052f, 3.877348f, 4.565136f, 5.21818f, 5.831511f, 6.40046f, 6.920698f, 7.388265f, 7.799603f, 8.151582f, 8.441522f, 8.667216f, 8.826948f, 8.919502f, 8.944173f, 8.900773f, 8.789633f, 8.611599f, 8.368025f, 8.060765f, 7.692159f, 7.26501f, 6.78257f, 6.24851f, 5.666896f, 5.042153f, 4.379037f, 3.682593f, 2.958122f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.012098f, 3.871856f, 4.702148f, 5.496653f, 6.249325f, 6.954437f, 7.60662f, 8.200913f, 8.732792f, 9.198209f, 9.593622f, 9.916022f, 10.162955f, 10.332541f, 10.423491f, 10.435112f, 10.367315f, 10.220617f, 9.996134f, 9.695574f, 9.321225f, 8.875936f, 8.363095f, 7.786607f, 7.150857f, 6.460685f, 5.721344f, 4.938459f, 4.11799f, 3.266181f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.637934f, 3.64256f, 4.619464f, 5.561211f, 6.460633f, 7.310886f, 8.105499f, 8.838425f, 9.504085f, 10.097412f, 10.613893f, 11.049595f, 11.401203f, 11.666041f, 11.842093f, 11.92802f, 11.923168f, 11.827573f, 11.641963f, 11.367751f, 11.007023f, 10.562526f, 10.037641f, 9.436363f, 8.763268f, 8.023481f, 7.22263f, 6.36681f, 5.462535f, 4.516686f, 3.536463f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.184318f, 4.309826f, 5.402534f, 6.454126f, 7.456598f, 8.402321f, 9.284097f, 10.095215f, 10.829502f, 11.481371f, 12.045859f, 12.518671f, 12.896209f, 13.175598f, 13.354713f, 13.432191f, 13.407442f, 13.280654f, 13.052792f, 12.725591f, 12.301539f, 11.783867f, 11.176512f, 10.484096f, 9.71189f, 8.865771f, 7.952178f, 6.978065f, 5.950844f, 4.878333f, 3.768696f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 3.768357f, 5.013612f, 6.220711f, 7.380466f, 8.484051f, 9.523067f, 10.489608f, 11.376315f, 12.176443f, 12.8839f, 13.493303f, 14.000013f, 14.400176f, 14.690744f, 14.869507f, 14.935103f, 14.887035f, 14.725668f, 14.452229f, 14.0688f, 13.578299f, 12.984458f, 12.291799f, 11.50559f, 10.631819f, 9.677132f, 8.648796f, 7.554638f, 6.402984f, 5.2026f, 3.962621f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 4.389823f, 5.753613f, 7.073615f, 8.339783f, 9.542479f, 10.672551f, 11.721399f, 12.681041f, 13.544171f, 14.304223f, 14.95541f, 15.492778f, 15.912237f, 16.210594f, 16.385578f, 16.435858f, 16.361052f, 16.161728f, 15.839403f, 15.396531f, 14.836482f, 14.163519f, 13.382762f, 12.500155f, 11.522414f, 10.456981f, 9.311963f, 8.096076f, 6.818573f, 5.489176f, 4.118003f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.529004f, 5.048466f, 6.529506f, 7.960852f, 9.331612f, 10.631352f, 11.850182f, 12.978824f, 14.00869f, 14.931941f, 15.741551f, 16.431358f, 16.996113f, 17.431517f, 17.734257f, 17.902029f, 17.933554f, 17.828596f, 17.58795f, 17.21345f, 16.707945f, 16.075281f, 15.320276f, 14.448674f, 13.46711f, 12.383052f, 11.204751f, 9.941176f, 8.601943f, 7.197243f, 5.737768f, 4.234625f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.103372f, 5.744017f, 7.340947f, 8.882009f, 10.355472f, 11.750124f, 13.055351f, 14.261218f, 15.358549f, 16.338993f, 17.195086f, 17.920315f, 18.50916f, 18.957138f, 19.260841f, 19.417957f, 19.427292f, 19.288773f, 19.003454f, 18.573507f, 18.002205f, 17.293896f, 16.45397f, 15.488818f, 14.405787f, 13.21312f, 11.919893f, 10.535949f, 9.071819f, 7.538648f, 5.948103f, 4.312289f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 4.715515f, 6.47619f, 8.187577f, 9.836652f, 11.410864f, 12.898232f, 14.287436f, 15.567905f, 16.729893f, 17.764557f, 18.66402f, 19.42144f, 20.031052f, 20.488214f, 20.78945f, 20.932463f, 20.91617f, 20.74069f, 20.407362f, 19.918722f, 19.278488f, 18.491533f, 17.563847f, 16.50249f, 15.315536f, 14.012025f, 12.601872f, 11.095812f, 9.505306f, 7.842459f, 6.119925f, 4.350816f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.404577f, 5.281602f, 7.118431f, 8.901083f, 10.615993f, 12.25011f, 13.790996f, 15.226923f, 16.546965f, 17.741074f, 18.800163f, 19.716171f, 20.482126f, 21.092201f, 21.541752f, 21.827358f, 21.946842f, 21.8993f, 21.68509f, 21.305843f, 20.764446f, 20.065018f, 19.212885f, 18.214529f, 17.077549f, 15.8106f, 14.423322f, 12.926274f, 11.33085f, 9.64919f, 7.894094f, 6.07892f, 4.217481f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 3.908961f, 5.865656f, 7.77771f, 9.630571f, 11.410138f, 13.102866f, 14.695874f, 16.177038f, 17.535084f, 18.759678f, 19.8415f, 20.772314f, 21.54504f, 22.153795f, 22.593946f, 22.862144f, 22.956347f, 22.875837f, 22.62123f, 22.194462f, 21.59878f, 20.838717f, 19.92006f, 18.849798f, 17.63608f, 16.28814f, 14.816236f, 13.231573f, 11.546209f, 9.772971f, 7.925356f, 6.017424f, 4.063695f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.288843f, 6.28262f, 8.228581f, 10.111919f, 11.918299f, 13.633973f, 15.245885f, 16.741766f, 18.110231f, 19.340868f, 20.424309f, 21.352308f, 22.117804f, 22.71497f, 23.139261f, 23.387447f, 23.457642f, 23.34931f, 23.063276f, 22.601715f, 21.968143f, 21.16738f, 20.205519f, 19.089882f, 17.82896f, 16.43235f, 14.910679f, 13.275528f, 11.539343f, 9.715337f, 7.81739f, 5.85995f, 3.85791f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 4.674564f, 6.70499f, 8.684387f, 10.597691f, 12.430339f, 14.168386f, 15.798601f, 17.30858f, 18.68683f, 19.922865f, 21.00727f, 21.9318f, 22.689417f, 23.274351f, 23.682156f, 23.909723f, 23.955322f, 23.81861f, 23.50062f, 23.003778f, 22.331863f, 21.48999f, 20.484564f, 19.323238f, 18.014853f, 16.56936f, 14.997767f, 13.312032f, 11.524983f, 9.650224f, 7.702019f, 5.695198f, 3.645032f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 4.828274f, 6.855405f, 8.830361f, 10.738114f, 12.564143f, 14.294551f, 15.916169f, 17.416655f, 18.78459f, 20.009563f, 21.082253f, 21.994492f, 22.73934f, 23.311127f, 23.705503f, 23.919468f, 23.95139f, 23.801025f, 23.469522f, 22.959402f, 22.274546f, 21.420168f, 20.40277f, 19.230095f, 17.911066f, 16.455723f, 14.875142f, 13.181354f, 11.387246f, 9.506474f, 7.553353f, 5.542747f, 3.489956f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 4.981777f, 7.005526f, 8.975958f, 10.878078f, 12.697409f, 14.420105f, 16.033054f, 17.523985f, 18.881546f, 20.095406f, 21.15633f, 22.05624f, 22.788288f, 23.346905f, 23.727839f, 23.928186f, 23.946428f, 23.782423f, 23.437418f, 22.914042f, 22.216276f, 21.34943f, 20.3201f, 19.136126f, 17.80651f, 16.34138f, 14.75188f, 13.05011f, 11.24902f, 9.362318f, 7.404364f, 5.390058f, 3.33473f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -8.045838f, -8.471933f, -8.833552f, -9.127942f, -9.352863f, -9.506603f, -9.587992f, -9.59641f, -9.531795f, -9.394635f, -9.185978f, -8.90741f, -8.56105f, -8.149536f, -7.676f, -7.144044f, -6.557717f, -5.921483f, -5.240182f, -4.519001f, -3.763427f, -2.979211f, -2.172322f, -1.3489f, -0.515212f, 0.322397f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.468196f, -6.691633f, -6.864143f, -6.984413f, -7.051527f, -7.064975f, -7.024654f, -6.930871f, -6.78434f, -6.586176f, -6.337887f, -6.041364f, -5.698861f, -5.312987f, -4.886678f, -4.423179f, -3.926016f, -3.398974f, -2.846063f, -2.271493f, -1.679635f, -1.074994f, -0.462171f, 0.154168f, 0.769335f, 1.378646f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.973547f, -4.989908f, -4.968293f, -4.908866f, -4.81208f, -4.678671f, -4.509654f, -4.306316f, -4.070205f, -3.803117f, -3.507084f, -3.184361f, -2.837403f, -2.46885f, -2.081508f, -1.678325f, -1.262368f, -0.836804f, -0.404872f, 0.030142f, 0.464927f, 0.896173f, 1.320598f, 1.734973f, 2.136144f, 2.521058f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.563154f, -3.368225f, -3.147661f, -2.903142f, -2.636528f, -2.349849f, -2.045285f, -1.725156f, -1.391898f, -1.048046f, -0.696218f, -0.339091f, 0.020616f, 0.380166f, 0.736824f, 1.087873f, 1.430643f, 1.762525f, 2.080993f, 2.383624f, 2.668113f, 2.932297f, 3.174165f, 3.391874f, 3.58377f, 3.748391f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.985103f, -2.797224f, -2.588057f, -2.359192f, -2.112374f, -1.849478f, -1.572507f, -1.283568f, -0.984861f, -0.678658f, -0.36729f, -0.053127f, 0.26144f, 0.574018f, 0.882227f, 1.183722f, 1.476208f, 1.75746f, 2.025335f, 2.277797f, 2.512923f, 2.728925f, 2.924158f, 3.097136f, 3.246543f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.399457f, -1.008177f, -0.609224f, -0.205634f, 0.199521f, 0.603158f, 1.002204f, 1.393622f, 1.774435f, 2.141742f, 2.49275f, 2.824787f, 3.135325f, 3.422002f, 3.682635f, 3.915241f, 4.118049f, 4.289517f, 4.428339f, 4.533459f, 4.604076f, 4.639653f, 4.63992f, 4.604874f, 4.534783f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.140214f, 0.738125f, 1.330419f, 1.912588f, 2.4802f, 3.028937f, 3.554621f, 4.053253f, 4.521037f, 4.954413f, 5.350084f, 5.705037f, 6.016571f, 6.282315f, 6.500247f, 6.668709f, 6.786417f, 6.852477f, 6.866385f, 6.828036f, 6.737721f, 6.596128f, 6.404335f, 6.163801f, 5.876357f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 1.633188f, 2.440878f, 3.229991f, 3.994522f, 4.728653f, 5.426795f, 6.083636f, 6.694178f, 7.253772f, 7.758161f, 8.203506f, 8.586416f, 8.903979f, 9.153778f, 9.33391f, 9.443007f, 9.480235f, 9.445313f, 9.338508f, 9.16063f, 8.913035f, 8.597606f, 8.216743f, 7.773347f, 7.270791f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.312599f, 2.02689f, 2.725754f, 3.403875f, 4.056089f, 4.677434f, 5.263181f, 5.808872f, 6.310355f, 6.763811f, 7.165791f, 7.513235f, 7.803498f, 8.034372f, 8.2041f, 8.31139f, 8.355425f, 8.33587f, 8.252873f, 8.107069f, 7.899564f, 7.631938f, 7.306229f, 6.924915f, 6.490899f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 2.854333f, 3.778942f, 4.674792f, 5.535064f, 6.35321f, 7.123004f, 7.838589f, 8.494516f, 9.085796f, 9.607927f, 10.056936f, 10.429405f, 10.722501f, 10.933992f, 11.062268f, 11.106355f, 11.065914f, 10.941256f, 10.733328f, 10.443713f, 10.074615f, 9.628843f, 9.10979f, 8.521405f, 7.868168f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.396156f, 5.5322f, 6.626141f, 7.669652f, 8.654794f, 9.574066f, 10.420475f, 11.187577f, 11.869535f, 12.461159f, 12.957946f, 13.356114f, 13.652636f, 13.845251f, 13.932497f, 13.913708f, 13.789026f, 13.559402f, 13.226583f, 12.793102f, 12.262258f, 11.638089f, 10.925349f, 10.129459f, 9.256479f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.543999f, 5.937732f, 7.286275f, 8.579366f, 9.807162f, 10.96032f, 12.030064f, 13.00825f, 13.887437f, 14.660932f, 15.322848f, 15.868148f, 16.292683f, 16.593218f, 16.767471f, 16.814114f, 16.73279f, 16.524118f, 16.18969f, 15.732047f, 15.154675f, 14.461966f, 13.659193f, 12.752465f, 11.748683f, 10.655487f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 4.822811f, 6.02201f, 7.175378f, 8.274137f, 9.309924f, 10.274858f, 11.161593f, 11.963383f, 12.674124f, 13.288406f, 13.801557f, 14.209669f, 14.509637f, 14.699178f, 14.776849f, 14.742059f, 14.595074f, 14.33701f, 13.969834f, 13.496339f, 12.920129f, 12.245588f, 11.477852f, 10.622762f, 9.686826f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 6.509814f, 7.917538f, 9.265005f, 10.541959f, 11.738683f, 12.846068f, 13.855687f, 14.759856f, 15.551694f, 16.225174f, 16.77517f, 17.197496f, 17.48894f, 17.647282f, 17.671318f, 17.560865f, 17.316763f, 16.940868f, 16.436045f, 15.806134f, 15.055928f, 14.191137f, 13.218343f, 12.14495f, 10.979126f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.576048f, 8.253114f, 9.867369f, 11.406526f, 12.858873f, 14.213357f, 15.459668f, 16.588322f, 17.590729f, 18.459259f, 19.187304f, 19.769321f, 20.200882f, 20.478703f, 20.600666f, 20.565847f, 20.37451f, 20.02811f, 19.529285f, 18.88183f, 18.090673f, 17.161835f, 16.102385f, 14.920385f, 13.624833f, 12.225588f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.156864f, 10.051997f, 11.870629f, 13.598918f, 15.223711f, 16.732643f, 18.114227f, 19.357954f, 20.454353f, 21.395082f, 22.172983f, 22.782135f, 23.2179f, 23.476961f, 23.55735f, 23.458452f, 23.181023f, 22.72717f, 22.100353f, 21.305336f, 20.348173f, 19.236149f, 17.977726f, 16.582481f, 15.061034f, 13.424964f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.319855f, 8.005251f, 9.629724f, 11.180907f, 12.646997f, 14.016837f, 15.28f, 16.426872f, 17.448727f, 18.337786f, 19.087282f, 19.691515f, 20.145882f, 20.446926f, 20.592358f, 20.581068f, 20.413145f, 20.089867f, 19.61369f, 18.988243f, 18.218283f, 17.309671f, 16.269321f, 15.105154f, 13.826027f, 12.441675f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.156864f, 10.051997f, 11.870629f, 13.598918f, 15.223711f, 16.732643f, 18.114227f, 19.357954f, 20.454353f, 21.395082f, 22.172983f, 22.782135f, 23.2179f, 23.476961f, 23.55735f, 23.458452f, 23.181023f, 22.72717f, 22.100353f, 21.305336f, 20.348173f, 19.236149f, 17.977726f, 16.582481f, 15.061034f, 13.424964f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 7.940523f, 10.11624f, 12.214965f, 14.220727f, 16.118261f, 17.893126f, 19.531813f, 21.02185f, 22.351898f, 23.511837f, 24.492834f, 25.287428f, 25.889568f, 26.294672f, 26.49966f, 26.502968f, 26.304573f, 25.905983f, 25.310234f, 24.52186f, 23.546858f, 22.39265f, 21.068022f, 19.583052f, 17.949045f, 16.178432f, 14.284695f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 9.807072f, 12.195602f, 14.491317f, 16.676744f, 18.73525f, 20.65117f, 22.409924f, 23.998121f, 25.40368f, 26.615902f, 27.62556f, 28.424973f, 29.008053f, 29.370365f, 29.50915f, 29.423353f, 29.113626f, 28.582327f, 27.833498f, 26.87284f, 25.707664f, 24.346838f, 22.800716f, 21.08107f, 19.200981f, 17.174763f, 15.017833f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.112191f, 11.797159f, 14.392344f, 16.877995f, 19.235193f, 21.446f, 23.49359f, 25.36238f, 27.038147f, 28.508137f, 29.761162f, 30.787687f, 31.5799f, 32.13177f, 32.4391f, 32.499546f, 32.312653f, 31.879839f, 31.204401f, 30.29148f, 29.148022f, 27.782728f, 26.205994f, 24.429813f, 22.467709f, 20.334612f, 18.046755f, 15.621552f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 10.94208f, 13.800193f, 16.553276f, 19.18038f, 21.66151f, 23.977781f, 26.111568f, 28.04663f, 29.768242f, 31.263298f, 32.52042f, 33.530045f, 34.284485f, 34.777996f, 35.00683f, 34.96924f, 34.665512f, 34.097958f, 33.270897f, 32.190628f, 30.865366f, 29.3052f, 27.522005f, 25.52935f, 23.342402f, 20.977804f, 18.453552f, 15.788858f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.734281f, 12.857882f, 15.883626f, 18.788486f, 21.550354f, 24.148212f, 26.562286f, 28.774206f, 30.767138f, 32.525913f, 34.037144f, 35.289333f, 36.27295f, 36.980507f, 37.40662f, 37.548046f, 37.40371f, 36.974705f, 36.264305f, 35.27791f, 34.02303f, 32.50921f, 30.747978f, 28.752737f, 26.538668f, 24.122625f, 21.522993f, 18.75956f, 15.853354f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.412765f, 14.671697f, 17.818968f, 20.830627f, 23.683752f, 26.356628f, 28.828917f, 31.081799f, 33.09813f, 34.862564f, 36.36167f, 37.584045f, 38.520386f, 39.16356f, 39.508675f, 39.553104f, 39.296513f, 38.74085f, 37.890347f, 36.751472f, 35.3329f, 33.645424f, 31.701883f, 29.517073f, 27.10762f, 24.491861f, 21.689705f, 18.722477f, 15.612761f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.146967f, 16.53683f, 19.80084f, 22.914152f, 25.853073f, 28.595238f, 31.119774f, 33.40747f, 35.440918f, 37.204636f, 38.685207f, 39.871357f, 40.754063f, 41.326607f, 41.58463f, 41.52617f, 41.15167f, 40.463978f, 39.468334f, 38.172314f, 36.585773f, 34.7208f, 32.591576f, 30.21431f, 27.607098f, 24.789776f, 21.78379f, 18.612017f, 15.298595f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.089277f, 14.678705f, 18.156418f, 21.49595f, 24.671886f, 27.660053f, 30.437712f, 32.98372f, 35.2787f, 37.30519f, 39.047768f, 40.493164f, 41.630386f, 42.45077f, 42.948086f, 43.118534f, 42.96083f, 42.476166f, 41.668232f, 40.543175f, 39.109562f, 37.378304f, 35.36257f, 33.07771f, 30.541107f, 27.772068f, 24.791666f, 21.622585f, 18.288942f, 14.816111f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.554127f, 16.239958f, 19.80219f, 23.213718f, 26.448576f, 29.482143f, 32.291336f, 34.854767f, 37.152935f, 39.16835f, 40.885666f, 42.29182f, 43.376106f, 44.130272f, 44.548584f, 44.62785f, 44.367474f, 43.769436f, 42.838284f, 41.58111f, 40.007473f, 38.129356f, 35.961056f, 33.519066f, 30.821978f, 27.890316f, 24.746391f, 21.414133f, 17.9189f, 14.287292f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 13.729358f, 17.471397f, 21.080471f, 24.52911f, 27.791065f, 30.841515f, 33.65724f, 36.21682f, 38.500763f, 40.49169f, 42.174454f, 43.536243f, 44.566696f, 45.25797f, 45.604805f, 45.604557f, 45.257233f, 44.56547f, 43.534542f, 42.172287f, 40.489075f, 38.49772f, 36.21337f, 33.653416f, 30.83734f, 27.786572f, 24.524332f, 21.075447f, 17.466166f, 13.723955f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 14.918708f, 18.714998f, 22.368856f, 25.852476f, 29.13934f, 32.204437f, 35.02444f, 37.577885f, 39.845337f, 41.809547f, 43.45556f, 44.770844f, 45.7454f, 46.371807f, 46.645294f, 46.56378f, 46.12789f, 45.340942f, 44.20892f, 42.74044f, 40.94668f, 38.84129f, 36.440296f, 33.76197f, 30.826693f, 27.656807f, 24.276436f, 20.711306f, 16.988552f, 13.136504f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.770247f, 15.705509f, 19.521244f, 23.18841f, 26.679098f, 29.966742f, 33.02632f, 35.83455f, 38.370056f, 40.613544f, 42.547935f, 44.158516f, 45.433018f, 46.36175f, 46.93764f, 47.15631f, 47.01609f, 46.518047f, 45.665977f, 44.46636f, 42.928326f, 41.063583f, 38.88632f, 36.41311f, 33.662773f, 30.656242f, 27.416399f, 23.9679f, 20.336992f, 16.551306f, 12.639655f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.535943f, 16.495775f, 20.330065f, 24.00963f, 27.506468f, 30.793964f, 33.8471f, 36.64264f, 39.159306f, 41.377945f, 43.281673f, 44.856003f, 46.08895f, 46.971138f, 47.495842f, 47.659073f, 47.45959f, 46.898914f, 45.981308f, 44.713757f, 43.105904f, 41.16999f, 38.92075f, 36.375298f, 33.55301f, 30.47536f, 27.165777f, 23.649445f, 19.953125f, 16.104952f, 12.134209f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 12.836619f, 16.78807f, 20.611755f, 24.27857f, 27.760612f, 31.031378f, 34.065975f, 36.841312f, 39.336266f, 41.531845f, 43.41134f, 44.96045f, 46.16738f, 47.022957f, 47.520653f, 47.656693f, 47.430035f, 46.842403f, 45.898277f, 44.604836f, 42.971924f, 41.01197f, 38.739887f, 36.172974f, 33.330765f, 30.234884f, 26.9089f, 23.378122f, 19.669422f, 15.811027f, 11.832299f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.136746f, 17.079647f, 20.892561f, 24.54647f, 28.013567f, 31.267464f, 34.283394f, 37.03841f, 39.51154f, 41.683964f, 43.539146f, 45.06297f, 46.243835f, 47.07276f, 47.54343f, 47.652267f, 47.398445f, 46.783886f, 45.81328f, 44.494003f, 42.8361f, 40.85219f, 38.55737f, 35.9691f, 33.10709f, 29.993113f, 26.65087f, 23.105797f, 19.384876f, 15.516424f, 11.529883f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.562766f, -5.715556f, -4.824846f, -3.897417f, -2.940326f, -1.960857f, -0.966465f, 0.035282f, 1.036761f, 2.03035f, 3.008486f, 3.963726f, 4.8888f, 5.776667f, 6.62057f, 7.414086f, 8.151176f, 8.826232f, 9.434114f, 9.970198f, 10.430402f, 10.811224f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.867209f, -2.755148f, -1.622119f, -0.476745f, 0.672258f, 1.816144f, 2.946209f, 4.053851f, 5.130641f, 6.168384f, 7.159181f, 8.095492f, 8.970193f, 9.776625f, 10.50865f, 11.160698f, 11.727807f, 12.20566f, 12.590621f, 12.879759f, 13.070874f, 13.162513f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -1.233219f, 0.150357f, 1.532789f, 2.903556f, 4.252224f, 5.568532f, 6.842458f, 8.06431f, 9.224788f, 10.315059f, 11.326826f, 12.25239f, 13.084704f, 13.817437f, 14.445011f, 14.96265f, 15.366413f, 15.65323f, 15.820915f, 15.868194f, 15.794706f, 15.601011f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.337163f, 2.998759f, 4.637532f, 6.241011f, 7.796991f, 9.293633f, 10.719543f, 12.063872f, 13.316387f, 14.467557f, 15.508619f, 16.431652f, 17.22963f, 17.89648f, 18.427128f, 18.817533f, 19.064726f, 19.166824f, 19.123053f, 18.93374f, 18.600334f, 18.125366f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 1.970361f, 3.46985f, 4.942932f, 6.378396f, 7.765315f, 9.093136f, 10.351753f, 11.531587f, 12.623658f, 13.619656f, 14.512f, 15.293899f, 15.959401f, 16.503445f, 16.921885f, 17.21154f, 17.370205f, 17.396673f, 17.290741f, 17.053217f, 16.685905f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.138844f, 4.933834f, 6.691275f, 8.397792f, 10.040396f, 11.606586f, 13.084444f, 14.462721f, 15.730927f, 16.879414f, 17.899435f, 18.783232f, 19.524078f, 20.116333f, 20.55549f, 20.83821f, 20.962336f, 20.926928f, 20.73225f, 20.37979f, 19.872227f, 19.213425f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 5.82443f, 7.902974f, 9.921371f, 11.86426f, 13.716854f, 15.465055f, 17.095558f, 18.595955f, 19.954823f, 21.161823f, 22.207771f, 23.084702f, 23.785946f, 24.306164f, 24.641397f, 24.789095f, 24.748133f, 24.518822f, 24.102907f, 23.503557f, 22.725328f, 21.774147f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 8.511476f, 10.876482f, 13.158711f, 15.340796f, 17.406126f, 19.338987f, 21.124666f, 22.749573f, 24.201342f, 25.468924f, 26.542673f, 27.414415f, 28.077518f, 28.526934f, 28.759243f, 28.772675f, 28.567131f, 28.144175f, 27.507023f, 26.660526f, 25.611126f, 24.366812f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.625389f, 8.80337f, 10.914351f, 12.942268f, 14.871687f, 16.687923f, 18.377153f, 19.926523f, 21.324242f, 22.559668f, 23.623402f, 24.507347f, 25.204777f, 25.710382f, 26.020317f, 26.132221f, 26.045244f, 25.760046f, 25.2788f, 24.605165f, 23.74427f, 22.702667f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.555478f, 12.01613f, 14.385333f, 16.645054f, 18.778095f, 20.768227f, 22.600296f, 24.260366f, 25.735798f, 27.015368f, 28.08933f, 28.94952f, 29.589384f, 30.004055f, 30.190378f, 30.146935f, 29.874054f, 29.373814f, 28.65002f, 27.708183f, 26.555471f, 25.200655f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 12.563073f, 15.304558f, 17.929565f, 20.41812f, 22.751278f, 24.911285f, 26.881702f, 28.647535f, 30.195341f, 31.513344f, 32.59151f, 33.421635f, 33.997402f, 34.314426f, 34.3703f, 34.164593f, 33.698875f, 32.976685f, 32.003525f, 30.786798f, 29.335764f, 27.661469f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.456191f, 15.552292f, 18.530031f, 21.366745f, 24.040844f, 26.531979f, 28.82119f, 30.891054f, 32.72582f, 34.31152f, 35.63609f, 36.689445f, 37.463573f, 37.952583f, 38.15275f, 38.06255f, 37.68267f, 37.016006f, 36.067623f, 34.84475f, 33.35668f, 31.61475f, 29.632212f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 12.632776f, 15.437498f, 18.124731f, 20.674026f, 23.065977f, 25.282383f, 27.306376f, 29.12255f, 30.717081f, 32.07784f, 33.194466f, 34.05846f, 34.663254f, 35.004234f, 35.078815f, 34.88642f, 34.428524f, 33.708603f, 32.73214f, 31.506565f, 30.041206f, 28.347216f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 12.858688f, 16.009287f, 19.038044f, 21.921911f, 24.638939f, 27.16845f, 29.491192f, 31.589487f, 33.44737f, 35.050697f, 36.387264f, 37.446907f, 38.221554f, 38.70531f, 38.8945f, 38.787674f, 38.385654f, 37.691494f, 36.71048f, 35.450077f, 33.91988f, 32.131527f, 30.098639f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.102575f, 19.495531f, 22.740116f, 25.811632f, 28.686708f, 31.34346f, 33.76167f, 35.922935f, 37.810802f, 39.410908f, 40.71107f, 41.7014f, 42.374355f, 42.724815f, 42.750114f, 42.450058f, 41.826935f, 40.88548f, 39.632862f, 38.078617f, 36.23457f, 34.114754f, 31.735304f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.554276f, 19.28774f, 22.874414f, 26.286999f, 29.499525f, 32.48754f, 35.228306f, 37.700962f, 39.886692f, 41.768864f, 43.333145f, 44.567635f, 45.46294f, 46.01224f, 46.211365f, 46.058792f, 45.555683f, 44.705868f, 43.515816f, 41.99458f, 40.15374f, 38.007305f, 35.571613f, 32.8652f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 15.582417f, 18.995428f, 22.26387f, 25.362873f, 28.268848f, 30.95968f, 33.41489f, 35.615795f, 37.54564f, 39.18974f, 40.535583f, 41.572926f, 42.293873f, 42.69294f, 42.767086f, 42.515747f, 41.94084f, 41.046738f, 39.840244f, 38.330544f, 36.529125f, 34.449696f, 32.10808f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.554276f, 19.28774f, 22.874414f, 26.286999f, 29.499525f, 32.48754f, 35.228306f, 37.700962f, 39.886692f, 41.768864f, 43.333145f, 44.567635f, 45.46294f, 46.01224f, 46.211365f, 46.058792f, 45.555683f, 44.705868f, 43.515816f, 41.99458f, 40.15374f, 38.007305f, 35.571613f, 32.8652f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.202505f, 23.123787f, 26.869083f, 30.40989f, 33.719257f, 36.772003f, 39.54489f, 42.01682f, 44.168972f, 45.984974f, 47.451f, 48.5559f, 49.291256f, 49.651478f, 49.63382f, 49.238422f, 48.46829f, 47.32928f, 45.83007f, 43.982063f, 41.799328f, 39.298473f, 36.498535f, 33.42082f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.497576f, 22.7267f, 26.782862f, 30.63519f, 34.254364f, 37.612846f, 40.685066f, 43.44765f, 45.879574f, 47.962326f, 49.680054f, 51.019688f, 51.971027f, 52.52684f, 52.68289f, 52.437992f, 51.79401f, 50.755844f, 49.331394f, 47.531506f, 45.36987f, 42.862946f, 40.029804f, 36.892014f, 33.473454f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 21.961988f, 26.340633f, 30.518808f, 34.464718f, 38.14833f, 41.54161f, 44.618732f, 47.35628f, 49.73342f, 51.732056f, 53.336983f, 54.53598f, 55.319927f, 55.682854f, 55.622f, 55.137833f, 54.23403f, 52.917477f, 51.19819f, 49.08925f, 46.606712f, 43.76947f, 40.599117f, 37.119778f, 33.357937f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.507986f, 25.179743f, 29.659864f, 33.914257f, 37.91054f, 41.618305f, 45.009327f, 48.0578f, 50.74053f, 53.037086f, 54.93f, 56.404865f, 57.450455f, 58.05881f, 58.225307f, 57.94867f, 57.23101f, 56.07779f, 54.49778f, 52.50301f, 50.10866f, 47.332954f, 44.197018f, 40.724712f, 36.942467f, 32.87907f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 23.667952f, 28.455832f, 33.02715f, 37.347107f, 41.38283f, 45.103607f, 48.481117f, 51.48966f, 54.10633f, 56.311222f, 58.08755f, 59.4218f, 60.30381f, 60.72687f, 60.687767f, 60.18679f, 59.227757f, 57.817966f, 55.968143f, 53.69237f, 51.007965f, 47.93536f, 44.497936f, 40.721855f, 36.635857f, 32.27104f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.412325f, 26.475035f, 31.336252f, 35.95898f, 40.30804f, 44.350334f, 48.05509f, 51.394123f, 54.342014f, 56.87633f, 58.977783f, 60.630375f, 61.821537f, 62.542202f, 62.786877f, 62.55371f, 61.84447f, 60.66456f, 59.022953f, 56.932144f, 54.40805f, 51.469875f, 48.139984f, 44.44372f, 40.409214f, 36.067165f, 31.450626f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.167389f, 29.317457f, 34.2444f, 38.910725f, 43.280914f, 47.32171f, 51.002357f, 54.29485f, 57.17412f, 59.618267f, 61.608677f, 63.13021f, 64.17129f, 64.723976f, 64.78408f, 64.35114f, 63.428448f, 62.023026f, 60.14557f, 57.81037f, 55.035202f, 51.84118f, 48.252613f, 44.296818f, 40.0039f, 35.40652f, 30.53968f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 26.477728f, 31.677412f, 36.636013f, 41.31579f, 45.68113f, 49.698807f, 53.338245f, 56.57175f, 59.37471f, 61.725792f, 63.6071f, 65.004326f, 65.90682f, 66.30773f, 66.204f, 65.59642f, 64.4896f, 62.891987f, 60.815723f, 58.276615f, 55.293987f, 51.890537f, 48.09217f, 43.92779f, 39.429096f, 34.63032f, 29.567991f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.343857f, 28.807308f, 34.05152f, 39.03658f, 43.72455f, 48.079746f, 52.069027f, 55.66203f, 58.831413f, 61.553055f, 63.806236f, 65.573814f, 66.84234f, 67.60216f, 67.84747f, 67.57643f, 66.7911f, 65.49744f, 63.705307f, 61.428337f, 58.68386f, 55.492767f, 51.879337f, 47.871075f, 43.498486f, 38.794846f, 33.795956f, 28.539854f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.08673f, 30.579065f, 35.838676f, 40.825535f, 45.501686f, 49.83154f, 53.782146f, 57.32344f, 60.428467f, 63.073597f, 65.23869f, 66.907295f, 68.06668f, 68.708046f, 68.8265f, 68.421135f, 67.495056f, 66.05529f, 64.11281f, 61.682384f, 58.782524f, 55.43529f, 51.666164f, 47.503826f, 42.979954f, 38.12898f, 32.98782f, 27.595602f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 26.838163f, 32.35647f, 37.628517f, 42.61419f, 47.275547f, 51.577106f, 55.48613f, 58.972874f, 62.0108f, 64.57678f, 66.6513f, 68.21856f, 69.26663f, 69.787544f, 69.777336f, 69.23608f, 68.16789f, 66.5809f, 64.4872f, 61.902702f, 58.847095f, 55.34362f, 51.41895f, 47.10295f, 42.42847f, 37.43108f, 32.14882f, 26.621887f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 27.96547f, 33.484398f, 38.748486f, 43.717678f, 48.35415f, 52.62262f, 56.490597f, 59.92865f, 62.910606f, 65.41378f, 67.41911f, 68.91134f, 69.87912f, 70.31507f, 70.21588f, 69.582306f, 68.419174f, 66.73533f, 64.54358f, 61.860622f, 58.706867f, 55.106316f, 51.086372f, 46.67763f, 41.913647f, 36.830673f, 31.467396f, 25.864632f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.093624f, 34.611908f, 39.86677f, 44.818226f, 49.42859f, 53.66277f, 57.488544f, 60.876793f, 63.801735f, 66.24111f, 68.176346f, 69.59272f, 70.479454f, 70.829796f, 70.641075f, 69.91474f, 68.65631f, 66.87536f, 64.58545f, 61.80401f, 58.552197f, 54.85477f, 50.739864f, 46.2388f, 41.38583f, 36.217888f, 30.774305f, 25.096512f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 29.515709f, 35.01567f, 40.249138f, 45.17629f, 49.75962f, 53.96425f, 57.75818f, 61.112534f, 64.001785f, 66.403946f, 68.30073f, 69.677704f, 70.52439f, 70.83434f, 70.60521f, 69.83872f, 68.54072f, 66.72108f, 64.393654f, 61.57615f, 58.29002f, 54.560265f, 50.41527f, 45.88659f, 41.008682f, 35.818676f, 30.356068f, 24.66243f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 29.93653f, 35.41793f, 40.62978f, 45.532413f, 50.08852f, 54.26342f, 58.02534f, 61.345657f, 64.1991f, 66.563934f, 68.42219f, 69.759705f, 70.56631f, 70.83586f, 70.56631f, 69.759705f, 68.42219f, 66.563934f, 64.1991f, 61.345657f, 58.02534f, 54.26342f, 50.08852f, 45.532413f, 40.62978f, 35.41793f, 29.93653f, 24.227291f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, -0.076547f, 2.660857f, 5.378011f, 8.054235f, 10.669161f, 13.202888f, 15.636134f, 17.950378f, 20.128012f, 22.152456f, 24.008308f, 25.681442f, 27.159124f, 28.43011f, 29.484726f, 30.314945f, 30.914448f, 31.278675f, 31.40485f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.01121f, 7.015853f, 9.967101f, 12.842493f, 15.620147f, 18.278921f, 20.798582f, 23.159952f, 25.345062f, 27.337282f, 29.121447f, 30.68398f, 32.01299f, 33.098362f, 33.931835f, 34.50707f, 34.81968f, 34.86729f, 34.649544f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.08869f, 11.366713f, 14.558228f, 17.638945f, 20.58542f, 23.375227f, 25.987135f, 28.401266f, 30.599245f, 32.564346f, 34.281612f, 35.737972f, 36.922348f, 37.82572f, 38.44122f, 38.764156f, 38.792072f, 38.524757f, 37.96425f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.371715f, 11.979471f, 15.496057f, 18.894709f, 22.149559f, 25.23584f, 28.130058f, 30.810192f, 33.25584f, 35.44839f, 37.371162f, 39.00951f, 40.35098f, 41.385345f, 42.104748f, 42.503708f, 42.57919f, 42.330616f, 41.759884f, 40.87133f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 8.950559f, 12.340837f, 15.637194f, 18.81454f, 21.8487f, 24.716576f, 27.396343f, 29.867609f, 32.111565f, 34.11113f, 35.85109f, 37.318203f, 38.5013f, 39.39138f, 39.981667f, 40.26767f, 40.24721f, 39.92045f, 39.289864f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.238826f, 16.863556f, 20.359945f, 23.701384f, 26.86244f, 29.819056f, 32.548733f, 35.03069f, 37.246048f, 39.177937f, 40.81166f, 42.13478f, 43.13723f, 43.81138f, 44.1521f, 44.15679f, 43.825428f, 43.160526f, 42.167145f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.566402f, 17.559458f, 21.418873f, 25.115278f, 28.620543f, 31.907986f, 34.95259f, 37.731186f, 40.222622f, 42.40794f, 44.27051f, 45.796154f, 46.973263f, 47.792873f, 48.248753f, 48.33743f, 48.05823f, 47.41328f, 46.407482f, 45.0485f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.42242f, 21.643293f, 25.699446f, 29.56001f, 33.195606f, 36.578564f, 39.683136f, 42.485695f, 44.964912f, 47.101917f, 48.88045f, 50.286976f, 51.310783f, 51.944088f, 52.182064f, 52.022903f, 51.46782f, 50.521034f, 49.18975f, 47.484104f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 17.719328f, 21.676987f, 25.469667f, 29.068512f, 32.446125f, 35.576805f, 38.43672f, 41.004116f, 43.25944f, 45.185535f, 46.767742f, 47.994015f, 48.85503f, 49.344223f, 49.45788f, 49.195133f, 48.55798f, 47.55127f, 46.182667f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.030365f, 22.340252f, 26.480116f, 30.41845f, 34.125282f, 37.5724f, 40.733566f, 43.58473f, 46.104183f, 48.27276f, 50.073948f, 51.494045f, 52.522243f, 53.15071f, 53.374672f, 53.19242f, 52.605343f, 51.617905f, 50.237625f, 48.475006f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.501545f, 27.022673f, 31.33814f, 35.415108f, 39.22254f, 42.731472f, 45.915188f, 48.749462f, 51.212723f, 53.286224f, 54.954185f, 56.203915f, 57.025894f, 57.413876f, 57.3649f, 56.87934f, 55.9609f, 54.61656f, 52.85656f, 50.694283f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 26.705854f, 31.395475f, 35.846157f, 40.02403f, 43.89729f, 47.43647f, 50.614628f, 53.407578f, 55.794067f, 57.755928f, 59.27823f, 60.34939f, 60.961254f, 61.109165f, 60.792f, 60.012173f, 58.77561f, 57.09174f, 54.97336f, 52.4366f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.079441f, 26.673388f, 31.064331f, 35.218857f, 39.105347f, 42.69422f, 45.958168f, 48.872345f, 51.414574f, 53.565502f, 55.30877f, 56.631104f, 57.522438f, 57.975994f, 57.98832f, 57.559315f, 56.692253f, 55.393726f, 53.673622f, 51.545025f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 26.95481f, 31.694439f, 36.192856f, 40.41582f, 44.3312f, 47.909187f, 51.122562f, 53.94686f, 56.36059f, 58.345383f, 59.88613f, 60.97111f, 61.592064f, 61.744263f, 61.42655f, 60.641346f, 59.394627f, 57.695873f, 55.55802f, 52.99734f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 26.797903f, 31.912157f, 36.78354f, 41.374977f, 45.651527f, 49.58064f, 53.132416f, 56.27982f, 58.9989f, 61.268967f, 63.07274f, 64.396484f, 65.23014f, 65.56735f, 65.405556f, 64.74599f, 63.593662f, 61.957348f, 59.849503f, 57.286167f, 54.286846f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.268776f, 36.50505f, 41.463497f, 46.106384f, 50.398373f, 54.306797f, 57.801918f, 60.85713f, 63.44918f, 65.55834f, 67.16857f, 68.26761f, 68.847084f, 68.90259f, 68.43371f, 67.444f, 65.94101f, 63.936165f, 61.444725f, 58.485657f, 55.081474f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.012201f, 31.15957f, 36.069794f, 40.70551f, 45.031425f, 49.01463f, 52.6248f, 55.834465f, 58.619198f, 60.9578f, 62.832478f, 64.228966f, 65.13663f, 65.54856f, 65.46163f, 64.8765f, 63.79762f, 62.2332f, 60.19515f, 57.698975f, 54.763676f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.268776f, 36.50505f, 41.463497f, 46.106384f, 50.398373f, 54.306797f, 57.801918f, 60.85713f, 63.44918f, 65.55834f, 67.16857f, 68.26761f, 68.847084f, 68.90259f, 68.43371f, 67.444f, 65.94101f, 63.936165f, 61.444725f, 58.485657f, 55.081474f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.029871f, 36.611458f, 41.914413f, 46.89837f, 51.525402f, 55.7603f, 59.570824f, 62.92798f, 65.80621f, 68.183624f, 70.042114f, 71.36754f, 72.14982f, 72.382996f, 72.06529f, 71.19913f, 69.79109f, 67.851906f, 65.39633f, 62.443047f, 59.014534f, 55.136883f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 35.87233f, 41.509422f, 46.830605f, 51.79538f, 56.36596f, 60.50756f, 64.18866f, 67.38125f, 70.06102f, 72.20759f, 73.80462f, 74.83994f, 75.305695f, 75.19832f, 74.51865f, 73.271835f, 71.467384f, 69.119026f, 66.24463f, 62.866066f, 59.009056f, 54.702953f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 34.782516f, 40.767216f, 46.44165f, 51.762634f, 56.689674f, 61.185272f, 65.21521f, 68.748825f, 71.75922f, 74.22348f, 76.122856f, 77.442894f, 78.173546f, 78.30924f, 77.84897f, 76.7962f, 75.15898f, 72.94975f, 70.18533f, 66.886765f, 63.079144f, 58.79145f, 54.05632f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.100372f, 45.11576f, 50.787792f, 56.073296f, 60.93205f, 65.32707f, 69.22492f, 72.595924f, 75.41442f, 77.65898f, 79.3125f, 80.362404f, 80.800705f, 80.62406f, 79.833824f, 78.436f, 76.44123f, 73.86469f, 70.726006f, 67.04905f, 62.861813f, 58.196156f, 53.087593f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.084934f, 43.44763f, 49.479664f, 55.135124f, 60.370975f, 65.14736f, 69.42795f, 73.18014f, 76.37538f, 78.989365f, 81.00219f, 82.398544f, 83.16779f, 83.304085f, 82.80638f, 81.678474f, 79.92894f, 77.5711f, 74.6229f, 71.10677f, 67.04948f, 62.481895f, 57.438793f, 51.95854f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 40.787254f, 47.16345f, 53.180695f, 58.79321f, 63.958267f, 68.636566f, 72.792496f, 76.39444f, 79.41497f, 81.8311f, 83.62445f, 84.78137f, 85.29305f, 85.1556f, 84.37006f, 82.94242f, 80.88353f, 78.209076f, 74.9394f, 71.09939f, 66.71827f, 61.82938f, 56.469936f, 50.68072f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.786064f, 44.504314f, 50.883858f, 56.876144f, 62.43557f, 67.51982f, 72.09021f, 76.111946f, 79.55443f, 82.39145f, 84.60142f, 86.16753f, 87.07784f, 87.32545f, 86.90845f, 85.830025f, 84.09838f, 81.72671f, 78.73303f, 75.14016f, 70.97542f, 66.270515f, 61.061256f, 55.38728f, 49.291775f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 40.7968f, 47.517357f, 53.87628f, 59.825172f, 65.318756f, 70.31523f, 74.77656f, 78.66879f, 81.96231f, 84.63205f, 86.657684f, 88.023796f, 88.72f, 88.74099f, 88.08661f, 86.76183f, 84.77675f, 82.14646f, 78.89099f, 75.03511f, 70.60817f, 65.64385f, 60.179955f, 54.258045f, 47.923203f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 43.81364f, 50.529846f, 56.86149f, 62.760384f, 68.18163f, 73.08398f, 77.43011f, 81.18695f, 84.32591f, 86.8231f, 88.659515f, 89.821175f, 90.29924f, 90.09008f, 89.195274f, 87.621635f, 85.38115f, 82.49086f, 78.97276f, 74.85364f, 70.16483f, 64.94203f, 59.22498f, 53.05719f, 46.485603f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.06267f, 52.756744f, 59.0493f, 64.892456f, 70.241745f, 75.05645f, 79.299934f, 82.939896f, 85.94863f, 88.303246f, 89.98582f, 90.98355f, 91.28884f, 90.89936f, 89.81809f, 88.053246f, 85.61826f, 82.53168f, 78.81697f, 74.502426f, 69.620865f, 64.20945f, 58.30937f, 51.96551f, 45.226166f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.27355f, 48.309387f, 54.977566f, 61.22733f, 67.011116f, 72.284904f, 77.00857f, 81.14614f, 84.66615f, 87.541794f, 89.7512f, 91.277534f, 92.1092f, 92.23985f, 91.66851f, 90.39951f, 88.44252f, 85.81242f, 82.52925f, 78.61797f, 74.10837f, 69.03475f, 63.43574f, 57.353947f, 50.83565f, 43.930466f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.703197f, 49.71704f, 56.352505f, 62.559093f, 68.28957f, 73.50032f, 78.151695f, 82.20828f, 85.63921f, 88.41838f, 90.524635f, 91.94194f, 92.65951f, 92.67188f, 91.978966f, 90.58604f, 88.50369f, 85.74779f, 82.33928f, 78.30412f, 73.67303f, 68.48124f, 62.76826f, 56.57758f, 49.95631f, 42.95484f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.13048f, 51.120724f, 57.72191f, 63.883793f, 69.55949f, 74.70579f, 79.28353f, 83.25788f, 86.59859f, 89.28023f, 91.28239f, 92.589836f, 93.19262f, 93.08615f, 92.27124f, 90.75409f, 88.54625f, 85.66451f, 82.13082f, 77.97206f, 73.219894f, 67.91047f, 62.084213f, 55.785454f, 49.062138f, 41.965427f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 44.66708f, 51.62995f, 58.19989f, 64.3269f, 69.96433f, 75.0693f, 79.60294f, 83.530754f, 86.82285f, 89.45418f, 91.4047f, 92.65958f, 93.20926f, 93.04956f, 92.1817f, 90.61228f, 88.35325f, 85.4218f, 81.84023f, 77.63581f, 72.84054f, 67.490906f, 61.62762f, 55.295315f, 48.54218f, 41.41961f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.20176f, 52.136967f, 58.67538f, 64.76724f, 70.36618f, 75.429596f, 79.91894f, 83.80006f, 87.0434f, 89.6243f, 91.523094f, 92.72535f, 93.22191f, 93.00899f, 92.08821f, 90.46659f, 88.15647f, 85.17542f, 81.546135f, 77.296234f, 72.45806f, 67.06844f, 61.16839f, 54.802807f, 48.020145f, 40.872017f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 13.444293f, 18.073524f, 22.565207f, 26.885153f, 31.000488f, 34.87989f, 38.493835f, 41.81482f, 44.817566f, 47.479225f, 49.77954f, 51.701f, 53.22899f, 54.351868f, 55.061096f, 55.35128f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 13.921811f, 18.841854f, 23.618502f, 28.215397f, 32.597553f, 36.73163f, 40.586147f, 44.131786f, 47.341553f, 50.19102f, 52.65851f, 54.72523f, 56.37546f, 57.59664f, 58.379475f, 58.718006f, 58.609657f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.130207f, 24.2435f, 29.172283f, 33.87905f, 38.327976f, 42.485203f, 46.31909f, 49.800465f, 52.902824f, 55.602566f, 57.879135f, 59.715206f, 61.096813f, 62.013435f, 62.4581f, 62.427418f, 61.921623f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 23.927607f, 29.20506f, 34.260242f, 39.054688f, 43.551903f, 47.71766f, 51.520256f, 54.930756f, 57.923195f, 60.474808f, 62.566166f, 64.18136f, 65.3081f, 65.9378f, 66.065674f, 65.69075f, 64.81588f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 24.2046f, 29.253063f, 34.078896f, 38.645363f, 42.91772f, 46.863445f, 50.45251f, 53.657604f, 56.454327f, 58.821404f, 60.74081f, 62.197945f, 63.181713f, 63.68463f, 63.70287f, 63.236294f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.469244f, 29.852444f, 35.00845f, 39.89802f, 44.483944f, 48.731316f, 52.607815f, 56.083935f, 59.133224f, 61.73247f, 63.8619f, 65.5053f, 66.65016f, 67.28778f, 67.4133f, 67.02576f, 66.12811f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 29.994743f, 35.52602f, 40.786922f, 45.73741f, 50.33981f, 54.559093f, 58.363148f, 61.723026f, 64.61315f, 67.011536f, 68.89992f, 70.26393f, 71.09319f, 71.38139f, 71.12634f, 70.32997f, 68.99835f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.137676f, 35.051888f, 40.699333f, 46.03703f, 51.02436f, 55.62336f, 59.799038f, 63.519604f, 66.75675f, 69.48584f, 71.6861f, 73.340775f, 74.437294f, 74.96729f, 74.92675f, 74.31597f, 73.1396f, 71.40659f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.424377f, 35.06787f, 40.44448f, 45.51328f, 50.235695f, 54.575787f, 58.500526f, 61.980038f, 64.98785f, 67.50106f, 69.50055f, 70.97109f, 71.901505f, 72.284706f, 72.117775f, 71.401985f, 70.142784f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.297913f, 41.030758f, 46.451332f, 51.518387f, 56.19335f, 60.440655f, 64.22797f, 67.52647f, 70.31104f, 72.56052f, 74.25776f, 75.389854f, 75.94819f, 75.928505f, 75.33097f, 74.16011f, 72.42486f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.08647f, 41.211803f, 47.02349f, 52.4773f, 57.531723f, 62.148296f, 66.291885f, 69.930954f, 73.0378f, 75.58879f, 77.5645f, 78.9499f, 79.73444f, 79.912155f, 79.4817f, 78.44633f, 76.813934f, 74.59694f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.36681f, 46.578316f, 52.43533f, 57.893284f, 62.91063f, 67.44919f, 71.47443f, 74.95569f, 77.8665f, 80.1847f, 81.89265f, 82.97734f, 83.43052f, 83.24875f, 82.4334f, 80.99069f, 78.93159f, 76.271774f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 40.404972f, 46.310566f, 51.86371f, 57.022137f, 61.746593f, 66.00112f, 69.753334f, 72.97469f, 75.64066f, 77.730965f, 79.22968f, 80.12542f, 80.411354f, 80.085304f, 79.14976f, 77.61184f, 75.483246f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.405113f, 46.66787f, 52.575455f, 58.08291f, 63.148315f, 67.73312f, 71.80245f, 75.32531f, 78.2749f, 80.62877f, 82.36901f, 83.48237f, 83.96037f, 83.79939f, 83.00065f, 81.57022f, 79.51899f, 76.86257f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 46.663113f, 52.956387f, 58.84663f, 64.28902f, 69.24213f, 73.66826f, 77.53373f, 80.80912f, 83.46951f, 85.494644f, 86.86912f, 87.58246f, 87.62924f, 87.00912f, 85.7268f, 83.79205f, 81.2196f, 78.02901f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.624287f, 52.307953f, 58.593525f, 64.43317f, 69.78243f, 74.60061f, 78.85103f, 82.50135f, 85.52378f, 87.895325f, 89.59794f, 90.61865f, 90.94971f, 90.58858f, 89.53801f, 87.80601f, 85.40575f, 82.3555f, 78.67848f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 45.687286f, 52.036953f, 57.99059f, 63.50288f, 68.531876f, 73.0393f, 76.99086f, 80.35646f, 83.11051f, 85.23203f, 86.704895f, 87.517876f, 87.66479f, 87.14452f, 85.96104f, 84.12334f, 81.6454f, 78.5461f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.624287f, 52.307953f, 58.593525f, 64.43317f, 69.78243f, 74.60061f, 78.85103f, 82.50135f, 85.52378f, 87.895325f, 89.59794f, 90.61865f, 90.94971f, 90.58858f, 89.53801f, 87.80601f, 85.40575f, 82.3555f, 78.67848f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 52.28843f, 58.929768f, 65.12262f, 70.81984f, 75.97809f, 80.55809f, 84.525f, 87.848625f, 90.50367f, 92.469925f, 93.73242f, 94.28156f, 94.11317f, 93.228516f, 91.63433f, 89.34276f, 86.37123f, 82.74237f, 78.48379f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.248543f, 58.249043f, 64.80623f, 70.8702f, 76.39481f, 81.33801f, 85.66218f, 89.334404f, 92.32674f, 94.61642f, 96.186f, 97.02355f, 97.122696f, 96.48268f, 95.10837f, 93.01023f, 90.20422f, 86.711716f, 82.55927f, 77.7785f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.87988f, 57.25451f, 64.1934f, 70.64374f, 76.556435f, 81.8865f, 86.593346f, 90.64117f, 93.99916f, 96.641754f, 98.54885f, 99.70593f, 100.104195f, 99.7406f, 98.61792f, 96.7447f, 94.135185f, 90.80925f, 86.792206f, 82.11462f, 76.81209f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.154343f, 62.476604f, 69.32338f, 75.64256f, 81.38606f, 86.51016f, 90.97587f, 94.74919f, 97.801414f, 100.109314f, 101.65532f, 102.427666f, 102.42048f, 101.63381f, 100.07365f, 97.751854f, 94.68612f, 90.899765f, 86.42161f, 81.28573f, 75.53122f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 60.42326f, 67.675835f, 74.41335f, 80.58455f, 86.14244f, 91.04474f, 95.25413f, 98.73858f, 101.471565f, 103.4323f, 104.60584f, 104.983284f, 104.56173f, 103.3444f, 101.34055f, 98.56545f, 95.0402f, 90.79164f, 85.8521f, 80.25917f, 74.05542f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.186954f, 64.84316f, 72.00588f, 78.62058f, 84.63694f, 90.00916f, 94.69635f, 98.66285f, 101.87846f, 104.31872f, 105.96505f, 106.804924f, 106.83194f, 106.045906f, 104.4528f, 102.06474f, 98.89991f, 94.98239f, 90.341995f, 85.014046f, 79.039085f, 72.46259f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 61.653206f, 69.24087f, 76.30157f, 82.78157f, 88.631546f, 93.80699f, 98.2685f, 101.98213f, 104.91962f, 107.0586f, 108.382805f, 108.88215f, 108.55283f, 107.39736f, 105.42454f, 102.64937f, 99.09297f, 94.78242f, 89.75052f, 84.03556f, 77.68104f, 70.73532f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 65.21523f, 72.72312f, 79.67755f, 86.02558f, 91.7189f, 96.714195f, 100.97343f, 104.464195f, 107.15992f, 109.0401f, 110.090416f, 110.30288f, 109.67587f, 108.214165f, 105.92889f, 102.83742f, 98.963295f, 94.336006f, 88.99076f, 82.96824f, 76.314285f, 69.07953f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 60.8162f, 68.75974f, 76.179985f, 83.020454f, 89.22908f, 94.75862f, 99.56699f, 103.61761f, 106.87962f, 109.32822f, 110.944756f, 111.71694f, 111.6389f, 110.71121f, 108.94095f, 106.341576f, 102.93288f, 98.7408f, 93.79725f, 88.13984f, 81.81164f, 74.860794f, 67.34022f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.46724f, 71.34612f, 78.68202f, 85.4191f, 91.50608f, 96.89665f, 101.54978f, 105.43005f, 108.50794f, 110.76002f, 112.16914f, 112.724594f, 112.42214f, 111.26409f, 109.259254f, 106.42288f, 102.77657f, 98.34807f, 93.17108f, 87.285f, 80.734634f, 73.569824f, 65.8451f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.1068f, 73.916595f, 81.16384f, 87.79339f, 93.75477f, 99.002625f, 103.497f, 107.20371f, 110.094536f, 112.14748f, 113.3469f, 113.68369f, 113.15528f, 111.765686f, 109.52549f, 106.45174f, 102.567825f, 97.903305f, 92.49368f, 86.380135f, 79.60918f, 72.232346f, 64.30578f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 67.74521f, 75.49479f, 82.66981f, 89.21566f, 95.082535f, 100.22576f, 104.60622f, 108.19055f, 110.9515f, 112.868034f, 113.92557f, 114.116066f, 113.43807f, 111.89674f, 109.50382f, 106.2775f, 102.24235f, 97.42906f, 91.87429f, 85.6203f, 78.71468f, 71.21f, 63.163364f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.160137f, 69.37567f, 77.06321f, 84.16425f, 90.624756f, 96.395546f, 101.43271f, 105.697914f, 109.15868f, 111.7887f, 113.56793f, 114.48284f, 114.52647f, 113.69848f, 112.00518f, 109.45945f, 106.08067f, 101.894554f, 96.93295f, 91.233635f, 84.83998f, 77.80064f, 70.16918f, 62.0037f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.793247f, 69.971306f, 77.61683f, 84.671646f, 91.08207f, 96.79929f, 101.779816f, 105.98574f, 109.38504f, 111.95186f, 113.66666f, 114.51638f, 114.49457f, 113.60138f, 111.84362f, 109.23466f, 105.79436f, 101.5489f, 96.53059f, 90.777626f, 84.333786f, 77.248116f, 69.57455f, 61.371468f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.423714f, 70.563934f, 78.16713f, 85.17542f, 91.53548f, 97.19889f, 102.12257f, 106.26902f, 109.60671f, 112.11022f, 113.76051f, 114.54501f, 114.457756f, 113.49941f, 111.67726f, 109.00518f, 105.50351f, 101.19889f, 96.124084f, 90.31772f, 83.82398f, 76.69229f, 68.97693f, 60.736607f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.137186f, 33.489708f, 39.587353f, 45.383713f, 50.834675f, 55.898758f, 60.537415f, 64.71535f, 68.40076f, 71.56559f, 74.18577f, 76.241356f, 77.71669f, 78.60056f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 33.401512f, 39.802773f, 45.901115f, 51.65012f, 57.006035f, 61.9281f, 66.37885f, 70.32443f, 73.73479f, 76.583984f, 78.85033f, 80.51657f, 81.57004f, 82.00271f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 32.920612f, 39.675747f, 46.12892f, 52.23103f, 57.935627f, 63.1993f, 67.98199f, 72.24729f, 75.962746f, 79.10008f, 81.63542f, 83.54946f, 84.827644f, 85.46023f, 85.44242f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.472504f, 45.306736f, 51.796158f, 57.89138f, 63.546013f, 68.717026f, 73.36505f, 77.454735f, 80.95493f, 83.83902f, 86.085045f, 87.6759f, 88.599495f, 88.84879f, 88.421906f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 38.65087f, 45.249916f, 51.50458f, 57.367268f, 62.79335f, 67.74154f, 72.17417f, 76.05752f, 79.36202f, 82.06253f, 84.1385f, 85.57412f, 86.35847f, 86.48557f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 45.23713f, 51.838573f, 58.045494f, 63.81065f, 69.09017f, 73.84387f, 78.03558f, 81.63339f, 84.60992f, 86.94251f, 88.61343f, 89.60994f, 89.92446f, 89.5546f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 44.84471f, 51.837936f, 58.43664f, 64.59061f, 70.253006f, 75.38073f, 79.93477f, 83.88045f, 87.18775f, 89.8315f, 91.79158f, 93.05307f, 93.60637f, 93.447266f, 92.57697f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 50.711594f, 57.729347f, 64.30775f, 70.39673f, 75.94994f, 80.92513f, 85.28444f, 88.994675f, 92.02761f, 94.36016f, 95.97457f, 96.85855f, 97.00539f, 96.41395f, 95.088745f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 50.699394f, 57.440914f, 63.745277f, 69.5645f, 74.85429f, 79.574394f, 83.68889f, 87.166466f, 89.98065f, 92.11003f, 93.53839f, 94.254875f, 94.25402f, 93.535835f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.50912f, 57.61891f, 64.290184f, 70.47217f, 76.11782f, 81.18417f, 85.63266f, 89.42943f, 92.545586f, 94.95742f, 96.64657f, 97.60018f, 97.81099f, 97.277405f, 96.00348f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 57.459076f, 64.53725f, 71.12425f, 77.16996f, 82.62836f, 87.45791f, 91.62184f, 95.088486f, 97.83144f, 99.82985f, 101.06849f, 101.53793f, 101.23461f, 100.160835f, 98.324776f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.13202f, 63.639244f, 70.66213f, 77.14724f, 83.04521f, 88.31116f, 92.905f, 96.79179f, 99.94192f, 102.33144f, 103.942154f, 104.76181f, 104.784164f, 104.00904f, 102.44235f, 100.096016f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.23026f, 63.42544f, 70.137924f, 76.316605f, 81.914474f, 86.88893f, 91.2021f, 94.821175f, 97.7186f, 99.87233f, 101.26597f, 101.88891f, 101.73642f, 100.80965f, 99.11566f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.96194f, 63.523888f, 70.60238f, 77.14354f, 83.097595f, 88.41923f, 93.06794f, 97.00835f, 100.21046f, 102.64991f, 104.30813f, 105.17251f, 105.23646f, 104.49949f, 102.967224f, 100.65131f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.315937f, 70.79301f, 77.7313f, 84.07801f, 89.784836f, 94.80834f, 99.110306f, 102.657974f, 105.424355f, 107.3884f, 108.53514f, 108.85587f, 108.348145f, 107.015816f, 104.86904f, 101.92415f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 69.82322f, 77.18679f, 83.96293f, 90.10005f, 95.55146f, 100.275665f, 104.23671f, 107.40445f, 109.754776f, 111.269806f, 111.938f, 111.75429f, 110.720055f, 108.84317f, 106.137924f, 102.62491f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.151375f, 69.704445f, 76.72703f, 83.16567f, 88.97137f, 94.099945f, 98.51236f, 102.17504f, 105.060104f, 107.14559f, 108.41565f, 108.86059f, 108.477036f, 107.26791f, 105.24241f, 102.41595f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 69.82322f, 77.18679f, 83.96293f, 90.10005f, 95.55146f, 100.275665f, 104.23671f, 107.40445f, 109.754776f, 111.269806f, 111.938f, 111.75429f, 110.720055f, 108.84317f, 106.137924f, 102.62491f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 69.694595f, 77.42439f, 84.56495f, 91.06191f, 96.865845f, 101.93256f, 106.22351f, 109.70604f, 112.35364f, 114.14616f, 115.069954f, 115.118f, 114.289925f, 112.59204f, 110.03726f, 106.64503f, 102.44116f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.39959f, 76.51461f, 84.04731f, 90.94036f, 97.141304f, 102.602936f, 107.2837f, 111.14797f, 114.16634f, 116.315834f, 117.58009f, 117.9495f, 117.421234f, 115.99933f, 113.694595f, 110.524574f, 106.5134f, 101.69159f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.318306f, 83.26143f, 90.57088f, 97.19103f, 103.07151f, 108.16754f, 112.44036f, 115.85744f, 118.39277f, 120.027054f, 120.74787f, 120.54972f, 119.43411f, 117.40954f, 114.49141f, 110.70193f, 106.06994f, 100.63069f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.86504f, 81.23615f, 88.989006f, 96.0646f, 102.40908f, 107.97417f, 112.71751f, 116.603f, 119.60107f, 121.6889f, 122.85061f, 123.077354f, 122.3674f, 120.72616f, 118.16612f, 114.706764f, 110.37442f, 105.202065f, 99.22905f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 78.88266f, 87.08854f, 94.631615f, 101.45449f, 107.50523f, 112.7378f, 117.11236f, 120.59563f, 123.16109f, 124.789215f, 125.46763f, 125.191154f, 123.9619f, 121.789215f, 118.689644f, 114.686775f, 109.81107f, 104.09964f, 97.59594f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 83.85773f, 91.892f, 99.22692f, 105.80666f, 111.58116f, 116.50645f, 120.54506f, 123.666245f, 125.84626f, 127.068504f, 127.323685f, 126.60985f, 124.93244f, 122.30422f, 118.74519f, 114.28244f, 108.94993f, 102.788246f, 95.84428f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.25628f, 88.78093f, 96.629906f, 103.74346f, 110.067474f, 115.5538f, 120.160706f, 123.8531f, 126.602905f, 128.38919f, 129.19835f, 129.02423f, 127.868164f, 125.73894f, 122.65277f, 118.63313f, 113.71063f, 107.92272f, 101.31345f, 93.93313f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.24953f, 92.630135f, 100.30576f, 107.21801f, 113.31427f, 118.54813f, 122.87977f, 126.27622f, 128.71164f, 130.16747f, 130.63266f, 130.10365f, 128.58447f, 126.0867f, 122.62932f, 118.23866f, 112.948135f, 106.798004f, 99.835075f, 92.11234f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.206566f, 96.4343f, 103.92811f, 110.63097f, 116.49185f, 121.46617f, 125.51605f, 128.61069f, 130.7265f, 131.84743f, 131.9649f, 131.07805f, 129.1936f, 126.32593f, 122.49683f, 117.735466f, 112.07806f, 105.56767f, 98.253845f, 90.19225f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.275375f, 91.06351f, 99.158585f, 106.49901f, 113.02891f, 118.69859f, 123.464905f, 127.29158f, 130.14949f, 132.01688f, 132.87955f, 132.73091f, 131.57211f, 129.41197f, 126.26694f, 122.160934f, 117.125206f, 111.19809f, 104.42468f, 96.856544f, 88.55127f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.22163f, 93.89391f, 101.8516f, 109.03414f, 115.38686f, 120.86142f, 125.41615f, 129.01639f, 131.63474f, 133.25125f, 133.85367f, 133.43736f, 132.00551f, 129.56903f, 126.14645f, 121.76381f, 116.45448f, 110.258865f, 103.224106f, 95.403755f, 86.85732f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.03636f, 95.618965f, 103.47386f, 110.54125f, 116.76736f, 122.10479f, 126.51294f, 129.95824f, 132.41449f, 133.86298f, 134.2927f, 133.70035f, 132.09047f, 129.47531f, 125.874756f, 121.31622f, 115.834404f, 109.47101f, 102.274475f, 94.299576f, 85.606995f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 88.83881f, 97.32974f, 105.07993f, 112.0304f, 118.12825f, 123.32707f, 127.587296f, 130.87651f, 133.16968f, 134.44934f, 134.70575f, 133.93698f, 132.14886f, 129.35503f, 125.576706f, 120.842674f, 115.18896f, 108.658585f, 101.301254f, 93.17296f, 84.33556f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 89.49992f, 97.93747f, 105.629654f, 112.51793f, 118.54988f, 123.67959f, 127.86803f, 131.08331f, 133.30096f, 134.50414f, 134.68362f, 133.8381f, 131.974f, 129.10548f, 125.2544f, 120.45006f, 114.72901f, 108.13481f, 100.71764f, 92.53395f, 83.64601f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.157196f, 98.541f, 106.17485f, 113.00064f, 118.96643f, 124.02682f, 128.14328f, 131.2845f, 133.42656f, 134.55316f, 134.65575f, 133.7335f, 131.79347f, 128.85042f, 124.92673f, 120.05228f, 114.26415f, 107.60641f, 100.129715f, 91.89097f, 82.95288f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.555874f, 35.161144f, 43.335682f, 51.18041f, 58.635624f, 65.644585f, 72.153946f, 78.11418f, 83.47991f, 88.21032f, 92.26939f, 95.62623f, 98.255295f, 100.13659f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 34.098995f, 42.099335f, 50.267666f, 58.053425f, 65.39736f, 72.24359f, 78.53999f, 84.23867f, 89.296234f, 93.674194f, 97.33924f, 100.26348f, 102.42465f, 103.80631f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 33.060234f, 40.79117f, 49.049038f, 57.212807f, 64.941154f, 72.175255f, 78.86006f, 84.9447f, 90.38285f, 95.13314f, 99.1594f, 102.43101f, 104.92305f, 106.61656f, 107.49866f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.769142f, 46.735126f, 55.182648f, 63.33236f, 71.00008f, 78.12743f, 84.6602f, 90.54865f, 95.74797f, 100.21859f, 103.92649f, 106.843445f, 108.94725f, 110.22191f, 110.65771f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 39.06956f, 46.921352f, 55.25291f, 63.163963f, 70.5943f, 77.487366f, 83.79071f, 89.45636f, 94.441185f, 98.70726f, 102.222115f, 104.95899f, 106.89707f, 108.0216f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 46.039158f, 54.291187f, 62.566147f, 70.36494f, 77.62821f, 84.30069f, 90.33158f, 95.675f, 100.290276f, 104.14228f, 107.2017f, 109.44525f, 110.85585f, 111.422775f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 45.08902f, 53.16206f, 61.66781f, 69.878746f, 77.55787f, 84.64672f, 91.09137f, 96.84275f, 101.8571f, 106.09626f, 109.52796f, 112.12609f, 113.87087f, 114.74902f, 114.75387f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 51.16514f, 59.505066f, 68.1593f, 76.294815f, 83.84967f, 90.76638f, 96.9923f, 102.48006f, 107.187874f, 111.07993f, 114.1266f, 116.304695f, 117.59765f, 117.995605f, 117.495544f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 51.39688f, 59.737476f, 68.111824f, 75.967804f, 83.24561f, 89.889885f, 95.85003f, 101.0807f, 105.54209f, 109.20024f, 112.027306f, 114.001785f, 115.108635f, 115.33944f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.75343f, 58.943035f, 67.52135f, 75.76031f, 83.42268f, 90.450165f, 96.78926f, 102.39173f, 107.21494f, 111.22218f, 114.38296f, 116.6732f, 118.0755f, 118.57917f, 118.180374f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 58.017128f, 66.62559f, 75.28504f, 83.37154f, 90.82352f, 97.584274f, 103.602356f, 108.83196f, 113.23329f, 116.77285f, 119.4237f, 121.16566f, 121.98547f, 121.8769f, 120.840775f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.25419f, 64.719864f, 73.53036f, 82.07787f, 90.000725f, 97.238625f, 103.73647f, 109.44483f, 114.320244f, 118.32561f, 121.43045f, 123.61112f, 124.85105f, 125.14078f, 124.47811f, 122.868095f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.579216f, 64.95804f, 73.67959f, 81.910194f, 89.51742f, 96.44337f, 102.635315f, 108.04615f, 112.63469f, 116.366005f, 119.211716f, 121.15015f, 122.16655f, 122.2532f, 121.40942f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.979397f, 64.39559f, 73.15897f, 81.76682f, 89.75239f, 97.05488f, 103.61872f, 109.39396f, 114.33665f, 118.40917f, 121.58052f, 123.82658f, 125.130226f, 125.48157f, 124.877914f, 123.32387f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.699764f, 72.39504f, 81.376335f, 89.77321f, 97.486855f, 104.458565f, 110.635284f, 115.97001f, 120.42213f, 123.957756f, 126.549995f, 128.17911f, 128.8327f, 128.50581f, 127.200905f, 124.927925f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.534904f, 96.704605f, 104.13832f, 110.77949f, 116.577545f, 121.48839f, 125.474625f, 128.50592f, 130.55922f, 131.61888f, 131.67683f, 130.73265f, 128.79352f, 125.87418f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.430573f, 71.09809f, 80.06176f, 88.555725f, 96.37573f, 103.46226f, 109.761375f, 115.22514f, 119.81198f, 123.48698f, 126.22216f, 127.99671f, 128.79713f, 128.61734f, 127.45868f, 125.32999f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.534904f, 96.704605f, 104.13832f, 110.77949f, 116.577545f, 121.48839f, 125.474625f, 128.50592f, 130.55922f, 131.61888f, 131.67683f, 130.73265f, 128.79352f, 125.87418f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 70.11328f, 79.09583f, 88.31328f, 96.85861f, 104.66679f, 111.67839f, 117.84005f, 123.10487f, 127.4328f, 130.79088f, 133.15356f, 134.50287f, 134.82854f, 134.12807f, 132.4068f, 129.67784f, 125.96196f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.486855f, 77.52561f, 86.81171f, 95.76864f, 103.996704f, 111.4333f, 118.02182f, 123.71212f, 128.46089f, 132.23201f, 134.99675f, 136.73409f, 137.4308f, 137.08157f, 135.68909f, 133.26392f, 129.82452f, 125.39709f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.77184f, 85.03714f, 94.42244f, 103.08912f, 110.97123f, 118.00879f, 124.148224f, 129.34282f, 133.55304f, 136.74683f, 138.8999f, 139.99586f, 140.02637f, 138.9912f, 136.89821f, 133.76334f, 129.61046f, 124.47116f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.93485f, 82.21233f, 91.70147f, 100.84166f, 109.21438f, 116.75591f, 123.40886f, 129.12259f, 133.85364f, 137.56596f, 140.23132f, 141.82945f, 142.34816f, 141.78352f, 140.13982f, 137.42957f, 133.6734f, 128.8999f, 123.145386f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 79.26649f, 88.69057f, 98.27665f, 107.14969f, 115.20725f, 122.38802f, 128.63734f, 133.90765f, 138.15886f, 141.35858f, 143.48248f, 144.51439f, 144.44646f, 143.2792f, 141.02151f, 137.69055f, 133.31169f, 127.91824f, 121.55126f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 84.59006f, 94.24059f, 103.64486f, 112.26033f, 120.02143f, 126.869095f, 132.7512f, 137.623f, 141.44742f, 144.19531f, 145.84581f, 146.38632f, 145.81274f, 144.12946f, 141.34924f, 137.49329f, 132.59091f, 126.67945f, 119.80388f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.46569f, 90.03551f, 99.75745f, 108.92958f, 117.27269f, 124.72329f, 131.22467f, 136.72736f, 141.18945f, 144.57703f, 146.86427f, 148.0338f, 148.07669f, 146.99263f, 144.78987f, 141.48517f, 137.10368f, 131.67876f, 125.25167f, 117.871346f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.66821f, 94.30157f, 104.0541f, 113.01471f, 121.11521f, 128.29396f, 134.4963f, 139.67505f, 143.7908f, 146.8122f, 148.71628f, 149.48853f, 149.12308f, 147.62273f, 144.99887f, 141.27148f, 136.46893f, 130.62776f, 123.79245f, 116.015f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.90405f, 98.730865f, 108.29466f, 117.03427f, 124.88318f, 131.78166f, 137.67719f, 142.52492f, 146.28795f, 148.93764f, 150.45381f, 150.82495f, 150.04822f, 148.12953f, 145.0835f, 140.93327f, 135.71048f, 129.45483f, 122.21396f, 114.04296f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.36264f, 92.0745f, 101.92298f, 111.32728f, 119.884315f, 127.52895f, 134.20302f, 139.85573f, 144.44403f, 147.93304f, 150.29619f, 151.5155f, 151.58168f, 150.49423f, 148.26143f, 144.90027f, 140.43634f, 134.9036f, 128.34415f, 120.80793f, 112.352295f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.465935f, 95.21803f, 105.08276f, 114.32227f, 122.69172f, 130.12741f, 136.57275f, 141.97868f, 146.3041f, 149.51602f, 151.59004f, 152.51038f, 152.27002f, 150.87079f, 148.32335f, 144.64706f, 139.86993f, 134.02832f, 127.16666f, 119.33718f, 110.59948f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.385315f, 97.151566f, 107.015526f, 116.13484f, 124.3703f, 131.65923f, 137.94615f, 143.18321f, 147.33058f, 150.35666f, 152.23843f, 152.9616f, 152.52061f, 150.91885f, 148.16852f, 144.29053f, 139.3144f, 133.27802f, 126.22729f, 118.215904f, 109.304825f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 89.29236f, 99.10546f, 108.93149f, 117.92849f, 126.02798f, 133.16832f, 139.29517f, 144.3619f, 148.32994f, 151.16911f, 152.85779f, 153.38313f, 152.74112f, 150.93668f, 147.9835f, 143.90408f, 138.72948f, 132.49905f, 125.26022f, 117.0681f, 107.98501f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 90.00573f, 99.86954f, 109.63591f, 118.56789f, 126.59749f, 133.6636f, 139.71246f, 144.69803f, 148.58235f, 151.33588f, 152.93764f, 153.37546f, 152.646f, 150.7548f, 147.71628f, 143.55354f, 138.29828f, 131.99048f, 124.678154f, 116.41695f, 107.269745f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.71525f, 100.62934f, 110.33564f, 119.20221f, 127.16158f, 134.15318f, 140.1238f, 145.02797f, 148.82841f, 151.49617f, 153.01096f, 153.36122f, 152.54433f, 150.56648f, 147.44273f, 143.19685f, 137.86115f, 131.47626f, 124.09074f, 115.76082f, 106.54989f}}};
        this.lut_y0 = newlut_y;
    }

    /*
     * Opcode count of 20224 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initYTable1() {
        float[][][] newlut_y = new float[][][]{new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.555874f, 35.161144f, 43.4753f, 52.295834f, 61.555737f, 70.62636f, 79.15948f, 87.09014f, 94.357994f, 100.90773f, 106.68949f, 111.65929f, 115.77928f, 119.01813f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 34.098995f, 42.099335f, 50.61662f, 59.58602f, 68.939026f, 77.83718f, 86.14294f, 93.793106f, 100.72945f, 106.89917f, 112.25533f, 116.757164f, 120.3704f, 123.06755f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 33.060234f, 40.79117f, 49.049038f, 57.77086f, 67.029495f, 76.336044f, 85.06163f, 93.139854f, 100.50922f, 107.113655f, 112.902885f, 117.832855f, 121.86605f, 124.97177f, 127.12638f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.769142f, 46.735126f, 55.2001f, 64.20406f, 73.55666f, 82.75072f, 91.31499f, 99.184296f, 106.29875f, 112.60421f, 118.05268f, 122.60271f, 126.21964f, 128.87598f, 130.55148f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 39.06956f, 46.921352f, 55.392532f, 64.27939f, 73.51441f, 82.46915f, 90.796234f, 98.43231f, 105.31926f, 111.40467f, 116.64222f, 120.99205f, 124.42106f, 126.903145f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 46.039158f, 54.291187f, 62.967403f, 72.00168f, 81.324905f, 90.046646f, 98.083084f, 105.373055f, 111.86106f, 117.49775f, 122.2402f, 126.05233f, 128.90514f, 130.77689f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 45.08902f, 53.16206f, 61.66781f, 70.64593f, 79.95847f, 89.11603f, 97.59536f, 105.331924f, 112.26686f, 118.34737f, 123.52718f, 127.766884f, 131.0342f, 133.30426f, 134.55981f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 51.16514f, 59.505066f, 68.333824f, 77.47983f, 86.87353f, 95.85037f, 104.09775f, 111.552864f, 118.159004f, 123.86588f, 128.63007f, 132.4153f, 135.19276f, 136.94133f, 137.6477f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 51.39688f, 59.737476f, 68.46078f, 77.5004f, 86.787285f, 95.483475f, 103.45298f, 110.63514f, 116.9753f, 122.42522f, 126.9434f, 130.49547f, 133.05438f, 134.60068f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.75343f, 58.943035f, 67.52135f, 76.52749f, 85.82329f, 94.91947f, 103.29325f, 110.880905f, 117.624695f, 123.47329f, 128.38217f, 132.314f, 135.23883f, 137.13441f, 137.98631f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 58.017128f, 66.62559f, 75.56424f, 84.765175f, 94.15824f, 102.97433f, 111.00672f, 118.19428f, 124.482315f, 129.82297f, 134.17558f, 137.50703f, 139.79198f, 141.01303f, 141.16087f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.25419f, 64.719864f, 73.53036f, 82.618515f, 92.03699f, 101.34792f, 109.887535f, 117.59084f, 124.39921f, 130.26082f, 135.13107f, 138.9729f, 141.75705f, 143.46234f, 144.0758f, 143.59276f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.579216f, 64.95804f, 73.7494f, 82.886375f, 92.22989f, 101.22043f, 109.44061f, 116.827896f, 123.32604f, 128.8856f, 133.46428f, 137.0272f, 139.54726f, 141.00528f, 141.39018f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.979397f, 64.39559f, 73.15897f, 82.20294f, 91.47597f, 100.85483f, 109.466125f, 117.244316f, 124.13021f, 130.0714f, 135.02266f, 138.94632f, 141.81252f, 143.59944f, 144.29347f, 143.88936f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.699764f, 72.39504f, 81.48105f, 90.81902f, 100.30317f, 109.338036f, 117.540764f, 124.848946f, 131.20694f, 136.56638f, 140.88646f, 144.13432f, 146.28522f, 147.32281f, 147.23918f, 146.03497f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 107.88665f, 116.57618f, 124.378494f, 131.2342f, 137.09116f, 141.90475f, 145.63838f, 148.2636f, 149.76045f, 150.11752f, 149.33212f, 147.41022f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.430573f, 71.09809f, 80.06176f, 89.39259f, 98.88034f, 108.03424f, 116.36594f, 123.81201f, 130.31581f, 135.82782f, 140.30609f, 143.71657f, 146.03325f, 147.23856f, 147.32327f, 146.28677f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 107.88665f, 116.57618f, 124.378494f, 131.2342f, 137.09116f, 141.90475f, 145.63838f, 148.2636f, 149.76045f, 150.11752f, 149.33212f, 147.41022f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 70.11328f, 79.09583f, 88.452896f, 97.97404f, 107.5869f, 116.660164f, 124.84557f, 132.08083f, 138.31088f, 143.4883f, 147.57367f, 150.53593f, 152.35252f, 153.00961f, 152.50221f, 150.83417f, 148.0182f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.486855f, 77.52561f, 86.81171f, 96.274445f, 105.92878f, 115.43956f, 124.07178f, 131.75974f, 138.44492f, 144.07645f, 148.61147f, 152.01547f, 154.26254f, 155.33559f, 155.22644f, 153.93591f, 151.47385f, 147.85896f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.77184f, 85.03714f, 94.596954f, 104.27413f, 113.99509f, 123.09278f, 131.25366f, 138.41563f, 144.52417f, 149.53278f, 153.40337f, 156.10646f, 157.62149f, 157.93692f, 157.05035f, 154.96855f, 151.70734f, 147.29153f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.93485f, 82.21233f, 91.70147f, 101.33005f, 111.09434f, 120.71062f, 129.40822f, 137.12096f, 143.7901f, 149.36493f, 153.803f, 157.07053f, 159.14267f, 160.00363f, 159.64687f, 158.07509f, 155.30028f, 151.34352f, 146.23495f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 79.26649f, 88.69057f, 98.38136f, 108.1955f, 118.02357f, 127.26749f, 135.54282f, 142.78659f, 148.94368f, 153.96721f, 157.81895f, 160.4696f, 161.89897f, 162.0962f, 161.05978f, 158.79759f, 155.32687f, 150.67401f, 144.87444f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 84.59006f, 94.24059f, 104.01125f, 113.827644f, 123.614784f, 132.5135f, 140.40372f, 147.22536f, 152.92654f, 157.46385f, 160.80276f, 162.91788f, 163.79309f, 163.42174f, 161.80664f, 158.9601f, 154.90378f, 149.66855f, 143.29425f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.46569f, 90.03551f, 99.75745f, 109.62706f, 119.56926f, 129.08984f, 137.62798f, 145.11868f, 151.50494f, 156.73816f, 160.7785f, 163.59523f, 165.1669f, 165.48154f, 164.53677f, 162.33978f, 158.90729f, 154.26541f, 148.44948f, 141.50377f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.66821f, 94.30157f, 104.19372f, 114.130135f, 124.035324f, 133.27573f, 141.50183f, 148.65102f, 154.66887f, 159.50961f, 163.13638f, 165.52158f, 166.64706f, 166.50427f, 165.09427f, 162.42781f, 158.52516f, 153.41606f, 147.13936f, 139.74284f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.90405f, 98.730865f, 108.643616f, 118.56687f, 128.42485f, 137.37524f, 145.28014f, 152.07936f, 157.72116f, 162.16261f, 165.3699f, 167.31863f, 167.99397f, 167.39078f, 165.51363f, 162.37682f, 158.00423f, 152.42914f, 145.69395f, 137.84996f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.36264f, 92.0745f, 101.92298f, 111.83309f, 121.81638f, 131.53522f, 140.25298f, 147.90334f, 154.42805f, 159.7775f, 163.91092f, 166.79689f, 168.41342f, 168.74825f, 167.79878f, 165.57227f, 162.08565f, 157.36546f, 151.44763f, 144.3772f, 136.20796f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.465935f, 95.21803f, 105.08276f, 115.089455f, 125.09233f, 134.59671f, 143.07674f, 150.46786f, 156.71384f, 161.76712f, 165.58926f, 168.15117f, 169.43335f, 169.42603f, 168.12929f, 165.55296f, 161.71669f, 156.64966f, 150.39043f, 142.98663f, 134.49461f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.385315f, 97.151566f, 107.085335f, 117.11102f, 127.08276f, 136.4363f, 144.75145f, 151.96497f, 158.02193f, 162.87625f, 166.491f, 168.83864f, 169.90132f, 169.67094f, 168.14928f, 165.34789f, 161.2881f, 156.00081f, 149.52628f, 141.91374f, 133.22116f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 89.29236f, 99.10546f, 109.10601f, 119.1135f, 129.05183f, 138.2523f, 146.4006f, 153.43471f, 159.30107f, 163.95506f, 167.36125f, 169.49373f, 170.33624f, 169.8824f, 168.13567f, 165.1093f, 160.82635f, 155.31943f, 148.63043f, 140.81026f, 131.91844f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 90.00573f, 99.86954f, 109.86278f, 119.85725f, 129.77686f, 138.90076f, 146.96753f, 153.9158f, 159.69267f, 164.25418f, 167.56563f, 169.60179f, 170.3472f, 169.79614f, 167.95284f, 164.83131f, 160.45532f, 154.85818f, 148.08246f, 140.17975f, 131.21019f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.71525f, 100.62934f, 110.61483f, 120.595856f, 130.4963f, 139.54324f, 147.52815f, 154.39029f, 160.07742f, 164.54628f, 167.76283f, 169.7026f, 170.35085f, 169.7026f, 167.76283f, 164.54628f, 160.07742f, 154.39029f, 147.52815f, 139.54324f, 130.4963f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.555874f, 35.161144f, 43.4753f, 52.295834f, 61.555737f, 71.18441f, 81.24782f, 91.25092f, 100.55956f, 109.10288f, 116.81586f, 123.63979f, 129.52277f, 134.41998f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 34.098995f, 42.099335f, 50.61662f, 59.58602f, 69.00884f, 78.81336f, 88.85541f, 98.57016f, 107.534744f, 115.680916f, 122.94669f, 129.27676f, 134.62297f, 138.94461f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 33.060234f, 40.79117f, 49.049038f, 57.77086f, 67.029495f, 76.61524f, 86.45528f, 96.47458f, 105.89928f, 114.51801f, 122.265205f, 129.08188f, 134.91615f, 139.72365f, 143.46776f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.769142f, 46.735126f, 55.2001f, 64.20406f, 73.55666f, 83.18684f, 93.03857f, 102.98425f, 112.14616f, 120.45457f, 127.846245f, 134.26494f, 139.66179f, 143.99573f, 147.23376f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 39.06956f, 46.921352f, 55.392532f, 64.27939f, 73.51441f, 83.0272f, 92.884575f, 102.5931f, 111.520836f, 119.59982f, 126.768585f, 132.97256f, 138.16454f, 142.305f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 46.039158f, 54.291187f, 62.967403f, 72.00168f, 81.44707f, 91.127266f, 100.95131f, 110.30368f, 118.81658f, 126.42522f, 133.07167f, 138.70538f, 143.28345f, 146.77106f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 45.08902f, 53.16206f, 61.66781f, 70.64593f, 79.95847f, 89.499855f, 99.19739f, 108.97696f, 117.96205f, 126.049385f, 133.17741f, 139.29187f, 144.34624f, 148.30203f, 151.12917f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 51.16514f, 59.505066f, 68.333824f, 77.47983f, 86.87353f, 96.47815f, 106.290215f, 115.816574f, 124.4615f, 132.1592f, 138.85109f, 144.48624f, 149.02176f, 152.42313f, 154.66447f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 51.39688f, 59.737476f, 68.46078f, 77.5004f, 86.85709f, 96.459656f, 106.16544f, 115.4122f, 123.7806f, 131.20695f, 137.63475f, 143.01506f, 147.30695f, 150.47772f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.75343f, 58.943035f, 67.52135f, 76.52749f, 85.82329f, 95.30329f, 104.89529f, 114.52594f, 123.31989f, 131.17531f, 138.0324f, 143.83897f, 148.55086f, 152.13217f, 154.55568f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 58.017128f, 66.62559f, 75.56424f, 84.765175f, 94.15824f, 103.811195f, 113.51133f, 122.766266f, 131.08687f, 138.40982f, 144.6794f, 149.84787f, 153.87592f, 156.73288f, 158.397f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.25419f, 64.719864f, 73.53036f, 82.618515f, 92.03699f, 101.60967f, 111.24642f, 120.873795f, 129.73831f, 137.61545f, 144.44525f, 150.17574f, 154.76329f, 158.173f, 160.37892f, 161.36426f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.579216f, 64.95804f, 73.7494f, 82.886375f, 92.22989f, 101.70882f, 111.32057f, 120.78261f, 129.32541f, 136.88396f, 143.40076f, 148.82617f, 153.11894f, 156.24637f, 158.18468f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.979397f, 64.39559f, 73.15897f, 82.20294f, 91.47597f, 101.011894f, 110.61635f, 120.21631f, 129.1631f, 137.12689f, 144.04707f, 149.87096f, 154.55423f, 158.06125f, 160.36534f, 161.44894f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.699764f, 72.39504f, 81.48105f, 90.81902f, 100.30317f, 109.86126f, 119.52493f, 128.90672f, 137.30746f, 144.66321f, 150.91798f, 156.02417f, 159.94293f, 162.64442f, 164.1081f, 164.3228f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.21599f, 144.09668f, 150.88072f, 156.51646f, 160.96101f, 164.18056f, 166.15059f, 166.85611f, 166.29176f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.430573f, 71.09809f, 80.06176f, 89.39259f, 98.88034f, 108.45293f, 118.03737f, 127.56034f, 136.1125f, 143.62877f, 150.05193f, 155.3331f, 159.4321f, 162.31772f, 163.968f, 164.37039f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.21599f, 144.09668f, 150.88072f, 156.51646f, 160.96101f, 164.18056f, 166.15059f, 166.85611f, 166.29176f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 70.11328f, 79.09583f, 88.452896f, 97.97404f, 107.5869f, 117.218216f, 126.933914f, 136.24162f, 144.51245f, 151.68344f, 157.70004f, 162.51645f, 166.096f, 168.41145f, 169.4452f, 169.18938f, 167.64592f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.486855f, 77.52561f, 86.81171f, 96.274445f, 105.92878f, 115.66642f, 125.36113f, 134.93909f, 143.68205f, 151.3315f, 157.82924f, 163.1258f, 167.18086f, 169.96358f, 171.45277f, 171.6371f, 170.51518f, 168.09554f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.77184f, 85.03714f, 94.596954f, 104.27413f, 113.99509f, 123.72056f, 133.44614f, 142.67934f, 150.82666f, 157.8261f, 163.62439f, 168.1774f, 171.45049f, 173.41872f, 174.06712f, 173.3908f, 171.39484f, 168.09447f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.93485f, 82.21233f, 91.70147f, 101.33005f, 111.09434f, 120.92004f, 130.66281f, 140.24849f, 148.97623f, 156.57014f, 162.97249f, 168.1345f, 172.0169f, 174.59018f, 175.8347f, 175.74101f, 174.30983f, 171.55205f, 167.48865f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 79.26649f, 88.69057f, 98.38136f, 108.1955f, 118.02357f, 127.79071f, 137.527f, 146.84438f, 155.0442f, 162.06404f, 167.85046f, 172.35945f, 175.55669f, 177.41782f, 177.9287f, 177.08543f, 174.89444f, 171.37239f, 166.5461f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 84.59006f, 94.24059f, 104.01125f, 113.827644f, 123.70205f, 133.5245f, 143.1681f, 152.05363f, 159.78194f, 166.2942f, 171.54088f, 175.48203f, 178.08765f, 179.3379f, 179.2233f, 177.74469f, 174.91335f, 170.7508f, 165.28874f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.46569f, 90.03551f, 99.75745f, 109.62706f, 119.56926f, 129.4388f, 139.16057f, 148.66034f, 157.09853f, 164.34111f, 170.33295f, 175.02844f, 178.39188f, 180.39763f, 181.03046f, 180.28554f, 178.16852f, 174.69554f, 169.89302f, 163.79752f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.66821f, 94.30157f, 104.19372f, 114.130135f, 124.035324f, 133.83379f, 143.59016f, 152.8118f, 160.87044f, 167.70476f, 173.26274f, 177.50209f, 180.39055f, 181.90611f, 182.03728f, 180.78302f, 178.1529f, 174.16692f, 168.85542f, 162.25883f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.90405f, 98.730865f, 108.643616f, 118.56687f, 128.49466f, 138.35143f, 147.9926f, 156.85641f, 164.52646f, 170.94435f, 176.06126f, 179.83824f, 182.24654f, 183.26782f, 182.89433f, 181.12892f, 177.98499f, 173.4865f, 167.66766f, 160.57277f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.36264f, 92.0745f, 101.92298f, 111.83309f, 121.81638f, 131.76207f, 141.54233f, 151.0827f, 159.66519f, 167.03255f, 173.12868f, 177.9072f, 181.33174f, 183.37624f, 184.02512f, 183.27347f, 181.127f, 177.60204f, 172.72542f, 166.53426f, 159.07565f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.465935f, 95.21803f, 105.08276f, 115.089455f, 125.09233f, 134.98055f, 144.67877f, 154.1129f, 162.40904f, 169.46915f, 175.23949f, 179.67616f, 182.74538f, 184.4238f, 184.69864f, 183.56783f, 181.03993f, 177.13422f, 171.88042f, 165.3185f, 157.4984f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.385315f, 97.151566f, 107.085335f, 117.11102f, 127.08276f, 136.92468f, 146.63141f, 155.91968f, 164.02129f, 170.87462f, 176.42747f, 180.63762f, 183.47299f, 184.91203f, 184.94379f, 183.568f, 180.79515f, 176.64633f, 171.15314f, 164.35736f, 156.31073f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 89.29236f, 99.10546f, 109.10601f, 119.1135f, 129.05183f, 138.88008f, 148.59308f, 157.69841f, 165.60356f, 172.24838f, 177.58228f, 181.56467f, 184.16524f, 185.3642f, 185.15244f, 183.53154f, 180.51385f, 176.12236f, 170.39047f, 163.3618f, 155.08984f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 90.00573f, 99.86954f, 109.86278f, 119.85725f, 129.77686f, 139.63309f, 149.31612f, 158.33374f, 166.14633f, 172.69446f, 177.92827f, 181.80795f, 184.30396f, 185.3973f, 185.07965f, 183.35344f, 180.2318f, 175.73848f, 169.9077f, 162.7838f, 154.42104f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.71525f, 100.62934f, 110.61483f, 120.595856f, 130.4963f, 140.38011f, 150.03276f, 158.96227f, 166.68198f, 173.13313f, 178.26665f, 182.04344f, 184.43478f, 185.42245f, 184.99895f, 183.1675f, 179.94202f, 175.34708f, 169.41765f, 162.19884f, 153.74559f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.555874f, 35.161144f, 43.4753f, 52.295834f, 61.555737f, 71.18441f, 81.24782f, 91.53012f, 101.9532f, 112.43761f, 122.20592f, 131.04416f, 138.88509f, 145.669f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 34.098995f, 42.099335f, 50.61662f, 59.58602f, 69.00884f, 78.81336f, 88.85541f, 99.05855f, 109.4147f, 119.63563f, 128.94604f, 137.27512f, 144.55943f, 150.74358f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 33.060234f, 40.79117f, 49.049038f, 57.77086f, 67.029495f, 76.61524f, 86.45528f, 96.47458f, 106.736145f, 117.02262f, 126.83718f, 135.68643f, 143.50302f, 150.22748f, 155.8086f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.769142f, 46.735126f, 55.2001f, 64.20406f, 73.55666f, 83.18684f, 93.03857f, 103.14132f, 113.29638f, 123.42656f, 132.87914f, 141.32043f, 148.68619f, 154.92035f, 159.97548f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 39.06956f, 46.921352f, 55.392532f, 64.27939f, 73.51441f, 83.0272f, 92.884575f, 102.8723f, 112.914474f, 122.934555f, 132.15865f, 140.37692f, 147.52686f, 153.55402f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 46.039158f, 54.291187f, 62.967403f, 72.00168f, 81.44707f, 91.127266f, 100.95131f, 110.84432f, 120.852844f, 130.53452f, 139.22273f, 146.8514f, 153.36241f, 158.70627f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 45.08902f, 53.16206f, 61.66781f, 70.64593f, 79.95847f, 89.499855f, 99.19739f, 109.08168f, 119.007866f, 128.8657f, 138.05687f, 146.19734f, 153.22517f, 159.08685f, 163.7378f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 51.16514f, 59.505066f, 68.333824f, 77.47983f, 86.87353f, 96.47815f, 106.290215f, 116.13065f, 125.92464f, 135.59743f, 144.34297f, 151.98996f, 158.48022f, 163.76436f, 167.80214f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 51.39688f, 59.737476f, 68.46078f, 77.5004f, 86.85709f, 96.459656f, 106.16544f, 115.90059f, 125.66056f, 135.16167f, 143.63411f, 151.01341f, 157.24342f, 162.2767f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.75343f, 58.943035f, 67.52135f, 76.52749f, 85.82329f, 95.30329f, 104.89529f, 114.63066f, 124.36571f, 133.99162f, 142.91187f, 150.74446f, 157.4298f, 162.91699f, 167.1643f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 58.017128f, 66.62559f, 75.56424f, 84.765175f, 94.15824f, 103.811195f, 113.51133f, 123.18495f, 132.7583f, 142.15816f, 150.47609f, 157.64882f, 163.62175f, 168.34941f, 171.79584f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.25419f, 64.719864f, 73.53036f, 82.618515f, 92.03699f, 101.60967f, 111.24642f, 120.873795f, 130.54034f, 140.06807f, 148.9659f, 156.73003f, 163.30133f, 168.6298f, 172.67491f, 175.40587f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.579216f, 64.95804f, 73.7494f, 82.886375f, 92.22989f, 101.70882f, 111.32057f, 120.99202f, 130.57999f, 140.0115f, 148.58687f, 156.03139f, 162.28842f, 167.31035f, 171.05893f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.979397f, 64.39559f, 73.15897f, 82.20294f, 91.47597f, 101.011894f, 110.61635f, 120.21631f, 129.75603f, 139.2673f, 148.25932f, 156.123f, 162.7985f, 168.23497f, 172.3911f, 175.23521f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.699764f, 72.39504f, 81.48105f, 90.81902f, 100.30317f, 109.86126f, 119.52493f, 129.15103f, 138.63159f, 147.89438f, 156.20612f, 163.32904f, 169.20892f, 173.80103f, 177.07039f, 178.99216f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.77405f, 146.18503f, 155.0415f, 162.71803f, 169.15616f, 174.30692f, 178.1311f, 180.5996f, 181.6936f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.430573f, 71.09809f, 80.06176f, 89.39259f, 98.88034f, 108.45293f, 118.03737f, 127.69996f, 137.22792f, 146.54887f, 155.03369f, 162.33862f, 168.40805f, 173.19579f, 176.6654f, 178.7905f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.77405f, 146.18503f, 155.0415f, 162.71803f, 169.15616f, 174.30692f, 178.1311f, 180.5996f, 181.6936f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 70.11328f, 79.09583f, 88.452896f, 97.97404f, 107.5869f, 117.218216f, 126.933914f, 136.52081f, 145.90608f, 155.01817f, 163.0901f, 169.9208f, 175.45831f, 179.66048f, 182.49532f, 183.94127f, 183.9873f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.486855f, 77.52561f, 86.81171f, 96.274445f, 105.92878f, 115.66642f, 125.36113f, 134.93909f, 144.41438f, 153.6801f, 162.24718f, 169.57945f, 175.62112f, 180.32622f, 183.65892f, 185.59387f, 186.11633f, 185.22234f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.77184f, 85.03714f, 94.596954f, 104.27413f, 113.99509f, 123.72056f, 133.44614f, 142.99341f, 152.2898f, 161.26433f, 169.11627f, 175.68112f, 180.90895f, 184.75993f, 187.2048f, 188.22491f, 187.81253f, 185.97076f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.93485f, 82.21233f, 91.70147f, 101.33005f, 111.09434f, 120.92004f, 130.66281f, 140.24849f, 149.6737f, 158.86671f, 167.33904f, 174.53781f, 180.40825f, 184.90565f, 187.99583f, 189.65524f, 189.87128f, 188.64226f, 185.97757f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 79.26649f, 88.69057f, 98.38136f, 108.1955f, 118.02357f, 127.79071f, 137.527f, 147.08868f, 156.36832f, 165.2952f, 173.1386f, 179.66432f, 184.82268f, 188.57442f, 190.891f, 191.75479f, 191.1592f, 189.10878f, 185.61913f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 84.59006f, 94.24059f, 104.01125f, 113.827644f, 123.70205f, 133.5245f, 143.1681f, 152.55945f, 161.714f, 170.30048f, 177.59084f, 183.52963f, 188.07166f, 191.18234f, 192.83801f, 193.02608f, 191.74509f, 189.0048f, 184.82608f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.46569f, 90.03551f, 99.75745f, 109.62706f, 119.56926f, 129.4388f, 139.16057f, 148.73016f, 158.07472f, 167.05357f, 175.11f, 181.83374f, 187.17361f, 191.08899f, 193.55006f, 194.5381f, 194.04558f, 192.07626f, 188.64513f, 183.77827f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.66821f, 94.30157f, 104.19372f, 114.130135f, 124.035324f, 133.83379f, 143.59016f, 153.091f, 162.26408f, 171.03949f, 178.6528f, 184.90646f, 189.75287f, 193.15514f, 195.08739f, 195.5349f, 194.49428f, 191.97342f, 187.99155f, 182.57893f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.90405f, 98.730865f, 108.643616f, 118.56687f, 128.49466f, 138.35143f, 147.9926f, 157.3448f, 166.40642f, 174.89906f, 182.06062f, 187.8366f, 192.18301f, 195.0668f, 196.46602f, 196.37f, 194.7795f, 191.7066f, 187.1747f, 181.21829f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.36264f, 92.0745f, 101.92298f, 111.83309f, 121.81638f, 131.76207f, 141.54233f, 151.0827f, 160.39754f, 169.38113f, 177.54662f, 184.36086f, 189.772f, 193.73888f, 196.23128f, 197.23022f, 196.72815f, 194.72884f, 191.24754f, 186.31071f, 179.95596f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.465935f, 95.21803f, 105.08276f, 115.089455f, 125.09233f, 134.98055f, 144.67877f, 154.21762f, 163.45485f, 172.28546f, 180.11896f, 186.58163f, 191.62431f, 195.20862f, 197.30727f, 197.9043f, 196.99513f, 194.58673f, 190.69742f, 185.35677f, 178.60544f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.385315f, 97.151566f, 107.085335f, 117.11102f, 127.08276f, 136.92468f, 146.63141f, 156.12909f, 165.27588f, 174.00215f, 181.61359f, 187.84283f, 192.64249f, 195.976f, 197.81802f, 198.15454f, 196.98297f, 194.31226f, 190.1627f, 184.56589f, 177.56442f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 89.29236f, 99.10546f, 109.10601f, 119.1135f, 129.05183f, 138.88008f, 148.59308f, 158.0125f, 167.0667f, 175.68661f, 183.07416f, 189.06839f, 193.6237f, 196.70543f, 198.2901f, 198.36566f, 196.93155f, 193.99866f, 189.58932f, 183.7371f, 176.48654f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 90.00573f, 99.86954f, 109.86278f, 119.85725f, 129.77686f, 139.63309f, 149.31612f, 158.70012f, 167.71365f, 176.28781f, 183.57268f, 189.46045f, 193.90631f, 196.87642f, 198.34819f, 198.31041f, 196.76337f, 193.71883f, 189.19998f, 183.2412f, 175.88785f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.71525f, 100.62934f, 110.61483f, 120.595856f, 130.4963f, 140.38011f, 150.03276f, 159.38097f, 168.35342f, 176.88147f, 184.06335f, 189.84439f, 194.1806f, 197.03899f, 198.39778f, 198.24666f, 196.58675f, 193.4307f, 188.80252f, 182.73744f, 175.28162f}}, new float[][]{{0.0f, -0.104714f, -0.662077f, -1.528237f, -2.504863f, -3.51478f, -4.497947f, -5.446882f, -6.267207f, -7.013656f, -7.55851f, -7.928059f, -8.093337f, -7.883183f, -7.36003f, -6.431877f, -4.970727f, -2.813369f, 0.202649f, 4.0545f, 8.712741f, 14.281157f, 20.578135f, 27.555874f, 35.161144f, 43.4753f, 52.295834f, 61.555737f, 71.18441f, 81.24782f, 91.53012f, 101.9532f, 112.43761f, 123.04278f, 133.54877f, 143.45706f, 152.27356f}, {0.0f, -0.059995f, -0.539094f, -1.30392f, -2.136253f, -3.021026f, -3.852284f, -4.641134f, -5.293293f, -5.875716f, -6.195532f, -6.353679f, -6.272671f, -5.790857f, -4.949838f, -3.640362f, -1.717604f, 0.976039f, 4.499599f, 8.895813f, 14.131227f, 20.096436f, 26.746042f, 34.098995f, 42.099335f, 50.61662f, 59.58602f, 69.00884f, 78.81336f, 88.85541f, 99.05855f, 109.4147f, 119.84504f, 130.20064f, 140.40266f, 149.74556f, 157.94879f}, {0.0f, -0.021817f, -0.457508f, -1.098987f, -1.806274f, -2.565218f, -3.269739f, -3.897039f, -4.398725f, -4.788414f, -4.919334f, -4.868839f, -4.537096f, -3.778526f, -2.60741f, -0.897372f, 1.513001f, 4.749108f, 8.925555f, 13.871322f, 19.548895f, 25.914936f, 33.060234f, 40.79117f, 49.049038f, 57.77086f, 67.029495f, 76.61524f, 86.45528f, 96.47458f, 106.736145f, 117.02262f, 127.25587f, 137.35786f, 147.25136f, 156.02417f, 163.60954f}, {0.0f, 0.0f, -0.38242f, -0.913479f, -1.515022f, -2.147527f, -2.750598f, -3.215046f, -3.584132f, -3.778763f, -3.730966f, -3.474802f, -2.888084f, -1.84786f, -0.334609f, 1.795027f, 4.700244f, 8.528784f, 13.129692f, 18.46805f, 24.520521f, 31.34547f, 38.769142f, 46.735126f, 55.2001f, 64.20406f, 73.55666f, 83.18684f, 93.03857f, 103.14132f, 113.29638f, 123.42656f, 133.47206f, 143.46085f, 152.89845f, 161.17241f, 168.21974f}, {0.0f, 0.0f, -0.313836f, -0.747429f, -1.262572f, -1.768107f, -2.260185f, -2.665305f, -3.032688f, -3.211374f, -3.291448f, -3.150263f, -2.740909f, -2.075102f, -1.062079f, 0.455876f, 2.550018f, 5.492162f, 9.229755f, 13.734479f, 18.971924f, 25.041464f, 31.757673f, 39.06956f, 46.921352f, 55.392532f, 64.27939f, 73.51441f, 83.0272f, 92.884575f, 102.8723f, 112.914474f, 122.934555f, 132.99551f, 142.88153f, 152.09883f, 160.15857f}, {0.0f, 0.0f, -0.251764f, -0.600869f, -1.03044f, -1.42709f, -1.794339f, -2.062893f, -2.269939f, -2.269f, -2.14717f, -1.780087f, -1.095348f, -0.097991f, 1.319965f, 3.302455f, 6.012088f, 9.513339f, 13.779466f, 18.899817f, 24.730995f, 31.21133f, 38.29141f, 46.039158f, 54.291187f, 62.967403f, 72.00168f, 81.44707f, 91.127266f, 100.95131f, 110.84432f, 120.852844f, 130.79626f, 140.58162f, 150.13435f, 158.70152f, 166.0609f}, {0.0f, 0.0f, -0.196209f, -0.473823f, -0.817586f, -1.124589f, -1.36634f, -1.510454f, -1.555833f, -1.380102f, -1.054251f, -0.458764f, 0.510756f, 1.855854f, 3.70156f, 6.208255f, 9.505006f, 13.67112f, 18.60527f, 24.23519f, 30.51797f, 37.51019f, 45.08902f, 53.16206f, 61.66781f, 70.64593f, 79.95847f, 89.499855f, 99.19739f, 109.08168f, 119.007866f, 128.8657f, 138.5801f, 148.18152f, 157.28296f, 165.18738f, 171.83463f}, {0.0f, 0.0f, -0.147177f, -0.36631f, -0.624059f, -0.860697f, -0.976358f, -1.008243f, -0.890722f, -0.545131f, -0.013239f, 0.813069f, 2.076674f, 3.785593f, 6.081692f, 9.13925f, 13.068954f, 17.7365f, 23.106426f, 29.172583f, 35.95842f, 43.30789f, 51.16514f, 59.505066f, 68.333824f, 77.47983f, 86.87353f, 96.47815f, 106.290215f, 116.13065f, 125.92464f, 135.63234f, 145.2495f, 154.59853f, 163.15479f, 170.46935f, 176.48653f}, {0.0f, 0.0f, -0.104672f, -0.278346f, -0.449902f, -0.618034f, -0.703003f, -0.765169f, -0.655895f, -0.450013f, -0.070629f, 0.588319f, 1.487097f, 2.714774f, 4.396985f, 6.695201f, 9.779552f, 13.626817f, 18.207716f, 23.556946f, 29.633793f, 36.322453f, 43.57202f, 51.39688f, 59.737476f, 68.46078f, 77.5004f, 86.85709f, 96.459656f, 106.16544f, 115.90059f, 125.66056f, 135.3711f, 144.8887f, 154.14096f, 162.42953f, 169.48192f}, {0.0f, 0.0f, -0.068698f, -0.199033f, -0.295152f, -0.378117f, -0.350305f, -0.286013f, -0.012523f, 0.390841f, 0.966781f, 1.908f, 3.154163f, 4.811464f, 7.022103f, 9.939303f, 13.618163f, 18.135082f, 23.386065f, 29.296432f, 35.82114f, 43.014927f, 50.75343f, 58.943035f, 67.52135f, 76.52749f, 85.82329f, 95.30329f, 104.89529f, 114.63066f, 124.36571f, 133.99162f, 143.43509f, 152.72862f, 161.48758f, 169.01752f, 175.26114f}, {0.0f, 0.0f, -0.03926f, -0.126199f, -0.159842f, -0.157368f, -0.022891f, 0.16848f, 0.606993f, 1.215365f, 2.032597f, 3.226655f, 4.840807f, 6.954478f, 9.725976f, 13.399939f, 17.809168f, 22.920233f, 28.694109f, 35.22609f, 42.32723f, 49.943604f, 58.017128f, 66.62559f, 75.56424f, 84.765175f, 94.15824f, 103.811195f, 113.51133f, 123.18495f, 132.7583f, 142.29778f, 151.59152f, 160.56894f, 168.60352f, 175.35493f, 180.77179f}, {0.0f, 0.0f, -0.01636f, -0.059852f, -0.043999f, 0.044156f, 0.279152f, 0.59819f, 1.202503f, 2.023372f, 3.115683f, 4.586541f, 6.579337f, 9.26529f, 12.717943f, 16.911179f, 21.812986f, 27.50788f, 33.84809f, 40.768066f, 48.215054f, 56.25419f, 64.719864f, 73.53036f, 82.618515f, 92.03699f, 101.60967f, 111.24642f, 120.873795f, 130.54034f, 140.06807f, 149.36716f, 158.36676f, 166.99802f, 174.37576f, 180.42642f, 185.10391f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.026177f, 0.113203f, 0.277888f, 0.536413f, 0.987066f, 1.565461f, 2.410967f, 3.586907f, 5.11068f, 7.105934f, 9.731911f, 13.121164f, 17.31746f, 22.288857f, 27.927967f, 34.19187f, 41.10246f, 48.60713f, 56.579216f, 64.95804f, 73.7494f, 82.886375f, 92.22989f, 101.70882f, 111.32057f, 120.99202f, 130.57999f, 140.0115f, 149.28435f, 158.32796f, 166.65497f, 173.71365f, 179.45026f}, {0.0f, 0.0f, 0.009817f, 0.053349f, 0.13574f, 0.308672f, 0.593751f, 0.977911f, 1.629235f, 2.465561f, 3.556826f, 5.052547f, 7.033934f, 9.610228f, 13.015758f, 17.159508f, 22.010036f, 27.547724f, 33.83485f, 40.70175f, 48.09626f, 55.979397f, 64.39559f, 73.15897f, 82.20294f, 91.47597f, 101.011894f, 110.61635f, 120.21631f, 129.75603f, 139.2673f, 148.55597f, 157.55139f, 166.18497f, 173.67595f, 179.84515f, 184.64563f}, {0.0f, 0.0f, 0.01309f, 0.100188f, 0.238878f, 0.497847f, 0.910035f, 1.437449f, 2.285155f, 3.398934f, 4.848935f, 6.759287f, 9.289845f, 12.587069f, 16.6258f, 21.4797f, 27.042212f, 33.236282f, 40.014706f, 47.430298f, 55.356995f, 63.699764f, 72.39504f, 81.48105f, 90.81902f, 100.30317f, 109.86126f, 119.52493f, 129.15103f, 138.63159f, 147.89438f, 156.9733f, 165.72964f, 173.67822f, 180.30501f, 185.55957f, 189.4019f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.77405f, 146.18503f, 155.32071f, 164.11166f, 172.49089f, 179.69698f, 185.53546f, 189.96191f, 192.94263f}, {0.0f, 0.0f, 0.0f, 0.087156f, 0.199827f, 0.459195f, 0.832848f, 1.344096f, 2.158952f, 3.210379f, 4.58636f, 6.411482f, 8.846187f, 12.050816f, 16.001104f, 20.666864f, 26.151821f, 32.274994f, 38.98991f, 46.24534f, 54.125294f, 62.430573f, 71.09809f, 80.06176f, 89.39259f, 98.88034f, 108.45293f, 118.03737f, 127.69996f, 137.22792f, 146.54887f, 155.59175f, 164.42696f, 172.56883f, 179.39735f, 184.86057f, 188.91685f}, {0.0f, 0.0f, 0.009817f, 0.140511f, 0.335577f, 0.680711f, 1.226712f, 1.941165f, 2.954749f, 4.365407f, 6.199652f, 8.598395f, 11.702435f, 15.693895f, 20.403164f, 25.794529f, 31.826828f, 38.59339f, 45.90348f, 53.701595f, 61.928257f, 70.66009f, 79.69141f, 88.95359f, 98.37604f, 108.02627f, 117.691605f, 127.29861f, 136.77405f, 146.18503f, 155.32071f, 164.11166f, 172.49089f, 179.69698f, 185.53546f, 189.96191f, 192.94263f}, {0.0f, 0.0f, 0.026179f, 0.200376f, 0.490828f, 0.921478f, 1.658952f, 2.636803f, 3.943572f, 5.704375f, 8.080143f, 11.231664f, 15.135079f, 19.760557f, 25.212128f, 31.309067f, 38.0051f, 45.24914f, 53.125294f, 61.434376f, 70.11328f, 79.09583f, 88.452896f, 97.97404f, 107.5869f, 117.218216f, 126.933914f, 136.52081f, 145.90608f, 155.01817f, 163.92696f, 172.42542f, 180.03029f, 186.26503f, 191.08218f, 194.44508f, 196.32814f}, {0.0f, 0.0f, 0.049084f, 0.266745f, 0.665551f, 1.230527f, 2.129416f, 3.395758f, 5.08659f, 7.343904f, 10.31288f, 14.127672f, 18.724438f, 24.016056f, 29.962223f, 36.604664f, 43.858013f, 51.614937f, 59.81636f, 68.486855f, 77.52561f, 86.81171f, 96.274445f, 105.92878f, 115.66642f, 125.36113f, 134.93909f, 144.41438f, 153.6801f, 162.61357f, 171.14677f, 179.21448f, 185.97063f, 191.31142f, 195.19623f, 197.59546f, 198.49088f}, {0.0f, 0.0f, 0.078531f, 0.33961f, 0.859716f, 1.613232f, 2.690294f, 4.217635f, 6.357873f, 9.28671f, 12.982173f, 17.4162f, 22.589764f, 28.533106f, 35.096596f, 42.23035f, 49.914787f, 58.16104f, 66.80196f, 75.77184f, 85.03714f, 94.596954f, 104.27413f, 113.99509f, 123.72056f, 133.44614f, 142.99341f, 152.2898f, 161.29924f, 170.0228f, 178.28969f, 185.58351f, 191.46494f, 195.88919f, 198.8226f, 200.24286f, 200.13916f}, {0.0f, 0.0f, 0.114517f, 0.418963f, 1.073286f, 2.034575f, 3.411165f, 5.347371f, 8.000693f, 11.43047f, 15.680153f, 20.717402f, 26.434322f, 32.787407f, 39.797855f, 47.412323f, 55.503296f, 64.0092f, 72.93485f, 82.21233f, 91.70147f, 101.33005f, 111.09434f, 120.92004f, 130.66281f, 140.24849f, 149.6737f, 158.86671f, 167.68799f, 176.0704f, 183.9499f, 190.49925f, 195.59879f, 199.20969f, 201.30449f, 201.86723f, 200.89365f}, {0.0f, 0.0f, 0.157039f, 0.526612f, 1.306219f, 2.494423f, 4.195697f, 6.571503f, 9.838998f, 13.903694f, 18.699942f, 24.191175f, 30.440002f, 37.329243f, 44.771755f, 52.710827f, 61.190445f, 70.07645f, 79.26649f, 88.69057f, 98.38136f, 108.1955f, 118.02357f, 127.79071f, 137.527f, 147.08868f, 156.36832f, 165.2952f, 173.90579f, 182.06493f, 189.29198f, 195.07841f, 199.38017f, 202.16454f, 203.41031f, 203.108f, 201.25992f}, {0.0f, 0.0f, 0.206095f, 0.693088f, 1.572648f, 2.992623f, 5.130755f, 8.066974f, 11.779155f, 16.239016f, 21.49959f, 27.486034f, 34.10065f, 41.293064f, 49.095516f, 57.413815f, 66.13252f, 75.18524f, 84.59006f, 94.24059f, 104.01125f, 113.827644f, 123.70205f, 133.5245f, 143.1681f, 152.55945f, 161.714f, 170.52733f, 178.88019f, 186.709f, 193.30879f, 198.43741f, 202.05579f, 204.13638f, 204.66339f, 203.6328f, 201.05243f}, {0.0f, 0.0f, 0.26168f, 0.879097f, 1.982684f, 3.738419f, 6.303046f, 9.657047f, 13.844452f, 18.833393f, 24.516344f, 30.850056f, 37.855877f, 45.480495f, 53.596325f, 62.141594f, 71.12083f, 80.46569f, 90.03551f, 99.75745f, 109.62706f, 119.56926f, 129.4388f, 139.16057f, 148.73016f, 158.07472f, 167.05357f, 175.59839f, 183.7137f, 191.12833f, 197.08835f, 201.54842f, 204.47456f, 205.84454f, 205.64793f, 203.8862f, 200.57278f}, {0.0f, 0.0f, 0.323789f, 1.084609f, 2.431497f, 4.522059f, 7.415454f, 11.228896f, 15.794128f, 21.076532f, 27.03578f, 33.76575f, 41.075996f, 48.911f, 57.21101f, 66.05209f, 75.22773f, 84.66821f, 94.30157f, 104.19372f, 114.130135f, 124.035324f, 133.83379f, 143.59016f, 153.091f, 162.26408f, 171.03949f, 179.48967f, 187.41107f, 194.32484f, 199.75969f, 203.67424f, 206.03871f, 206.83511f, 206.05736f, 203.7114f, 199.81506f}, {0.0f, 0.0f, 0.392419f, 1.30959f, 2.918952f, 5.413f, 8.772752f, 12.903082f, 17.772554f, 23.413668f, 29.783491f, 36.763985f, 44.30203f, 52.409805f, 61.025616f, 70.01433f, 79.307526f, 88.90405f, 98.730865f, 108.643616f, 118.56687f, 128.49466f, 138.35143f, 147.9926f, 157.3448f, 166.40642f, 175.10847f, 183.3152f, 190.96413f, 197.36913f, 202.27202f, 205.6355f, 207.43398f, 207.65375f, 206.29315f, 203.36253f, 198.88422f}, {0.0f, 0.0f, 0.467562f, 1.554001f, 3.491842f, 6.292602f, 9.882828f, 14.235166f, 19.403467f, 25.313591f, 31.868422f, 39.01804f, 46.79501f, 55.105335f, 63.833633f, 72.913445f, 82.36264f, 92.0745f, 101.92298f, 111.83309f, 121.81638f, 131.76207f, 141.54233f, 151.0827f, 160.39754f, 169.38113f, 177.91301f, 185.92818f, 193.36537f, 199.38329f, 203.88377f, 206.83258f, 208.20728f, 207.99738f, 206.2045f, 202.84229f, 197.93631f}, {0.0f, 0.0f, 0.549214f, 1.922516f, 4.153269f, 7.18978f, 11.008877f, 15.68589f, 21.115608f, 27.221989f, 33.9585f, 41.378265f, 49.3552f, 57.79388f, 66.63002f, 75.900764f, 85.465935f, 95.21803f, 105.08276f, 115.089455f, 125.09233f, 134.98055f, 144.67877f, 154.21762f, 163.45485f, 172.28546f, 180.64218f, 188.56581f, 195.6821f, 201.30914f, 205.4041f, 207.9358f, 208.885f, 208.24445f, 206.01903f, 202.22568f, 196.89328f}, {0.0f, 0.0f, 0.707179f, 2.262426f, 4.637798f, 7.815217f, 11.840059f, 16.68169f, 22.23371f, 28.453857f, 35.364357f, 42.912613f, 50.97162f, 59.480045f, 68.442696f, 77.79135f, 87.385315f, 97.151566f, 107.085335f, 117.11102f, 127.08276f, 136.92468f, 146.63141f, 156.12909f, 165.27588f, 174.00215f, 182.31108f, 190.13939f, 197.00903f, 202.3793f, 206.20935f, 208.47003f, 209.14412f, 208.22649f, 205.72414f, 201.6561f, 196.05333f}, {0.0f, 0.034906f, 0.906532f, 2.608562f, 5.128106f, 8.480705f, 12.710463f, 17.680788f, 23.353922f, 29.7214f, 36.80438f, 44.44456f, 52.58386f, 61.195045f, 70.2822f, 79.67177f, 89.29236f, 99.10546f, 109.10601f, 119.1135f, 129.05183f, 138.88008f, 148.59308f, 158.0125f, 167.0667f, 175.72151f, 183.98068f, 191.67696f, 198.29826f, 203.41042f, 206.97449f, 208.96335f, 209.3619f, 208.16705f, 205.38794f, 201.04568f, 195.17337f}, {0.0f, 0.087265f, 1.011f, 2.764397f, 5.334082f, 8.787475f, 13.063482f, 18.077427f, 23.791117f, 30.248045f, 37.36426f, 45.03347f, 53.197273f, 61.880512f, 70.9823f, 80.381226f, 90.00573f, 99.86954f, 109.86278f, 119.85725f, 129.77686f, 139.63309f, 149.31612f, 158.70012f, 167.71365f, 176.37508f, 184.58368f, 192.22484f, 198.73459f, 203.73183f, 207.17854f, 209.04852f, 209.3275f, 208.01338f, 205.11615f, 200.65785f, 194.67244f}, {0.0f, 0.139619f, 1.115424f, 2.920114f, 5.539829f, 9.093866f, 13.415942f, 18.47329f, 24.227291f, 30.773394f, 37.92254f, 45.62045f, 53.808407f, 62.56333f, 71.67936f, 81.08724f, 90.71525f, 100.62934f, 110.61483f, 120.595856f, 130.4963f, 140.38011f, 150.03276f, 159.38097f, 168.35342f, 177.02109f, 185.17877f, 192.76451f, 199.16238f, 204.04451f, 207.37373f, 209.12473f, 209.28415f, 207.8508f, 204.83557f, 200.26143f, 194.16316f}}};
        this.lut_y1 = newlut_y;
    }
}

