/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Heading;

public class Bearing {
    private double mBearing = 0.0;

    public void Initialise() {
        this.mBearing = 0.0;
    }

    public void Set(double newValue) {
        this.mBearing = newValue;
        this.Normalise();
    }

    public void Set(Bearing newValue) {
        this.mBearing = newValue.Get();
        this.Normalise();
    }

    public void Flip() {
        this.mBearing += 180.0;
        this.Normalise();
    }

    public final double Get() {
        return this.mBearing;
    }

    public final double GetAbs() {
        return Math.abs(this.mBearing);
    }

    public final boolean IsNormalised() {
        boolean answer = false;
        if (this.mBearing >= -180.0 && this.mBearing < 180.0) {
            answer = true;
        }
        return answer;
    }

    public void Normalise() {
        boolean done = false;
        while (!done) {
            if (this.mBearing >= 180.0) {
                this.mBearing -= 360.0;
                continue;
            }
            if (this.mBearing < -180.0) {
                this.mBearing += 360.0;
                continue;
            }
            done = true;
        }
    }

    public void SetFromTo(Heading fromHdng, Heading toHdng) {
        this.mBearing = toHdng.Get() - fromHdng.Get();
        this.Normalise();
    }

    public final boolean IsOpposed() {
        boolean answer = false;
        if (this.mBearing >= 179.5 || this.mBearing <= -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsLeft() {
        boolean answer = false;
        if (this.mBearing < -0.5 && this.mBearing > -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsRight() {
        boolean answer = false;
        if (this.mBearing > 0.5 && this.mBearing < 179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsAligned() {
        boolean answer = false;
        if (this.mBearing >= -0.5 && this.mBearing <= 0.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsForward() {
        boolean answer = false;
        if (this.mBearing >= -90.0 && this.mBearing <= 90.0) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsBackward() {
        boolean answer = false;
        if (this.mBearing < -90.0 || this.mBearing > 90.0) {
            answer = true;
        }
        return answer;
    }

    public Bearing() {
        this.Initialise();
    }
}

