/*
 * Decompiled with CFR 0.152.
 */
package kano.gamma;

import java.awt.Color;
import java.util.Vector;
import kano.gamma.EnemyMgr;
import kano.gamma.FireMgr;
import kano.gamma.IStrategy;
import kano.gamma.MeleeStrategy;
import kano.gamma.MoveMgr;
import kano.gamma.OneOnOneStrategy;
import kano.gamma.ScanMgr;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;

public class KanoGamma
extends AdvancedRobot {
    FireMgr fireMgr = null;
    MoveMgr moveMgr = null;
    EnemyMgr enemyMgr = null;
    ScanMgr scanMgr = null;
    Vector strategies = null;

    public void run() {
        this.setColors(Color.red, Color.red, Color.red);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.fireMgr = new FireMgr(this);
        this.moveMgr = new MoveMgr(this);
        this.enemyMgr = new EnemyMgr(this);
        this.scanMgr = new ScanMgr(this);
        this.strategies = new Vector();
        this.strategies.add(new OneOnOneStrategy(this));
        this.strategies.add(new MeleeStrategy(this));
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            IStrategy strategy = this.selectStrategy();
            strategy.run();
            this.execute();
        }
    }

    public IStrategy selectStrategy() {
        int current = -1;
        IStrategy currentStrategy = null;
        int l = this.strategies.size();
        int i = 0;
        while (i < l) {
            IStrategy s = (IStrategy)this.strategies.elementAt(i);
            int aux = s.getPoints();
            if (aux > current) {
                currentStrategy = s;
                current = aux;
            }
            ++i;
        }
        return currentStrategy;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyMgr.addEnemy(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemyMgr.killEnemy(e);
    }

    public void onDeath(DeathEvent event) {
        this.enemyMgr.refresh();
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        System.out.println("skipped turn");
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double getVectorAngle(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (h == 0.0) {
            return 0.0;
        }
        if (x > 0.0 && y > 0.0) {
            return Math.asin(x / h);
        }
        if (x > 0.0 && y < 0.0) {
            return Math.asin(-y / h) + 1.5707963267948966;
        }
        if (x < 0.0 && y > 0.0) {
            return Math.asin(y / h) + 4.71238898038469;
        }
        if (x < 0.0 && y < 0.0) {
            return Math.asin(-x / h) + Math.PI;
        }
        if (x > 0.0 && y == 0.0) {
            return 1.5707963267948966;
        }
        if (x < 0.0 && y == 0.0) {
            return 4.71238898038469;
        }
        if (x == 0.0 && y < 0.0) {
            return Math.PI;
        }
        return 0.0;
    }

    public double normalize(double angle) {
        if (Math.abs(angle) >= Math.PI * 2) {
            angle %= Math.PI * 2;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public double getTurnAngle(double startAngle, double finishAngle) {
        startAngle = this.normalize(startAngle);
        double turnAngle = (finishAngle = this.normalize(finishAngle)) - startAngle;
        if (turnAngle > Math.PI) {
            turnAngle -= Math.PI * 2;
        }
        if (turnAngle <= -Math.PI) {
            turnAngle += Math.PI * 2;
        }
        return turnAngle;
    }

    public int setHeading(double angle) {
        double heading = this.getHeadingRadians();
        double delta = this.getTurnAngle(heading, angle);
        int type = 1;
        if (delta > 1.5707963267948966 || delta < -1.5707963267948966) {
            delta = this.getTurnAngle(heading, angle + Math.PI);
            type = -1;
        }
        if (delta != 0.0) {
            this.setTurnRightRadians(delta);
        }
        return type;
    }

    public void setGunHeading(double angle) {
        double gunHeading = this.getGunHeadingRadians();
        double delta = this.getTurnAngle(gunHeading, angle);
        if (delta != 0.0) {
            this.setTurnGunRightRadians(delta);
        }
    }

    public void goTo(double x, double y) {
        double x0 = this.getX();
        double y0 = this.getY();
        double h = this.getRange(x0, y0, x, y);
        double angle = 0.0;
        if (h == 0.0) {
            return;
        }
        angle = this.getVectorAngle(x0, y0, x, y);
        this.setAhead(h *= (double)this.setHeading(angle));
    }

    public boolean isNearWalls() {
        return this.getX() < 50.0 || this.getY() < 50.0 || this.getX() > this.getBattleFieldWidth() - 50.0 || this.getY() > this.getBattleFieldHeight() - 50.0;
    }

    public boolean isInCorner() {
        return this.inCorner(this.getX(), this.getY());
    }

    public boolean inCorner(double x, double y) {
        int delta = 200;
        double finX = this.getBattleFieldWidth() - (double)delta;
        double finY = this.getBattleFieldHeight() - (double)delta;
        if (x < (double)delta && y < (double)delta) {
            return true;
        }
        if (x < (double)delta && y > finY) {
            return true;
        }
        if (x > finX && y < (double)delta) {
            return true;
        }
        return x > finX && y > finY;
    }

    int getNearestCorner() {
        double x = this.getX();
        double y = this.getY();
        double medX = this.getBattleFieldWidth() / 2.0;
        double medY = this.getBattleFieldHeight() / 2.0;
        if (x <= medX && y <= medY) {
            return 0;
        }
        if (x <= medX && y > medY) {
            return 1;
        }
        if (x > medX && y <= medY) {
            return 2;
        }
        return 3;
    }
}

