/*
 * Decompiled with CFR 0.152.
 */
package eem.bullets;

import eem.EvBot;
import eem.bullets.wave;
import eem.gun.baseGun;
import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.Bullet;

public class firedBullet {
    protected EvBot myBot;
    protected Bullet robocodeBullet;
    protected baseGun firedGun;
    private boolean belongToMyBot = false;
    private boolean virtualState = true;
    public Point2D.Double targetPosition;
    protected Point2D.Double firingPosition;
    protected long firedTime;
    protected double firingAngle;
    protected double bulletSpeed;
    protected Color bulletColor;

    public firedBullet() {
    }

    public firedBullet(EvBot evBot) {
        this.myBot = evBot;
        this.firingPosition = this.myBot.myCoord;
    }

    public firedBullet(EvBot evBot, baseGun baseGun2, InfoBot infoBot, Point2D.Double double_, Point2D.Double double_2, double d, long l) {
        this.myBot = evBot;
        this.belongToMyBot = infoBot.getName().equals(this.myBot.getName());
        this.firedGun = baseGun2;
        this.bulletSpeed = physics.bulletSpeed(d);
        this.targetPosition = (Point2D.Double)double_.clone();
        this.firingPosition = (Point2D.Double)double_2.clone();
        this.firedTime = l;
        this.virtualState = true;
        this.firingAngle = Math.atan2(double_.x - double_2.x, double_.y - double_2.y);
        this.bulletColor = this.firedGun.gunColor;
    }

    public firedBullet(EvBot evBot, Bullet bullet, baseGun baseGun2) {
        this.myBot = evBot;
        this.robocodeBullet = bullet;
        this.firedGun = baseGun2;
        this.belongToMyBot = true;
        this.targetPosition = this.firedGun.getTargetFuturePosition();
        logger.noise("fired bullet target position = " + this.targetPosition);
        this.firingPosition = new Point2D.Double(bullet.getX(), bullet.getY());
        logger.noise("bullet firing position = " + this.firingPosition);
        this.firedTime = this.myBot.ticTime;
        this.firingAngle = bullet.getHeadingRadians();
        this.bulletSpeed = bullet.getVelocity();
        logger.noise("fired bullet speed = " + this.bulletSpeed);
        this.bulletColor = this.firedGun.gunColor;
    }

    public double getBulletEnergy() {
        return physics.bulletEnergy(this.bulletSpeed);
    }

    public firedBullet(EvBot evBot, wave wave2, baseGun baseGun2, Point2D.Double double_) {
        this.myBot = evBot;
        this.belongToMyBot = false;
        this.firedGun = baseGun2;
        this.bulletSpeed = wave2.bulletSpeed;
        this.firingPosition = (Point2D.Double)wave2.getFiringPosition().clone();
        this.targetPosition = null;
        this.firedTime = wave2.getFiredTime();
        this.firingAngle = Math.atan2(double_.x - this.firingPosition.x, double_.y - this.firingPosition.y);
        this.bulletColor = baseGun2.gunColor;
    }

    public firedBullet(EvBot evBot, InfoBot infoBot, baseGun baseGun2, double d) {
        this(evBot, infoBot, EvBot._tracker, baseGun2, d);
    }

    public firedBullet(EvBot evBot, InfoBot infoBot, InfoBot infoBot2, baseGun baseGun2, double d) {
        this.myBot = evBot;
        this.firedGun = baseGun2;
        this.bulletSpeed = physics.bulletSpeed(d);
        if (infoBot.getName().equals(this.myBot.getName())) {
            this.belongToMyBot = true;
            this.firedTime = this.myBot.ticTime;
            this.firingPosition = (Point2D.Double)infoBot.getPosition().clone();
        } else {
            this.belongToMyBot = false;
            this.firedTime = this.myBot.ticTime - 1L;
            this.firingPosition = (Point2D.Double)infoBot.getPrevTicPosition().clone();
        }
        this.targetPosition = baseGun2.calcTargetFuturePosition(infoBot, d, infoBot2);
        this.firingAngle = Math.atan2(this.targetPosition.x - this.firingPosition.x, this.targetPosition.y - this.firingPosition.y);
        this.bulletColor = this.firedGun.gunColor;
    }

    public void setIsItVirtual(boolean bl) {
        this.virtualState = bl;
    }

    public boolean isItVirtual() {
        return this.virtualState;
    }

    public boolean isItMine() {
        return this.belongToMyBot;
    }

    public firedBullet(EvBot evBot, baseGun baseGun2) {
        this.myBot = evBot;
        this.belongToMyBot = false;
        this.firedGun = baseGun2;
        this.bulletSpeed = physics.bulletSpeed(this.myBot._trgt.energyDrop());
        this.targetPosition = new Point2D.Double(this.myBot.myCoord.x, this.myBot.myCoord.y);
        this.firingPosition = new Point2D.Double(this.myBot._trgt.getX(), this.myBot._trgt.getY());
        this.firedTime = this.myBot.ticTime;
        this.firingAngle = Math.atan2(this.targetPosition.x - this.firingPosition.x, this.targetPosition.y - this.firingPosition.y);
        this.bulletColor = this.firedGun.gunColor;
    }

    public baseGun getFiredGun() {
        return this.firedGun;
    }

    public double getDistanceTraveledAtTime(long l) {
        double d = l - this.firedTime;
        double d2 = d * this.bulletSpeed;
        return d2;
    }

    public double getDistanceTraveled() {
        return this.getDistanceTraveledAtTime(this.myBot.ticTime);
    }

    public long getFiredTime() {
        return this.firedTime;
    }

    public Point2D.Double getPositionAtTime(long l) {
        Point2D.Double double_ = (Point2D.Double)this.firingPosition.clone();
        double d = this.getDistanceTraveledAtTime(l);
        double_.x += d * Math.sin(this.firingAngle);
        double_.y += d * Math.cos(this.firingAngle);
        return double_;
    }

    public Point2D.Double getPosition() {
        return this.getPositionAtTime(this.myBot.ticTime);
    }

    public boolean isPositionHitAtTime(Point2D.Double double_, long l) {
        Point2D.Double double_2 = this.getPositionAtTime(l);
        double d = double_.x - double_2.x;
        double d2 = double_.y - double_2.y;
        return Math.abs(d) <= (double)this.myBot.robotHalfSize && Math.abs(d2) <= (double)this.myBot.robotHalfSize;
    }

    public double pointDangerFromExactBulletHit(Point2D.Double double_, long l) {
        double d = 500.0;
        double d2 = -d / 6.0;
        double d3 = 2 * this.myBot.robotHalfSize + 2;
        double d4 = 0.0;
        if (this.isActive() && !this.belongToMyBot) {
            Point2D.Double double_2 = this.getPositionAtTime(l);
            double d5 = double_.distance(double_2);
            if (this.isPositionHitAtTime(double_, l)) {
                d4 = !this.getFiredGun().getName().equals("shadow") ? (d4 += d) : (d4 += d2);
            }
            double d6 = 1.0;
            d4 = !this.getFiredGun().getName().equals("shadow") ? (d4 += math.gaussian(d5, d, d6 * d3)) : (d4 += math.gaussian(d5, d2, d6 * d3));
        }
        return d4;
    }

    public double pointDangerFromBulletPrecursor(Point2D.Double double_, long l) {
        double d = 200.0;
        double d2 = 100.0;
        double d3 = -d2 / 6.0;
        double d4 = 2 * this.myBot.robotHalfSize + 2;
        double d5 = 0.0;
        if (this.isActive() && !this.belongToMyBot) {
            double d6;
            double d7;
            double d8;
            double d9;
            Point2D.Double double_2 = this.getPositionAtTime(l);
            Point2D.Double double_3 = this.endPositionAtBorder();
            double d10 = double_3.x - double_2.x;
            double d11 = double_3.y - double_2.y;
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            if (d10 == 0.0) {
                d10 = 1.0E-8;
            }
            if (d11 == 0.0) {
                d11 = 1.0E-8;
            }
            if ((d9 = ((d8 = double_.x - double_2.x) * d10 + (d7 = double_.y - double_2.y) * d11) / ((d6 = Math.sqrt(d8 * d8 + d7 * d7)) * d12)) > 0.0) {
                double d13 = d6 * Math.sqrt(1.0 - d9 * d9);
                double d14 = d6 * d9;
                if (!this.getFiredGun().getName().equals("shadow")) {
                    d5 = math.gaussian(d13, d2, d4);
                    d5 *= math.gaussian(d14, 1.0, d);
                    if (this.myBot.fightType().equals("1on1")) {
                        double d15 = physics.bulletDamageByEnergy(this.getBulletEnergy());
                        d5 *= 1.0 + (double)(this.myBot.totalNumOfEnemiesAtStart / Math.max(this.myBot.numEnemyBotsAlive, 1)) * 0.01 * d15;
                    }
                } else {
                    d5 = math.gaussian(d13, d3, d4);
                    d5 *= math.gaussian(d14, 1.0, d);
                }
            }
        }
        return d5;
    }

    public boolean isActive() {
        return !math.isItOutOfBorders(this.getPosition(), this.myBot.BattleField);
    }

    public Point2D.Double endPositionAtBorder() {
        return math.vecCrossesBorder(this.firingPosition, this.firingAngle, this.myBot.BattleField);
    }

    private void drawTargetPosition(Graphics2D graphics2D) {
        double d = physics.robotHalfSize;
        if (this.targetPosition != null) {
            logger.noise("draw target at position = " + this.targetPosition);
            graphics.drawSquare(graphics2D, this.targetPosition, 2.0 * d + 1.0);
            graphics.drawSquare(graphics2D, this.targetPosition, 2.0 * d + 2.0);
            graphics.drawSquare(graphics2D, this.targetPosition, d);
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(this.bulletColor);
        double d = 18.0;
        if (this.targetPosition != null) {
            // empty if block
        }
        int n = 10;
        Point2D.Double double_ = this.getPosition();
        logger.noise("draw bullet at position = " + double_);
        graphics.drawCircle(graphics2D, double_, n / 2);
    }

    public Point2D.Double getFiringPosition() {
        return this.firingPosition;
    }

    public double getSpeed() {
        return this.bulletSpeed;
    }

    public Color getColor() {
        return this.bulletColor;
    }

    public String format() {
        String string = "";
        string = string + "Bullet fired by " + this.firedGun.getName() + " gun," + " from " + this.firingPosition + " to " + this.targetPosition + " with speed " + this.bulletSpeed;
        return string;
    }
}

